// **********************************************************************
//
// Copyright (c) 2003-2018 ZeroC, Inc. All rights reserved.
//
// This copy of Ice is licensed to you under the terms described in the
// ICE_LICENSE file included in this distribution.
//
// **********************************************************************
//
// Ice version 3.7.1
//
// <auto-generated>
//
// Generated from file `IceStorm.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

package com.zeroc.IceStorm;

/**
 * Publishers publish information on a particular topic. A topic
 * logically represents a type.
 *
 * @see TopicManager
 **/
public interface TopicPrx extends com.zeroc.Ice.ObjectPrx
{
    /**
     * Get the name of this topic.
     * @return The name of the topic.
     *
     * @see TopicManager#create
     **/
    default String getName()
    {
        return getName(com.zeroc.Ice.ObjectPrx.noExplicitContext);
    }

    /**
     * Get the name of this topic.
     * @param context The Context map to send with the invocation.
     * @return The name of the topic.
     *
     * @see TopicManager#create
     **/
    default String getName(java.util.Map<String, String> context)
    {
        return _iceI_getNameAsync(context, true).waitForResponse();
    }

    /**
     * Get the name of this topic.
     * @return The name of the topic.
     *
     * @see TopicManager#create
     **/
    default java.util.concurrent.CompletableFuture<java.lang.String> getNameAsync()
    {
        return _iceI_getNameAsync(com.zeroc.Ice.ObjectPrx.noExplicitContext, false);
    }

    /**
     * Get the name of this topic.
     * @param context The Context map to send with the invocation.
     * @return The name of the topic.
     *
     * @see TopicManager#create
     **/
    default java.util.concurrent.CompletableFuture<java.lang.String> getNameAsync(java.util.Map<String, String> context)
    {
        return _iceI_getNameAsync(context, false);
    }

    default com.zeroc.IceInternal.OutgoingAsync<java.lang.String> _iceI_getNameAsync(java.util.Map<String, String> context, boolean sync)
    {
        com.zeroc.IceInternal.OutgoingAsync<java.lang.String> f = new com.zeroc.IceInternal.OutgoingAsync<>(this, "getName", com.zeroc.Ice.OperationMode.Nonmutating, sync, null);
        f.invoke(true, context, null, null, istr -> {
                     String ret;
                     ret = istr.readString();
                     return ret;
                 });
        return f;
    }

    /**
     * Get a proxy to a publisher object for this topic. To publish
     * data to a topic, the publisher calls getPublisher and then
     * casts to the topic type. An unchecked cast must be used on this
     * proxy. If a replicated IceStorm deployment is used this call
     * may return a replicated proxy.
     * @return A proxy to publish data on this topic.
     **/
    default com.zeroc.Ice.ObjectPrx getPublisher()
    {
        return getPublisher(com.zeroc.Ice.ObjectPrx.noExplicitContext);
    }

    /**
     * Get a proxy to a publisher object for this topic. To publish
     * data to a topic, the publisher calls getPublisher and then
     * casts to the topic type. An unchecked cast must be used on this
     * proxy. If a replicated IceStorm deployment is used this call
     * may return a replicated proxy.
     * @param context The Context map to send with the invocation.
     * @return A proxy to publish data on this topic.
     **/
    default com.zeroc.Ice.ObjectPrx getPublisher(java.util.Map<String, String> context)
    {
        return _iceI_getPublisherAsync(context, true).waitForResponse();
    }

    /**
     * Get a proxy to a publisher object for this topic. To publish
     * data to a topic, the publisher calls getPublisher and then
     * casts to the topic type. An unchecked cast must be used on this
     * proxy. If a replicated IceStorm deployment is used this call
     * may return a replicated proxy.
     * @return A proxy to publish data on this topic.
     **/
    default java.util.concurrent.CompletableFuture<com.zeroc.Ice.ObjectPrx> getPublisherAsync()
    {
        return _iceI_getPublisherAsync(com.zeroc.Ice.ObjectPrx.noExplicitContext, false);
    }

    /**
     * Get a proxy to a publisher object for this topic. To publish
     * data to a topic, the publisher calls getPublisher and then
     * casts to the topic type. An unchecked cast must be used on this
     * proxy. If a replicated IceStorm deployment is used this call
     * may return a replicated proxy.
     * @param context The Context map to send with the invocation.
     * @return A proxy to publish data on this topic.
     **/
    default java.util.concurrent.CompletableFuture<com.zeroc.Ice.ObjectPrx> getPublisherAsync(java.util.Map<String, String> context)
    {
        return _iceI_getPublisherAsync(context, false);
    }

    default com.zeroc.IceInternal.OutgoingAsync<com.zeroc.Ice.ObjectPrx> _iceI_getPublisherAsync(java.util.Map<String, String> context, boolean sync)
    {
        com.zeroc.IceInternal.OutgoingAsync<com.zeroc.Ice.ObjectPrx> f = new com.zeroc.IceInternal.OutgoingAsync<>(this, "getPublisher", com.zeroc.Ice.OperationMode.Nonmutating, sync, null);
        f.invoke(true, context, null, null, istr -> {
                     com.zeroc.Ice.ObjectPrx ret;
                     ret = istr.readProxy();
                     return ret;
                 });
        return f;
    }

    /**
     * Get a non-replicated proxy to a publisher object for this
     * topic. To publish data to a topic, the publisher calls
     * getPublisher and then casts to the topic type. An unchecked
     * cast must be used on this proxy.
     * @return A proxy to publish data on this topic.
     **/
    default com.zeroc.Ice.ObjectPrx getNonReplicatedPublisher()
    {
        return getNonReplicatedPublisher(com.zeroc.Ice.ObjectPrx.noExplicitContext);
    }

    /**
     * Get a non-replicated proxy to a publisher object for this
     * topic. To publish data to a topic, the publisher calls
     * getPublisher and then casts to the topic type. An unchecked
     * cast must be used on this proxy.
     * @param context The Context map to send with the invocation.
     * @return A proxy to publish data on this topic.
     **/
    default com.zeroc.Ice.ObjectPrx getNonReplicatedPublisher(java.util.Map<String, String> context)
    {
        return _iceI_getNonReplicatedPublisherAsync(context, true).waitForResponse();
    }

    /**
     * Get a non-replicated proxy to a publisher object for this
     * topic. To publish data to a topic, the publisher calls
     * getPublisher and then casts to the topic type. An unchecked
     * cast must be used on this proxy.
     * @return A proxy to publish data on this topic.
     **/
    default java.util.concurrent.CompletableFuture<com.zeroc.Ice.ObjectPrx> getNonReplicatedPublisherAsync()
    {
        return _iceI_getNonReplicatedPublisherAsync(com.zeroc.Ice.ObjectPrx.noExplicitContext, false);
    }

    /**
     * Get a non-replicated proxy to a publisher object for this
     * topic. To publish data to a topic, the publisher calls
     * getPublisher and then casts to the topic type. An unchecked
     * cast must be used on this proxy.
     * @param context The Context map to send with the invocation.
     * @return A proxy to publish data on this topic.
     **/
    default java.util.concurrent.CompletableFuture<com.zeroc.Ice.ObjectPrx> getNonReplicatedPublisherAsync(java.util.Map<String, String> context)
    {
        return _iceI_getNonReplicatedPublisherAsync(context, false);
    }

    default com.zeroc.IceInternal.OutgoingAsync<com.zeroc.Ice.ObjectPrx> _iceI_getNonReplicatedPublisherAsync(java.util.Map<String, String> context, boolean sync)
    {
        com.zeroc.IceInternal.OutgoingAsync<com.zeroc.Ice.ObjectPrx> f = new com.zeroc.IceInternal.OutgoingAsync<>(this, "getNonReplicatedPublisher", com.zeroc.Ice.OperationMode.Nonmutating, sync, null);
        f.invoke(true, context, null, null, istr -> {
                     com.zeroc.Ice.ObjectPrx ret;
                     ret = istr.readProxy();
                     return ret;
                 });
        return f;
    }

    /**
     * Subscribe with the given <tt>qos</tt> to this topic.  A
     * per-subscriber publisher object is returned.
     * @param theQoS The quality of service parameters for this
     * subscription.
     * @param subscriber The subscriber's proxy.
     * @return The per-subscriber publisher object.
     * @throws AlreadySubscribed Raised if the subscriber object is
     * already subscribed.
     * @throws BadQoS Raised if the requested quality of service
     * is unavailable or invalid.
     * @throws InvalidSubscriber Raised if the subscriber object is null.
     *
     * @see #unsubscribe
     **/
    default com.zeroc.Ice.ObjectPrx subscribeAndGetPublisher(java.util.Map<java.lang.String, java.lang.String> theQoS, com.zeroc.Ice.ObjectPrx subscriber)
        throws AlreadySubscribed,
               BadQoS,
               InvalidSubscriber
    {
        return subscribeAndGetPublisher(theQoS, subscriber, com.zeroc.Ice.ObjectPrx.noExplicitContext);
    }

    /**
     * Subscribe with the given <tt>qos</tt> to this topic.  A
     * per-subscriber publisher object is returned.
     * @param theQoS The quality of service parameters for this
     * subscription.
     * @param subscriber The subscriber's proxy.
     * @param context The Context map to send with the invocation.
     * @return The per-subscriber publisher object.
     * @throws AlreadySubscribed Raised if the subscriber object is
     * already subscribed.
     * @throws BadQoS Raised if the requested quality of service
     * is unavailable or invalid.
     * @throws InvalidSubscriber Raised if the subscriber object is null.
     *
     * @see #unsubscribe
     **/
    default com.zeroc.Ice.ObjectPrx subscribeAndGetPublisher(java.util.Map<java.lang.String, java.lang.String> theQoS, com.zeroc.Ice.ObjectPrx subscriber, java.util.Map<String, String> context)
        throws AlreadySubscribed,
               BadQoS,
               InvalidSubscriber
    {
        try
        {
            return _iceI_subscribeAndGetPublisherAsync(theQoS, subscriber, context, true).waitForResponseOrUserEx();
        }
        catch(AlreadySubscribed ex)
        {
            throw ex;
        }
        catch(BadQoS ex)
        {
            throw ex;
        }
        catch(InvalidSubscriber ex)
        {
            throw ex;
        }
        catch(com.zeroc.Ice.UserException ex)
        {
            throw new com.zeroc.Ice.UnknownUserException(ex.ice_id(), ex);
        }
    }

    /**
     * Subscribe with the given <tt>qos</tt> to this topic.  A
     * per-subscriber publisher object is returned.
     * @param theQoS The quality of service parameters for this
     * subscription.
     * @param subscriber The subscriber's proxy.
     * @return The per-subscriber publisher object.
     *
     * @see #unsubscribe
     **/
    default java.util.concurrent.CompletableFuture<com.zeroc.Ice.ObjectPrx> subscribeAndGetPublisherAsync(java.util.Map<java.lang.String, java.lang.String> theQoS, com.zeroc.Ice.ObjectPrx subscriber)
    {
        return _iceI_subscribeAndGetPublisherAsync(theQoS, subscriber, com.zeroc.Ice.ObjectPrx.noExplicitContext, false);
    }

    /**
     * Subscribe with the given <tt>qos</tt> to this topic.  A
     * per-subscriber publisher object is returned.
     * @param theQoS The quality of service parameters for this
     * subscription.
     * @param subscriber The subscriber's proxy.
     * @param context The Context map to send with the invocation.
     * @return The per-subscriber publisher object.
     *
     * @see #unsubscribe
     **/
    default java.util.concurrent.CompletableFuture<com.zeroc.Ice.ObjectPrx> subscribeAndGetPublisherAsync(java.util.Map<java.lang.String, java.lang.String> theQoS, com.zeroc.Ice.ObjectPrx subscriber, java.util.Map<String, String> context)
    {
        return _iceI_subscribeAndGetPublisherAsync(theQoS, subscriber, context, false);
    }

    default com.zeroc.IceInternal.OutgoingAsync<com.zeroc.Ice.ObjectPrx> _iceI_subscribeAndGetPublisherAsync(java.util.Map<java.lang.String, java.lang.String> iceP_theQoS, com.zeroc.Ice.ObjectPrx iceP_subscriber, java.util.Map<String, String> context, boolean sync)
    {
        com.zeroc.IceInternal.OutgoingAsync<com.zeroc.Ice.ObjectPrx> f = new com.zeroc.IceInternal.OutgoingAsync<>(this, "subscribeAndGetPublisher", null, sync, _iceE_subscribeAndGetPublisher);
        f.invoke(true, context, null, ostr -> {
                     QoSHelper.write(ostr, iceP_theQoS);
                     ostr.writeProxy(iceP_subscriber);
                 }, istr -> {
                     com.zeroc.Ice.ObjectPrx ret;
                     ret = istr.readProxy();
                     return ret;
                 });
        return f;
    }

    static final Class<?>[] _iceE_subscribeAndGetPublisher =
    {
        AlreadySubscribed.class,
        BadQoS.class,
        InvalidSubscriber.class
    };

    /**
     * Unsubscribe the given <tt>subscriber</tt>.
     * @param subscriber The proxy of an existing subscriber.
     *
     * @see #subscribeAndGetPublisher
     **/
    default void unsubscribe(com.zeroc.Ice.ObjectPrx subscriber)
    {
        unsubscribe(subscriber, com.zeroc.Ice.ObjectPrx.noExplicitContext);
    }

    /**
     * Unsubscribe the given <tt>subscriber</tt>.
     * @param subscriber The proxy of an existing subscriber.
     * @param context The Context map to send with the invocation.
     *
     * @see #subscribeAndGetPublisher
     **/
    default void unsubscribe(com.zeroc.Ice.ObjectPrx subscriber, java.util.Map<String, String> context)
    {
        _iceI_unsubscribeAsync(subscriber, context, true).waitForResponse();
    }

    /**
     * Unsubscribe the given <tt>subscriber</tt>.
     * @param subscriber The proxy of an existing subscriber.
     * @return A future that will be completed when the invocation completes.
     *
     * @see #subscribeAndGetPublisher
     **/
    default java.util.concurrent.CompletableFuture<Void> unsubscribeAsync(com.zeroc.Ice.ObjectPrx subscriber)
    {
        return _iceI_unsubscribeAsync(subscriber, com.zeroc.Ice.ObjectPrx.noExplicitContext, false);
    }

    /**
     * Unsubscribe the given <tt>subscriber</tt>.
     * @param subscriber The proxy of an existing subscriber.
     * @param context The Context map to send with the invocation.
     * @return A future that will be completed when the invocation completes.
     *
     * @see #subscribeAndGetPublisher
     **/
    default java.util.concurrent.CompletableFuture<Void> unsubscribeAsync(com.zeroc.Ice.ObjectPrx subscriber, java.util.Map<String, String> context)
    {
        return _iceI_unsubscribeAsync(subscriber, context, false);
    }

    default com.zeroc.IceInternal.OutgoingAsync<Void> _iceI_unsubscribeAsync(com.zeroc.Ice.ObjectPrx iceP_subscriber, java.util.Map<String, String> context, boolean sync)
    {
        com.zeroc.IceInternal.OutgoingAsync<Void> f = new com.zeroc.IceInternal.OutgoingAsync<>(this, "unsubscribe", com.zeroc.Ice.OperationMode.Idempotent, sync, null);
        f.invoke(false, context, null, ostr -> {
                     ostr.writeProxy(iceP_subscriber);
                 }, null);
        return f;
    }

    /**
     * Create a link to the given topic. All events originating
     * on this topic will also be sent to <tt>linkTo</tt>.
     * @param linkTo The topic to link to.
     * @param cost The cost to the linked topic.
     * @throws LinkExists Raised if a link to the same topic already
     * exists.
     **/
    default void link(TopicPrx linkTo, int cost)
        throws LinkExists
    {
        link(linkTo, cost, com.zeroc.Ice.ObjectPrx.noExplicitContext);
    }

    /**
     * Create a link to the given topic. All events originating
     * on this topic will also be sent to <tt>linkTo</tt>.
     * @param linkTo The topic to link to.
     * @param cost The cost to the linked topic.
     * @param context The Context map to send with the invocation.
     * @throws LinkExists Raised if a link to the same topic already
     * exists.
     **/
    default void link(TopicPrx linkTo, int cost, java.util.Map<String, String> context)
        throws LinkExists
    {
        try
        {
            _iceI_linkAsync(linkTo, cost, context, true).waitForResponseOrUserEx();
        }
        catch(LinkExists ex)
        {
            throw ex;
        }
        catch(com.zeroc.Ice.UserException ex)
        {
            throw new com.zeroc.Ice.UnknownUserException(ex.ice_id(), ex);
        }
    }

    /**
     * Create a link to the given topic. All events originating
     * on this topic will also be sent to <tt>linkTo</tt>.
     * @param linkTo The topic to link to.
     * @param cost The cost to the linked topic.
     * @return A future that will be completed when the invocation completes.
     **/
    default java.util.concurrent.CompletableFuture<Void> linkAsync(TopicPrx linkTo, int cost)
    {
        return _iceI_linkAsync(linkTo, cost, com.zeroc.Ice.ObjectPrx.noExplicitContext, false);
    }

    /**
     * Create a link to the given topic. All events originating
     * on this topic will also be sent to <tt>linkTo</tt>.
     * @param linkTo The topic to link to.
     * @param cost The cost to the linked topic.
     * @param context The Context map to send with the invocation.
     * @return A future that will be completed when the invocation completes.
     **/
    default java.util.concurrent.CompletableFuture<Void> linkAsync(TopicPrx linkTo, int cost, java.util.Map<String, String> context)
    {
        return _iceI_linkAsync(linkTo, cost, context, false);
    }

    default com.zeroc.IceInternal.OutgoingAsync<Void> _iceI_linkAsync(TopicPrx iceP_linkTo, int iceP_cost, java.util.Map<String, String> context, boolean sync)
    {
        com.zeroc.IceInternal.OutgoingAsync<Void> f = new com.zeroc.IceInternal.OutgoingAsync<>(this, "link", null, sync, _iceE_link);
        f.invoke(true, context, null, ostr -> {
                     ostr.writeProxy(iceP_linkTo);
                     ostr.writeInt(iceP_cost);
                 }, null);
        return f;
    }

    static final Class<?>[] _iceE_link =
    {
        LinkExists.class
    };

    /**
     * Destroy the link from this topic to the given topic <tt>linkTo</tt>.
     * @param linkTo The topic to destroy the link to.
     * @throws NoSuchLink Raised if a link to the topic does not exist.
     **/
    default void unlink(TopicPrx linkTo)
        throws NoSuchLink
    {
        unlink(linkTo, com.zeroc.Ice.ObjectPrx.noExplicitContext);
    }

    /**
     * Destroy the link from this topic to the given topic <tt>linkTo</tt>.
     * @param linkTo The topic to destroy the link to.
     * @param context The Context map to send with the invocation.
     * @throws NoSuchLink Raised if a link to the topic does not exist.
     **/
    default void unlink(TopicPrx linkTo, java.util.Map<String, String> context)
        throws NoSuchLink
    {
        try
        {
            _iceI_unlinkAsync(linkTo, context, true).waitForResponseOrUserEx();
        }
        catch(NoSuchLink ex)
        {
            throw ex;
        }
        catch(com.zeroc.Ice.UserException ex)
        {
            throw new com.zeroc.Ice.UnknownUserException(ex.ice_id(), ex);
        }
    }

    /**
     * Destroy the link from this topic to the given topic <tt>linkTo</tt>.
     * @param linkTo The topic to destroy the link to.
     * @return A future that will be completed when the invocation completes.
     **/
    default java.util.concurrent.CompletableFuture<Void> unlinkAsync(TopicPrx linkTo)
    {
        return _iceI_unlinkAsync(linkTo, com.zeroc.Ice.ObjectPrx.noExplicitContext, false);
    }

    /**
     * Destroy the link from this topic to the given topic <tt>linkTo</tt>.
     * @param linkTo The topic to destroy the link to.
     * @param context The Context map to send with the invocation.
     * @return A future that will be completed when the invocation completes.
     **/
    default java.util.concurrent.CompletableFuture<Void> unlinkAsync(TopicPrx linkTo, java.util.Map<String, String> context)
    {
        return _iceI_unlinkAsync(linkTo, context, false);
    }

    default com.zeroc.IceInternal.OutgoingAsync<Void> _iceI_unlinkAsync(TopicPrx iceP_linkTo, java.util.Map<String, String> context, boolean sync)
    {
        com.zeroc.IceInternal.OutgoingAsync<Void> f = new com.zeroc.IceInternal.OutgoingAsync<>(this, "unlink", null, sync, _iceE_unlink);
        f.invoke(true, context, null, ostr -> {
                     ostr.writeProxy(iceP_linkTo);
                 }, null);
        return f;
    }

    static final Class<?>[] _iceE_unlink =
    {
        NoSuchLink.class
    };

    /**
     * Retrieve information on the current links.
     * @return A sequence of LinkInfo objects.
     **/
    default LinkInfo[] getLinkInfoSeq()
    {
        return getLinkInfoSeq(com.zeroc.Ice.ObjectPrx.noExplicitContext);
    }

    /**
     * Retrieve information on the current links.
     * @param context The Context map to send with the invocation.
     * @return A sequence of LinkInfo objects.
     **/
    default LinkInfo[] getLinkInfoSeq(java.util.Map<String, String> context)
    {
        return _iceI_getLinkInfoSeqAsync(context, true).waitForResponse();
    }

    /**
     * Retrieve information on the current links.
     * @return A sequence of LinkInfo objects.
     **/
    default java.util.concurrent.CompletableFuture<LinkInfo[]> getLinkInfoSeqAsync()
    {
        return _iceI_getLinkInfoSeqAsync(com.zeroc.Ice.ObjectPrx.noExplicitContext, false);
    }

    /**
     * Retrieve information on the current links.
     * @param context The Context map to send with the invocation.
     * @return A sequence of LinkInfo objects.
     **/
    default java.util.concurrent.CompletableFuture<LinkInfo[]> getLinkInfoSeqAsync(java.util.Map<String, String> context)
    {
        return _iceI_getLinkInfoSeqAsync(context, false);
    }

    default com.zeroc.IceInternal.OutgoingAsync<LinkInfo[]> _iceI_getLinkInfoSeqAsync(java.util.Map<String, String> context, boolean sync)
    {
        com.zeroc.IceInternal.OutgoingAsync<LinkInfo[]> f = new com.zeroc.IceInternal.OutgoingAsync<>(this, "getLinkInfoSeq", com.zeroc.Ice.OperationMode.Nonmutating, sync, null);
        f.invoke(true, context, null, null, istr -> {
                     LinkInfo[] ret;
                     ret = LinkInfoSeqHelper.read(istr);
                     return ret;
                 });
        return f;
    }

    /**
     * Retrieve the list of subscribers for this topic.
     * @return The sequence of Ice identities for the subscriber objects.
     **/
    default com.zeroc.Ice.Identity[] getSubscribers()
    {
        return getSubscribers(com.zeroc.Ice.ObjectPrx.noExplicitContext);
    }

    /**
     * Retrieve the list of subscribers for this topic.
     * @param context The Context map to send with the invocation.
     * @return The sequence of Ice identities for the subscriber objects.
     **/
    default com.zeroc.Ice.Identity[] getSubscribers(java.util.Map<String, String> context)
    {
        return _iceI_getSubscribersAsync(context, true).waitForResponse();
    }

    /**
     * Retrieve the list of subscribers for this topic.
     * @return The sequence of Ice identities for the subscriber objects.
     **/
    default java.util.concurrent.CompletableFuture<com.zeroc.Ice.Identity[]> getSubscribersAsync()
    {
        return _iceI_getSubscribersAsync(com.zeroc.Ice.ObjectPrx.noExplicitContext, false);
    }

    /**
     * Retrieve the list of subscribers for this topic.
     * @param context The Context map to send with the invocation.
     * @return The sequence of Ice identities for the subscriber objects.
     **/
    default java.util.concurrent.CompletableFuture<com.zeroc.Ice.Identity[]> getSubscribersAsync(java.util.Map<String, String> context)
    {
        return _iceI_getSubscribersAsync(context, false);
    }

    default com.zeroc.IceInternal.OutgoingAsync<com.zeroc.Ice.Identity[]> _iceI_getSubscribersAsync(java.util.Map<String, String> context, boolean sync)
    {
        com.zeroc.IceInternal.OutgoingAsync<com.zeroc.Ice.Identity[]> f = new com.zeroc.IceInternal.OutgoingAsync<>(this, "getSubscribers", null, sync, null);
        f.invoke(true, context, null, null, istr -> {
                     com.zeroc.Ice.Identity[] ret;
                     ret = com.zeroc.Ice.IdentitySeqHelper.read(istr);
                     return ret;
                 });
        return f;
    }

    /**
     * Destroy the topic.
     **/
    default void destroy()
    {
        destroy(com.zeroc.Ice.ObjectPrx.noExplicitContext);
    }

    /**
     * Destroy the topic.
     * @param context The Context map to send with the invocation.
     **/
    default void destroy(java.util.Map<String, String> context)
    {
        _iceI_destroyAsync(context, true).waitForResponse();
    }

    /**
     * Destroy the topic.
     * @return A future that will be completed when the invocation completes.
     **/
    default java.util.concurrent.CompletableFuture<Void> destroyAsync()
    {
        return _iceI_destroyAsync(com.zeroc.Ice.ObjectPrx.noExplicitContext, false);
    }

    /**
     * Destroy the topic.
     * @param context The Context map to send with the invocation.
     * @return A future that will be completed when the invocation completes.
     **/
    default java.util.concurrent.CompletableFuture<Void> destroyAsync(java.util.Map<String, String> context)
    {
        return _iceI_destroyAsync(context, false);
    }

    default com.zeroc.IceInternal.OutgoingAsync<Void> _iceI_destroyAsync(java.util.Map<String, String> context, boolean sync)
    {
        com.zeroc.IceInternal.OutgoingAsync<Void> f = new com.zeroc.IceInternal.OutgoingAsync<>(this, "destroy", null, sync, null);
        f.invoke(false, context, null, null, null);
        return f;
    }

    /**
     * Contacts the remote server to verify that the object implements this type.
     * Raises a local exception if a communication error occurs.
     * @param obj The untyped proxy.
     * @return A proxy for this type, or null if the object does not support this type.
     **/
    static TopicPrx checkedCast(com.zeroc.Ice.ObjectPrx obj)
    {
        return com.zeroc.Ice.ObjectPrx._checkedCast(obj, ice_staticId(), TopicPrx.class, _TopicPrxI.class);
    }

    /**
     * Contacts the remote server to verify that the object implements this type.
     * Raises a local exception if a communication error occurs.
     * @param obj The untyped proxy.
     * @param context The Context map to send with the invocation.
     * @return A proxy for this type, or null if the object does not support this type.
     **/
    static TopicPrx checkedCast(com.zeroc.Ice.ObjectPrx obj, java.util.Map<String, String> context)
    {
        return com.zeroc.Ice.ObjectPrx._checkedCast(obj, context, ice_staticId(), TopicPrx.class, _TopicPrxI.class);
    }

    /**
     * Contacts the remote server to verify that a facet of the object implements this type.
     * Raises a local exception if a communication error occurs.
     * @param obj The untyped proxy.
     * @param facet The name of the desired facet.
     * @return A proxy for this type, or null if the object does not support this type.
     **/
    static TopicPrx checkedCast(com.zeroc.Ice.ObjectPrx obj, String facet)
    {
        return com.zeroc.Ice.ObjectPrx._checkedCast(obj, facet, ice_staticId(), TopicPrx.class, _TopicPrxI.class);
    }

    /**
     * Contacts the remote server to verify that a facet of the object implements this type.
     * Raises a local exception if a communication error occurs.
     * @param obj The untyped proxy.
     * @param facet The name of the desired facet.
     * @param context The Context map to send with the invocation.
     * @return A proxy for this type, or null if the object does not support this type.
     **/
    static TopicPrx checkedCast(com.zeroc.Ice.ObjectPrx obj, String facet, java.util.Map<String, String> context)
    {
        return com.zeroc.Ice.ObjectPrx._checkedCast(obj, facet, context, ice_staticId(), TopicPrx.class, _TopicPrxI.class);
    }

    /**
     * Downcasts the given proxy to this type without contacting the remote server.
     * @param obj The untyped proxy.
     * @return A proxy for this type.
     **/
    static TopicPrx uncheckedCast(com.zeroc.Ice.ObjectPrx obj)
    {
        return com.zeroc.Ice.ObjectPrx._uncheckedCast(obj, TopicPrx.class, _TopicPrxI.class);
    }

    /**
     * Downcasts the given proxy to this type without contacting the remote server.
     * @param obj The untyped proxy.
     * @param facet The name of the desired facet.
     * @return A proxy for this type.
     **/
    static TopicPrx uncheckedCast(com.zeroc.Ice.ObjectPrx obj, String facet)
    {
        return com.zeroc.Ice.ObjectPrx._uncheckedCast(obj, facet, TopicPrx.class, _TopicPrxI.class);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the per-proxy context.
     * @param newContext The context for the new proxy.
     * @return A proxy with the specified per-proxy context.
     **/
    @Override
    default TopicPrx ice_context(java.util.Map<String, String> newContext)
    {
        return (TopicPrx)_ice_context(newContext);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the adapter ID.
     * @param newAdapterId The adapter ID for the new proxy.
     * @return A proxy with the specified adapter ID.
     **/
    @Override
    default TopicPrx ice_adapterId(String newAdapterId)
    {
        return (TopicPrx)_ice_adapterId(newAdapterId);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the endpoints.
     * @param newEndpoints The endpoints for the new proxy.
     * @return A proxy with the specified endpoints.
     **/
    @Override
    default TopicPrx ice_endpoints(com.zeroc.Ice.Endpoint[] newEndpoints)
    {
        return (TopicPrx)_ice_endpoints(newEndpoints);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the locator cache timeout.
     * @param newTimeout The new locator cache timeout (in seconds).
     * @return A proxy with the specified locator cache timeout.
     **/
    @Override
    default TopicPrx ice_locatorCacheTimeout(int newTimeout)
    {
        return (TopicPrx)_ice_locatorCacheTimeout(newTimeout);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the invocation timeout.
     * @param newTimeout The new invocation timeout (in seconds).
     * @return A proxy with the specified invocation timeout.
     **/
    @Override
    default TopicPrx ice_invocationTimeout(int newTimeout)
    {
        return (TopicPrx)_ice_invocationTimeout(newTimeout);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for connection caching.
     * @param newCache <code>true</code> if the new proxy should cache connections; <code>false</code> otherwise.
     * @return A proxy with the specified caching policy.
     **/
    @Override
    default TopicPrx ice_connectionCached(boolean newCache)
    {
        return (TopicPrx)_ice_connectionCached(newCache);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the endpoint selection policy.
     * @param newType The new endpoint selection policy.
     * @return A proxy with the specified endpoint selection policy.
     **/
    @Override
    default TopicPrx ice_endpointSelection(com.zeroc.Ice.EndpointSelectionType newType)
    {
        return (TopicPrx)_ice_endpointSelection(newType);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for how it selects endpoints.
     * @param b If <code>b</code> is <code>true</code>, only endpoints that use a secure transport are
     * used by the new proxy. If <code>b</code> is false, the returned proxy uses both secure and
     * insecure endpoints.
     * @return A proxy with the specified selection policy.
     **/
    @Override
    default TopicPrx ice_secure(boolean b)
    {
        return (TopicPrx)_ice_secure(b);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the encoding used to marshal parameters.
     * @param e The encoding version to use to marshal request parameters.
     * @return A proxy with the specified encoding version.
     **/
    @Override
    default TopicPrx ice_encodingVersion(com.zeroc.Ice.EncodingVersion e)
    {
        return (TopicPrx)_ice_encodingVersion(e);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for its endpoint selection policy.
     * @param b If <code>b</code> is <code>true</code>, the new proxy will use secure endpoints for invocations
     * and only use insecure endpoints if an invocation cannot be made via secure endpoints. If <code>b</code> is
     * <code>false</code>, the proxy prefers insecure endpoints to secure ones.
     * @return A proxy with the specified selection policy.
     **/
    @Override
    default TopicPrx ice_preferSecure(boolean b)
    {
        return (TopicPrx)_ice_preferSecure(b);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the router.
     * @param router The router for the new proxy.
     * @return A proxy with the specified router.
     **/
    @Override
    default TopicPrx ice_router(com.zeroc.Ice.RouterPrx router)
    {
        return (TopicPrx)_ice_router(router);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the locator.
     * @param locator The locator for the new proxy.
     * @return A proxy with the specified locator.
     **/
    @Override
    default TopicPrx ice_locator(com.zeroc.Ice.LocatorPrx locator)
    {
        return (TopicPrx)_ice_locator(locator);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for collocation optimization.
     * @param b <code>true</code> if the new proxy enables collocation optimization; <code>false</code> otherwise.
     * @return A proxy with the specified collocation optimization.
     **/
    @Override
    default TopicPrx ice_collocationOptimized(boolean b)
    {
        return (TopicPrx)_ice_collocationOptimized(b);
    }

    /**
     * Returns a proxy that is identical to this proxy, but uses twoway invocations.
     * @return A proxy that uses twoway invocations.
     **/
    @Override
    default TopicPrx ice_twoway()
    {
        return (TopicPrx)_ice_twoway();
    }

    /**
     * Returns a proxy that is identical to this proxy, but uses oneway invocations.
     * @return A proxy that uses oneway invocations.
     **/
    @Override
    default TopicPrx ice_oneway()
    {
        return (TopicPrx)_ice_oneway();
    }

    /**
     * Returns a proxy that is identical to this proxy, but uses batch oneway invocations.
     * @return A proxy that uses batch oneway invocations.
     **/
    @Override
    default TopicPrx ice_batchOneway()
    {
        return (TopicPrx)_ice_batchOneway();
    }

    /**
     * Returns a proxy that is identical to this proxy, but uses datagram invocations.
     * @return A proxy that uses datagram invocations.
     **/
    @Override
    default TopicPrx ice_datagram()
    {
        return (TopicPrx)_ice_datagram();
    }

    /**
     * Returns a proxy that is identical to this proxy, but uses batch datagram invocations.
     * @return A proxy that uses batch datagram invocations.
     **/
    @Override
    default TopicPrx ice_batchDatagram()
    {
        return (TopicPrx)_ice_batchDatagram();
    }

    /**
     * Returns a proxy that is identical to this proxy, except for compression.
     * @param co <code>true</code> enables compression for the new proxy; <code>false</code> disables compression.
     * @return A proxy with the specified compression setting.
     **/
    @Override
    default TopicPrx ice_compress(boolean co)
    {
        return (TopicPrx)_ice_compress(co);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for its connection timeout setting.
     * @param t The connection timeout for the proxy in milliseconds.
     * @return A proxy with the specified timeout.
     **/
    @Override
    default TopicPrx ice_timeout(int t)
    {
        return (TopicPrx)_ice_timeout(t);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for its connection ID.
     * @param connectionId The connection ID for the new proxy. An empty string removes the connection ID.
     * @return A proxy with the specified connection ID.
     **/
    @Override
    default TopicPrx ice_connectionId(String connectionId)
    {
        return (TopicPrx)_ice_connectionId(connectionId);
    }

    /**
     * Returns a proxy that is identical to this proxy, except it's a fixed proxy bound
     * the given connection.@param connection The fixed proxy connection.
     * @return A fixed proxy bound to the given connection.
     **/
    @Override
    default TopicPrx ice_fixed(com.zeroc.Ice.Connection connection)
    {
        return (TopicPrx)_ice_fixed(connection);
    }

    static String ice_staticId()
    {
        return "::IceStorm::Topic";
    }
}
