/*
 * Copyright (C) Internet Systems Consortium, Inc. ("ISC")
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * See the COPYRIGHT file distributed with this work for additional
 * information regarding copyright ownership.
 */

#ifndef ISC_PLATFORM_H
#define ISC_PLATFORM_H 1

/*! \file */

/*****
 ***** Platform-dependent defines.
 *****/

/***
 *** Thread-Local Storage
 ***/

#ifdef HAVE___THREAD
#define thread_local __thread
#endif

/***
 *** Default strerror_r buffer size
 ***/

#define ISC_STRERRORSIZE 128

/***
 *** Network.
 ***/

/*! \brief
 * Define if the system has struct lifconf which is a extended struct ifconf
 * for IPv6.
 */
#undef ISC_PLATFORM_HAVELIFCONF

/*! \brief
 * Define if the system has struct if_laddrconf which is a extended struct
 * ifconf for IPv6.
 */
#undef ISC_PLATFORM_HAVEIF_LADDRCONF

/*! \brief
 * Define if the system has struct if_laddrreq.
 */
#undef ISC_PLATFORM_HAVEIF_LADDRREQ

/*! \brief
 * Define if the system supports if_nametoindex.
 */
#define ISC_PLATFORM_HAVEIFNAMETOINDEX 1

/*! \brief
 * Define if the system has TCP_FASTOPEN socket option.
 */
#define ISC_PLATFORM_HAVETFO 1

/*! \brief
 * Define if the system supports kqueue multiplexing
 */
#undef ISC_PLATFORM_HAVEKQUEUE

/*! \brief
 * Define if the system supports epoll multiplexing
 */
#define ISC_PLATFORM_HAVEEPOLL 1

/*! \brief
 * Define if the system supports /dev/poll multiplexing
 */
#undef ISC_PLATFORM_HAVEDEVPOLL

/*! \brief
 * Define if we want to log backtrace
 */
#define ISC_PLATFORM_USEBACKTRACE 1

/*
 *** Printing.
 ***/

/*
 * If the system needs strlcpy(), ISC_PLATFORM_NEEDSTRLCPY will be defined.
 */
#define ISC_PLATFORM_NEEDSTRLCPY 1

/*
 * If the system needs strlcat(), ISC_PLATFORM_NEEDSTRLCAT will be defined.
 */
#define ISC_PLATFORM_NEEDSTRLCAT 1

/***
 *** Miscellaneous.
 ***/

/*
 * Defined if unistd.h does not cause fd_set to be delared.
 */
#undef ISC_PLATFORM_NEEDSYSSELECTH

/*
 * Defined to <gssapi.h> or <gssapi/gssapi.h> for how to include
 * the GSSAPI header.
 */
#define ISC_PLATFORM_GSSAPIHEADER <gssapi/gssapi.h>

/*
 * Defined to <gssapi_krb5.h> or <gssapi/gssapi_krb5.h> for how to
 * include the GSSAPI KRB5 header.
 */
#define ISC_PLATFORM_GSSAPI_KRB5_HEADER <gssapi/gssapi_krb5.h>

/*
 * Defined to <krb5.h> or <krb5/krb5.h> for how to include
 * the KRB5 header.
 */
#define ISC_PLATFORM_KRB5HEADER <krb5/krb5.h>

/*
 * Define if the system has nanosecond-level accuracy in file stats.
 */
#define ISC_PLATFORM_HAVESTATNSEC 1

/*
 * Used to control how extern data is linked; needed for Win32 platforms.
 */
#undef ISC_PLATFORM_USEDECLSPEC

/*
 * Define if the platform has <sys/un.h>.
 */
#define ISC_PLATFORM_HAVESYSUNH 1

/*
 * Define with the busy wait nop asm or function call.
 */


/*
 * Define if the platform has <strings.h>.
 */
#define ISC_PLATFORM_HAVESTRINGSH 1

/*
 * Defines for the noreturn attribute.
 */
#define ISC_PLATFORM_NORETURN_PRE
#define ISC_PLATFORM_NORETURN_POST __attribute__((noreturn))

/***
 ***	Windows dll support.
 ***/

#ifndef ISC_PLATFORM_USEDECLSPEC
#define LIBISC_EXTERNAL_DATA
#define LIBDNS_EXTERNAL_DATA
#define LIBISCCC_EXTERNAL_DATA
#define LIBISCCFG_EXTERNAL_DATA
#define LIBNS_EXTERNAL_DATA
#define LIBBIND9_EXTERNAL_DATA
#define LIBTESTS_EXTERNAL_DATA
#else /*! \brief ISC_PLATFORM_USEDECLSPEC */
#ifdef LIBISC_EXPORTS
#define LIBISC_EXTERNAL_DATA __declspec(dllexport)
#else
#define LIBISC_EXTERNAL_DATA __declspec(dllimport)
#endif
#ifdef LIBDNS_EXPORTS
#define LIBDNS_EXTERNAL_DATA __declspec(dllexport)
#else
#define LIBDNS_EXTERNAL_DATA __declspec(dllimport)
#endif
#ifdef LIBISCCC_EXPORTS
#define LIBISCCC_EXTERNAL_DATA __declspec(dllexport)
#else
#define LIBISCCC_EXTERNAL_DATA __declspec(dllimport)
#endif
#ifdef LIBISCCFG_EXPORTS
#define LIBISCCFG_EXTERNAL_DATA __declspec(dllexport)
#else
#define LIBISCCFG_EXTERNAL_DATA __declspec(dllimport)
#endif
#ifdef LIBNS_EXPORTS
#define LIBNS_EXTERNAL_DATA __declspec(dllexport)
#else
#define LIBNS_EXTERNAL_DATA __declspec(dllimport)
#endif
#ifdef LIBBIND9_EXPORTS
#define LIBBIND9_EXTERNAL_DATA __declspec(dllexport)
#else
#define LIBBIND9_EXTERNAL_DATA __declspec(dllimport)
#endif
#ifdef LIBTESTS_EXPORTS
#define LIBTESTS_EXTERNAL_DATA __declspec(dllexport)
#else
#define LIBTESTS_EXTERNAL_DATA __declspec(dllimport)
#endif
#endif /*! \brief ISC_PLATFORM_USEDECLSPEC */

/*
 * Tell emacs to use C mode for this file.
 *
 * Local Variables:
 * mode: c
 * End:
 */

#endif /* ISC_PLATFORM_H */
