/*
 * Decompiled with CFR 0.152.
 */
package org.hamcrest.number;

import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IsCloseTo
extends TypeSafeMatcher<Double> {
    private final double delta;
    private final double value;

    public IsCloseTo(double value, double error) {
        this.delta = error;
        this.value = value;
    }

    public boolean matchesSafely(Double item) {
        return this.actualDelta(item) <= 0.0;
    }

    public void describeMismatchSafely(Double item, Description mismatchDescription) {
        mismatchDescription.appendValue((Object)item).appendText(" differed by ").appendValue((Object)this.actualDelta(item));
    }

    public void describeTo(Description description) {
        description.appendText("a numeric value within ").appendValue((Object)this.delta).appendText(" of ").appendValue((Object)this.value);
    }

    private double actualDelta(Double item) {
        return Math.abs(item - this.value) - this.delta;
    }

    @Factory
    public static Matcher<Double> closeTo(double operand, double error) {
        return new IsCloseTo(operand, error);
    }
}

