/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import java.io.UnsupportedEncodingException;
import java.nio.file.Path;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ResourceAlreadyExistsException;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.alias.Alias;
import org.elasticsearch.action.admin.indices.create.CreateIndexClusterStateUpdateRequest;
import org.elasticsearch.action.admin.indices.shrink.ResizeType;
import org.elasticsearch.action.support.ActiveShardCount;
import org.elasticsearch.action.support.ActiveShardsObserver;
import org.elasticsearch.cluster.AckedClusterStateUpdateTask;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ack.ClusterStateUpdateResponse;
import org.elasticsearch.cluster.ack.CreateIndexClusterStateUpdateResponse;
import org.elasticsearch.cluster.block.ClusterBlock;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.block.ClusterBlocks;
import org.elasticsearch.cluster.metadata.AliasMetaData;
import org.elasticsearch.cluster.metadata.AliasValidator;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.IndexTemplateMetaData;
import org.elasticsearch.cluster.metadata.MappingMetaData;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.metadata.MetaDataIndexTemplateService;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.routing.IndexRoutingTable;
import org.elasticsearch.cluster.routing.RoutingTable;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.ShardRoutingState;
import org.elasticsearch.cluster.routing.allocation.AllocationService;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.UUIDs;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.compress.CompressedXContent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.PathUtils;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.env.Environment;
import org.elasticsearch.index.AbstractIndexComponent;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.mapper.DocumentMapper;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.indices.IndexCreationException;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.indices.InvalidIndexNameException;
import org.elasticsearch.indices.cluster.IndicesClusterStateService;
import org.elasticsearch.threadpool.ThreadPool;

public class MetaDataCreateIndexService
extends AbstractComponent {
    private static final DeprecationLogger deprecationLogger = new DeprecationLogger(Loggers.getLogger(MetaDataCreateIndexService.class));
    public static final int MAX_INDEX_NAME_BYTES = 255;
    private final ClusterService clusterService;
    private final IndicesService indicesService;
    private final AllocationService allocationService;
    private final AliasValidator aliasValidator;
    private final Environment env;
    private final IndexScopedSettings indexScopedSettings;
    private final ActiveShardsObserver activeShardsObserver;
    private final NamedXContentRegistry xContentRegistry;

    @Inject
    public MetaDataCreateIndexService(Settings settings, ClusterService clusterService, IndicesService indicesService, AllocationService allocationService, AliasValidator aliasValidator, Environment env, IndexScopedSettings indexScopedSettings, ThreadPool threadPool, NamedXContentRegistry xContentRegistry) {
        super(settings);
        this.clusterService = clusterService;
        this.indicesService = indicesService;
        this.allocationService = allocationService;
        this.aliasValidator = aliasValidator;
        this.env = env;
        this.indexScopedSettings = indexScopedSettings;
        this.activeShardsObserver = new ActiveShardsObserver(settings, clusterService, threadPool);
        this.xContentRegistry = xContentRegistry;
    }

    public static void validateIndexName(String index, ClusterState state) {
        MetaDataCreateIndexService.validateIndexOrAliasName(index, InvalidIndexNameException::new);
        if (!index.toLowerCase(Locale.ROOT).equals(index)) {
            throw new InvalidIndexNameException(index, "must be lowercase");
        }
        if (state.routingTable().hasIndex(index)) {
            throw new ResourceAlreadyExistsException(state.routingTable().index(index).getIndex());
        }
        if (state.metaData().hasIndex(index)) {
            throw new ResourceAlreadyExistsException(state.metaData().index(index).getIndex());
        }
        if (state.metaData().hasAlias(index)) {
            throw new InvalidIndexNameException(index, "already exists as alias");
        }
    }

    public static void validateIndexOrAliasName(String index, BiFunction<String, String, ? extends RuntimeException> exceptionCtor) {
        if (!Strings.validFileName(index)) {
            throw exceptionCtor.apply(index, "must not contain the following characters " + Strings.INVALID_FILENAME_CHARS);
        }
        if (index.contains("#")) {
            throw exceptionCtor.apply(index, "must not contain '#'");
        }
        if (index.contains(":")) {
            deprecationLogger.deprecated("index or alias name [" + index + "] containing ':' is deprecated and will not be supported in Elasticsearch 7.0+", new Object[0]);
        }
        if (index.charAt(0) == '_' || index.charAt(0) == '-' || index.charAt(0) == '+') {
            throw exceptionCtor.apply(index, "must not start with '_', '-', or '+'");
        }
        int byteCount = 0;
        try {
            byteCount = index.getBytes("UTF-8").length;
        }
        catch (UnsupportedEncodingException e) {
            throw new ElasticsearchException("Unable to determine length of index name", (Throwable)e, new Object[0]);
        }
        if (byteCount > 255) {
            throw exceptionCtor.apply(index, "index name is too long, (" + byteCount + " > " + 255 + ")");
        }
        if (index.equals(".") || index.equals("..")) {
            throw exceptionCtor.apply(index, "must not be '.' or '..'");
        }
    }

    public void createIndex(CreateIndexClusterStateUpdateRequest request, ActionListener<CreateIndexClusterStateUpdateResponse> listener) {
        this.onlyCreateIndex(request, ActionListener.wrap(response -> {
            if (response.isAcknowledged()) {
                this.activeShardsObserver.waitForActiveShards(new String[]{request.index()}, request.waitForActiveShards(), request.ackTimeout(), shardsAcknowledged -> {
                    if (!shardsAcknowledged.booleanValue()) {
                        this.logger.debug("[{}] index created, but the operation timed out while waiting for enough shards to be started.", (Object)request.index());
                    }
                    listener.onResponse(new CreateIndexClusterStateUpdateResponse(response.isAcknowledged(), (boolean)shardsAcknowledged));
                }, listener::onFailure);
            } else {
                listener.onResponse(new CreateIndexClusterStateUpdateResponse(false, false));
            }
        }, listener::onFailure));
    }

    private void onlyCreateIndex(CreateIndexClusterStateUpdateRequest request, ActionListener<ClusterStateUpdateResponse> listener) {
        Settings.Builder updatedSettingsBuilder = Settings.builder();
        Settings build = updatedSettingsBuilder.put(request.settings()).normalizePrefix("index.").build();
        this.indexScopedSettings.validate(build, true);
        request.settings(build);
        this.clusterService.submitStateUpdateTask("create-index [" + request.index() + "], cause [" + request.cause() + "]", new IndexCreationTask(this.logger, this.allocationService, request, listener, this.indicesService, this.aliasValidator, this.xContentRegistry, this.settings, this::validate, this.indexScopedSettings));
    }

    private void validate(CreateIndexClusterStateUpdateRequest request, ClusterState state) {
        MetaDataCreateIndexService.validateIndexName(request.index(), state);
        this.validateIndexSettings(request.index(), request.settings());
    }

    public void validateIndexSettings(String indexName, Settings settings) throws IndexCreationException {
        List<String> validationErrors = this.getIndexSettingsValidationErrors(settings);
        if (!validationErrors.isEmpty()) {
            ValidationException validationException = new ValidationException();
            validationException.addValidationErrors(validationErrors);
            throw new IndexCreationException(indexName, validationException);
        }
    }

    List<String> getIndexSettingsValidationErrors(Settings settings) {
        Path resolvedPath;
        String customPath = IndexMetaData.INDEX_DATA_PATH_SETTING.get(settings);
        ArrayList<String> validationErrors = new ArrayList<String>();
        if (!Strings.isEmpty(customPath) && this.env.sharedDataFile() == null) {
            validationErrors.add("path.shared_data must be set in order to use custom data paths");
        } else if (!Strings.isEmpty(customPath) && (resolvedPath = PathUtils.get(new Path[]{this.env.sharedDataFile()}, customPath)) == null) {
            validationErrors.add("custom path [" + customPath + "] is not a sub-path of path.shared_data [" + this.env.sharedDataFile() + "]");
        }
        return validationErrors;
    }

    static List<String> validateShrinkIndex(ClusterState state, String sourceIndex, Set<String> targetIndexMappingsTypes, String targetIndexName, Settings targetIndexSettings) {
        IndexMetaData sourceMetaData = MetaDataCreateIndexService.validateResize(state, sourceIndex, targetIndexMappingsTypes, targetIndexName, targetIndexSettings);
        assert (IndexMetaData.INDEX_NUMBER_OF_SHARDS_SETTING.exists(targetIndexSettings));
        IndexMetaData.selectShrinkShards(0, sourceMetaData, IndexMetaData.INDEX_NUMBER_OF_SHARDS_SETTING.get(targetIndexSettings));
        if (sourceMetaData.getNumberOfShards() == 1) {
            throw new IllegalArgumentException("can't shrink an index with only one shard");
        }
        IndexRoutingTable table = state.routingTable().index(sourceIndex);
        HashMap<String, AtomicInteger> nodesToNumRouting = new HashMap<String, AtomicInteger>();
        int numShards = sourceMetaData.getNumberOfShards();
        for (ShardRouting routing : table.shardsWithState(ShardRoutingState.STARTED)) {
            nodesToNumRouting.computeIfAbsent(routing.currentNodeId(), s -> new AtomicInteger(0)).incrementAndGet();
        }
        ArrayList<String> nodesToAllocateOn = new ArrayList<String>();
        for (Map.Entry entries : nodesToNumRouting.entrySet()) {
            int numAllocations = ((AtomicInteger)entries.getValue()).get();
            assert (numAllocations <= numShards) : "wait what? " + numAllocations + " is > than num shards " + numShards;
            if (numAllocations != numShards) continue;
            nodesToAllocateOn.add((String)entries.getKey());
        }
        if (nodesToAllocateOn.isEmpty()) {
            throw new IllegalStateException("index " + sourceIndex + " must have all shards allocated on the same node to shrink index");
        }
        return nodesToAllocateOn;
    }

    static void validateSplitIndex(ClusterState state, String sourceIndex, Set<String> targetIndexMappingsTypes, String targetIndexName, Settings targetIndexSettings) {
        IndexMetaData sourceMetaData = MetaDataCreateIndexService.validateResize(state, sourceIndex, targetIndexMappingsTypes, targetIndexName, targetIndexSettings);
        IndexMetaData.selectSplitShard(0, sourceMetaData, IndexMetaData.INDEX_NUMBER_OF_SHARDS_SETTING.get(targetIndexSettings));
        if (sourceMetaData.getCreationVersion().before(Version.V_6_0_0_alpha1)) {
            throw new IllegalStateException("source index created version is too old to apply a split operation");
        }
    }

    static IndexMetaData validateResize(ClusterState state, String sourceIndex, Set<String> targetIndexMappingsTypes, String targetIndexName, Settings targetIndexSettings) {
        if (state.metaData().hasIndex(targetIndexName)) {
            throw new ResourceAlreadyExistsException(state.metaData().index(targetIndexName).getIndex());
        }
        IndexMetaData sourceMetaData = state.metaData().index(sourceIndex);
        if (sourceMetaData == null) {
            throw new IndexNotFoundException(sourceIndex);
        }
        if (!state.blocks().indexBlocked(ClusterBlockLevel.WRITE, sourceIndex)) {
            throw new IllegalStateException("index " + sourceIndex + " must be read-only to resize index. use \"index.blocks.write=true\"");
        }
        if (targetIndexMappingsTypes.size() > 1 || !(targetIndexMappingsTypes.isEmpty() || targetIndexMappingsTypes.contains("_default_"))) {
            throw new IllegalArgumentException("mappings are not allowed when resizing indices, all mappings are copied from the source index");
        }
        if (IndexMetaData.INDEX_NUMBER_OF_SHARDS_SETTING.exists(targetIndexSettings)) {
            IndexMetaData.getRoutingFactor(sourceMetaData.getNumberOfShards(), IndexMetaData.INDEX_NUMBER_OF_SHARDS_SETTING.get(targetIndexSettings));
        }
        return sourceMetaData;
    }

    static void prepareResizeIndexSettings(ClusterState currentState, Set<String> mappingKeys, Settings.Builder indexSettingsBuilder, Index resizeSourceIndex, String resizeIntoName, ResizeType type, boolean copySettings, IndexScopedSettings indexScopedSettings) {
        IndexMetaData sourceMetaData = currentState.metaData().index(resizeSourceIndex.getName());
        if (type == ResizeType.SHRINK) {
            List<String> nodesToAllocateOn = MetaDataCreateIndexService.validateShrinkIndex(currentState, resizeSourceIndex.getName(), mappingKeys, resizeIntoName, indexSettingsBuilder.build());
            indexSettingsBuilder.put(IndexMetaData.INDEX_ROUTING_INITIAL_RECOVERY_GROUP_SETTING.getKey() + "_id", Strings.arrayToCommaDelimitedString(nodesToAllocateOn.toArray())).put("index.allocation.max_retries", 1).put(IndexMetaData.INDEX_SHRINK_SOURCE_NAME.getKey(), resizeSourceIndex.getName()).put(IndexMetaData.INDEX_SHRINK_SOURCE_UUID.getKey(), resizeSourceIndex.getUUID());
        } else if (type == ResizeType.SPLIT) {
            MetaDataCreateIndexService.validateSplitIndex(currentState, resizeSourceIndex.getName(), mappingKeys, resizeIntoName, indexSettingsBuilder.build());
        } else {
            throw new IllegalStateException("unknown resize type is " + (Object)((Object)type));
        }
        Settings.Builder builder = Settings.builder();
        if (copySettings) {
            for (String key : sourceMetaData.getSettings().keySet()) {
                Setting<?> setting = indexScopedSettings.get(key);
                if (setting == null) {
                    assert (indexScopedSettings.isPrivateSetting(key)) : key;
                } else if (setting.getProperties().contains((Object)Setting.Property.NotCopyableOnResize)) continue;
                if (indexSettingsBuilder.keys().contains(key)) continue;
                builder.copy(key, sourceMetaData.getSettings());
            }
        } else {
            Predicate<String> sourceSettingsPredicate = s -> (s.startsWith("index.similarity.") || s.startsWith("index.analysis.") || s.startsWith("index.sort.") || s.equals("index.mapping.single_type")) && !indexSettingsBuilder.keys().contains(s);
            builder.put(sourceMetaData.getSettings().filter(sourceSettingsPredicate));
        }
        indexSettingsBuilder.put("index.version.created", sourceMetaData.getCreationVersion()).put("index.version.upgraded", sourceMetaData.getUpgradedVersion()).put(builder.build()).put("index.routing_partition_size", sourceMetaData.getRoutingPartitionSize()).put(IndexMetaData.INDEX_RESIZE_SOURCE_NAME.getKey(), resizeSourceIndex.getName()).put(IndexMetaData.INDEX_RESIZE_SOURCE_UUID.getKey(), resizeSourceIndex.getUUID());
    }

    static class IndexCreationTask
    extends AckedClusterStateUpdateTask<ClusterStateUpdateResponse> {
        private final IndicesService indicesService;
        private final AliasValidator aliasValidator;
        private final NamedXContentRegistry xContentRegistry;
        private final CreateIndexClusterStateUpdateRequest request;
        private final Logger logger;
        private final AllocationService allocationService;
        private final Settings settings;
        private final IndexValidator validator;
        private final IndexScopedSettings indexScopedSettings;

        IndexCreationTask(Logger logger, AllocationService allocationService, CreateIndexClusterStateUpdateRequest request, ActionListener<ClusterStateUpdateResponse> listener, IndicesService indicesService, AliasValidator aliasValidator, NamedXContentRegistry xContentRegistry, Settings settings, IndexValidator validator, IndexScopedSettings indexScopedSettings) {
            super(Priority.URGENT, request, listener);
            this.request = request;
            this.logger = logger;
            this.allocationService = allocationService;
            this.indicesService = indicesService;
            this.aliasValidator = aliasValidator;
            this.xContentRegistry = xContentRegistry;
            this.settings = settings;
            this.validator = validator;
            this.indexScopedSettings = indexScopedSettings;
        }

        @Override
        protected ClusterStateUpdateResponse newResponse(boolean acknowledged) {
            return new ClusterStateUpdateResponse(acknowledged);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ClusterState execute(ClusterState currentState) throws Exception {
            Index createdIndex = null;
            String removalExtraInfo = null;
            IndicesClusterStateService.AllocatedIndices.IndexRemovalReason removalReason = IndicesClusterStateService.AllocatedIndices.IndexRemovalReason.FAILURE;
            try {
                IndexMetaData indexMetaData;
                int routingNumShards;
                this.validator.validate(this.request, currentState);
                for (Alias alias : this.request.aliases()) {
                    this.aliasValidator.validateAlias(alias, this.request.index(), currentState.metaData());
                }
                List<IndexTemplateMetaData> templates = MetaDataIndexTemplateService.findTemplates(currentState.metaData(), this.request.index());
                HashMap<String, IndexMetaData.Custom> customs = new HashMap<String, IndexMetaData.Custom>();
                HashMap<String, Map<String, Object>> mappings = new HashMap<String, Map<String, Object>>();
                HashMap<String, AliasMetaData> templatesAliases = new HashMap<String, AliasMetaData>();
                ArrayList<String> templateNames = new ArrayList<String>();
                for (Map.Entry<String, String> entry : this.request.mappings().entrySet()) {
                    mappings.put(entry.getKey(), MapperService.parseMapping(this.xContentRegistry, entry.getValue()));
                }
                for (Map.Entry<String, Object> entry : this.request.customs().entrySet()) {
                    customs.put(entry.getKey(), (IndexMetaData.Custom)entry.getValue());
                }
                Index recoverFromIndex = this.request.recoverFrom();
                if (recoverFromIndex == null) {
                    for (IndexTemplateMetaData template : templates) {
                        templateNames.add(template.getName());
                        for (ObjectObjectCursor<String, CompressedXContent> objectObjectCursor : template.mappings()) {
                            String mappingString = ((CompressedXContent)objectObjectCursor.value).string();
                            if (mappings.containsKey(objectObjectCursor.key)) {
                                XContentHelper.mergeDefaults((Map)mappings.get(objectObjectCursor.key), MapperService.parseMapping(this.xContentRegistry, mappingString));
                                continue;
                            }
                            mappings.put((String)objectObjectCursor.key, MapperService.parseMapping(this.xContentRegistry, mappingString));
                        }
                        for (ObjectObjectCursor objectObjectCursor : template.customs()) {
                            String type = (String)objectObjectCursor.key;
                            IndexMetaData.Custom custom = (IndexMetaData.Custom)objectObjectCursor.value;
                            IndexMetaData.Custom existing = (IndexMetaData.Custom)customs.get(type);
                            if (existing == null) {
                                customs.put(type, custom);
                                continue;
                            }
                            IndexMetaData.Custom merged = existing.mergeWith(custom);
                            customs.put(type, merged);
                        }
                        for (ObjectObjectCursor objectObjectCursor : template.aliases()) {
                            AliasMetaData aliasMetaData = (AliasMetaData)objectObjectCursor.value;
                            if (this.request.aliases().contains(new Alias(aliasMetaData.alias())) || templatesAliases.containsKey(objectObjectCursor.key)) continue;
                            if (aliasMetaData.alias().contains("{index}")) {
                                String templatedAlias = aliasMetaData.alias().replace("{index}", this.request.index());
                                aliasMetaData = AliasMetaData.newAliasMetaData(aliasMetaData, templatedAlias);
                            }
                            this.aliasValidator.validateAliasMetaData(aliasMetaData, this.request.index(), currentState.metaData());
                            templatesAliases.put(aliasMetaData.alias(), aliasMetaData);
                        }
                    }
                }
                Settings.Builder builder = Settings.builder();
                if (recoverFromIndex == null) {
                    for (int i = templates.size() - 1; i >= 0; --i) {
                        builder.put(templates.get(i).settings());
                    }
                }
                builder.put(this.request.settings());
                if (builder.get("index.number_of_shards") == null) {
                    deprecationLogger.deprecated("the default number of shards will change from [5] to [1] in 7.0.0; if you wish to continue using the default of [5] shards, you must manage this on the create index request or with an index template", new Object[0]);
                    builder.put("index.number_of_shards", this.settings.getAsInt("index.number_of_shards", 5));
                }
                if (builder.get("index.number_of_replicas") == null) {
                    builder.put("index.number_of_replicas", this.settings.getAsInt("index.number_of_replicas", 1));
                }
                if (this.settings.get("index.auto_expand_replicas") != null && builder.get("index.auto_expand_replicas") == null) {
                    builder.put("index.auto_expand_replicas", this.settings.get("index.auto_expand_replicas"));
                }
                if (builder.get("index.version.created") == null) {
                    DiscoveryNodes nodes = currentState.nodes();
                    Version createdVersion = Version.min(Version.CURRENT, nodes.getSmallestNonClientNodeVersion());
                    builder.put("index.version.created", createdVersion);
                }
                if (builder.get("index.creation_date") == null) {
                    builder.put("index.creation_date", Instant.now().toEpochMilli());
                }
                builder.put("index.provided_name", this.request.getProvidedName());
                builder.put("index.uuid", UUIDs.randomBase64UUID());
                IndexMetaData.Builder tmpImdBuilder = IndexMetaData.builder(this.request.index());
                if (recoverFromIndex == null) {
                    Settings settings = builder.build();
                    routingNumShards = IndexMetaData.INDEX_NUMBER_OF_ROUTING_SHARDS_SETTING.get(settings);
                } else {
                    assert (!IndexMetaData.INDEX_NUMBER_OF_ROUTING_SHARDS_SETTING.exists(builder.build())) : "index.number_of_routing_shards should be present on the target index on resize";
                    IndexMetaData indexMetaData2 = currentState.metaData().getIndexSafe(recoverFromIndex);
                    routingNumShards = indexMetaData2.getRoutingNumShards();
                }
                builder.remove(IndexMetaData.INDEX_NUMBER_OF_ROUTING_SHARDS_SETTING.getKey());
                tmpImdBuilder.setRoutingNumShards(routingNumShards);
                if (recoverFromIndex != null) {
                    assert (this.request.resizeType() != null);
                    MetaDataCreateIndexService.prepareResizeIndexSettings(currentState, mappings.keySet(), builder, recoverFromIndex, this.request.index(), this.request.resizeType(), this.request.copySettings(), this.indexScopedSettings);
                }
                Settings settings = builder.build();
                tmpImdBuilder.settings(settings);
                if (recoverFromIndex != null) {
                    IndexMetaData sourceMetaData = currentState.metaData().getIndexSafe(recoverFromIndex);
                    long primaryTerm = IntStream.range(0, sourceMetaData.getNumberOfShards()).mapToLong(sourceMetaData::primaryTerm).max().getAsLong();
                    for (int shardId = 0; shardId < tmpImdBuilder.numberOfShards(); ++shardId) {
                        tmpImdBuilder.primaryTerm(shardId, primaryTerm);
                    }
                }
                IndexMetaData tmpImd = tmpImdBuilder.build();
                ActiveShardCount waitForActiveShards = this.request.waitForActiveShards();
                if (waitForActiveShards == ActiveShardCount.DEFAULT) {
                    waitForActiveShards = tmpImd.getWaitForActiveShards();
                }
                if (!waitForActiveShards.validate(tmpImd.getNumberOfReplicas())) {
                    throw new IllegalArgumentException("invalid wait_for_active_shards[" + this.request.waitForActiveShards() + "]: cannot be greater than number of shard copies [" + (tmpImd.getNumberOfReplicas() + 1) + "]");
                }
                IndicesClusterStateService.AllocatedIndex indexService = this.indicesService.createIndex(tmpImd, Collections.emptyList());
                createdIndex = ((AbstractIndexComponent)((Object)indexService)).index();
                MapperService mapperService = ((IndexService)indexService).mapperService();
                try {
                    mapperService.merge(mappings, MapperService.MergeReason.MAPPING_UPDATE, this.request.updateAllTypes());
                }
                catch (Exception e) {
                    removalExtraInfo = "failed on parsing default mapping/mappings on index creation";
                    throw e;
                }
                if (this.request.recoverFrom() == null) {
                    ((IndexService)indexService).getIndexSortSupplier().get();
                }
                QueryShardContext queryShardContext = ((IndexService)indexService).newQueryShardContext(0, null, () -> 0L, null);
                for (Alias alias : this.request.aliases()) {
                    if (!Strings.hasLength(alias.filter())) continue;
                    this.aliasValidator.validateAliasFilter(alias.name(), alias.filter(), queryShardContext, this.xContentRegistry);
                }
                for (Object aliasMetaData : templatesAliases.values()) {
                    if (((AliasMetaData)aliasMetaData).filter() == null) continue;
                    this.aliasValidator.validateAliasFilter(((AliasMetaData)aliasMetaData).alias(), ((AliasMetaData)aliasMetaData).filter().uncompressed(), queryShardContext, this.xContentRegistry);
                }
                HashMap<String, MappingMetaData> mappingsMetaData = new HashMap<String, MappingMetaData>();
                for (DocumentMapper mapper : mapperService.docMappers(true)) {
                    MappingMetaData mappingMetaData = new MappingMetaData(mapper);
                    mappingsMetaData.put(mapper.type(), mappingMetaData);
                }
                IndexMetaData.Builder indexMetaDataBuilder = IndexMetaData.builder(this.request.index()).settings(settings).setRoutingNumShards(routingNumShards);
                for (int shardId = 0; shardId < tmpImd.getNumberOfShards(); ++shardId) {
                    indexMetaDataBuilder.primaryTerm(shardId, tmpImd.primaryTerm(shardId));
                }
                for (MappingMetaData mappingMetaData : mappingsMetaData.values()) {
                    indexMetaDataBuilder.putMapping(mappingMetaData);
                }
                for (AliasMetaData aliasMetaData : templatesAliases.values()) {
                    indexMetaDataBuilder.putAlias(aliasMetaData);
                }
                for (Alias alias : this.request.aliases()) {
                    AliasMetaData aliasMetaData = AliasMetaData.builder(alias.name()).filter(alias.filter()).indexRouting(alias.indexRouting()).searchRouting(alias.searchRouting()).writeIndex(alias.writeIndex()).build();
                    indexMetaDataBuilder.putAlias(aliasMetaData);
                }
                for (Map.Entry entry : customs.entrySet()) {
                    indexMetaDataBuilder.putCustom((String)entry.getKey(), (IndexMetaData.Custom)entry.getValue());
                }
                indexMetaDataBuilder.state(this.request.state());
                try {
                    indexMetaData = indexMetaDataBuilder.build();
                }
                catch (Exception exception) {
                    removalExtraInfo = "failed to build index metadata";
                    throw exception;
                }
                ((IndexService)indexService).getIndexEventListener().beforeIndexAddedToCluster(indexMetaData.getIndex(), indexMetaData.getSettings());
                MetaData metaData = MetaData.builder(currentState.metaData()).put(indexMetaData, false).build();
                this.logger.info("[{}] creating index, cause [{}], templates {}, shards [{}]/[{}], mappings {}", (Object)this.request.index(), (Object)this.request.cause(), (Object)templateNames, (Object)indexMetaData.getNumberOfShards(), (Object)indexMetaData.getNumberOfReplicas(), (Object)mappings.keySet());
                ClusterBlocks.Builder blocks = ClusterBlocks.builder().blocks(currentState.blocks());
                if (!this.request.blocks().isEmpty()) {
                    for (ClusterBlock block : this.request.blocks()) {
                        blocks.addIndexBlock(this.request.index(), block);
                    }
                }
                blocks.updateBlocks(indexMetaData);
                ClusterState updatedState = ClusterState.builder(currentState).blocks(blocks).metaData(metaData).build();
                if (this.request.state() == IndexMetaData.State.OPEN) {
                    RoutingTable.Builder routingTableBuilder = RoutingTable.builder(updatedState.routingTable()).addAsNew(updatedState.metaData().index(this.request.index()));
                    updatedState = this.allocationService.reroute(ClusterState.builder(updatedState).routingTable(routingTableBuilder.build()).build(), "index [" + this.request.index() + "] created");
                }
                removalExtraInfo = "cleaning up after validating index on master";
                removalReason = IndicesClusterStateService.AllocatedIndices.IndexRemovalReason.NO_LONGER_ASSIGNED;
                ClusterState clusterState = updatedState;
                if (createdIndex != null) {
                    this.indicesService.removeIndex(createdIndex, removalReason, removalExtraInfo);
                }
                return clusterState;
            }
            catch (Throwable throwable) {
                if (createdIndex != null) {
                    this.indicesService.removeIndex(createdIndex, removalReason, removalExtraInfo);
                }
                throw throwable;
            }
        }

        @Override
        public void onFailure(String source, Exception e) {
            if (e instanceof ResourceAlreadyExistsException) {
                this.logger.trace(() -> new ParameterizedMessage("[{}] failed to create", (Object)this.request.index()), (Throwable)e);
            } else {
                this.logger.debug(() -> new ParameterizedMessage("[{}] failed to create", (Object)this.request.index()), (Throwable)e);
            }
            super.onFailure(source, e);
        }
    }

    static interface IndexValidator {
        public void validate(CreateIndexClusterStateUpdateRequest var1, ClusterState var2);
    }
}

