/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import org.jruby.util.ByteList;
import org.jruby.util.SafeDoubleParser;

public class ConvertDouble {
    public static double byteListToDouble19(ByteList bytes2, boolean strict) {
        return new DoubleConverter().parse(bytes2, strict, true);
    }

    public static class DoubleConverter {
        private byte[] bytes;
        private int index;
        private int endIndex;
        private boolean isStrict;
        private char[] chars;
        private int charsIndex;
        private int significantDigitsProcessed;
        private int adjustExponent;
        private boolean wroteExponent;
        private double result;
        private static final int SIGNIFICANT_DIGITS_LIMIT = 30;
        private static final int EXPONENT_DIGITS_LIMIT = 3;
        private static final int MAX_EXPONENT = (int)Math.pow(10.0, 3.0) - 1;
        private static final int MAX_LENGTH = 39;

        public void init(ByteList list2, boolean isStrict) {
            this.bytes = list2.getUnsafeBytes();
            this.index = list2.begin();
            this.endIndex = this.index + list2.length();
            this.isStrict = isStrict;
            this.chars = new char[Math.min(list2.length() + 2, 39)];
            this.charsIndex = 0;
            this.significantDigitsProcessed = 0;
            this.adjustExponent = 0;
            this.wroteExponent = false;
            this.result = -1.0;
        }

        private byte next() {
            return this.bytes[this.index++];
        }

        private boolean previous() {
            --this.index;
            return false;
        }

        private boolean isEOS() {
            return this.index >= this.endIndex;
        }

        private boolean stopParsing() {
            this.index = this.endIndex;
            return true;
        }

        private boolean isDigit(byte b2) {
            return b2 >= 48 && b2 <= 57;
        }

        private boolean isExponent(byte b2) {
            return b2 == 101 || b2 == 69;
        }

        private boolean isWhitespace(byte b2) {
            return b2 == 32 || b2 <= 13 && b2 >= 9 && b2 != 11;
        }

        private void addToResult(byte b2) {
            this.chars[this.charsIndex++] = (char)b2;
        }

        private void addExponentToResult(int exponent2) {
            String exp = Integer.toString(exponent2);
            for (int i2 = 0; i2 < exp.length(); ++i2) {
                this.addToResult((byte)exp.charAt(i2));
            }
        }

        private boolean eatUnderscores() {
            while (!this.isEOS()) {
                byte value2 = this.next();
                if (value2 != 95) {
                    this.previous();
                    return this.isEOS();
                }
                if (!this.isStrict) continue;
                this.strictError();
            }
            return true;
        }

        private double completeCalculation() {
            if (this.charsIndex == 0 || this.charsIndex == 1 && this.chars[0] == '-') {
                this.strictError();
                return 0.0;
            }
            if (this.isExponent((byte)this.chars[this.charsIndex - 1])) {
                this.strictError();
                this.addExponentToResult(this.adjustExponent);
            } else if (this.isStrict && !this.isEOS()) {
                this.strictError();
            } else if (!this.wroteExponent && this.adjustExponent != 0) {
                this.addToResult((byte)69);
                this.addExponentToResult(this.adjustExponent);
            }
            return SafeDoubleParser.parseDouble(new String(this.chars, 0, this.charsIndex));
        }

        private boolean strictError() {
            if (this.isStrict) {
                throw new LightweightNumberFormatException("does not meet strict criteria");
            }
            return true;
        }

        public double parse(ByteList list2, boolean strict, boolean is19) {
            this.init(list2, strict);
            if (this.skipWhitespace()) {
                return this.completeCalculation();
            }
            if (this.parseOptionalSign()) {
                return this.completeCalculation();
            }
            this.parseDigits();
            if (this.result != -1.0) {
                return this.result;
            }
            return this.completeCalculation();
        }

        private boolean skipWhitespace() {
            while (!this.isEOS()) {
                byte value2 = this.next();
                if (this.isWhitespace(value2)) continue;
                return this.previous();
            }
            return true;
        }

        private boolean parseOptionalSign() {
            byte sign2 = this.next();
            if (sign2 == 45) {
                this.addToResult(sign2);
            } else if (sign2 != 43) {
                this.previous();
            }
            return this.isEOS();
        }

        /*
         * Enabled aggressive block sorting
         */
        private boolean parseDigits() {
            byte value2;
            block12: {
                if (!this.isEOS()) {
                    value2 = this.next();
                    if (this.isDigit(value2)) {
                        if (value2 != 48) {
                            ++this.significantDigitsProcessed;
                        }
                        this.addToResult(value2);
                        break block12;
                    } else {
                        if (value2 == 46) {
                            this.addToResult(value2);
                            return this.parseDecimalDigits();
                        }
                        return this.isEOS();
                    }
                }
                this.strictError();
            }
            while (true) {
                if (this.isEOS()) {
                    return true;
                }
                value2 = this.next();
                if (this.isDigit(value2)) {
                    if (this.significantDigitsProcessed < 30) {
                        if (value2 == 48 && this.significantDigitsProcessed <= 0) continue;
                        ++this.significantDigitsProcessed;
                        this.addToResult(value2);
                        continue;
                    }
                    ++this.adjustExponent;
                    continue;
                }
                if (value2 == 46) {
                    this.addToResult(value2);
                    return this.parseDecimalDigits();
                }
                if (value2 != 95) break;
                this.verifyNumberAfterUnderscore();
            }
            if (this.isExponent(value2)) {
                this.addToResult(value2);
                return this.parseExponent();
            }
            if (this.isWhitespace(value2)) {
                return this.skipWhitespace();
            }
            return this.strictError();
        }

        private boolean parseDecimalDigits() {
            if (this.isEOS()) {
                return this.strictError();
            }
            byte value2 = this.next();
            if (value2 == 95) {
                this.strictError();
                if (this.isEOS()) {
                    return this.strictError();
                }
                value2 = this.next();
            }
            if (this.isDigit(value2)) {
                if (this.significantDigitsProcessed < 30) {
                    if (value2 != 48 || this.significantDigitsProcessed != 0) {
                        ++this.significantDigitsProcessed;
                    }
                } else {
                    value2 = 48;
                }
                this.addToResult(value2);
            } else {
                return this.strictError();
            }
            while (!this.isEOS()) {
                value2 = this.next();
                if (this.isDigit(value2)) {
                    if (this.significantDigitsProcessed >= 30) continue;
                    if (value2 == 48 && this.significantDigitsProcessed == 0) {
                        --this.adjustExponent;
                        continue;
                    }
                    ++this.significantDigitsProcessed;
                    this.addToResult(value2);
                    continue;
                }
                if (this.isExponent(value2)) {
                    this.addToResult(value2);
                    return this.parseExponent();
                }
                if (value2 == 95) {
                    this.verifyNumberAfterUnderscore();
                    continue;
                }
                if (this.isWhitespace(value2)) {
                    return this.skipWhitespace();
                }
                return this.strictError();
            }
            return true;
        }

        private boolean parseExponent() {
            if (this.eatUnderscores()) {
                return this.isEOS();
            }
            byte value2 = this.next();
            int exponent2 = 0;
            int digits2 = 0;
            boolean negative = false;
            if (value2 == 45) {
                negative = true;
            } else if (value2 != 43) {
                this.previous();
            }
            while (!this.isEOS()) {
                value2 = this.next();
                if (this.isDigit(value2)) {
                    if (digits2 < 3) {
                        if (value2 == 48 && digits2 <= 0) continue;
                        ++digits2;
                        exponent2 = 10 * exponent2 + (value2 - 48);
                        continue;
                    }
                    return this.tooLargeExponent(this.chars[0] == '-', negative);
                }
                if (this.isWhitespace(value2)) {
                    this.skipWhitespace();
                    break;
                }
                if (value2 == 95) {
                    this.verifyNumberAfterUnderscore();
                    continue;
                }
                this.strictError();
                this.stopParsing();
                break;
            }
            if (negative) {
                exponent2 = -exponent2;
            }
            if (-MAX_EXPONENT <= (exponent2 += this.adjustExponent) && exponent2 <= MAX_EXPONENT) {
                this.addExponentToResult(exponent2);
                this.wroteExponent = true;
                return this.isEOS();
            }
            return this.tooLargeExponent(this.chars[0] == '-', negative);
        }

        private boolean tooLargeExponent(boolean negativeFloat, boolean negativeExponent) {
            this.result = negativeExponent ? (negativeFloat ? -0.0 : 0.0) : (negativeFloat ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY);
            return this.stopParsing();
        }

        private void verifyNumberAfterUnderscore() {
            if (this.isStrict && (this.isEOS() || !this.isDigit(this.bytes[this.index]))) {
                this.strictError();
            }
        }

        static class LightweightNumberFormatException
        extends NumberFormatException {
            public LightweightNumberFormatException(String message2) {
                super(message2);
            }

            @Override
            public Throwable fillInStackTrace() {
                return this;
            }
        }
    }
}

