/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.coroutine;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsContext;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsExpressionStatement;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsVars;
import org.jetbrains.kotlin.js.backend.ast.JsVisitorWithContextImpl;
import org.jetbrains.kotlin.js.backend.ast.metadata.HasMetadata;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.coroutine.CoroutineFunctionTransformer;
import org.jetbrains.kotlin.js.inline.util.FunctionWithWrapper;
import org.jetbrains.kotlin.js.translate.declaration.InlineCoroutineUtilKt;
import org.jetbrains.kotlin.js.translate.expression.InlineMetadata;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u000e\u0010\f\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00070\rH\u0016J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000e2\u000e\u0010\f\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00070\rH\u0016J\u001c\u0010\u000f\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u000b2\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\rH\u0016J\u001c\u0010\u000f\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u00112\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\rH\u0016J\u001c\u0010\u000f\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u00122\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\rH\u0016R \u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/js/coroutine/CoroutineTransformer;", "Lorg/jetbrains/kotlin/js/backend/ast/JsVisitorWithContextImpl;", "()V", "additionalStatementsByNode", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsNode;", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;", "endVisit", "", "x", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpressionStatement;", "ctx", "Lorg/jetbrains/kotlin/js/backend/ast/JsContext;", "Lorg/jetbrains/kotlin/js/backend/ast/JsVars;", "visit", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsFunction;", "Lorg/jetbrains/kotlin/js/backend/ast/JsVars$JsVar;", "js.translator"})
public final class CoroutineTransformer
extends JsVisitorWithContextImpl {
    private final Map<JsNode, List<JsStatement>> additionalStatementsByNode;

    public void endVisit(@NotNull JsExpressionStatement x, @NotNull JsContext<? super JsStatement> ctx) {
        Intrinsics.checkParameterIsNotNull(x, "x");
        Intrinsics.checkParameterIsNotNull(ctx, "ctx");
        List<JsStatement> list2 = this.additionalStatementsByNode.remove(x);
        if (list2 != null) {
            Iterable $receiver$iv = list2;
            for (Object element$iv : $receiver$iv) {
                JsStatement it = (JsStatement)element$iv;
                ctx.addNext((JsNode)it);
            }
        }
        super.endVisit(x, ctx);
    }

    public void endVisit(@NotNull JsVars x, @NotNull JsContext<? super JsStatement> ctx) {
        Intrinsics.checkParameterIsNotNull(x, "x");
        Intrinsics.checkParameterIsNotNull(ctx, "ctx");
        for (JsVars.JsVar v2 : x.getVars()) {
            List<JsStatement> list2 = this.additionalStatementsByNode.remove(v2);
            if (list2 == null) continue;
            Iterable $receiver$iv = list2;
            for (Object element$iv : $receiver$iv) {
                JsStatement it = (JsStatement)element$iv;
                ctx.addNext((JsNode)it);
            }
        }
        super.endVisit(x, ctx);
    }

    /*
     * WARNING - void declaration
     */
    public boolean visit(@NotNull JsExpressionStatement x, @NotNull JsContext<?> ctx) {
        Intrinsics.checkParameterIsNotNull(x, "x");
        Intrinsics.checkParameterIsNotNull(ctx, "ctx");
        JsExpression expression2 = x.getExpression();
        Pair<JsExpression, JsExpression> assignment = JsAstUtils.decomposeAssignment(expression2);
        if (assignment != null) {
            JsFunction function2;
            JsFunction jsFunction;
            Pair<JsExpression, JsExpression> pair = assignment;
            JsExpression jsExpression = pair.component1();
            JsExpression rhs = pair.component2();
            JsExpression jsExpression2 = rhs;
            if (!(jsExpression2 instanceof JsFunction)) {
                jsExpression2 = null;
            }
            if ((jsFunction = (JsFunction)jsExpression2) == null) {
                Object object = InlineMetadata.Companion.decompose(rhs);
                jsFunction = object != null && (object = ((InlineMetadata)object).getFunction()) != null ? ((FunctionWithWrapper)object).getFunction() : null;
            }
            JsFunction jsFunction2 = function2 = jsFunction;
            if ((jsFunction2 != null ? MetadataProperties.getCoroutineMetadata(jsFunction2) : null) != null) {
                HasMetadata hasMetadata;
                void lhs;
                Object v4 = lhs;
                if (!(v4 instanceof JsNameRef)) {
                    v4 = null;
                }
                if ((hasMetadata = (JsNameRef)v4) == null || (hasMetadata = ((JsNameRef)hasMetadata).getName()) == null) {
                    hasMetadata = function2.getName();
                }
                String name = hasMetadata != null ? ((JsName)hasMetadata).getIdent() : null;
                Map<JsNode, List<JsStatement>> map2 = this.additionalStatementsByNode;
                List<JsStatement> list2 = new CoroutineFunctionTransformer(function2, name).transform();
                map2.put(x, list2);
                return false;
            }
        } else if (expression2 instanceof JsFunction && MetadataProperties.getCoroutineMetadata((JsFunction)expression2) != null) {
            Map<JsNode, List<JsStatement>> map3 = this.additionalStatementsByNode;
            JsName jsName = ((JsFunction)expression2).getName();
            List<JsStatement> list3 = new CoroutineFunctionTransformer((JsFunction)expression2, jsName != null ? jsName.getIdent() : null).transform();
            map3.put(x, list3);
            return false;
        }
        return super.visit(x, ctx);
    }

    public boolean visit(@NotNull JsFunction x, @NotNull JsContext<?> ctx) {
        Intrinsics.checkParameterIsNotNull(x, "x");
        Intrinsics.checkParameterIsNotNull(ctx, "ctx");
        if (MetadataProperties.isInlineableCoroutineBody(x)) {
            x.setBody((JsBlock)InlineCoroutineUtilKt.transformCoroutineMetadataToSpecialFunctions((JsNode)x.getBody()));
            return false;
        }
        return super.visit(x, ctx);
    }

    public boolean visit(@NotNull JsVars.JsVar x, @NotNull JsContext<?> ctx) {
        Intrinsics.checkParameterIsNotNull(x, "x");
        Intrinsics.checkParameterIsNotNull(ctx, "ctx");
        JsExpression initExpression = x.getInitExpression();
        if (initExpression != null) {
            JsFunction function2;
            JsFunction jsFunction;
            JsExpression jsExpression = initExpression;
            if (!(jsExpression instanceof JsFunction)) {
                jsExpression = null;
            }
            if ((jsFunction = (JsFunction)jsExpression) == null) {
                Object object = InlineMetadata.Companion.decompose(initExpression);
                jsFunction = object != null && (object = ((InlineMetadata)object).getFunction()) != null ? ((FunctionWithWrapper)object).getFunction() : null;
            }
            JsFunction jsFunction2 = function2 = jsFunction;
            if ((jsFunction2 != null ? MetadataProperties.getCoroutineMetadata(jsFunction2) : null) != null) {
                JsName jsName = x.getName();
                Intrinsics.checkExpressionValueIsNotNull(jsName, "x.name");
                String name = jsName.getIdent();
                Map<JsNode, List<JsStatement>> map2 = this.additionalStatementsByNode;
                List<JsStatement> list2 = new CoroutineFunctionTransformer(function2, name).transform();
                map2.put(x, list2);
                return false;
            }
        }
        return super.visit(x, ctx);
    }

    public CoroutineTransformer() {
        Map map2;
        CoroutineTransformer coroutineTransformer = this;
        coroutineTransformer.additionalStatementsByNode = map2 = (Map)new LinkedHashMap();
    }
}

