/*
 * Decompiled with CFR 0.152.
 */
package com.zeroc.IceGridGUI.LiveDeployment;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.util.LayoutStyle;
import com.zeroc.Ice.Identity;
import com.zeroc.Ice.LocalException;
import com.zeroc.Ice.ProcessPrx;
import com.zeroc.IceGrid.AdminPrx;
import com.zeroc.IceGridGUI.Coordinator;
import com.zeroc.IceGridGUI.LiveDeployment.Root;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

class WriteMessageDialog
extends JDialog {
    private JRadioButton _stdOut;
    private JTextArea _message = new JTextArea(3, 40);
    private String _target;
    private JFrame _mainFrame;

    WriteMessageDialog(final Root root) {
        super(root.getCoordinator().getMainFrame(), "Write Message - IceGrid GUI", true);
        this.setDefaultCloseOperation(1);
        this._mainFrame = root.getCoordinator().getMainFrame();
        this._stdOut = new JRadioButton("Write to stdout");
        this._stdOut.setSelected(true);
        JRadioButton stdErr = new JRadioButton("Write to stderr");
        ButtonGroup bg = new ButtonGroup();
        bg.add(this._stdOut);
        bg.add(stdErr);
        JButton okButton = new JButton("OK");
        ActionListener okListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Coordinator c = root.getCoordinator();
                AdminPrx admin = c.getAdmin();
                if (admin == null) {
                    JOptionPane.showMessageDialog(WriteMessageDialog.this._mainFrame, "No longer connected to IceGrid Registry", "Writing message to server '" + WriteMessageDialog.this._target + "' failed", 0);
                } else {
                    Identity adminId = new Identity(WriteMessageDialog.this._target, c.getServerAdminCategory());
                    ProcessPrx process = ProcessPrx.uncheckedCast(admin.ice_identity(adminId).ice_facet("Process"));
                    String prefix = "Writing message to server '" + WriteMessageDialog.this._target + "'...";
                    c.getStatusBar().setText(prefix);
                    try {
                        process.writeMessageAsync(WriteMessageDialog.this._message.getText(), WriteMessageDialog.this._stdOut.isSelected() ? 1 : 2).whenComplete((result, ex) -> {
                            if (ex == null) {
                                SwingUtilities.invokeLater(() -> c.getStatusBar().setText(prefix + "done."));
                            } else {
                                SwingUtilities.invokeLater(() -> {
                                    c.getStatusBar().setText(prefix + "failed!");
                                    JOptionPane.showMessageDialog(WriteMessageDialog.this._mainFrame, "Communication exception: " + ex.toString(), "Writing message to server '" + process.ice_getIdentity().name + "' failed", 0);
                                });
                            }
                        });
                    }
                    catch (LocalException ex2) {
                        c.getStatusBar().setText(prefix + "failed.");
                        JOptionPane.showMessageDialog(WriteMessageDialog.this._mainFrame, "Communication exception: " + ex2.toString(), "Writing message to server '" + WriteMessageDialog.this._target + "' failed", 0);
                        return;
                    }
                }
                WriteMessageDialog.this.setVisible(false);
            }
        };
        okButton.addActionListener(okListener);
        this.getRootPane().setDefaultButton(okButton);
        JButton cancelButton = new JButton("Cancel");
        ActionListener cancelListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WriteMessageDialog.this.setVisible(false);
            }
        };
        cancelButton.addActionListener(cancelListener);
        FormLayout layout = new FormLayout("left:pref, 3dlu, fill:pref:grow", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        builder.border(Borders.DIALOG);
        builder.rowGroupingEnabled(true);
        builder.lineGapSize(LayoutStyle.getCurrent().getLinePad());
        this._message.setLineWrap(true);
        JScrollPane scrollPane = new JScrollPane(this._message, 20, 31);
        builder.append((Component)scrollPane, 3);
        builder.nextLine();
        builder.append(this._stdOut);
        builder.append(stdErr);
        builder.nextLine();
        JPanel buttonBar = new ButtonBarBuilder().addGlue().addButton(okButton, cancelButton).build();
        buttonBar.setBorder(Borders.DIALOG);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BoxLayout(contentPane, 1));
        contentPane.add(builder.getPanel());
        contentPane.add(buttonBar);
        this.pack();
        this.setResizable(false);
    }

    void showDialog(String serverId) {
        this._target = serverId;
        this._message.setText("");
        this.setLocationRelativeTo(this._mainFrame);
        this.setVisible(true);
    }
}

