/*
 * Decompiled with CFR 0.152.
 */
package com.zeroc.IceInternal;

import com.zeroc.Ice.ACMClose;
import com.zeroc.Ice.ACMHeartbeat;
import com.zeroc.Ice.Logger;
import com.zeroc.Ice.Properties;

public final class ACMConfig
implements Cloneable {
    public int timeout;
    public ACMHeartbeat heartbeat;
    public ACMClose close;

    ACMConfig(boolean server) {
        this.timeout = 60000;
        this.heartbeat = ACMHeartbeat.HeartbeatOnDispatch;
        this.close = server ? ACMClose.CloseOnInvocation : ACMClose.CloseOnInvocationAndIdle;
    }

    public ACMConfig(Properties p, Logger l, String prefix, ACMConfig dflt) {
        assert (prefix != null);
        String timeoutProperty = (prefix.equals("Ice.ACM.Client") || prefix.equals("Ice.ACM.Server")) && p.getProperty(prefix + ".Timeout").isEmpty() ? prefix : prefix + ".Timeout";
        this.timeout = p.getPropertyAsIntWithDefault(timeoutProperty, dflt.timeout / 1000) * 1000;
        if (this.timeout < 0) {
            l.warning("invalid value for property `" + timeoutProperty + "', default value will be used instead");
            this.timeout = dflt.timeout;
        }
        int hb = p.getPropertyAsIntWithDefault(prefix + ".Heartbeat", dflt.heartbeat.ordinal());
        ACMHeartbeat[] heartbeatValues = ACMHeartbeat.values();
        if (hb >= 0 && hb < heartbeatValues.length) {
            this.heartbeat = heartbeatValues[hb];
        } else {
            l.warning("invalid value for property `" + prefix + ".Heartbeat', default value will be used instead");
            this.heartbeat = dflt.heartbeat;
        }
        ACMClose[] closeValues = ACMClose.values();
        int cl = p.getPropertyAsIntWithDefault(prefix + ".Close", dflt.close.ordinal());
        if (cl >= 0 && cl < closeValues.length) {
            this.close = closeValues[cl];
        } else {
            l.warning("invalid value for property `" + prefix + ".Close', default value will be used instead");
            this.close = dflt.close;
        }
    }

    public ACMConfig clone() {
        ACMConfig c;
        block2: {
            c = null;
            try {
                c = (ACMConfig)super.clone();
            }
            catch (CloneNotSupportedException ex) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
        return c;
    }
}

