/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import org.gradle.api.internal.changedetection.state.RegularFileHasher;
import org.gradle.api.internal.changedetection.state.ResourceSnapshotterCacheService;
import org.gradle.api.internal.changedetection.state.WellKnownFileLocations;
import org.gradle.api.internal.changedetection.state.mirror.PhysicalFileSnapshot;
import org.gradle.internal.hash.HashCode;

public class SplitResourceSnapshotterCacheService
implements ResourceSnapshotterCacheService {
    private final ResourceSnapshotterCacheService globalCache;
    private final ResourceSnapshotterCacheService localCache;
    private final WellKnownFileLocations wellKnownFileLocations;

    public SplitResourceSnapshotterCacheService(ResourceSnapshotterCacheService globalCache, ResourceSnapshotterCacheService localCache, WellKnownFileLocations wellKnownFileLocations) {
        this.globalCache = globalCache;
        this.localCache = localCache;
        this.wellKnownFileLocations = wellKnownFileLocations;
    }

    @Override
    public HashCode hashFile(PhysicalFileSnapshot fileSnapshot, RegularFileHasher hasher, HashCode configurationHash) {
        if (this.wellKnownFileLocations.isImmutable(fileSnapshot.getAbsolutePath())) {
            return this.globalCache.hashFile(fileSnapshot, hasher, configurationHash);
        }
        return this.localCache.hashFile(fileSnapshot, hasher, configurationHash);
    }
}

