/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental.classpath;

import com.google.common.collect.Maps;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.gradle.api.internal.changedetection.state.WellKnownFileLocations;
import org.gradle.api.internal.tasks.compile.incremental.classpath.ClasspathEntrySnapshot;
import org.gradle.api.internal.tasks.compile.incremental.classpath.ClasspathEntrySnapshotCache;
import org.gradle.internal.Factory;
import org.gradle.internal.concurrent.CompositeStoppable;
import org.gradle.internal.hash.HashCode;

public class SplitClasspathEntrySnapshotCache
implements ClasspathEntrySnapshotCache,
Closeable {
    private final WellKnownFileLocations fileLocations;
    private final ClasspathEntrySnapshotCache globalCache;
    private final ClasspathEntrySnapshotCache localCache;

    public SplitClasspathEntrySnapshotCache(WellKnownFileLocations fileLocations, ClasspathEntrySnapshotCache globalCache, ClasspathEntrySnapshotCache localCache) {
        this.fileLocations = fileLocations;
        this.globalCache = globalCache;
        this.localCache = localCache;
    }

    @Override
    public Map<File, ClasspathEntrySnapshot> getClasspathEntrySnapshots(Map<File, HashCode> fileHashes) {
        LinkedHashMap globalEntries = Maps.newLinkedHashMap();
        LinkedHashMap localEntries = Maps.newLinkedHashMap();
        for (Map.Entry<File, HashCode> entry : fileHashes.entrySet()) {
            if (this.fileLocations.isImmutable(entry.getKey().getPath())) {
                globalEntries.put(entry.getKey(), entry.getValue());
                continue;
            }
            localEntries.put(entry.getKey(), entry.getValue());
        }
        Map<File, ClasspathEntrySnapshot> globalSnapshots = this.globalCache.getClasspathEntrySnapshots(globalEntries);
        Map<File, ClasspathEntrySnapshot> localSnapshots = this.localCache.getClasspathEntrySnapshots(localEntries);
        LinkedHashMap snapshots = Maps.newLinkedHashMap();
        for (File entry : fileHashes.keySet()) {
            ClasspathEntrySnapshot snapshot = globalSnapshots.get(entry);
            if (snapshot == null) {
                snapshot = localSnapshots.get(entry);
            }
            snapshots.put(entry, snapshot);
        }
        return snapshots;
    }

    public ClasspathEntrySnapshot get(File entry, Factory<ClasspathEntrySnapshot> factory) {
        if (this.fileLocations.isImmutable(entry.getPath())) {
            return (ClasspathEntrySnapshot)this.globalCache.get(entry, factory);
        }
        return (ClasspathEntrySnapshot)this.localCache.get(entry, factory);
    }

    @Override
    public void close() throws IOException {
        CompositeStoppable.stoppable((Object[])new Object[]{this.localCache}).stop();
    }
}

