/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.connection;

import org.gradle.initialization.BuildCancellationToken;
import org.gradle.internal.concurrent.ExecutorFactory;
import org.gradle.internal.logging.progress.ProgressLoggerFactory;
import org.gradle.tooling.internal.connection.DefaultGradleConnection;
import org.gradle.tooling.internal.connection.ToolingClientConsumerConnection;
import org.gradle.tooling.internal.consumer.CompositeConnectionParameters;
import org.gradle.tooling.internal.consumer.ConnectionParameters;
import org.gradle.tooling.internal.consumer.Distribution;
import org.gradle.tooling.internal.consumer.LoggingProvider;
import org.gradle.tooling.internal.consumer.async.DefaultAsyncConsumerActionExecutor;
import org.gradle.tooling.internal.consumer.connection.CancellableConsumerActionExecutor;
import org.gradle.tooling.internal.consumer.connection.ConsumerConnection;
import org.gradle.tooling.internal.consumer.connection.LazyConsumerActionExecutor;
import org.gradle.tooling.internal.consumer.connection.ProgressLoggingConsumerActionExecutor;
import org.gradle.tooling.internal.consumer.connection.RethrowingErrorsConsumerActionExecutor;
import org.gradle.tooling.internal.consumer.loader.ToolingImplementationLoader;

public class GradleConnectionFactory {
    private final ToolingImplementationLoader toolingImplementationLoader;
    private final ExecutorFactory executorFactory;
    private final LoggingProvider loggingProvider;

    public GradleConnectionFactory(ToolingImplementationLoader toolingImplementationLoader, ExecutorFactory executorFactory, LoggingProvider loggingProvider) {
        this.toolingImplementationLoader = toolingImplementationLoader;
        this.executorFactory = executorFactory;
        this.loggingProvider = loggingProvider;
    }

    public DefaultGradleConnection create(Distribution distribution, CompositeConnectionParameters parameters, boolean useDaemonCoordinator) {
        LazyConsumerActionExecutor lazyConnection = useDaemonCoordinator ? new LazyConsumerActionExecutor(distribution, this.toolingImplementationLoader, this.loggingProvider, parameters) : new LazyConsumerActionExecutor(distribution, new EmbeddedCoordinator(), this.loggingProvider, parameters);
        CancellableConsumerActionExecutor cancellableConnection = new CancellableConsumerActionExecutor(lazyConnection);
        ProgressLoggingConsumerActionExecutor progressLoggingConnection = new ProgressLoggingConsumerActionExecutor(cancellableConnection, this.loggingProvider);
        RethrowingErrorsConsumerActionExecutor rethrowingErrorsConnection = new RethrowingErrorsConsumerActionExecutor(progressLoggingConnection);
        DefaultAsyncConsumerActionExecutor asyncConnection = new DefaultAsyncConsumerActionExecutor(rethrowingErrorsConnection, this.executorFactory);
        return new DefaultGradleConnection(asyncConnection, parameters);
    }

    private static class EmbeddedCoordinator
    implements ToolingImplementationLoader {
        private EmbeddedCoordinator() {
        }

        public ConsumerConnection create(Distribution distribution, ProgressLoggerFactory progressLoggerFactory, ConnectionParameters connectionParameters, BuildCancellationToken cancellationToken) {
            return new ToolingClientConsumerConnection();
        }
    }
}

