/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.mapping.reflect;

import groovy.lang.GroovySystem;
import groovy.lang.MetaBeanProperty;
import groovy.lang.MetaClass;
import groovy.lang.MetaMethod;
import groovy.lang.MetaProperty;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.codehaus.groovy.reflection.CachedClass;
import org.codehaus.groovy.reflection.CachedField;
import org.codehaus.groovy.reflection.CachedMethod;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.MetaClassHelper;
import org.codehaus.groovy.runtime.metaclass.MultipleSetterProperty;
import org.grails.datastore.mapping.reflect.NameUtils;
import org.grails.datastore.mapping.reflect.ReflectionUtils;
import org.springframework.beans.BeanUtils;

public class ClassPropertyFetcher {
    private final Class clazz;
    private final ClassInfo classInfo;
    private final MetaClass theMetaClass;
    private final List<MetaProperty> metaProperties;
    public static final Set EXCLUDED_PROPERTIES = new HashSet<String>(Arrays.asList("class", "metaClass", "properties"));

    public static ClassPropertyFetcher forClass(Class c) {
        return new ClassPropertyFetcher(c);
    }

    @Deprecated
    public static void clearCache() {
    }

    ClassPropertyFetcher(Class clazz) {
        this.clazz = clazz;
        this.classInfo = ClassInfo.getClassInfo((Class)clazz);
        this.theMetaClass = this.classInfo.getMetaClass();
        List properties = this.theMetaClass.getProperties();
        this.metaProperties = new ArrayList<MetaProperty>(properties.size());
        for (MetaProperty property : properties) {
            MultipleSetterProperty msp;
            MetaMethod getter;
            int modifiers = property.getModifiers();
            String propertyName = property.getName();
            if (!Modifier.isPublic(modifiers) || Modifier.isStatic(modifiers) || EXCLUDED_PROPERTIES.contains(propertyName)) continue;
            if (property instanceof MetaBeanProperty) {
                MetaBeanProperty beanProperty = (MetaBeanProperty)property;
                getter = beanProperty.getGetter();
                if (!(getter instanceof CachedMethod)) continue;
                this.metaProperties.add(property);
                continue;
            }
            if (!(property instanceof MultipleSetterProperty) || !((getter = (msp = (MultipleSetterProperty)property).getGetter()) instanceof CachedMethod)) continue;
            try {
                CachedClass cachedClass = this.classInfo.getCachedClass();
                Method foundGetter = clazz.getDeclaredMethod(NameUtils.getGetterName(propertyName), new Class[0]);
                if (foundGetter == null) continue;
                getter = new CachedMethod(cachedClass, foundGetter);
                Method foundSetter = clazz.getDeclaredMethod(NameUtils.getSetterName(propertyName), getter.getReturnType());
                if (foundSetter == null) continue;
                CachedMethod setter = new CachedMethod(cachedClass, foundSetter);
                this.metaProperties.add((MetaProperty)new MetaBeanProperty(msp.getName(), clazz, getter, (MetaMethod)setter));
            }
            catch (NoSuchMethodException noSuchMethodException) {}
        }
    }

    public Class getJavaClass() {
        return this.clazz;
    }

    @Deprecated
    public Object getReference() {
        return BeanUtils.instantiate((Class)this.clazz);
    }

    @Deprecated
    public PropertyDescriptor[] getPropertyDescriptors() {
        try {
            return Introspector.getBeanInfo(this.clazz).getPropertyDescriptors();
        }
        catch (IntrospectionException e) {
            return new PropertyDescriptor[0];
        }
    }

    public List<MetaProperty> getMetaProperties() {
        return this.metaProperties;
    }

    public boolean isReadableProperty(String name) {
        MetaProperty metaProperty = this.theMetaClass.getMetaProperty(name);
        if (metaProperty instanceof MetaBeanProperty) {
            MetaBeanProperty metaBeanProperty = (MetaBeanProperty)metaProperty;
            return metaBeanProperty.getField() != null || metaBeanProperty.getGetter() != null;
        }
        return false;
    }

    public Object getPropertyValue(String name) {
        MetaClass theMetaClass = this.theMetaClass;
        return ClassPropertyFetcher.getStaticPropertyValue(theMetaClass, name);
    }

    private static Object getStaticPropertyValue(MetaClass theMetaClass, String name) {
        MetaProperty metaProperty = theMetaClass.getMetaProperty(name);
        if (metaProperty != null && Modifier.isStatic(metaProperty.getModifiers())) {
            return metaProperty.getProperty((Object)theMetaClass.getTheClass());
        }
        return null;
    }

    public Object getPropertyValue(Object instance, String name) {
        MetaClass metaClass = this.theMetaClass;
        return ClassPropertyFetcher.getInstancePropertyValue(instance, name, metaClass);
    }

    public static Object getInstancePropertyValue(Object instance, String name) {
        return ClassPropertyFetcher.getInstancePropertyValue(instance, name, GroovySystem.getMetaClassRegistry().getMetaClass(instance.getClass()));
    }

    public <T> T getStaticPropertyValue(String name, Class<T> c) {
        return ClassPropertyFetcher.returnOnlyIfInstanceOf(this.getPropertyValue(name), c);
    }

    public static <T> T getStaticPropertyValue(Class clazz, String name, Class<T> requiredType) {
        return ClassPropertyFetcher.returnOnlyIfInstanceOf(ClassPropertyFetcher.getStaticPropertyValue(GroovySystem.getMetaClassRegistry().getMetaClass(clazz), name), requiredType);
    }

    public <T> List<T> getStaticPropertyValuesFromInheritanceHierarchy(String name, Class<T> c) {
        ClassInfo classInfo = this.classInfo;
        return ClassPropertyFetcher.getStaticPropertyValuesFromInheritanceHierarchy(classInfo, name, c);
    }

    public static <T> List<T> getStaticPropertyValuesFromInheritanceHierarchy(Class theClass, String name, Class<T> requiredTyped) {
        return ClassPropertyFetcher.getStaticPropertyValuesFromInheritanceHierarchy(ClassInfo.getClassInfo((Class)theClass), name, requiredTyped);
    }

    private static <T> List<T> getStaticPropertyValuesFromInheritanceHierarchy(ClassInfo classInfo, String name, Class<T> c) {
        CachedClass cachedClass = classInfo.getCachedClass();
        Collection hierarchy = cachedClass.getHierarchy();
        Class javaClass = cachedClass.getTheClass();
        ArrayList<Object> values = new ArrayList<Object>(hierarchy.size());
        for (ClassInfo current : hierarchy) {
            MetaProperty metaProperty;
            if (cachedClass.isInterface() || (metaProperty = current.getMetaClass().getMetaProperty(name)) == null || !Modifier.isStatic(metaProperty.getModifiers())) continue;
            Class type = metaProperty.getType();
            if (type == Object.class || c.isAssignableFrom(type)) {
                if (metaProperty instanceof MetaBeanProperty) {
                    Object val;
                    MetaBeanProperty beanProperty = (MetaBeanProperty)metaProperty;
                    CachedField field = beanProperty.getField();
                    if (field != null) {
                        val = field.getProperty((Object)javaClass);
                        if (!c.isInstance(val)) continue;
                        values.add(val);
                        continue;
                    }
                    val = metaProperty.getProperty((Object)javaClass);
                    if (!c.isInstance(val)) continue;
                    values.add(val);
                    continue;
                }
                Object val = metaProperty.getProperty((Object)javaClass);
                if (!c.isInstance(val)) continue;
                values.add(val);
                continue;
            }
            Field field = org.springframework.util.ReflectionUtils.findField((Class)javaClass, (String)name);
            if (field != null && c.isAssignableFrom(field.getType())) {
                org.springframework.util.ReflectionUtils.makeAccessible((Field)field);
                try {
                    values.add(field.get(javaClass));
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
            return null;
        }
        Collections.reverse(values);
        return values;
    }

    public <T> T getPropertyValue(String name, Class<T> c) {
        return this.getStaticPropertyValue(name, c);
    }

    public Class getPropertyType(String name) {
        return this.getPropertyType(name, false);
    }

    public Class getPropertyType(String name, boolean onlyInstanceProperties) {
        MetaProperty metaProperty = this.theMetaClass.getMetaProperty(name);
        if (metaProperty != null) {
            boolean isStatic = Modifier.isStatic(metaProperty.getModifiers());
            if (onlyInstanceProperties && isStatic) {
                return null;
            }
            return metaProperty.getType();
        }
        return null;
    }

    public PropertyDescriptor getPropertyDescriptor(String name) {
        MetaProperty property = this.theMetaClass.getMetaProperty(name);
        if (property != null) {
            return ClassPropertyFetcher.createPropertyDescriptor(this.clazz, property);
        }
        return null;
    }

    public static PropertyDescriptor createPropertyDescriptor(Class declaringClass, MetaProperty property) {
        int modifiers = property.getModifiers();
        if (!Modifier.isStatic(modifiers)) {
            MultipleSetterProperty msp;
            MetaMethod getter;
            String propertyName = property.getName();
            if (property instanceof MetaBeanProperty) {
                MetaBeanProperty beanProperty = (MetaBeanProperty)property;
                MetaMethod getter2 = beanProperty.getGetter();
                MetaMethod setter = beanProperty.getSetter();
                if (getter2 instanceof CachedMethod && setter instanceof CachedMethod) {
                    try {
                        Method getterMethod = ((CachedMethod)getter2).getCachedMethod();
                        Method setterMethod = ((CachedMethod)setter).getCachedMethod();
                        if (getterMethod.getReturnType().equals(setterMethod.getParameterTypes()[0])) {
                            return new PropertyDescriptor(propertyName, getterMethod, setterMethod);
                        }
                        String getterName = NameUtils.getGetterName(propertyName);
                        String setterName = NameUtils.getSetterName(propertyName);
                        getterMethod = declaringClass.getMethod(getterName, new Class[0]);
                        setterMethod = declaringClass.getMethod(setterName, getterMethod.getReturnType());
                        return new PropertyDescriptor(propertyName, getterMethod, setterMethod);
                    }
                    catch (IntrospectionException e) {
                        return null;
                    }
                    catch (NoSuchMethodException e) {
                        return null;
                    }
                }
                if (getter2 instanceof CachedMethod) {
                    try {
                        return new PropertyDescriptor(propertyName, ((CachedMethod)getter2).getCachedMethod(), null);
                    }
                    catch (IntrospectionException e) {
                        return null;
                    }
                }
            } else if (property instanceof MultipleSetterProperty && (getter = (msp = (MultipleSetterProperty)property).getGetter()) instanceof CachedMethod) {
                try {
                    Method foundGetter = declaringClass.getDeclaredMethod(NameUtils.getGetterName(propertyName), new Class[0]);
                    if (foundGetter != null) {
                        Method foundSetter = declaringClass.getDeclaredMethod(NameUtils.getSetterName(propertyName), foundGetter.getReturnType());
                        if (foundSetter != null) {
                            try {
                                return new PropertyDescriptor(propertyName, foundGetter, foundSetter);
                            }
                            catch (IntrospectionException e) {
                                return null;
                            }
                        }
                        try {
                            return new PropertyDescriptor(propertyName, foundGetter, null);
                        }
                        catch (IntrospectionException e) {
                            return null;
                        }
                    }
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    public List<PropertyDescriptor> getPropertiesOfType(Class javaClass) {
        List properties = this.theMetaClass.getProperties();
        ArrayList<PropertyDescriptor> propertyDescriptors = new ArrayList<PropertyDescriptor>(2);
        for (MetaProperty property : properties) {
            int modifiers = property.getModifiers();
            if (Modifier.isStatic(modifiers) || property.getName().contains("$") || !property.getType().equals(javaClass)) continue;
            this.addBeanProperty(propertyDescriptors, property);
        }
        return propertyDescriptors;
    }

    public List<PropertyDescriptor> getPropertiesAssignableToType(Class assignableType) {
        List properties = this.theMetaClass.getProperties();
        ArrayList<PropertyDescriptor> propertyDescriptors = new ArrayList<PropertyDescriptor>(2);
        for (MetaProperty property : properties) {
            int modifiers = property.getModifiers();
            if (Modifier.isStatic(modifiers) || property.getName().contains("$") || !assignableType.isAssignableFrom(property.getType())) continue;
            this.addBeanProperty(propertyDescriptors, property);
        }
        return propertyDescriptors;
    }

    public List<PropertyDescriptor> getPropertiesAssignableFromType(Class assignableType) {
        List properties = this.theMetaClass.getProperties();
        ArrayList<PropertyDescriptor> propertyDescriptors = new ArrayList<PropertyDescriptor>(2);
        for (MetaProperty property : properties) {
            int modifiers = property.getModifiers();
            if (Modifier.isStatic(modifiers) || property.getName().contains("$") || !property.getType().isAssignableFrom(assignableType)) continue;
            this.addBeanProperty(propertyDescriptors, property);
        }
        return propertyDescriptors;
    }

    public static Class<?> getPropertyType(Class<?> cls, String propertyName) {
        MetaProperty metaProperty = GroovySystem.getMetaClassRegistry().getMetaClass(cls).getMetaProperty(propertyName);
        if (metaProperty != null) {
            return metaProperty.getType();
        }
        return null;
    }

    public Field getDeclaredField(String name) {
        MultipleSetterProperty msp;
        CachedField field;
        MetaProperty metaProperty = this.theMetaClass.getMetaProperty(name);
        if (metaProperty instanceof MetaBeanProperty) {
            CachedField field2 = ((MetaBeanProperty)metaProperty).getField();
            if (field2 != null) {
                return field2.field;
            }
        } else if (metaProperty instanceof MultipleSetterProperty && (field = (msp = (MultipleSetterProperty)metaProperty).getField()) != null) {
            return field.field;
        }
        return null;
    }

    protected void addBeanProperty(List<PropertyDescriptor> propertyDescriptors, MetaProperty property) {
        if (property instanceof MetaBeanProperty) {
            MetaBeanProperty beanProperty = (MetaBeanProperty)property;
            MetaMethod getter = beanProperty.getGetter();
            MetaMethod setter = beanProperty.getSetter();
            boolean isGetterCachedMethod = getter instanceof CachedMethod;
            if (isGetterCachedMethod && setter instanceof CachedMethod) {
                CachedMethod cachedGetter = (CachedMethod)getter;
                CachedMethod cachedSetter = (CachedMethod)setter;
                try {
                    propertyDescriptors.add(new PropertyDescriptor(beanProperty.getName(), cachedGetter.getCachedMethod(), cachedSetter.getCachedMethod()));
                }
                catch (IntrospectionException introspectionException) {}
            } else if (isGetterCachedMethod) {
                CachedMethod cachedGetter = (CachedMethod)getter;
                try {
                    propertyDescriptors.add(new PropertyDescriptor(beanProperty.getName(), cachedGetter.getCachedMethod(), null));
                }
                catch (IntrospectionException introspectionException) {
                    // empty catch block
                }
            }
        }
    }

    private static <T> T returnOnlyIfInstanceOf(Object value, Class<T> type) {
        if (value != null && (type == Object.class || ReflectionUtils.isAssignableFrom(type, value.getClass()))) {
            return (T)value;
        }
        return null;
    }

    private static Object getInstancePropertyValue(Object instance, String name, MetaClass metaClass) {
        MetaProperty metaProperty = metaClass.getMetaProperty(name);
        if (metaProperty != null && !Modifier.isStatic(metaProperty.getModifiers())) {
            if (metaProperty instanceof MetaBeanProperty) {
                MetaMethod getter;
                MetaBeanProperty beanProperty = (MetaBeanProperty)metaProperty;
                CachedField field = beanProperty.getField();
                Object result = ClassPropertyFetcher.getPropertyWithFieldOrGetter(instance, name, field, getter = beanProperty.getGetter());
                if (result != null) {
                    return result;
                }
            } else if (metaProperty instanceof MultipleSetterProperty) {
                MetaMethod getter;
                MultipleSetterProperty msp = (MultipleSetterProperty)metaProperty;
                CachedField field = msp.getField();
                Object result = ClassPropertyFetcher.getPropertyWithFieldOrGetter(instance, name, field, getter = msp.getGetter());
                if (result != null) {
                    return result;
                }
            } else {
                return metaProperty.getProperty(instance);
            }
        }
        return null;
    }

    private static Object getPropertyWithFieldOrGetter(Object instance, String name, CachedField field, MetaMethod getter) {
        if (field != null) {
            return field.getProperty(instance);
        }
        if (getter instanceof CachedMethod) {
            return getter.invoke(instance, MetaClassHelper.EMPTY_ARRAY);
        }
        Method method = org.springframework.util.ReflectionUtils.findMethod(instance.getClass(), (String)NameUtils.getGetterName(name));
        if (method != null) {
            org.springframework.util.ReflectionUtils.makeAccessible((Method)method);
            return org.springframework.util.ReflectionUtils.invokeMethod((Method)method, (Object)instance);
        }
        return null;
    }
}

