// Generated by CoffeeScript 1.10.0
(function() {
  var Controller, DSError, NotFound, ref,
    bind = function(fn, me){ return function(){ return fn.apply(me, arguments); }; },
    indexOf = [].indexOf || function(item) { for (var i = 0, l = this.length; i < l; i++) { if (i in this && this[i] === item) return i; } return -1; };

  ref = require('./utils/errors'), NotFound = ref.NotFound, DSError = ref.DSError;

  Controller = (function() {
    var copySafeHeaders, getFileName;

    function Controller(options) {
      this.sendAttachment = bind(this.sendAttachment, this);
      this.destroy = bind(this.destroy, this);
      this.update = bind(this.update, this);
      this.send = bind(this.send, this);
      this.listAll = bind(this.listAll, this);
      this.find = bind(this.find, this);
      this.fetch = bind(this.fetch, this);
      this.model = options.model || (function() {
        throw new Error('model needed');
      })();
      this.reqProp = options.reqProp || this.model.getDocType().toLowerCase();
      this.reqParamID = options.reqParamID || this.reqProp + 'id';
    }

    Controller.prototype.fetch = function(req, res, next, id) {
      return this.model.find(id, (function(_this) {
        return function(err, found) {
          if (err) {
            return next(err);
          }
          if (!found) {
            return next(NotFound(_this.reqProp + "#" + id));
          }
          req[_this.reqProp] = found;
          return next();
        };
      })(this));
    };

    Controller.prototype.find = function(req, res, next) {
      var id;
      id = req.params[this.reqParamID];
      return this.model.find(id, (function(_this) {
        return function(err, found) {
          if (err) {
            return next(err);
          }
          if (!found) {
            return next(NotFound(_this.reqProp + "#" + id));
          }
          req[_this.reqProp] = found;
          return next();
        };
      })(this));
    };

    Controller.prototype.listAll = function(req, res, next) {
      return this.model.all(function(err, items) {
        if (err) {
          return next(err);
        }
        return res.status(200).send(items);
      });
    };

    Controller.prototype.send = function(req, res, next) {
      return res.status(200).send(req[this.reqProp]);
    };

    Controller.prototype.update = function(req, res, next) {
      var changes, id;
      id = req.params[this.reqParamID];
      changes = req.body;
      return this.model.updateAttributes(id, req.body, function(err, updated) {
        if (err) {
          return next(err);
        }
        res.status(200).send(updated);
        return next();
      });
    };

    Controller.prototype.destroy = function(req, res, next) {
      var id;
      id = req.params[this.reqParamID];
      return this.model.destroy(id, function(err) {
        if (err) {
          return next(err);
        }
        res.status(204).send('Deleted');
        return next();
      });
    };

    copySafeHeaders = function(dsres, myres) {
      var XSSmimeTypes, header, ref1, ref2, value;
      ref1 = dsres.headers;
      for (header in ref1) {
        value = ref1[header];
        myres.setHeader(header, value);
      }
      XSSmimeTypes = ['text/html', 'image/svg+xml'];
      if (ref2 = myres.getHeader('Content-Type'), indexOf.call(XSSmimeTypes, ref2) >= 0) {
        return myres.setHeader('content-type', 'text/plain');
      }
    };

    getFileName = function(options, req) {
      if (options.filename && !options.reqParamFilename) {
        return options.filename;
      }
      if (options.reqParamFilename && !options.filename) {
        return req.params[options.reqParamFilename];
      }
      throw new Error("You should set only one of reqParamFilename or filename");
    };

    Controller.prototype.sendAttachment = function(options) {
      var handler;
      if (options == null) {
        options = {};
      }
      return handler = (function(_this) {
        return function(req, res, next) {
          var id, name, stream;
          if (res.connection && !res.connection.destroyed) {
            name = getFileName(options);
            id = req.params[_this.reqParamID];
            stream = _this.model.getFile(id, name, function(err) {
              if (err) {
                return next(err);
              }
            });
            stream.pipefilter = copySafeHeaders;
            req.on('close', function() {
              return stream.abort();
            });
            res.on('close', function() {
              return stream.abort();
            });
            return stream.pipe(res);
          }
        };
      })(this);
    };

    Controller.prototype.sendBinary = function(options) {
      var handler;
      if (options == null) {
        options = {};
      }
      return handler = (function(_this) {
        return function(req, res, next) {
          var id, name, stream;
          if (res.connection && !res.connection.destroyed) {
            name = getFileName(options);
            id = req.params[_this.reqParamID];
            stream = _this.model.getBinary(id, name, function(err) {
              if (err) {
                return next(err);
              }
            });
            stream.pipefilter = copySafeHeaders;
            req.on('close', function() {
              return stream.abort();
            });
            res.on('close', function() {
              return stream.abort();
            });
            return stream.pipe(res);
          }
        };
      })(this);
    };

    return Controller;

  })();

  module.exports = Controller;

}).call(this);
