PK
     L,)4/)  /)  
  debugtests.stUT	 NP>[NP>[ux     "======================================================================
|
|   DebugTools package unit tests
|
|
 ======================================================================"

"======================================================================
|
| Copyright 2007, 2008 Free Software Foundation, Inc.
| Written by Paolo Bonzini
|
| This file is part of GNU Smalltalk.
|
| GNU Smalltalk is free software; you can redistribute it and/or modify it
| under the terms of the GNU General Public License as published by the Free
| Software Foundation; either version 2, or (at your option) any later version.
|
| GNU Smalltalk is distributed in the hope that it will be useful, but WITHOUT
| ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
| FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
| details.
|
| You should have received a copy of the GNU General Public License along with
| GNU Smalltalk; see the file COPYING.  If not, write to the Free Software
| Foundation, 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
|
 ======================================================================"



SmallInteger extend [

    dbgPrintNl [
        <category: '*DebugTools'>
        ^ self dbgPrintString
    ]

    dbgPrintString [
        "Return the base 10 representation of the receiver"

        <category: '*DebugTools'>
        ^self dbgPrintString: 10
    ]

    dbgPrintString: baseInteger [
        "Return the base baseInteger representation of the receiver"

        <category: '*DebugTools'>
        | num string |
        ^self < self zero
            ifFalse:
                [string := String new: (self floorLog: baseInteger) + 1.
                self replace: string withStringBase: baseInteger]
            ifTrue:
                [num := self negated.
                string := String new: (num floorLog: baseInteger) + 2.
                string at: 1 put: $-.
                num replace: string withStringBase: baseInteger]
    ]
]


TestCase subclass: DebuggerTest [
    
    <comment: nil>
    <category: 'System-Debugging-Test'>

    debuggerOn: aBlock [
	"Attach aBlock to a debugger and step until aBlock's execution begins."

	<category: 'test'>
	| debugger |
	debugger := Debugger on: aBlock newProcess.
	[debugger suspendedContext method == aBlock block] 
	    whileFalse: [debugger stepBytecode].
	^debugger
    ]

    testOn [
	"Test that #debuggerOn: works as we intend."

	<category: 'test'>
	| debugger notReached |
	notReached := false.
	debugger := self debuggerOn: [notReached := true].
	self assert: debugger suspendedContext isBlock.
	self deny: notReached
    ]

    testStep [
	"Test that #step goes through the traced process a single line at a time."

	<category: 'test'>
	| debugger reached1 reached2 notReached |
	reached1 := reached2 := notReached := false.
	debugger := self debuggerOn: 
			[reached1 := true. reached2 := true.
			notReached := true].
	debugger step.
	self assert: reached1.
	self assert: reached2.
	self deny: notReached
    ]

    testCurrentLine [
	"Test that #currentLine does not do something completely bogus."

	<category: 'test'>
	| debugger a b c prevLine |
	debugger := self debuggerOn: 
			[a := 5.
			b := 6.
			c := 7].
	
	[debugger step.
	a = 5] whileFalse.
	prevLine := debugger currentLine.
	debugger step.
	self assert: prevLine + 1 = debugger currentLine
    ]

    testForkDebugger [
	"Test forking a debugger for the current process."

	<category: 'test'>
	| value |
	
	[:debugger | 
	
	[debugger step.
	debugger suspendedContext selector = #y] whileFalse.
	value := false.
	debugger finish.
	
	[debugger step.
	debugger suspendedContext selector = #y] whileFalse.
	value := true.
	debugger finish.
	
	[debugger step.
	debugger suspendedContext selector = #y] whileFalse.
	value := 42.
	debugger continue] 
		forkDebugger.
	self y.
	self deny: value.
	self y.
	self assert: value.
	self y.
	self assert: value = 42
    ]

    testStopInferior [
	"Test using #stopInferior to restart the debugger."

	<category: 'test'>
	| theDebugger value |
	
	[:debugger | 
	theDebugger := debugger.
	[[debugger step] repeat] on: SystemExceptions.DebuggerReentered
	    do: [:ex | ex return].
	value := 42.
	debugger continue] 
		forkDebugger.
	self assert: value isNil.
	theDebugger stopInferior.
	self assert: value = 42
    ]

    testStepIntoSend [
	"Test that #step stops at the next message send."

	<category: 'test'>
	| debugger reached notReached |
	reached := false.
	debugger := self debuggerOn: 
			[reached := true. notReached := 3 factorial].
	debugger step.
	self assert: reached.
	self assert: notReached isNil
    ]

    testFinish [
	"Test that #finish does not proceed further in the parent context."

	<category: 'test'>
	| debugger reached |
	debugger := self debuggerOn: [reached := 3 factorial].
	debugger step.
	self assert: reached isNil.
	debugger finish.
	"The assignment has not been executed yet."
	self assert: reached isNil.
	debugger finish.
	self assert: reached = 6
    ]

    testStepTooMuch [
	"Test that #stepBytecode eventually raises an error."

	<category: 'test'>
	| debugger reached toFinish |
	debugger := self debuggerOn: [3 factorial].
	self should: [[debugger stepBytecode] repeat] raise: Error.
	self deny: debugger isActive
    ]

    testFinishColon [
	"Test using #finish: to leave multiple contexts at once."

	<category: 'test'>
	| debugger reached toFinish |
	debugger := self debuggerOn: [self x: [:foo | reached := foo]].
	
	[debugger step.
	debugger suspendedContext selector = #x:] whileFalse.
	toFinish := debugger suspendedContext.
	
	[debugger step.
	debugger suspendedContext selector = #z:] whileFalse.
	debugger finish: toFinish.
	self assert: reached = 42.
	self deny: debugger suspendedContext selector = #x:
    ]

    testContinue [
	"Test that #continue terminates the controlling process."

	<category: 'test'>
	| debugger reached sema1 sema2 curtailed |
	debugger := self debuggerOn: 
			[reached := 3 factorial.
			sema1 signal].
	sema1 := Semaphore new.
	sema2 := Semaphore new.
	curtailed := true.
	
	["The controlling process is terminated, so we run the test in another
	 process."

	
	[debugger continue.
	curtailed := false] ensure: [sema2 signal]] 
		fork.
	sema1 wait.
	sema2 wait.
	self assert: reached = 6.
	self assert: curtailed.
	self deny: debugger isActive
    ]

    testStepOverPrimitive [
	"Test that #step does not go inside a primitive."

	<category: 'test'>
	| debugger reached notReached |
	debugger := self debuggerOn: [reached := Object basicNew].
	debugger step.
	self assert: reached notNil
    ]

    testNext [
	"Test that #next runs a whole line independent of how many sends are there."

	<category: 'test'>
	| debugger reached1 reached2 |
	debugger := self debuggerOn: 
			[reached1 := 3 factorial. reached2 := 4 factorial].
	debugger next.
	self assert: reached1 = 6.
	self assert: reached2 = 24
    ]

    testCurtailFinish [
	"Test that finish is not fooled by method returns."

	<category: 'test'>
	| debugger notReached |
	notReached := false.
	debugger := self debuggerOn: 
			[self w. notReached := true].
	
	[debugger step.
	debugger suspendedContext selector = #z:] whileFalse.
	debugger finish.
	self assert: debugger suspendedContext selector = #y.
	debugger finish.
	self assert: debugger suspendedContext selector = #x:.
	debugger step.
	self assert: debugger suspendedContext isBlock.
	self assert: debugger suspendedContext selector = #w.
	debugger finish.
	self assert: debugger isActive.
	self deny: notReached
    ]

    testRegressionCurrentLine [
        <category: 'testing'>

        | debugger |
        debugger := self debuggerOn: [ 1 dbgPrintNl ].
        debugger step.

        #(34 36 39 43 46 51 53) doWithIndex: [ :each :i |
            self assert: debugger suspendedContext currentLineInFile == each.
            debugger step.
        ]
    ]

    testEvaluation [
        " Test that #eval gives the good states "

        <category: 'test'>

        | debugger i j k |
        i := 312.
        j := 412.
        k := 512.

        debugger := self debuggerOn: [ | x y z |
                                        x := 1.
                                        y := x * 2.
                                        z := y * 2.
                                        i yourself ].

        debugger step; step; step.

        self assert: (debugger eval: '^ i') = 312.
        self assert: (debugger eval: '^ j') = 412.
        self assert: (debugger eval: '^ k') = 512.

        self assert: (debugger eval: '^ x') = 1.
        self assert: (debugger eval: '^ y') = 2.
        self assert: (debugger eval: '^ z') = 4.
    ]

    testRestart [
        " Test that #restart "

        <category: 'test'>

        | debugger i j |

        debugger := self debuggerOn: [ 
                            i := self restart ].
        debugger step.
        self assert: debugger suspendedContext method == (self class >> #restart).

        self class compile: 'restart [ | i | i := 234. ^ i * 2 ]'.

        debugger restart.
        self assert: debugger suspendedContext method == (self class >> #restart).
        self assert: debugger suspendedContext receiver == self.
        self assert: debugger suspendedContext ip == 0.
        self assert: debugger suspendedContext sp == 0.

        debugger next; next.

        self assert: i = 468.

        j := OrderedCollection new.
        j add: 123.
        debugger := self debuggerOn: [
                            i := self restart_1: j ].
        debugger step; step.
        self assert: debugger suspendedContext method == (self class >> #restart_1:).

        self class compile: 'restart_1: anObject [ ^ anObject first ]'.

        j addFirst: 234.
        debugger restart.
        self assert: debugger suspendedContext method == (self class >> #restart_1:).
        self assert: debugger suspendedContext receiver == self.
        self assert: debugger suspendedContext ip == 0.
        self assert: debugger suspendedContext sp == 0.

        debugger next; next.

        self assert: i = 234.
    ]

    w [
	<category: 'support'>
	self x: [:foo | ^foo]
    ]

    x: aBlock [
	<category: 'support'>
	aBlock value: self y
    ]

    y [
	<category: 'support'>
	^self z: 42
    ]

    z: anObject [
	<category: 'support'>
	^anObject
    ]

    restart [
        <category: 'support'>

        ^ 123 * 2
    ]

    restart_1: anObject [
        <category: 'support'>

        ^ anObject first * 2
    ]
]

PK    Lc8
    	  ChangeLogUT	 NP>[NP>[ux     TYo0~^~l鉢A흱hG,:t~EmbH a$q2<4"L҃\GRAk4'])|q3tvP)YJi,O, KH
ޣâ.иQ|g
NVik6dFX,thEEh27#ٗQH߹D~nHI/^1iZ:TZ*n
##"XK?T7Z@[9Xk07jW\z}Р>wH?g?EZϜy=TeGI~prY*H.1FTw'0ۂq(nħ NG8G
v$ӖXc)eߤp6Jj+fA_%++o֪u	JlllF!7{[:Rݦ,Cb4s	q_RwP$;
XQUuT\hȖ*,?Uqw2xN)ȹ`?\p
is$?3&l*E)Wzک^!W(o
PK
     LH[7  [7  
  DebugTools.stUT	 NP>[NP>[ux     "======================================================================
|
|   Inferior process control
|
|
 ======================================================================"

"======================================================================
|
| Copyright 2002, 2006, 2007 Free Software Foundation, Inc.
| Written by Paolo Bonzini.
|
| This file is part of GNU Smalltalk.
|
| GNU Smalltalk is free software; you can redistribute it and/or modify it
| under the terms of the GNU General Public License as published by the Free
| Software Foundation; either version 2, or (at your option) any later version.
| 
| GNU Smalltalk is distributed in the hope that it will be useful, but WITHOUT
| ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
| FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
| details.
| 
| You should have received a copy of the GNU General Public License along with
| GNU Smalltalk; see the file COPYING.  If not, write to the Free Software
| Foundation, 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.  
|
 ======================================================================"



Object subclass: Debugger [
    | debugProcess process breakpointContext stepSemaphore |
    
    <category: 'System-Debugging'>
    <comment: 'I provide debugging facilities for another inferior process.  I have
methods that allow the controlled process to proceed with varying
granularity.  In addition, I keep a cache mapping instruction
pointer bytecodes to line numbers.'>

    MethodLineMapCache := nil.

    Debugger class >> currentLineIn: aContext [
        <category: 'source code'>
        | lineMap method res |
        method := aContext method.
        MethodLineMapCache isNil
            ifTrue: [MethodLineMapCache := WeakKeyIdentityDictionary new].
        lineMap := MethodLineMapCache at: method
                    ifAbsentPut: [method sourceCodeMap].
        res := lineMap at: (aContext ip + 1).
        ^ res = 0
            ifTrue: [ self error: 'IP is not correct' ]
            ifFalse: [ res ]
    ]

    Debugger class >> on: aProcess [
	"Suspend aProcess and return a new Debugger that controls aProcess.
	 aProcess must not be the currently running process."

	<category: 'instance creation'>
	aProcess == Processor activeProcess 
	    ifTrue: [self error: 'cannot attach to current process'].
	aProcess suspend.
	^self new initializeFor: aProcess
    ]

    Debugger class >> debuggerClass [
	<category: 'disabling debugging'>
	^nil
    ]

    isActive [
	"Answer true if the inferior process is still running."

	<category: 'inferior process properties'>
	^process notNil and: [process suspendedContext notNil]
    ]

    process [
	"Answer the inferior process."

	<category: 'inferior process properties'>
	^process
    ]

    currentLine [
	"Return the line number in traced process."

	<category: 'inferior process properties'>
	self isActive ifFalse: [^''].
	^self suspendedContext currentLine
    ]

    suspendedContext [
	"Answer the suspended execution state of the inferior process."

	<category: 'inferior process properties'>
	^process suspendedContext
    ]

    stopInferior [
	"Suspend the inferior process and raise a DebuggerReentered notification
	 in the controlling process."

	<category: 'stepping commands'>
	self stopInferior: nil
    ]

    stopInferior: anObject [
	"Suspend the inferior process and raise a DebuggerReentered notification
	 in the controlling process with anObject as the exception's message."

	<category: 'stepping commands'>
	| exception |
	
	[
	[process suspend.
	debugProcess
	    queueInterrupt: 
		    [self disableBreakpointContext.
		    SystemExceptions.DebuggerReentered signal: anObject];
	    resume] 
		on: Exception
		do: 
		    [:ex | 
		    exception := ex.
		    process resume]] 
		forkAt: Processor unpreemptedPriority.

	"Pass the exception on in the calling process."
	exception isNil ifFalse: [exception signal]
    ]

    restart [
        <category: 'stepping commands'>

        self restart: self suspendedContext.
    ]

    restart: aContext [
        <category: 'stepping commands'>

        | context method newContext |

        context := self suspendedContext.

        [ context = aContext ] whileFalse: [ context := context parentContext ].

        context isBlock ifTrue: [ context outerContext isNil ifTrue: [ ^ self ].
                                  context := context outerContext ].

        method := context receiver class lookupSelector: context method selector.

        newContext := MethodContext new: method stackDepth.

        newContext parentContext: context parentContext.
        newContext ip: 0.
        newContext instVarAt: 4 put: -1 + method numArgs + method numTemps. " stack pointer "
        newContext instVarAt: 5 put: context receiver.                      " receiver "
        newContext instVarAt: 6 put: method.                                " method "
        newContext instVarAt: 7 put: (context instVarAt: 7).                " flags "

        1 to: method numArgs do: [ :i |
            newContext at: i put: (context at: i) ].

        process suspendedContext: newContext
    ]

    stepBytecode [
	"Run a single bytecode in the inferior process."

	<category: 'stepping commands'>
	debugProcess := Processor activeProcess.
	process singleStepWaitingOn: stepSemaphore.
	process suspend.
	debugProcess := nil
    ]

    step [
	"Run to the end of the current line in the inferior process or to the
	 next message send."

	<category: 'stepping commands'>
	| context line |
	context := self suspendedContext.
	line := self currentLine.
	
	[self stepBytecode.
	self suspendedContext == context and: [line = self currentLine]] 
		whileTrue
    ]

    slowNext [
	"Run to the end of the current line in the inferior process, skipping
	 over message sends."

	<category: 'stepping commands'>
	| context line |
	context := self suspendedContext.
	line := self currentLine.

	[self stepBytecode.
	(self suspendedContext notNil
	    and: [self suspendedContext parentContext == context])
		ifTrue: [self slowFinish: self suspendedContext].
	self suspendedContext == context and: [line = self currentLine]]
		whileTrue
    ]

    next [
	"Run to the end of the current line in the inferior process, skipping
	 over message sends."

	<category: 'stepping commands'>
	| context line |
	context := self suspendedContext.
	line := self currentLine.
	
	[self stepBytecode.
	(self suspendedContext notNil 
	    and: [self suspendedContext parentContext == context]) 
		ifTrue: [self finish: self suspendedContext].
	self suspendedContext == context and: [line = self currentLine]] 
		whileTrue
    ]

    finish [
	"Run to the next return."

	<category: 'stepping commands'>
	self finish: self suspendedContext
    ]

    finish: aContext [
	"Run up until aContext returns."

	<category: 'stepping commands'>
	"First, use the slow scheme for internal exception handling contexts.
	 These are more delicate and in general pretty small, so it is not
	 expensive."

	| proc cont context retVal |
	<debugging: true>
	aContext isInternalExceptionHandlingContext 
	    ifTrue: [^self slowFinish: aContext].
	[self suspendedContext isInternalExceptionHandlingContext] 
	    whileTrue: [self slowFinish: self suspendedContext].

	"Create a context that will restart the debugger and place it in the
	 chain.  We don't really use the continuation object directly but,
	 if we use the methods in Continuation, we are sure that contexts
	 are set up correctly."
	debugProcess := Processor activeProcess.
	retVal := Continuation currentDo: [:cc | cont := cc].
	Processor activeProcess == debugProcess 
	    ifTrue: 
		["Put our context below aContext and restart the debugged process."

		context := cont stack.
		context instVarAt: MethodContext instSize put: 2.
		context parentContext: aContext parentContext.
		aContext parentContext: context.
		
		[breakpointContext := aContext.
		debugProcess suspend.
		process resume] 
			forkAt: Processor unpreemptedPriority.

		"Finish the continuation context, which is at the `retVal' line
		 below."
		debugProcess := nil.
		self slowFinish: context]
	    ifFalse: 
		["We arrive here when we finish execution of aContext.  Put the
		 debugger process in control again."

		
		[breakpointContext := nil.
		process suspend.
		debugProcess resume] 
			forkAt: Processor unpreemptedPriority.
		^retVal]
    ]

    slowFinish [
	"Run in single-step mode up to the next return."

	<category: 'stepping commands'>
	self slowFinish: self suspendedContext
    ]

    slowFinish: aContext [
	"Run in single-step mode until aContext returns."

	<category: 'stepping commands'>
	| context newContext |
	context := self suspendedContext.
	
	[
	[self stepBytecode.
	self suspendedContext == context] whileTrue.
	newContext := self suspendedContext.
	newContext notNil and: 
		["no context? exit"

		"a send? go on"

		newContext parentContext == context or: 
			["aContext still in the chain? go on"

			self includes: aContext]]] 
		whileTrue
    ]

    continue [
	"Terminate the controlling process and continue execution of the
	 traced process."

	<category: 'stepping commands'>
	| theDebugProcess theProcess |
	theDebugProcess := Processor activeProcess.
	theProcess := process.
	
	[debugProcess := nil.
	process := nil.
	theDebugProcess terminate.
	theProcess resume] 
		forkAt: Processor unpreemptedPriority.

	"Just in case we get here."
	theDebugProcess primTerminate
    ]

    eval: aString [
        <category: 'evaluation'>

        | context selectorAndArguments stream method result |
        context := self suspendedContext.

        selectorAndArguments := Dictionary new.
        stream := WriteStream on: String new.

        (context isBlock and: [ context outerContext isNil not ]) ifTrue: [ self extractSelectorAndArgumentsFrom: context outerContext to: selectorAndArguments ].
        self extractSelectorAndArgumentsFrom: context to: selectorAndArguments.
        self buildSelectorAndArgs: selectorAndArguments to: stream.
        self buildCode: aString withArgs: selectorAndArguments keys to: stream.
        ^ (self compile: stream contents to: self receiver)
                    ifError: [ :fname :lineNo :errorString | stream contents printNl. (' error : ', errorString) displayNl ]
                    ifSucceed: [ :method | self perform: method selector to: self receiver with: (self extractArgsFrom: selectorAndArguments) ].
    ]

    extractArgsFrom: aDictionary [
        <category: 'private'>

        | array i |
        i := 1.
        array := Array new: aDictionary size.

        aDictionary keys do: [ :each |
            array at: i put: (aDictionary at: each).
            i := i + 1 ].

        ^ array
    ]

    extractSelectorAndArgumentsFrom: aContext to: aDictionary [
        <category: 'private'>

        | i |
        i := 1.

        aContext method arguments do: [ :each |
            aDictionary at: each put: (aContext at: i).
            i := i + 1 ].
        aContext method temporaries do: [ :each |
            aDictionary at: each put: (aContext at: i).
            i := i + 1 ]
    ]

    buildSelectorAndArgs: aDictionary to: aStream [
        <category: 'private'>

        | i |
        i := 1.
        aDictionary isEmpty ifTrue: [ ^ aStream nextPutAll: 'DoIt'; space ].
        aDictionary keys do: [ :each |
            aStream
                nextPutAll: 'arg_';
                nextPutAll: i asString;
                nextPutAll: ': ';
                nextPutAll: #xxx_;
                nextPutAll: each;
                space.
            i := i + 1 ].
    ]

    buildCode: aString withArgs: anArray to: aStream [
        <category: 'private'>

        aStream
            nextPutAll: '[';
            nl;
            nextPutAll: '| '.
        anArray do: [ :each |
            aStream
                nextPutAll: each;
                space ].
        aStream
            nextPutAll: '|';
            nl.
        anArray do: [ :each |
            aStream
                nextPutAll: each;
                nextPutAll: ' := ';
                nextPutAll: #xxx_;
                nextPutAll: each;
                nextPutAll: '.';
                nl ].
        aStream
            nextPutAll: ' ^ [ ';
            nl;
            nextPutAll: aString;
            nl;
            nextPutAll: ' ] value';
            nl;
            nextPutAll: ']'.
    ]

    compile: aString to: anObject [
        <category: 'private'>

        ^ Just value:
                    (anObject class
                        compile: aString
                        ifError: [ :fname :lineNo :errorString | ^ Nothing value: fname value: lineNo value: errorString ])
    ]

    perform: aSelector to: anObject with: anArray [
        <category: 'private'>

        | sem result |
        sem := Semaphore new.
        [ [ result := anObject perform: aSelector withArguments: anArray.
             sem signal ]
                receiver: nil;
                on: Exception do: [ :ex | [ sem signal ] fork.
                                          ex pass ] ]
            receiver: nil;
            fork.
        sem wait.
        anObject class removeSelector: aSelector ifAbsent: [].
        ^ result
    ]

    disableBreakpointContext [
	"Remove the context inserted set by #finish:."

	<category: 'private'>
	| theBreakpointContext |
	theBreakpointContext := breakpointContext.
	breakpointContext := nil.
	debugProcess := nil.
	theBreakpointContext isNil 
	    ifFalse: 
		[theBreakpointContext 
		    parentContext: theBreakpointContext parentContext parentContext]
    ]

    includes: aContext [
	"Answer whether aContext is still in the stack of the traced process."

	<category: 'private'>
	| context |
	context := self suspendedContext.
	
	[context isNil ifTrue: [^false].
	context == aContext ifTrue: [^true].
	context := context parentContext] 
		repeat
    ]

    initializeFor: aProcess [
	<category: 'private'>
	process := aProcess.
	stepSemaphore := Semaphore new
    ]

    receiver [
        <category: 'private'>
        ^ self suspendedContext receiver
    ]
]

PK
     L+x  x    DebuggerReentered.stUT	 NP>[NP>[ux     "======================================================================
|
|   Inferior process control
|
|
 ======================================================================"

"======================================================================
|
| Copyright 2002, 2006, 2007 Free Software Foundation, Inc.
| Written by Paolo Bonzini.
|
| This file is part of GNU Smalltalk.
|
| GNU Smalltalk is free software; you can redistribute it and/or modify it
| under the terms of the GNU General Public License as published by the Free
| Software Foundation; either version 2, or (at your option) any later version.
|
| GNU Smalltalk is distributed in the hope that it will be useful, but WITHOUT
| ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
| FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
| details.
|
| You should have received a copy of the GNU General Public License along with
| GNU Smalltalk; see the file COPYING.  If not, write to the Free Software
| Foundation, 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
|
 ======================================================================"



Namespace current: SystemExceptions [

Notification subclass: DebuggerReentered [

    <category: 'System-Debugging'>
    <comment: 'This notification is raised when the debugger is started on a process
that was already being debugged.  Trapping it allows the pre-existing
debugger to keep control of the process.'>

    description [
	"Answer a textual description of the exception."

	<category: 'description'>
	^'the debugger was started on an already debugged process'
    ]
]

]
PK
     L)<    
  Extensions.stUT	 NP>[NP>[ux     "======================================================================
|
|   Inferior process control
|
|
 ======================================================================"

"======================================================================
|
| Copyright 2002, 2006, 2007 Free Software Foundation, Inc.
| Written by Paolo Bonzini.
|
| This file is part of GNU Smalltalk.
|
| GNU Smalltalk is free software; you can redistribute it and/or modify it
| under the terms of the GNU General Public License as published by the Free
| Software Foundation; either version 2, or (at your option) any later version.
|
| GNU Smalltalk is distributed in the hope that it will be useful, but WITHOUT
| ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
| FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
| details.
|
| You should have received a copy of the GNU General Public License along with
| GNU Smalltalk; see the file COPYING.  If not, write to the Free Software
| Foundation, 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
|
 ======================================================================"



ContextPart extend [

    currentLine [
	"Answer the 1-based number of the line that is pointed to by the receiver's
	 instruction pointer."

	<category: 'source code'>
	^Debugger currentLineIn: self
    ]

    debugger [
	"Answer the debugger that is attached to the given context.  It
	 is always nil unless the DebugTools package is loaded."

	<category: 'debugging'>
	| ctx home |
	ctx := self.
	[ctx isNil] whileFalse:
		[home := ctx home.
		(home notNil
		    and: [(home method attributeAt: #debugging: ifAbsent: [nil]) notNil])
			ifTrue: [^ctx receiver].
		ctx := ctx parentContext].
	^nil
    ]

]



BlockClosure extend [

    forkDebugger [
	"Suspend the currently running process and fork the receiver into a new
	 process, passing a Debugger object that controls the currently running
	 process."

	<category: 'instance creation'>
	| process |
	process := Processor activeProcess.

	[process suspend.
	Processor activeProcess priority: process priority.
	self value: (Debugger on: process)]
		forkAt: Processor unpreemptedPriority
    ]

]
PK
     \L              maybe/UT	 Q>[Q>[ux     PK
     L!)xi  i  
  maybe/Just.stUT	 NP>[NP>[ux     "======================================================================
|
|   Just class declaration
|
|
 ======================================================================"

"======================================================================
|
| Copyright 2013 Free Software Foundation, Inc.
| Written by Gwenael Casaccio.
|
| This file is part of GNU Smalltalk.
|
| GNU Smalltalk is free software; you can redistribute it and/or modify it
| under the terms of the GNU General Public License as published by the Free
| Software Foundation; either version 2, or (at your option) any later version.
|
| GNU Smalltalk is distributed in the hope that it will be useful, but WITHOUT
| ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
| FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
| details.
|
| You should have received a copy of the GNU General Public License along with
| GNU Smalltalk; see the file COPYING.  If not, write to the Free Software
| Foundation, 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
|
 ======================================================================"

Maybe subclass: Just [

    ifSucceed: aBlock [

        ^ aBlock valueWithArguments: values
    ]

    ifError: aBlock [
    ]

    ifError: unusedBlock ifSucceed: aBlock [

        ^ aBlock valueWithArguments: values
    ]
]
PK
     L גo  o    maybe/Nothing.stUT	 NP>[NP>[ux     "======================================================================
|
|   Nothing class declaration
|
|
 ======================================================================"

"======================================================================
|
| Copyright 2013 Free Software Foundation, Inc.
| Written by Gwenael Casaccio.
|
| This file is part of GNU Smalltalk.
|
| GNU Smalltalk is free software; you can redistribute it and/or modify it
| under the terms of the GNU General Public License as published by the Free
| Software Foundation; either version 2, or (at your option) any later version.
|
| GNU Smalltalk is distributed in the hope that it will be useful, but WITHOUT
| ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
| FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
| details.
|
| You should have received a copy of the GNU General Public License along with
| GNU Smalltalk; see the file COPYING.  If not, write to the Free Software
| Foundation, 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
|
 ======================================================================"

Maybe subclass: Nothing [

    ifSucceed: aBlock [
    ]

    ifError: aBlock [

        ^ aBlock valueWithArguments: values
    ]

    ifError: aBlock ifSucceed: unusedBlock [

        ^ aBlock valueWithArguments: values
    ]
]
PK
     L 0      maybe/Maybe.stUT	 NP>[NP>[ux     "======================================================================
|
|   Maybe class declaration
|
|
 ======================================================================"

"======================================================================
|
| Copyright 2013 Free Software Foundation, Inc.
| Written by Gwenael Casaccio.
|
| This file is part of GNU Smalltalk.
|
| GNU Smalltalk is free software; you can redistribute it and/or modify it
| under the terms of the GNU General Public License as published by the Free
| Software Foundation; either version 2, or (at your option) any later version.
|
| GNU Smalltalk is distributed in the hope that it will be useful, but WITHOUT
| ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
| FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
| details.
|
| You should have received a copy of the GNU General Public License along with
| GNU Smalltalk; see the file COPYING.  If not, write to the Free Software
| Foundation, 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
|
 ======================================================================"

Object subclass: Maybe [

    Maybe class >> value: anObject [

        ^ self new
            value: anObject;
            yourself
    ]

    Maybe class >> value: anObject1 value: anObject2 [

        ^ self new
            value: anObject1 value: anObject2;
            yourself
    ]

    Maybe class >> value: anObject1 value: anObject2 value: anObject3 [

        ^ self new
            value: anObject1 value: anObject2 value: anObject3;
            yourself
    ]

    | values |


    value: anObject [
        <category: 'initialization'>

        values := Array with: anObject.
    ]

    value: anObject1 value: anObject2 [
        <category: 'initialization'>

        values := Array with: anObject1 with: anObject2.
    ]

    value: anObject1 value: anObject2 value: anObject3 [
        <category: 'initialization'>

        values := Array with: anObject1 with: anObject2 with: anObject3.
    ]

    ifSucceed: aBlock [
    ]

    ifError: aBlock [
    ]

    ifError: unusedBlock ifSucceed: aBlock [
    ]
]
PK
     \L戣      package.xmlUT	 Q>[Q>[ux     <package>
  <name>DebugTools</name>
  <test>
    <prereq>DebugTools</prereq>
    <prereq>SUnit</prereq>
    <sunit>DebuggerTest</sunit>
    <filein>debugtests.st</filein>
  </test>

  <filein>Extensions.st</filein>
  <filein>maybe/Maybe.st</filein>
  <filein>maybe/Nothing.st</filein>
  <filein>maybe/Just.st</filein>
  <filein>DebuggerReentered.st</filein>
  <filein>DebugTools.st</filein>
  <file>ChangeLog</file>
</package>PK
     L,)4/)  /)  
              debugtests.stUT NP>[ux     PK    Lc8
    	         v)  ChangeLogUT NP>[ux     PK
     LH[7  [7  
          A,  DebugTools.stUT NP>[ux     PK
     L+x  x            c  DebuggerReentered.stUT NP>[ux     PK
     L)<    
          j  Extensions.stUT NP>[ux     PK
     \L                     As  maybe/UT Q>[ux     PK
     L!)xi  i  
          s  maybe/Just.stUT NP>[ux     PK
     L גo  o            y  maybe/Nothing.stUT NP>[ux     PK
     L 0              L  maybe/Maybe.stUT NP>[ux     PK
     \L戣                package.xmlUT Q>[ux     PK    
 
 <      