/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.monitor;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import javax.swing.JPanel;
import org.netbeans.lib.profiler.results.monitor.VMTelemetryDataManager;
import org.netbeans.lib.profiler.ui.graphs.CPUGraphPanel;
import org.netbeans.lib.profiler.ui.graphs.GraphPanel;
import org.netbeans.lib.profiler.ui.graphs.MemoryGraphPanel;
import org.netbeans.lib.profiler.ui.graphs.SurvivingGenerationsGraphPanel;
import org.netbeans.lib.profiler.ui.graphs.ThreadsGraphPanel;
import org.netbeans.lib.profiler.ui.monitor.VMTelemetryModels;

public class MonitorView
extends JPanel {
    private VMTelemetryModels models;
    private GraphPanel cpuPanel;
    private GraphPanel memoryPanel;
    private GraphPanel gcPanel;
    private GraphPanel threadsPanel;

    public MonitorView(VMTelemetryDataManager vMTelemetryDataManager) {
        this.initUI(vMTelemetryDataManager);
    }

    public void setupCPUView(boolean bl) {
        this.cpuPanel.setVisible(bl);
    }

    public void setupMemoryView(boolean bl) {
        this.memoryPanel.setVisible(bl);
    }

    public void setupGCView(boolean bl) {
        this.gcPanel.setVisible(bl);
    }

    public void setupThreadsView(boolean bl) {
        this.threadsPanel.setVisible(bl);
    }

    public void cleanup() {
        this.cpuPanel.cleanup();
        this.memoryPanel.cleanup();
        this.gcPanel.cleanup();
        this.threadsPanel.cleanup();
        this.models.cleanup();
    }

    private void initUI(VMTelemetryDataManager vMTelemetryDataManager) {
        this.setLayout(new GraphsLayout());
        this.models = new VMTelemetryModels(vMTelemetryDataManager);
        this.cpuPanel = CPUGraphPanel.createBigPanel(this.models);
        this.add(this.cpuPanel);
        this.memoryPanel = MemoryGraphPanel.createBigPanel(this.models);
        this.add(this.memoryPanel);
        this.gcPanel = SurvivingGenerationsGraphPanel.createBigPanel(this.models);
        this.add(this.gcPanel);
        this.threadsPanel = ThreadsGraphPanel.createBigPanel(this.models);
        this.add(this.threadsPanel);
    }

    private class GraphsLayout
    implements LayoutManager {
        private GraphsLayout() {
        }

        @Override
        public void addLayoutComponent(String string, Component component) {
        }

        @Override
        public void removeLayoutComponent(Component component) {
        }

        @Override
        public Dimension preferredLayoutSize(Container container) {
            return new Dimension();
        }

        @Override
        public Dimension minimumLayoutSize(Container container) {
            return new Dimension();
        }

        @Override
        public void layoutContainer(Container container) {
            int n;
            int n2;
            int n3 = MonitorView.this.getWidth();
            int n4 = MonitorView.this.getHeight();
            boolean bl = MonitorView.this.cpuPanel.isVisible();
            boolean bl2 = MonitorView.this.memoryPanel.isVisible();
            boolean bl3 = MonitorView.this.gcPanel.isVisible();
            boolean bl4 = MonitorView.this.threadsPanel.isVisible();
            int n5 = bl || bl2 ? (bl3 || bl4 ? n4 / 2 : n4) : 0;
            int n6 = n4 - n5;
            if (n5 > 0) {
                if (bl && bl2) {
                    n2 = n3 / 2;
                    n = n3 - n2;
                    MonitorView.this.cpuPanel.setBounds(0, 0, n2, n5);
                    MonitorView.this.memoryPanel.setBounds(n2, 0, n, n5);
                } else if (bl) {
                    MonitorView.this.cpuPanel.setBounds(0, 0, n3, n5);
                } else {
                    MonitorView.this.memoryPanel.setBounds(0, 0, n3, n5);
                }
            }
            if (n6 > 0) {
                if (bl3 && bl4) {
                    n2 = n3 / 2;
                    n = n3 - n2;
                    MonitorView.this.gcPanel.setBounds(0, n5, n2, n6);
                    MonitorView.this.threadsPanel.setBounds(n2, n5, n, n6);
                } else if (bl3) {
                    MonitorView.this.gcPanel.setBounds(0, n5, n3, n6);
                } else {
                    MonitorView.this.threadsPanel.setBounds(0, n5, n3, n6);
                }
            }
        }
    }
}

