/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.cli;

import java.util.Locale;
import org.elasticsearch.xpack.sql.cli.CliTerminal;
import org.elasticsearch.xpack.sql.cli.command.CliCommand;
import org.elasticsearch.xpack.sql.cli.command.CliSession;

public class CliRepl {
    private CliTerminal cliTerminal;
    private CliCommand cliCommand;
    private CliSession cliSession;

    public CliRepl(CliTerminal cliTerminal, CliSession cliSession, CliCommand cliCommand) {
        this.cliTerminal = cliTerminal;
        this.cliCommand = cliCommand;
        this.cliSession = cliSession;
    }

    public void execute() {
        String DEFAULT_PROMPT = "sql> ";
        String MULTI_LINE_PROMPT = "   | ";
        StringBuilder multiLine = new StringBuilder();
        String prompt = DEFAULT_PROMPT;
        this.cliTerminal.flush();
        this.cliCommand.handle(this.cliTerminal, this.cliSession, "logo");
        String line;
        while ((line = this.cliTerminal.readLine(prompt)) != null) {
            if (!(line = line.trim()).endsWith(";")) {
                multiLine.append(line);
                multiLine.append(" ");
                prompt = MULTI_LINE_PROMPT;
                continue;
            }
            line = line.substring(0, line.length() - 1);
            prompt = DEFAULT_PROMPT;
            if (multiLine.length() > 0) {
                multiLine.append(line);
                line = multiLine.toString().trim();
                multiLine.setLength(0);
            }
            if (line.isEmpty()) continue;
            if (CliRepl.isExit(line)) {
                this.cliTerminal.line().em("Bye!").ln();
                this.cliTerminal.flush();
                return;
            }
            if (!this.cliCommand.handle(this.cliTerminal, this.cliSession, line)) {
                this.cliTerminal.error("Unrecognized command", line);
            }
            this.cliTerminal.println();
        }
        return;
    }

    private static boolean isExit(String line) {
        return (line = line.toLowerCase(Locale.ROOT)).equals("exit") || line.equals("quit");
    }
}

