/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.function.scalar.string;

import java.util.Locale;
import java.util.Objects;
import org.elasticsearch.xpack.sql.expression.Expression;
import org.elasticsearch.xpack.sql.expression.FieldAttribute;
import org.elasticsearch.xpack.sql.expression.function.scalar.UnaryScalarFunction;
import org.elasticsearch.xpack.sql.expression.function.scalar.processor.definition.ProcessorDefinition;
import org.elasticsearch.xpack.sql.expression.function.scalar.processor.definition.ProcessorDefinitions;
import org.elasticsearch.xpack.sql.expression.function.scalar.processor.definition.UnaryProcessorDefinition;
import org.elasticsearch.xpack.sql.expression.function.scalar.script.ParamsBuilder;
import org.elasticsearch.xpack.sql.expression.function.scalar.script.ScriptTemplate;
import org.elasticsearch.xpack.sql.expression.function.scalar.string.StringProcessor;
import org.elasticsearch.xpack.sql.tree.Location;
import org.elasticsearch.xpack.sql.util.StringUtils;

public abstract class UnaryStringIntFunction
extends UnaryScalarFunction {
    protected UnaryStringIntFunction(Location location, Expression field) {
        super(location, field);
    }

    @Override
    public boolean foldable() {
        return this.field().foldable();
    }

    @Override
    public Object fold() {
        return this.operation().apply(this.field().fold());
    }

    @Override
    protected Expression.TypeResolution resolveType() {
        if (!this.childrenResolved()) {
            return new Expression.TypeResolution("Unresolved children", new Object[0]);
        }
        return this.field().dataType().isInteger ? Expression.TypeResolution.TYPE_RESOLVED : new Expression.TypeResolution("'%s' requires a integer type, received %s", new Object[]{this.operation(), this.field().dataType().esType});
    }

    @Override
    protected final ProcessorDefinition makeProcessorDefinition() {
        return new UnaryProcessorDefinition(this.location(), this, ProcessorDefinitions.toProcessorDefinition(this.field()), new StringProcessor(this.operation()));
    }

    protected abstract StringProcessor.StringOperation operation();

    @Override
    protected ScriptTemplate asScriptFrom(FieldAttribute field) {
        return new ScriptTemplate(this.formatScript("doc[{}].value"), ParamsBuilder.paramsBuilder().variable(field.name()).build(), this.dataType());
    }

    @Override
    protected String formatScript(String template) {
        return super.formatScript(String.format(Locale.ROOT, "{sql}.%s(%s)", StringUtils.underscoreToLowerCamelCase(this.operation().toString()), template));
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        UnaryStringIntFunction other = (UnaryStringIntFunction)obj;
        return Objects.equals(other.field(), this.field());
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.field());
    }
}

