/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.parser;

import org.elasticsearch.common.Strings;
import org.elasticsearch.xpack.sql.parser.AbstractBuilder;
import org.elasticsearch.xpack.sql.parser.ParsingException;
import org.elasticsearch.xpack.sql.parser.SqlBaseParser;
import org.elasticsearch.xpack.sql.plan.TableIdentifier;
import org.elasticsearch.xpack.sql.tree.Location;

abstract class IdentifierBuilder
extends AbstractBuilder {
    IdentifierBuilder() {
    }

    @Override
    public TableIdentifier visitTableIdentifier(SqlBaseParser.TableIdentifierContext ctx) {
        Location source = IdentifierBuilder.source(ctx);
        SqlBaseParser.IdentifierContext tree = ctx.name != null ? ctx.name : ctx.TABLE_IDENTIFIER();
        String index = tree.getText();
        IdentifierBuilder.validateIndex(index, source);
        return new TableIdentifier(source, this.visitIdentifier(ctx.catalog), index);
    }

    static void validateIndex(String index, Location source) {
        for (int i = 0; i < index.length(); ++i) {
            char c = index.charAt(i);
            if (Character.isUpperCase(c)) {
                throw new ParsingException(source, "Invalid index name (needs to be lowercase) {}", index);
            }
            if (c != '\\' && c != '/' && c != '<' && c != '>' && c != '|' && c != ',' && c != ' ') continue;
            throw new ParsingException(source, "Invalid index name (illegal character {}) {}", Character.valueOf(c), index);
        }
    }

    @Override
    public String visitIdentifier(SqlBaseParser.IdentifierContext ctx) {
        return ctx == null ? null : ctx.getText();
    }

    @Override
    public String visitQualifiedName(SqlBaseParser.QualifiedNameContext ctx) {
        if (ctx == null) {
            return null;
        }
        return Strings.collectionToDelimitedString(this.visitList(ctx.identifier(), String.class), (String)".");
    }
}

