/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authz.store;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.cache.Cache;
import org.elasticsearch.common.cache.CacheBuilder;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.common.util.concurrent.ReleasableLock;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.xpack.core.common.IteratingActionListener;
import org.elasticsearch.xpack.core.security.SecurityField;
import org.elasticsearch.xpack.core.security.authz.RoleDescriptor;
import org.elasticsearch.xpack.core.security.authz.permission.FieldPermissionsCache;
import org.elasticsearch.xpack.core.security.authz.permission.FieldPermissionsDefinition;
import org.elasticsearch.xpack.core.security.authz.permission.Role;
import org.elasticsearch.xpack.core.security.authz.privilege.ApplicationPrivilege;
import org.elasticsearch.xpack.core.security.authz.privilege.ApplicationPrivilegeDescriptor;
import org.elasticsearch.xpack.core.security.authz.privilege.ConditionalClusterPrivilege;
import org.elasticsearch.xpack.core.security.authz.privilege.IndexPrivilege;
import org.elasticsearch.xpack.core.security.authz.privilege.Privilege;
import org.elasticsearch.xpack.core.security.authz.store.ReservedRolesStore;
import org.elasticsearch.xpack.security.authz.store.FileRolesStore;
import org.elasticsearch.xpack.security.authz.store.NativePrivilegeStore;
import org.elasticsearch.xpack.security.authz.store.NativeRolesStore;
import org.elasticsearch.xpack.security.support.SecurityIndexManager;

public class CompositeRolesStore
extends AbstractComponent {
    private final ReleasableLock readLock;
    private final ReleasableLock writeLock;
    public static final Setting<Integer> CACHE_SIZE_SETTING = Setting.intSetting((String)SecurityField.setting((String)"authz.store.roles.cache.max_size"), (int)10000, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    private final FileRolesStore fileRolesStore;
    private final NativeRolesStore nativeRolesStore;
    private final ReservedRolesStore reservedRolesStore;
    private final NativePrivilegeStore privilegeStore;
    private final XPackLicenseState licenseState;
    private final Cache<Set<String>, Role> roleCache;
    private final Set<String> negativeLookupCache;
    private final ThreadContext threadContext;
    private final AtomicLong numInvalidation;
    private final List<BiConsumer<Set<String>, ActionListener<Set<RoleDescriptor>>>> customRolesProviders;

    public CompositeRolesStore(Settings settings, FileRolesStore fileRolesStore, NativeRolesStore nativeRolesStore, ReservedRolesStore reservedRolesStore, NativePrivilegeStore privilegeStore, List<BiConsumer<Set<String>, ActionListener<Set<RoleDescriptor>>>> rolesProviders, ThreadContext threadContext, XPackLicenseState licenseState) {
        super(settings);
        ReentrantReadWriteLock iterationLock = new ReentrantReadWriteLock();
        this.readLock = new ReleasableLock(iterationLock.readLock());
        this.writeLock = new ReleasableLock(iterationLock.writeLock());
        this.numInvalidation = new AtomicLong();
        this.fileRolesStore = fileRolesStore;
        fileRolesStore.addListener(this::invalidateAll);
        this.nativeRolesStore = nativeRolesStore;
        this.reservedRolesStore = reservedRolesStore;
        this.privilegeStore = privilegeStore;
        this.licenseState = licenseState;
        CacheBuilder builder = CacheBuilder.builder();
        int cacheSize = (Integer)CACHE_SIZE_SETTING.get(settings);
        if (cacheSize >= 0) {
            builder.setMaximumWeight((long)cacheSize);
        }
        this.roleCache = builder.build();
        this.threadContext = threadContext;
        this.negativeLookupCache = ConcurrentCollections.newConcurrentSet();
        this.customRolesProviders = Collections.unmodifiableList(rolesProviders);
    }

    public void roles(Set<String> roleNames, FieldPermissionsCache fieldPermissionsCache, ActionListener<Role> roleActionListener) {
        Role existing = (Role)this.roleCache.get(roleNames);
        if (existing != null) {
            roleActionListener.onResponse((Object)existing);
        } else {
            long invalidationCounter = this.numInvalidation.get();
            this.roleDescriptors(roleNames, (ActionListener<Set<RoleDescriptor>>)ActionListener.wrap(descriptors -> {
                Set<RoleDescriptor> effectiveDescriptors = this.licenseState.isDocumentAndFieldLevelSecurityAllowed() ? descriptors : descriptors.stream().filter(rd -> !rd.isUsingDocumentOrFieldLevelSecurity()).collect(Collectors.toSet());
                this.logger.trace("Building role from descriptors [{}] for names [{}]", effectiveDescriptors, (Object)roleNames);
                CompositeRolesStore.buildRoleFromDescriptors(effectiveDescriptors, fieldPermissionsCache, this.privilegeStore, (ActionListener<Role>)ActionListener.wrap(role -> {
                    if (role != null) {
                        ReleasableLock ignored = this.readLock.acquire();
                        Throwable throwable = null;
                        try {
                            if (invalidationCounter == this.numInvalidation.get()) {
                                this.roleCache.computeIfAbsent((Object)roleNames, s -> role);
                            }
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (ignored != null) {
                                CompositeRolesStore.$closeResource(throwable, (AutoCloseable)ignored);
                            }
                        }
                    }
                    roleActionListener.onResponse(role);
                }, arg_0 -> ((ActionListener)roleActionListener).onFailure(arg_0)));
            }, arg_0 -> roleActionListener.onFailure(arg_0)));
        }
    }

    private void roleDescriptors(Set<String> roleNames, ActionListener<Set<RoleDescriptor>> roleDescriptorActionListener) {
        Set<RoleDescriptor> builtInRoleDescriptors;
        Set<String> filteredRoleNames = roleNames.stream().filter(s -> {
            if (this.negativeLookupCache.contains(s)) {
                this.logger.debug("Requested role [{}] does not exist (cached)", s);
                return false;
            }
            return true;
        }).collect(Collectors.toSet());
        Set<String> remainingRoleNames = this.difference(filteredRoleNames, builtInRoleDescriptors = this.getBuiltInRoleDescriptors(filteredRoleNames));
        if (remainingRoleNames.isEmpty()) {
            roleDescriptorActionListener.onResponse(Collections.unmodifiableSet(builtInRoleDescriptors));
        } else {
            this.nativeRolesStore.getRoleDescriptors(remainingRoleNames.toArray(Strings.EMPTY_ARRAY), (ActionListener<Collection<RoleDescriptor>>)ActionListener.wrap(descriptors -> {
                this.logger.debug(() -> new ParameterizedMessage("Roles [{}] were resolved from the native index store", (Object)this.names((Collection<RoleDescriptor>)descriptors)));
                builtInRoleDescriptors.addAll((Collection<RoleDescriptor>)descriptors);
                this.callCustomRoleProvidersIfEnabled(builtInRoleDescriptors, filteredRoleNames, roleDescriptorActionListener);
            }, e -> {
                this.logger.warn("role retrieval failed from the native roles store", (Throwable)e);
                this.callCustomRoleProvidersIfEnabled(builtInRoleDescriptors, filteredRoleNames, roleDescriptorActionListener);
            }));
        }
    }

    private void callCustomRoleProvidersIfEnabled(Set<RoleDescriptor> builtInRoleDescriptors, Set<String> filteredRoleNames, ActionListener<Set<RoleDescriptor>> roleDescriptorActionListener) {
        if (builtInRoleDescriptors.size() != filteredRoleNames.size()) {
            Set<String> missing = this.difference(filteredRoleNames, builtInRoleDescriptors);
            assert (!missing.isEmpty()) : "the missing set should not be empty if the sizes didn't match";
            if (this.licenseState.isCustomRoleProvidersAllowed() && !this.customRolesProviders.isEmpty()) {
                new IteratingActionListener(roleDescriptorActionListener, (rolesProvider, listener) -> rolesProvider.accept(missing, ActionListener.wrap(resolvedDescriptors -> {
                    this.logger.debug(() -> new ParameterizedMessage("Roles [{}] were resolved by [{}]", (Object)this.names((Collection<RoleDescriptor>)resolvedDescriptors), rolesProvider));
                    builtInRoleDescriptors.addAll((Collection<RoleDescriptor>)resolvedDescriptors);
                    for (RoleDescriptor descriptor : resolvedDescriptors) {
                        missing.remove(descriptor.getName());
                    }
                    if (missing.isEmpty()) {
                        listener.onResponse(Collections.unmodifiableSet(builtInRoleDescriptors));
                    } else {
                        listener.onResponse(null);
                    }
                }, arg_0 -> ((ActionListener)listener).onFailure(arg_0))), this.customRolesProviders, this.threadContext, () -> {
                    this.negativeLookupCache.addAll(missing);
                    return builtInRoleDescriptors;
                }).run();
            } else {
                this.logger.debug(() -> new ParameterizedMessage("Requested roles [{}] do not exist", (Object)Strings.collectionToCommaDelimitedString((Iterable)missing)));
                this.negativeLookupCache.addAll(missing);
                roleDescriptorActionListener.onResponse(Collections.unmodifiableSet(builtInRoleDescriptors));
            }
        } else {
            roleDescriptorActionListener.onResponse(Collections.unmodifiableSet(builtInRoleDescriptors));
        }
    }

    private Set<RoleDescriptor> getBuiltInRoleDescriptors(Set<String> roleNames) {
        Set<String> difference;
        Set descriptors = this.reservedRolesStore.roleDescriptors().stream().filter(rd -> roleNames.contains(rd.getName())).collect(Collectors.toCollection(HashSet::new));
        if (descriptors.size() > 0) {
            this.logger.debug(() -> new ParameterizedMessage("Roles [{}] are builtin roles", (Object)this.names(descriptors)));
        }
        if (!(difference = this.difference(roleNames, descriptors)).isEmpty()) {
            Set<RoleDescriptor> fileRoles = this.fileRolesStore.roleDescriptors(difference);
            this.logger.debug(() -> new ParameterizedMessage("Roles [{}] were resolved from [{}]", (Object)this.names(fileRoles), (Object)this.fileRolesStore.getFile()));
            descriptors.addAll(fileRoles);
        }
        return descriptors;
    }

    private String names(Collection<RoleDescriptor> descriptors) {
        return descriptors.stream().map(RoleDescriptor::getName).collect(Collectors.joining(","));
    }

    private Set<String> difference(Set<String> roleNames, Set<RoleDescriptor> descriptors) {
        Set foundNames = descriptors.stream().map(RoleDescriptor::getName).collect(Collectors.toSet());
        return Sets.difference(roleNames, foundNames);
    }

    public static void buildRoleFromDescriptors(Collection<RoleDescriptor> roleDescriptors, FieldPermissionsCache fieldPermissionsCache, NativePrivilegeStore privilegeStore, ActionListener<Role> listener) {
        if (roleDescriptors.isEmpty()) {
            listener.onResponse((Object)Role.EMPTY);
            return;
        }
        HashSet<String> clusterPrivileges = new HashSet<String>();
        ArrayList<ConditionalClusterPrivilege> conditionalClusterPrivileges = new ArrayList<ConditionalClusterPrivilege>();
        HashSet<String> runAs = new HashSet<String>();
        HashMap<Set, MergeableIndicesPrivilege> indicesPrivilegesMap = new HashMap<Set, MergeableIndicesPrivilege>();
        HashMap<Tuple, Set> applicationPrivilegesMap = new HashMap<Tuple, Set>();
        ArrayList<String> roleNames = new ArrayList<String>(roleDescriptors.size());
        for (RoleDescriptor descriptor : roleDescriptors) {
            HashSet key;
            RoleDescriptor.IndicesPrivileges[] indicesPrivileges;
            roleNames.add(descriptor.getName());
            if (descriptor.getClusterPrivileges() != null) {
                clusterPrivileges.addAll(Arrays.asList(descriptor.getClusterPrivileges()));
            }
            if (descriptor.getConditionalClusterPrivileges() != null) {
                conditionalClusterPrivileges.addAll(Arrays.asList(descriptor.getConditionalClusterPrivileges()));
            }
            if (descriptor.getRunAs() != null) {
                runAs.addAll(Arrays.asList(descriptor.getRunAs()));
            }
            for (RoleDescriptor.IndicesPrivileges indicesPrivileges2 : indicesPrivileges = descriptor.getIndicesPrivileges()) {
                boolean isExplicitDenial;
                key = Sets.newHashSet((Object[])indicesPrivileges2.getIndices());
                boolean bl = isExplicitDenial = indicesPrivileges.length == 1 && "none".equalsIgnoreCase(indicesPrivileges2.getPrivileges()[0]);
                if (isExplicitDenial) continue;
                indicesPrivilegesMap.compute(key, (k, value) -> {
                    if (value == null) {
                        return new MergeableIndicesPrivilege(indicesPrivilege.getIndices(), indicesPrivilege.getPrivileges(), indicesPrivilege.getGrantedFields(), indicesPrivilege.getDeniedFields(), indicesPrivilege.getQuery());
                    }
                    value.merge(new MergeableIndicesPrivilege(indicesPrivilege.getIndices(), indicesPrivilege.getPrivileges(), indicesPrivilege.getGrantedFields(), indicesPrivilege.getDeniedFields(), indicesPrivilege.getQuery()));
                    return value;
                });
            }
            for (RoleDescriptor.IndicesPrivileges indicesPrivileges3 : descriptor.getApplicationPrivileges()) {
                key = new Tuple((Object)indicesPrivileges3.getApplication(), (Object)Sets.newHashSet((Object[])indicesPrivileges3.getResources()));
                applicationPrivilegesMap.compute((Tuple)key, (arg_0, arg_1) -> CompositeRolesStore.lambda$buildRoleFromDescriptors$17((RoleDescriptor.ApplicationResourcePrivileges)indicesPrivileges3, arg_0, arg_1));
            }
        }
        Privilege runAsPrivilege = runAs.isEmpty() ? Privilege.NONE : new Privilege(runAs, runAs.toArray(Strings.EMPTY_ARRAY));
        Role.Builder builder = Role.builder((String[])roleNames.toArray(new String[roleNames.size()]), (FieldPermissionsCache)fieldPermissionsCache).cluster(clusterPrivileges, conditionalClusterPrivileges).runAs(runAsPrivilege);
        indicesPrivilegesMap.entrySet().forEach(entry -> {
            MergeableIndicesPrivilege privilege = (MergeableIndicesPrivilege)entry.getValue();
            builder.add(fieldPermissionsCache.getFieldPermissions(privilege.fieldPermissionsDefinition), privilege.query, IndexPrivilege.get((Set)privilege.privileges), privilege.indices.toArray(Strings.EMPTY_ARRAY));
        });
        if (applicationPrivilegesMap.isEmpty()) {
            listener.onResponse((Object)builder.build());
        } else {
            Set<String> applicationNames = applicationPrivilegesMap.keySet().stream().map(Tuple::v1).collect(Collectors.toSet());
            Set<String> applicationPrivilegeNames = applicationPrivilegesMap.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
            privilegeStore.getPrivileges(applicationNames, applicationPrivilegeNames, (ActionListener<Collection<ApplicationPrivilegeDescriptor>>)ActionListener.wrap(appPrivileges -> {
                applicationPrivilegesMap.forEach((key, names) -> builder.addApplicationPrivilege(ApplicationPrivilege.get((String)((String)key.v1()), (Set)names, (Collection)appPrivileges), (Set)key.v2()));
                listener.onResponse((Object)builder.build());
            }, arg_0 -> listener.onFailure(arg_0)));
        }
    }

    public void invalidateAll() {
        this.numInvalidation.incrementAndGet();
        this.negativeLookupCache.clear();
        try (ReleasableLock ignored = this.readLock.acquire();){
            this.roleCache.invalidateAll();
        }
    }

    public void invalidate(String role) {
        this.numInvalidation.incrementAndGet();
        try (ReleasableLock ignored = this.writeLock.acquire();){
            Iterator keyIter = this.roleCache.keys().iterator();
            while (keyIter.hasNext()) {
                Set key = (Set)keyIter.next();
                if (!key.contains(role)) continue;
                keyIter.remove();
            }
        }
        this.negativeLookupCache.remove(role);
    }

    public void usageStats(ActionListener<Map<String, Object>> listener) {
        HashMap<String, Map<String, Object>> usage = new HashMap<String, Map<String, Object>>(2);
        usage.put("file", this.fileRolesStore.usageStats());
        this.nativeRolesStore.usageStats((ActionListener<Map<String, Object>>)ActionListener.wrap(map -> {
            usage.put("native", (Map<String, Object>)map);
            listener.onResponse((Object)usage);
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    public void onSecurityIndexStateChange(SecurityIndexManager.State previousState, SecurityIndexManager.State currentState) {
        if (SecurityIndexManager.isMoveFromRedToNonRed(previousState, currentState) || SecurityIndexManager.isIndexDeleted(previousState, currentState) || previousState.isIndexUpToDate != currentState.isIndexUpToDate) {
            this.invalidateAll();
        }
    }

    private static /* synthetic */ Set lambda$buildRoleFromDescriptors$17(RoleDescriptor.ApplicationResourcePrivileges appPrivilege, Tuple k, Set v) {
        if (v == null) {
            return Sets.newHashSet((Object[])appPrivilege.getPrivileges());
        }
        v.addAll(Arrays.asList(appPrivilege.getPrivileges()));
        return v;
    }

    private static class MergeableIndicesPrivilege {
        private Set<String> indices;
        private Set<String> privileges;
        private FieldPermissionsDefinition fieldPermissionsDefinition;
        private Set<BytesReference> query = null;

        MergeableIndicesPrivilege(String[] indices, String[] privileges, @Nullable String[] grantedFields, @Nullable String[] deniedFields, @Nullable BytesReference query) {
            this.indices = Sets.newHashSet((Object[])Objects.requireNonNull(indices));
            this.privileges = Sets.newHashSet((Object[])Objects.requireNonNull(privileges));
            this.fieldPermissionsDefinition = new FieldPermissionsDefinition(grantedFields, deniedFields);
            if (query != null) {
                this.query = Sets.newHashSet((Object[])new BytesReference[]{query});
            }
        }

        void merge(MergeableIndicesPrivilege other) {
            assert (this.indices.equals(other.indices)) : "index names must be equivalent in order to merge";
            HashSet groups = new HashSet();
            groups.addAll(this.fieldPermissionsDefinition.getFieldGrantExcludeGroups());
            groups.addAll(other.fieldPermissionsDefinition.getFieldGrantExcludeGroups());
            this.fieldPermissionsDefinition = new FieldPermissionsDefinition(groups);
            this.privileges.addAll(other.privileges);
            if (this.query == null || other.query == null) {
                this.query = null;
            } else {
                this.query.addAll(other.query);
            }
        }
    }
}

