/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.job.config;

import java.io.IOException;
import java.util.EnumMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ml.MlParserType;
import org.elasticsearch.xpack.core.ml.job.config.Operator;

public class RuleCondition
implements ToXContentObject,
Writeable {
    public static final ParseField RULE_CONDITION_FIELD = new ParseField("rule_condition", new String[0]);
    public static final ParseField APPLIES_TO_FIELD = new ParseField("applies_to", new String[0]);
    public static final ParseField VALUE_FIELD = new ParseField("value", new String[0]);
    public static final ConstructingObjectParser<RuleCondition, Void> METADATA_PARSER = new ConstructingObjectParser(RULE_CONDITION_FIELD.getPreferredName(), true, a -> new RuleCondition((AppliesTo)((Object)((Object)a[0])), (Operator)((Object)((Object)a[1])), (Double)a[2]));
    public static final ConstructingObjectParser<RuleCondition, Void> CONFIG_PARSER = new ConstructingObjectParser(RULE_CONDITION_FIELD.getPreferredName(), false, a -> new RuleCondition((AppliesTo)((Object)((Object)a[0])), (Operator)((Object)((Object)a[1])), (Double)a[2]));
    public static final Map<MlParserType, ConstructingObjectParser<RuleCondition, Void>> PARSERS = new EnumMap<MlParserType, ConstructingObjectParser<RuleCondition, Void>>(MlParserType.class);
    private final AppliesTo appliesTo;
    private final Operator operator;
    private final double value;

    public RuleCondition(StreamInput in) throws IOException {
        this.appliesTo = AppliesTo.readFromStream(in);
        this.operator = Operator.readFromStream(in);
        this.value = in.readDouble();
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.appliesTo.writeTo(out);
        this.operator.writeTo(out);
        out.writeDouble(this.value);
    }

    public RuleCondition(AppliesTo appliesTo, Operator operator, double value) {
        this.appliesTo = appliesTo;
        this.operator = operator;
        this.value = value;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(APPLIES_TO_FIELD.getPreferredName(), (Object)this.appliesTo);
        builder.field(Operator.OPERATOR_FIELD.getPreferredName(), (Object)this.operator);
        builder.field(VALUE_FIELD.getPreferredName(), this.value);
        builder.endObject();
        return builder;
    }

    public AppliesTo getAppliesTo() {
        return this.appliesTo;
    }

    public Operator getOperator() {
        return this.operator;
    }

    public double getValue() {
        return this.value;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof RuleCondition)) {
            return false;
        }
        RuleCondition other = (RuleCondition)obj;
        return this.appliesTo == other.appliesTo && this.operator == other.operator && this.value == other.value;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.appliesTo, this.operator, this.value});
    }

    public static RuleCondition createTime(Operator operator, long epochSeconds) {
        return new RuleCondition(AppliesTo.TIME, operator, epochSeconds);
    }

    static {
        PARSERS.put(MlParserType.METADATA, METADATA_PARSER);
        PARSERS.put(MlParserType.CONFIG, CONFIG_PARSER);
        for (MlParserType parserType : MlParserType.values()) {
            ConstructingObjectParser<RuleCondition, Void> parser = PARSERS.get((Object)parserType);
            assert (parser != null);
            parser.declareField(ConstructingObjectParser.constructorArg(), p -> {
                if (p.currentToken() == XContentParser.Token.VALUE_STRING) {
                    return AppliesTo.fromString(p.text());
                }
                throw new IllegalArgumentException("Unsupported token [" + p.currentToken() + "]");
            }, APPLIES_TO_FIELD, ObjectParser.ValueType.STRING);
            parser.declareField(ConstructingObjectParser.constructorArg(), p -> {
                if (p.currentToken() == XContentParser.Token.VALUE_STRING) {
                    return Operator.fromString(p.text());
                }
                throw new IllegalArgumentException("Unsupported token [" + p.currentToken() + "]");
            }, Operator.OPERATOR_FIELD, ObjectParser.ValueType.STRING);
            parser.declareDouble(ConstructingObjectParser.constructorArg(), VALUE_FIELD);
        }
    }

    public static enum AppliesTo implements Writeable
    {
        ACTUAL,
        TYPICAL,
        DIFF_FROM_TYPICAL,
        TIME;


        public static AppliesTo fromString(String value) {
            return AppliesTo.valueOf(value.toUpperCase(Locale.ROOT));
        }

        public static AppliesTo readFromStream(StreamInput in) throws IOException {
            return (AppliesTo)in.readEnum(AppliesTo.class);
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeEnum((Enum)this);
        }

        public String toString() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

