/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.manage.schema.extract;

import com.google.common.base.Equivalence;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.gradle.api.Action;
import org.gradle.internal.reflect.PropertyAccessorType;
import org.gradle.model.internal.manage.schema.ModelProperty;
import org.gradle.model.internal.manage.schema.ModelSchema;
import org.gradle.model.internal.manage.schema.extract.CandidateMethods;
import org.gradle.model.internal.manage.schema.extract.ModelPropertyExtractionContext;
import org.gradle.model.internal.manage.schema.extract.ModelPropertyExtractionResult;
import org.gradle.model.internal.manage.schema.extract.ModelSchemaAspect;
import org.gradle.model.internal.manage.schema.extract.ModelSchemaAspectExtractor;
import org.gradle.model.internal.manage.schema.extract.ModelSchemaExtractionContext;
import org.gradle.model.internal.manage.schema.extract.ModelSchemaExtractionStrategy;
import org.gradle.model.internal.manage.schema.extract.ModelSchemaUtils;
import org.gradle.model.internal.manage.schema.extract.PropertyAccessorExtractionContext;
import org.gradle.model.internal.method.WeaklyTypeReferencingMethod;
import org.gradle.model.internal.type.ModelType;

public abstract class StructSchemaExtractionStrategySupport
implements ModelSchemaExtractionStrategy {
    private final ModelSchemaAspectExtractor aspectExtractor;

    protected StructSchemaExtractionStrategySupport(ModelSchemaAspectExtractor aspectExtractor) {
        this.aspectExtractor = aspectExtractor;
    }

    public <R> void extract(ModelSchemaExtractionContext<R> extractionContext) {
        ModelType<R> type = extractionContext.getType();
        if (!this.isTarget(type)) {
            return;
        }
        CandidateMethods candidateMethods = ModelSchemaUtils.getCandidateMethods(type.getRawClass());
        Iterable<ModelPropertyExtractionContext> candidateProperties = this.selectProperties(extractionContext, candidateMethods);
        List<ModelPropertyExtractionResult<?>> extractedProperties = StructSchemaExtractionStrategySupport.extractProperties(candidateProperties);
        List<ModelSchemaAspect> aspects = this.aspectExtractor.extract(extractionContext, extractedProperties);
        Set<WeaklyTypeReferencingMethod<?, ?>> nonPropertyMethods = this.getNonPropertyMethods(candidateMethods, extractedProperties);
        Iterable properties = Iterables.transform(extractedProperties, (Function)new Function<ModelPropertyExtractionResult<?>, ModelProperty<?>>(){

            public ModelProperty<?> apply(ModelPropertyExtractionResult<?> propertyResult) {
                return propertyResult.getProperty();
            }
        });
        ModelSchema<R> schema = this.createSchema(extractionContext, properties, nonPropertyMethods, aspects);
        for (ModelPropertyExtractionResult<?> propertyResult : extractedProperties) {
            StructSchemaExtractionStrategySupport.toPropertyExtractionContext(extractionContext, propertyResult);
        }
        extractionContext.found(schema);
    }

    private Set<WeaklyTypeReferencingMethod<?, ?>> getNonPropertyMethods(CandidateMethods candidateMethods, List<ModelPropertyExtractionResult<?>> extractedProperties) {
        LinkedHashSet nonPropertyMethods = Sets.newLinkedHashSet((Iterable)Iterables.transform(candidateMethods.allMethods().keySet(), (Function)new Function<Equivalence.Wrapper<Method>, Method>(){

            public Method apply(Equivalence.Wrapper<Method> method) {
                return (Method)method.get();
            }
        }));
        for (ModelPropertyExtractionResult<?> extractedProperty : extractedProperties) {
            for (PropertyAccessorExtractionContext accessor : extractedProperty.getAccessors()) {
                nonPropertyMethods.removeAll(accessor.getDeclaringMethods());
            }
        }
        return Sets.newLinkedHashSet((Iterable)Iterables.transform((Iterable)nonPropertyMethods, (Function)new Function<Method, WeaklyTypeReferencingMethod<?, ?>>(){

            public WeaklyTypeReferencingMethod<?, ?> apply(Method method) {
                return WeaklyTypeReferencingMethod.of(method);
            }
        }));
    }

    protected abstract boolean isTarget(ModelType<?> var1);

    private Iterable<ModelPropertyExtractionContext> selectProperties(ModelSchemaExtractionContext<?> context, CandidateMethods candidateMethods) {
        TreeMap propertiesMap = Maps.newTreeMap();
        for (Map.Entry<Equivalence.Wrapper<Method>, Collection<Method>> entry : candidateMethods.allMethods().entrySet()) {
            Method method = (Method)entry.getKey().get();
            PropertyAccessorType propertyAccessorType = PropertyAccessorType.of((Method)method);
            Collection<Method> methodsWithEqualSignature = entry.getValue();
            if (propertyAccessorType == null) continue;
            String propertyName = propertyAccessorType.propertyNameFor(method);
            ModelPropertyExtractionContext propertyContext = (ModelPropertyExtractionContext)propertiesMap.get(propertyName);
            if (propertyContext == null) {
                propertyContext = new ModelPropertyExtractionContext(propertyName);
                propertiesMap.put(propertyName, propertyContext);
            }
            propertyContext.addAccessor(new PropertyAccessorExtractionContext(propertyAccessorType, methodsWithEqualSignature));
        }
        return Collections2.filter(propertiesMap.values(), (Predicate)new Predicate<ModelPropertyExtractionContext>(){

            public boolean apply(ModelPropertyExtractionContext property) {
                return property.isReadable();
            }
        });
    }

    private static List<ModelPropertyExtractionResult<?>> extractProperties(Iterable<ModelPropertyExtractionContext> properties) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (ModelPropertyExtractionContext propertyContext : properties) {
            builder.add(StructSchemaExtractionStrategySupport.extractProperty(propertyContext));
        }
        return builder.build();
    }

    private static ModelPropertyExtractionResult<?> extractProperty(ModelPropertyExtractionContext property) {
        ModelType<?> propertyType = StructSchemaExtractionStrategySupport.determinePropertyType(property.getAccessor(PropertyAccessorType.GET_GETTER));
        if (propertyType == null) {
            propertyType = StructSchemaExtractionStrategySupport.determinePropertyType(property.getAccessor(PropertyAccessorType.IS_GETTER));
        }
        if (propertyType == null) {
            propertyType = StructSchemaExtractionStrategySupport.determinePropertyType(property.getAccessor(PropertyAccessorType.SETTER));
        }
        return StructSchemaExtractionStrategySupport.createProperty(propertyType, property);
    }

    private static ModelType<?> determinePropertyType(PropertyAccessorExtractionContext accessor) {
        return accessor == null ? null : ModelType.of(accessor.getAccessorType().propertyTypeFor(accessor.getMostSpecificDeclaration()));
    }

    private static <P> ModelPropertyExtractionResult<P> createProperty(ModelType<P> propertyType, ModelPropertyExtractionContext propertyContext) {
        ImmutableMap.Builder accessors = ImmutableMap.builder();
        for (PropertyAccessorExtractionContext accessor : propertyContext.getAccessors()) {
            WeaklyTypeReferencingMethod<?, ?> accessorMethod = WeaklyTypeReferencingMethod.of(accessor.getMostSpecificDeclaration());
            accessors.put((Object)accessor.getAccessorType(), accessorMethod);
        }
        ModelProperty<P> property = new ModelProperty<P>(propertyType, propertyContext.getPropertyName(), propertyContext.getDeclaredBy(), (Map<PropertyAccessorType, WeaklyTypeReferencingMethod<?, ?>>)accessors.build());
        return new ModelPropertyExtractionResult<P>(property, propertyContext.getAccessors());
    }

    private static <R, P> void toPropertyExtractionContext(ModelSchemaExtractionContext<R> parentContext, ModelPropertyExtractionResult<P> propertyResult) {
        ModelProperty<P> property = propertyResult.getProperty();
        String propertyDescription = StructSchemaExtractionStrategySupport.propertyDescription(parentContext, property);
        parentContext.child(property.getType(), propertyDescription, StructSchemaExtractionStrategySupport.attachSchema(property));
    }

    private static <P> Action<? super ModelSchema<P>> attachSchema(final ModelProperty<P> property) {
        return new Action<ModelSchema<P>>(){

            public void execute(ModelSchema<P> propertySchema) {
                property.setSchema(propertySchema);
            }
        };
    }

    private static String propertyDescription(ModelSchemaExtractionContext<?> parentContext, ModelProperty<?> property) {
        if (property.getDeclaredBy().size() == 1 && property.getDeclaredBy().contains(parentContext.getType())) {
            return String.format("property '%s'", property.getName());
        }
        ImmutableSortedSet declaredBy = ImmutableSortedSet.copyOf((Iterable)Iterables.transform(property.getDeclaredBy(), (Function)Functions.toStringFunction()));
        return String.format("property '%s' declared by %s", property.getName(), Joiner.on((String)", ").join((Iterable)declaredBy));
    }

    protected abstract <R> ModelSchema<R> createSchema(ModelSchemaExtractionContext<R> var1, Iterable<ModelProperty<?>> var2, Set<WeaklyTypeReferencingMethod<?, ?>> var3, Iterable<ModelSchemaAspect> var4);
}

