/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.command;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import javax.swing.Icon;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.PseudoCommand;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Utils;

public class SequenceCommand
extends Command {
    private Command[] sequence;
    private boolean sequenceComplete;
    private final String name;
    protected final boolean continueOnError;

    public SequenceCommand(DataSet ds, String name, Collection<Command> sequenz, boolean continueOnError) {
        super(ds);
        this.name = name;
        this.sequence = sequenz.toArray(new Command[0]);
        this.continueOnError = continueOnError;
    }

    public SequenceCommand(String name, Collection<Command> sequenz, boolean continueOnError) {
        this(sequenz.iterator().next().getAffectedDataSet(), name, sequenz, continueOnError);
    }

    public SequenceCommand(String name, Collection<Command> sequenz) {
        this(name, sequenz, false);
    }

    public SequenceCommand(String name, Command ... sequenz) {
        this(name, Arrays.asList(sequenz));
    }

    @Override
    public boolean executeCommand() {
        for (int i = 0; i < this.sequence.length; ++i) {
            boolean result = this.sequence[i].executeCommand();
            if (result || this.continueOnError) continue;
            this.undoCommands(i - 1);
            return false;
        }
        this.sequenceComplete = true;
        return true;
    }

    public Command getLastCommand() {
        if (this.sequence.length == 0) {
            return null;
        }
        return this.sequence[this.sequence.length - 1];
    }

    protected final void undoCommands(int start) {
        for (int i = start; i >= 0; --i) {
            this.sequence[i].undoCommand();
        }
    }

    @Override
    public void undoCommand() {
        if (!this.sequenceComplete) {
            return;
        }
        this.undoCommands(this.sequence.length - 1);
    }

    @Override
    public void fillModifiedData(Collection<OsmPrimitive> modified, Collection<OsmPrimitive> deleted, Collection<OsmPrimitive> added) {
        for (Command c : this.sequence) {
            c.fillModifiedData(modified, deleted, added);
        }
    }

    @Override
    public String getDescriptionText() {
        return I18n.tr("Sequence: {0}", this.name);
    }

    @Override
    public Icon getDescriptionIcon() {
        return ImageProvider.get("data", "sequence");
    }

    @Override
    public Collection<PseudoCommand> getChildren() {
        return Arrays.asList(this.sequence);
    }

    @Override
    public Collection<? extends OsmPrimitive> getParticipatingPrimitives() {
        HashSet<? extends OsmPrimitive> prims = new HashSet<OsmPrimitive>();
        for (Command c : this.sequence) {
            prims.addAll(c.getParticipatingPrimitives());
        }
        return prims;
    }

    protected final void setSequence(Command ... sequence) {
        this.sequence = Utils.copyArray(sequence);
    }

    protected final void setSequenceComplete(boolean sequenceComplete) {
        this.sequenceComplete = sequenceComplete;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), Arrays.hashCode(this.sequence), this.sequenceComplete, this.name, this.continueOnError);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        SequenceCommand that = (SequenceCommand)obj;
        return this.sequenceComplete == that.sequenceComplete && this.continueOnError == that.continueOnError && Arrays.equals(this.sequence, that.sequence) && Objects.equals(this.name, that.name);
    }
}

