/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import org.openstreetmap.josm.actions.AboutAction;
import org.openstreetmap.josm.actions.AddNodeAction;
import org.openstreetmap.josm.actions.AlignInCircleAction;
import org.openstreetmap.josm.actions.AlignInLineAction;
import org.openstreetmap.josm.actions.AutoScaleAction;
import org.openstreetmap.josm.actions.ChangesetManagerToggleAction;
import org.openstreetmap.josm.actions.CloseChangesetAction;
import org.openstreetmap.josm.actions.CombineWayAction;
import org.openstreetmap.josm.actions.CopyAction;
import org.openstreetmap.josm.actions.CopyCoordinatesAction;
import org.openstreetmap.josm.actions.CreateCircleAction;
import org.openstreetmap.josm.actions.CreateMultipolygonAction;
import org.openstreetmap.josm.actions.DeleteAction;
import org.openstreetmap.josm.actions.DeleteLayerAction;
import org.openstreetmap.josm.actions.DialogsToggleAction;
import org.openstreetmap.josm.actions.DistributeAction;
import org.openstreetmap.josm.actions.DownloadAction;
import org.openstreetmap.josm.actions.DownloadNotesInViewAction;
import org.openstreetmap.josm.actions.DownloadOsmInViewAction;
import org.openstreetmap.josm.actions.DownloadPrimitiveAction;
import org.openstreetmap.josm.actions.DownloadReferrersAction;
import org.openstreetmap.josm.actions.DuplicateAction;
import org.openstreetmap.josm.actions.ExitAction;
import org.openstreetmap.josm.actions.ExpertToggleAction;
import org.openstreetmap.josm.actions.FollowLineAction;
import org.openstreetmap.josm.actions.FullscreenToggleAction;
import org.openstreetmap.josm.actions.GpxExportAction;
import org.openstreetmap.josm.actions.HelpAction;
import org.openstreetmap.josm.actions.HistoryInfoAction;
import org.openstreetmap.josm.actions.HistoryInfoWebAction;
import org.openstreetmap.josm.actions.InfoAction;
import org.openstreetmap.josm.actions.InfoWebAction;
import org.openstreetmap.josm.actions.JoinAreasAction;
import org.openstreetmap.josm.actions.JoinNodeWayAction;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.actions.JumpToAction;
import org.openstreetmap.josm.actions.MergeLayerAction;
import org.openstreetmap.josm.actions.MergeNodesAction;
import org.openstreetmap.josm.actions.MergeSelectionAction;
import org.openstreetmap.josm.actions.MirrorAction;
import org.openstreetmap.josm.actions.MoveAction;
import org.openstreetmap.josm.actions.MoveNodeAction;
import org.openstreetmap.josm.actions.NewAction;
import org.openstreetmap.josm.actions.OpenFileAction;
import org.openstreetmap.josm.actions.OpenLocationAction;
import org.openstreetmap.josm.actions.OrthogonalizeAction;
import org.openstreetmap.josm.actions.PasteAction;
import org.openstreetmap.josm.actions.PasteAtSourcePositionAction;
import org.openstreetmap.josm.actions.PasteTagsAction;
import org.openstreetmap.josm.actions.PreferenceToggleAction;
import org.openstreetmap.josm.actions.PreferencesAction;
import org.openstreetmap.josm.actions.PurgeAction;
import org.openstreetmap.josm.actions.RedoAction;
import org.openstreetmap.josm.actions.ReorderImageryLayersAction;
import org.openstreetmap.josm.actions.ReportBugAction;
import org.openstreetmap.josm.actions.RestartAction;
import org.openstreetmap.josm.actions.ReverseWayAction;
import org.openstreetmap.josm.actions.SaveAction;
import org.openstreetmap.josm.actions.SaveAsAction;
import org.openstreetmap.josm.actions.SearchNotesDownloadAction;
import org.openstreetmap.josm.actions.SelectAllAction;
import org.openstreetmap.josm.actions.SelectNonBranchingWaySequencesAction;
import org.openstreetmap.josm.actions.SessionSaveAsAction;
import org.openstreetmap.josm.actions.ShowStatusReportAction;
import org.openstreetmap.josm.actions.SimplifyWayAction;
import org.openstreetmap.josm.actions.SplitWayAction;
import org.openstreetmap.josm.actions.TaggingPresetSearchAction;
import org.openstreetmap.josm.actions.UnGlueAction;
import org.openstreetmap.josm.actions.UnJoinNodeWayAction;
import org.openstreetmap.josm.actions.UndoAction;
import org.openstreetmap.josm.actions.UnselectAllAction;
import org.openstreetmap.josm.actions.UpdateDataAction;
import org.openstreetmap.josm.actions.UpdateModifiedAction;
import org.openstreetmap.josm.actions.UpdateSelectionAction;
import org.openstreetmap.josm.actions.UploadAction;
import org.openstreetmap.josm.actions.UploadSelectionAction;
import org.openstreetmap.josm.actions.ViewportFollowToggleAction;
import org.openstreetmap.josm.actions.WireframeToggleAction;
import org.openstreetmap.josm.actions.ZoomInAction;
import org.openstreetmap.josm.actions.ZoomOutAction;
import org.openstreetmap.josm.actions.audio.AudioBackAction;
import org.openstreetmap.josm.actions.audio.AudioFasterAction;
import org.openstreetmap.josm.actions.audio.AudioFwdAction;
import org.openstreetmap.josm.actions.audio.AudioNextAction;
import org.openstreetmap.josm.actions.audio.AudioPlayPauseAction;
import org.openstreetmap.josm.actions.audio.AudioPrevAction;
import org.openstreetmap.josm.actions.audio.AudioSlowerAction;
import org.openstreetmap.josm.actions.search.SearchAction;
import org.openstreetmap.josm.data.UndoRedoHandler;
import org.openstreetmap.josm.gui.ImageryMenu;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MenuScroller;
import org.openstreetmap.josm.gui.dialogs.MenuItemSearchDialog;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.io.RecentlyOpenedFilesMenu;
import org.openstreetmap.josm.gui.layer.MainLayerManager;
import org.openstreetmap.josm.gui.mappaint.MapPaintMenu;
import org.openstreetmap.josm.gui.preferences.imagery.ImageryPreference;
import org.openstreetmap.josm.gui.preferences.map.TaggingPresetPreference;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPresetSearchPrimitiveDialog;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.PlatformManager;
import org.openstreetmap.josm.tools.Shortcut;

public class MainMenu
extends JMenuBar {
    public final NewAction newAction = new NewAction();
    public final OpenFileAction openFile = new OpenFileAction();
    public final RecentlyOpenedFilesMenu recentlyOpened = new RecentlyOpenedFilesMenu();
    public final OpenLocationAction openLocation = new OpenLocationAction();
    public final DeleteLayerAction deleteLayerAction = new DeleteLayerAction();
    public final SaveAction save = SaveAction.getInstance();
    public final SaveAsAction saveAs = SaveAsAction.getInstance();
    public SessionSaveAsAction sessionSaveAs;
    public final GpxExportAction gpxExport = new GpxExportAction();
    public final DownloadAction download = new DownloadAction();
    public final DownloadOsmInViewAction downloadInView = new DownloadOsmInViewAction();
    public final DownloadPrimitiveAction downloadPrimitive = new DownloadPrimitiveAction();
    public final DownloadNotesInViewAction downloadNotesInView = DownloadNotesInViewAction.newActionWithNoteIcon();
    public final SearchNotesDownloadAction searchNotes = new SearchNotesDownloadAction();
    public final DownloadReferrersAction downloadReferrers = new DownloadReferrersAction();
    public final CloseChangesetAction closeChangesetAction = new CloseChangesetAction();
    public final JosmAction update = new UpdateDataAction();
    public final JosmAction updateSelection = new UpdateSelectionAction();
    public final JosmAction updateModified = new UpdateModifiedAction();
    public final JosmAction upload = new UploadAction();
    public final JosmAction uploadSelection = new UploadSelectionAction();
    public final RestartAction restart = new RestartAction();
    public final ExitAction exit = new ExitAction();
    public final UndoAction undo = new UndoAction();
    public final RedoAction redo = new RedoAction();
    public final CopyAction copy = new CopyAction();
    public final JosmAction copyCoordinates = new CopyCoordinatesAction();
    public final PasteAction paste = new PasteAction();
    private final PasteAtSourcePositionAction pasteAtSource = new PasteAtSourcePositionAction();
    public final PasteTagsAction pasteTags = new PasteTagsAction();
    public final DuplicateAction duplicate = new DuplicateAction();
    public final DeleteAction delete = new DeleteAction();
    public final JosmAction purge = new PurgeAction();
    public final MergeLayerAction merge = new MergeLayerAction();
    public final MergeSelectionAction mergeSelected = new MergeSelectionAction();
    public final SearchAction search = new SearchAction();
    public final PreferencesAction preferences = new PreferencesAction();
    public final WireframeToggleAction wireFrameToggleAction = new WireframeToggleAction();
    public final InfoAction info = new InfoAction();
    public final InfoWebAction infoweb = new InfoWebAction();
    public final HistoryInfoAction historyinfo = new HistoryInfoAction();
    public final HistoryInfoWebAction historyinfoweb = new HistoryInfoWebAction();
    public final Map<String, AutoScaleAction> autoScaleActions = new HashMap<String, AutoScaleAction>();
    public final JumpToAction jumpToAct = new JumpToAction();
    public final SplitWayAction splitWay = new SplitWayAction();
    public final CombineWayAction combineWay = new CombineWayAction();
    public final ReverseWayAction reverseWay = new ReverseWayAction();
    public final SimplifyWayAction simplifyWay = new SimplifyWayAction();
    public final AlignInCircleAction alignInCircle = new AlignInCircleAction();
    public final AlignInLineAction alignInLine = new AlignInLineAction();
    public final DistributeAction distribute = new DistributeAction();
    public final OrthogonalizeAction ortho = new OrthogonalizeAction();
    public final OrthogonalizeAction.Undo orthoUndo = new OrthogonalizeAction.Undo();
    public final MirrorAction mirror = new MirrorAction();
    public final FollowLineAction followLine = new FollowLineAction();
    public final AddNodeAction addNode = new AddNodeAction();
    public final MoveNodeAction moveNode = new MoveNodeAction();
    public final CreateCircleAction createCircle = new CreateCircleAction();
    public final MergeNodesAction mergeNodes = new MergeNodesAction();
    public final JoinNodeWayAction joinNodeWay = JoinNodeWayAction.createJoinNodeToWayAction();
    public final JoinNodeWayAction moveNodeOntoWay = JoinNodeWayAction.createMoveNodeOntoWayAction();
    public final UnJoinNodeWayAction unJoinNodeWay = new UnJoinNodeWayAction();
    public final UnGlueAction unglueNodes = new UnGlueAction();
    public final JoinAreasAction joinAreas = new JoinAreasAction();
    public final CreateMultipolygonAction createMultipolygon = new CreateMultipolygonAction(false);
    public final CreateMultipolygonAction updateMultipolygon = new CreateMultipolygonAction(true);
    public final SelectAllAction selectAll = new SelectAllAction();
    public final UnselectAllAction unselectAll = new UnselectAllAction();
    public final SelectNonBranchingWaySequencesAction nonBranchingWaySequences = new SelectNonBranchingWaySequencesAction();
    public final JosmAction audioPlayPause = new AudioPlayPauseAction();
    public final JosmAction audioNext = new AudioNextAction();
    public final JosmAction audioPrev = new AudioPrevAction();
    public final JosmAction audioFwd = new AudioFwdAction();
    public final JosmAction audioBack = new AudioBackAction();
    public final JosmAction audioFaster = new AudioFasterAction();
    public final JosmAction audioSlower = new AudioSlowerAction();
    public final ChangesetManagerToggleAction changesetManager = new ChangesetManagerToggleAction();
    public final HelpAction help = new HelpAction();
    public final AboutAction about = new AboutAction();
    public final ShowStatusReportAction statusreport = new ShowStatusReportAction();
    public final ReportBugAction reportbug = new ReportBugAction();
    public final JMenu fileMenu = this.addMenu("File", I18n.trc("menu", "File"), 70, 0, HelpUtil.ht("/Menu/File"));
    public final JMenu editMenu = this.addMenu("Edit", I18n.trc("menu", "Edit"), 69, 1, HelpUtil.ht("/Menu/Edit"));
    public final JMenu viewMenu = this.addMenu("View", I18n.trc("menu", "View"), 86, 2, HelpUtil.ht("/Menu/View"));
    public final JMenu toolsMenu = this.addMenu("Tools", I18n.trc("menu", "Tools"), 84, 3, HelpUtil.ht("/Menu/Tools"));
    public final JMenu moreToolsMenu = this.addMenu("More tools", I18n.trc("menu", "More tools"), 77, 4, HelpUtil.ht("/Menu/MoreTools"));
    public final JMenu dataMenu = this.addMenu("Data", I18n.trc("menu", "Data"), 68, 5, HelpUtil.ht("/Menu/Data"));
    public final JMenu selectionMenu = this.addMenu("Selection", I18n.trc("menu", "Selection"), 78, 6, HelpUtil.ht("/Menu/Selection"));
    public final JMenu presetsMenu = this.addMenu("Presets", I18n.trc("menu", "Presets"), 80, 7, HelpUtil.ht("/Menu/Presets"));
    public final JMenu imagerySubMenu = new JMenu(I18n.tr("More...", new Object[0]));
    public final ImageryMenu imageryMenu = this.addMenu(new ImageryMenu(this.imagerySubMenu), "Imagery", 73, 8, HelpUtil.ht("/Menu/Imagery"));
    public final JMenu gpsMenu = this.addMenu("GPS", I18n.trc("menu", "GPS"), 71, 9, HelpUtil.ht("/Menu/GPS"));
    public final JMenu windowMenu = this.addMenu("Windows", I18n.trc("menu", "Windows"), 87, 10, HelpUtil.ht("/ToggleDialogs"));
    public JMenu audioMenu;
    public final JMenu helpMenu = this.addMenu("Help", I18n.trc("menu", "Help"), 72, 11, HelpUtil.ht("/Menu/Help"));
    private static final int defaultMenuPos = 11;
    public final JosmAction moveUpAction = new MoveAction(MoveAction.Direction.UP);
    public final JosmAction moveDownAction = new MoveAction(MoveAction.Direction.DOWN);
    public final JosmAction moveLeftAction = new MoveAction(MoveAction.Direction.LEFT);
    public final JosmAction moveRightAction = new MoveAction(MoveAction.Direction.RIGHT);
    public final ReorderImageryLayersAction reorderImageryLayersAction = new ReorderImageryLayersAction();
    public final TaggingPresetSearchAction presetSearchAction = new TaggingPresetSearchAction();
    public final TaggingPresetSearchPrimitiveDialog.Action presetSearchPrimitiveAction = new TaggingPresetSearchPrimitiveDialog.Action();
    public final DialogsToggleAction dialogsToggleAction = new DialogsToggleAction();
    public FullscreenToggleAction fullscreenToggleAction;
    public static final MenuListener menuSeparatorHandler = new MenuListener(){

        @Override
        public void menuCanceled(MenuEvent e) {
        }

        @Override
        public void menuDeselected(MenuEvent e) {
        }

        @Override
        public void menuSelected(MenuEvent a) {
            if (!(a.getSource() instanceof JMenu)) {
                return;
            }
            JPopupMenu m = ((JMenu)a.getSource()).getPopupMenu();
            for (int i = 0; i < m.getComponentCount() - 1; ++i) {
                if (!(m.getComponent(i) instanceof JSeparator)) continue;
                ((JSeparator)m.getComponent(i)).setVisible(!(m.getComponent(i + 1) instanceof JSeparator));
            }
            if (m.getComponent(m.getComponentCount() - 1) instanceof JSeparator) {
                ((JSeparator)m.getComponent(m.getComponentCount() - 1)).setVisible(false);
            }
        }
    };

    public int getDefaultMenuPos() {
        return 11;
    }

    public static JMenuItem add(JMenu menu, JosmAction action) {
        return MainMenu.add(menu, action, false);
    }

    public static JMenuItem add(JMenu menu, JosmAction action, boolean isExpert) {
        return MainMenu.add(menu, action, isExpert, null);
    }

    public static JMenuItem add(JMenu menu, JosmAction action, boolean isExpert, Integer index) {
        KeyStroke ks;
        if (action.getShortcut().isAutomatic()) {
            return null;
        }
        JMenuItem menuitem = index == null ? menu.add(action) : menu.insert(action, (int)index);
        if (isExpert) {
            ExpertToggleAction.addVisibilitySwitcher(menuitem);
        }
        if ((ks = action.getShortcut().getKeyStroke()) != null) {
            menuitem.setAccelerator(ks);
        }
        if (!menu.isVisible()) {
            menu.setVisible(true);
        }
        return menuitem;
    }

    public static JMenuItem addAfter(JMenu menu, JosmAction actionToBeInserted, boolean isExpert, JosmAction existingMenuEntryAction) {
        Component c;
        int i = 0;
        Component[] componentArray = menu.getMenuComponents();
        int n = componentArray.length;
        for (int j = 0; !(j >= n || (c = componentArray[j]) instanceof JMenuItem && ((JMenuItem)c).getAction() == existingMenuEntryAction); ++j) {
            ++i;
        }
        return MainMenu.add(menu, actionToBeInserted, isExpert, i + 1);
    }

    public static <E extends Enum<E>> JMenuItem add(JMenu menu, JosmAction action, Enum<E> group) {
        if (action.getShortcut().isAutomatic()) {
            return null;
        }
        int i = MainMenu.getInsertionIndexForGroup(menu, group.ordinal());
        JMenuItem menuitem = (JMenuItem)menu.add((Component)new JMenuItem(action), i);
        KeyStroke ks = action.getShortcut().getKeyStroke();
        if (ks != null) {
            menuitem.setAccelerator(ks);
        }
        return menuitem;
    }

    public static <E extends Enum<E>> JCheckBoxMenuItem addWithCheckbox(JMenu menu, JosmAction action, Enum<E> group) {
        int i = MainMenu.getInsertionIndexForGroup(menu, group.ordinal());
        JCheckBoxMenuItem mi = (JCheckBoxMenuItem)menu.add((Component)new JCheckBoxMenuItem(action), i);
        KeyStroke ks = action.getShortcut().getKeyStroke();
        if (ks != null) {
            mi.setAccelerator(ks);
        }
        return mi;
    }

    private static int getInsertionIndexForGroup(JMenu menu, int group) {
        int i;
        if (group < 0) {
            return -1;
        }
        for (i = 0; i < menu.getItemCount() && group >= 0; ++i) {
            if (menu.getItem(i) != null) continue;
            --group;
        }
        if (group < 0) {
            --i;
        }
        while (group > 0) {
            menu.addSeparator();
            --group;
            ++i;
        }
        return i;
    }

    public JMenu addMenu(String name, String translatedName, int mnemonicKey, int position, String relativeHelpTopic) {
        JMenu menu = new JMenu(translatedName);
        if (!GraphicsEnvironment.isHeadless()) {
            MenuScroller.setScrollerFor(menu);
        }
        return this.addMenu(menu, name, mnemonicKey, position, relativeHelpTopic);
    }

    public <T extends JMenu> T addMenu(T menu, String name, int mnemonicKey, int position, String relativeHelpTopic) {
        Shortcut.registerShortcut("menu:" + name, I18n.tr("Menu: {0}", name), mnemonicKey, 5001).setMnemonic(menu);
        this.add((Component)menu, position);
        menu.putClientProperty("help", relativeHelpTopic);
        return menu;
    }

    public void initialize() {
        this.moreToolsMenu.setVisible(false);
        this.dataMenu.setVisible(false);
        this.gpsMenu.setVisible(false);
        MainMenu.add(this.fileMenu, this.newAction);
        MainMenu.add(this.fileMenu, this.openFile);
        this.fileMenu.add(this.recentlyOpened);
        MainMenu.add(this.fileMenu, this.openLocation);
        MainMenu.add(this.fileMenu, this.deleteLayerAction);
        this.fileMenu.addSeparator();
        MainMenu.add(this.fileMenu, this.save);
        MainMenu.add(this.fileMenu, this.saveAs);
        this.sessionSaveAs = new SessionSaveAsAction();
        ExpertToggleAction.addVisibilitySwitcher(this.fileMenu.add(this.sessionSaveAs));
        MainMenu.add(this.fileMenu, (JosmAction)this.gpxExport, true);
        this.fileMenu.addSeparator();
        MainMenu.add(this.fileMenu, this.download);
        MainMenu.add(this.fileMenu, (JosmAction)this.downloadInView, true);
        MainMenu.add(this.fileMenu, this.downloadPrimitive);
        MainMenu.add(this.fileMenu, this.searchNotes);
        MainMenu.add(this.fileMenu, this.downloadNotesInView);
        MainMenu.add(this.fileMenu, this.downloadReferrers);
        MainMenu.add(this.fileMenu, this.update);
        MainMenu.add(this.fileMenu, this.updateSelection);
        MainMenu.add(this.fileMenu, this.updateModified);
        this.fileMenu.addSeparator();
        MainMenu.add(this.fileMenu, this.upload);
        MainMenu.add(this.fileMenu, this.uploadSelection);
        JPopupMenu.Separator sep = new JPopupMenu.Separator();
        this.fileMenu.add(sep);
        ExpertToggleAction.addVisibilitySwitcher(sep);
        MainMenu.add(this.fileMenu, (JosmAction)this.closeChangesetAction, true);
        this.fileMenu.addSeparator();
        MainMenu.add(this.fileMenu, this.restart);
        MainMenu.add(this.fileMenu, this.exit);
        MainMenu.add(this.editMenu, this.undo);
        UndoRedoHandler.getInstance().addCommandQueueListener(this.undo);
        MainMenu.add(this.editMenu, this.redo);
        UndoRedoHandler.getInstance().addCommandQueueListener(this.redo);
        this.editMenu.addSeparator();
        MainMenu.add(this.editMenu, this.copy);
        MainMenu.add(this.editMenu, this.copyCoordinates, true);
        MainMenu.add(this.editMenu, this.paste);
        MainMenu.add(this.editMenu, (JosmAction)this.pasteAtSource, true);
        MainMenu.add(this.editMenu, this.pasteTags);
        MainMenu.add(this.editMenu, this.duplicate);
        MainMenu.add(this.editMenu, this.delete);
        MainMenu.add(this.editMenu, this.purge, true);
        this.editMenu.addSeparator();
        MainMenu.add(this.editMenu, this.merge);
        MainMenu.add(this.editMenu, this.mergeSelected);
        this.editMenu.addSeparator();
        MainMenu.add(this.editMenu, this.search);
        MainMenu.add(this.editMenu, this.presetSearchPrimitiveAction);
        this.editMenu.addSeparator();
        MainMenu.add(this.editMenu, this.preferences);
        JCheckBoxMenuItem wireframe = new JCheckBoxMenuItem(this.wireFrameToggleAction);
        this.viewMenu.add(wireframe);
        wireframe.setAccelerator(this.wireFrameToggleAction.getShortcut().getKeyStroke());
        this.wireFrameToggleAction.addButtonModel(wireframe.getModel());
        this.viewMenu.add(new MapPaintMenu());
        this.viewMenu.addSeparator();
        MainMenu.add(this.viewMenu, new ZoomInAction());
        MainMenu.add(this.viewMenu, new ZoomOutAction());
        this.viewMenu.addSeparator();
        for (String mode : AutoScaleAction.MODES) {
            AutoScaleAction autoScaleAction = new AutoScaleAction(mode);
            this.autoScaleActions.put(mode, autoScaleAction);
            MainMenu.add(this.viewMenu, autoScaleAction);
        }
        ViewportFollowToggleAction viewportFollowToggleAction = new ViewportFollowToggleAction();
        JCheckBoxMenuItem vft = new JCheckBoxMenuItem(viewportFollowToggleAction);
        ExpertToggleAction.addVisibilitySwitcher(vft);
        this.viewMenu.add(vft);
        vft.setAccelerator(viewportFollowToggleAction.getShortcut().getKeyStroke());
        viewportFollowToggleAction.addButtonModel(vft.getModel());
        if (PlatformManager.getPlatform().canFullscreen()) {
            this.fullscreenToggleAction = new FullscreenToggleAction();
            JCheckBoxMenuItem fullscreen = new JCheckBoxMenuItem(this.fullscreenToggleAction);
            this.viewMenu.addSeparator();
            this.viewMenu.add(fullscreen);
            fullscreen.setAccelerator(this.fullscreenToggleAction.getShortcut().getKeyStroke());
            this.fullscreenToggleAction.addButtonModel(fullscreen.getModel());
        }
        MainMenu.add(this.viewMenu, (JosmAction)this.jumpToAct, true);
        this.viewMenu.addSeparator();
        MainMenu.add(this.viewMenu, this.info);
        MainMenu.add(this.viewMenu, this.infoweb);
        MainMenu.add(this.viewMenu, this.historyinfo);
        MainMenu.add(this.viewMenu, this.historyinfoweb);
        this.viewMenu.addSeparator();
        this.viewMenu.add(new PreferenceToggleAction(I18n.tr("Main toolbar", new Object[0]), I18n.tr("Toggles the visibility of the main toolbar (i.e., the horizontal toolbar)", new Object[0]), "toolbar.visible", true).getCheckbox());
        this.viewMenu.add(new PreferenceToggleAction(I18n.tr("Edit toolbar", new Object[0]), I18n.tr("Toggles the visibility of the edit toolbar (i.e., the vertical tool)", new Object[0]), "sidetoolbar.visible", true).getCheckbox());
        JCheckBoxMenuItem dialogsToggle = new JCheckBoxMenuItem(this.dialogsToggleAction);
        dialogsToggle.setAccelerator(this.dialogsToggleAction.getShortcut().getKeyStroke());
        this.dialogsToggleAction.addButtonModel(dialogsToggle.getModel());
        this.viewMenu.add(dialogsToggle);
        this.viewMenu.addSeparator();
        JCheckBoxMenuItem expertItem = new JCheckBoxMenuItem(ExpertToggleAction.getInstance());
        this.viewMenu.add(expertItem);
        ExpertToggleAction.getInstance().addButtonModel(expertItem.getModel());
        MainMenu.add(this.presetsMenu, this.presetSearchAction);
        MainMenu.add(this.presetsMenu, this.presetSearchPrimitiveAction);
        MainMenu.add(this.presetsMenu, PreferencesAction.forPreferenceSubTab(I18n.tr("Preset preferences", new Object[0]), I18n.tr("Click to open the tagging presets tab in the preferences", new Object[0]), TaggingPresetPreference.class));
        this.presetsMenu.addSeparator();
        MainMenu.add(this.imageryMenu, this.reorderImageryLayersAction);
        MainMenu.add(this.imageryMenu, PreferencesAction.forPreferenceTab(I18n.tr("Imagery preferences", new Object[0]), I18n.tr("Click to open the imagery tab in the preferences", new Object[0]), ImageryPreference.class));
        MainMenu.add(this.selectionMenu, this.selectAll);
        MainMenu.add(this.selectionMenu, this.unselectAll);
        MainMenu.add(this.selectionMenu, this.nonBranchingWaySequences);
        MainMenu.add(this.toolsMenu, this.splitWay);
        MainMenu.add(this.toolsMenu, this.combineWay);
        this.toolsMenu.addSeparator();
        MainMenu.add(this.toolsMenu, this.reverseWay);
        MainMenu.add(this.toolsMenu, this.simplifyWay);
        this.toolsMenu.addSeparator();
        MainMenu.add(this.toolsMenu, this.alignInCircle);
        MainMenu.add(this.toolsMenu, this.alignInLine);
        MainMenu.add(this.toolsMenu, this.distribute);
        MainMenu.add(this.toolsMenu, this.ortho);
        MainMenu.add(this.toolsMenu, (JosmAction)this.mirror, true);
        this.toolsMenu.addSeparator();
        MainMenu.add(this.toolsMenu, (JosmAction)this.followLine, true);
        MainMenu.add(this.toolsMenu, (JosmAction)this.addNode, true);
        MainMenu.add(this.toolsMenu, (JosmAction)this.moveNode, true);
        MainMenu.add(this.toolsMenu, this.createCircle);
        this.toolsMenu.addSeparator();
        MainMenu.add(this.toolsMenu, this.mergeNodes);
        MainMenu.add(this.toolsMenu, this.joinNodeWay);
        MainMenu.add(this.toolsMenu, this.moveNodeOntoWay);
        MainMenu.add(this.toolsMenu, this.unJoinNodeWay);
        MainMenu.add(this.toolsMenu, this.unglueNodes);
        this.toolsMenu.addSeparator();
        MainMenu.add(this.toolsMenu, this.joinAreas);
        MainMenu.add(this.toolsMenu, this.createMultipolygon);
        MainMenu.add(this.toolsMenu, this.updateMultipolygon);
        JCheckBoxMenuItem mi = MainMenu.addWithCheckbox(this.windowMenu, this.changesetManager, WINDOW_MENU_GROUP.ALWAYS);
        this.changesetManager.addButtonModel(mi.getModel());
        if (!Config.getPref().getBoolean("audio.menuinvisible", false)) {
            this.showAudioMenu(true);
        }
        Config.getPref().addPreferenceChangeListener(e -> {
            if ("audio.menuinvisible".equals(e.getKey())) {
                this.showAudioMenu(!Boolean.parseBoolean(e.getNewValue().toString()));
            }
        });
        MainMenu.add(this.helpMenu, new MenuItemSearchDialog.Action());
        this.helpMenu.addSeparator();
        MainMenu.add(this.helpMenu, this.statusreport);
        MainMenu.add(this.helpMenu, this.reportbug);
        this.helpMenu.addSeparator();
        MainMenu.add(this.helpMenu, this.help);
        MainMenu.add(this.helpMenu, this.about);
        this.windowMenu.addMenuListener(menuSeparatorHandler);
        new PresetsMenuEnabler(this.presetsMenu);
    }

    public List<JMenuItem> findMenuItems(String textToFind, boolean skipPresets) {
        textToFind = textToFind.toLowerCase(Locale.getDefault());
        ArrayList<JMenuItem> result = new ArrayList<JMenuItem>();
        for (int i = 0; i < this.getMenuCount(); ++i) {
            if (this.getMenu(i) == null || skipPresets && this.presetsMenu == this.getMenu(i)) continue;
            MainMenu.findMenuItems(this.getMenu(i), textToFind, result);
        }
        return result;
    }

    private static void findMenuItems(JMenu menu, String textToFind, List<JMenuItem> result) {
        for (int i = 0; i < menu.getItemCount(); ++i) {
            JMenuItem menuItem = menu.getItem(i);
            if (menuItem == null) continue;
            if (menuItem.getAction() != null && menuItem.getText().toLowerCase(Locale.getDefault()).contains(textToFind)) {
                result.add(menuItem);
            }
            if (!(menuItem instanceof JMenu)) continue;
            MainMenu.findMenuItems((JMenu)menuItem, textToFind, result);
        }
    }

    protected void showAudioMenu(boolean showMenu) {
        if (showMenu && this.audioMenu == null) {
            this.audioMenu = this.addMenu("Audio", I18n.trc("menu", "Audio"), 85, 11, HelpUtil.ht("/Menu/Audio"));
            MainMenu.add(this.audioMenu, this.audioPlayPause);
            MainMenu.add(this.audioMenu, this.audioNext);
            MainMenu.add(this.audioMenu, this.audioPrev);
            MainMenu.add(this.audioMenu, this.audioFwd);
            MainMenu.add(this.audioMenu, this.audioBack);
            MainMenu.add(this.audioMenu, this.audioSlower);
            MainMenu.add(this.audioMenu, this.audioFaster);
            this.validate();
        } else if (!showMenu && this.audioMenu != null) {
            this.remove(this.audioMenu);
            this.audioMenu.removeAll();
            this.audioMenu = null;
            this.validate();
        }
    }

    static class PresetsMenuEnabler
    implements MainLayerManager.ActiveLayerChangeListener {
        private final JMenu presetsMenu;

        PresetsMenuEnabler(JMenu presetsMenu) {
            this.presetsMenu = presetsMenu;
            MainApplication.getLayerManager().addAndFireActiveLayerChangeListener(this);
        }

        @Override
        public void activeOrEditLayerChanged(MainLayerManager.ActiveLayerChangeEvent e) {
            this.presetsMenu.setEnabled(e.getSource().getEditLayer() != null);
        }
    }

    public static enum WINDOW_MENU_GROUP {
        ALWAYS,
        TOGGLE_DIALOG,
        VOLATILE;

    }
}

