/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal.util;

import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import jline.Terminal;
import jline.TerminalFactory;
import jline.console.ConsoleReader;
import jline.console.history.FileHistory;
import jline.console.history.History;
import jline.console.history.MemoryHistory;
import sbt.internal.util.InputStreamWrapper;
import sbt.internal.util.Signals$;
import sbt.internal.util.SimpleReader;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.concurrent.duration.Duration$;
import scala.runtime.BoxedUnit;

public final class JLine$ {
    public static JLine$ MODULE$;
    private final String TerminalProperty;
    private final FileInputStream originalIn;
    private final int MaxHistorySize;
    private final boolean HandleCONT;

    static {
        new JLine$();
    }

    public void fixTerminalProperty() {
        String string = System.getProperty(this.TerminalProperty);
        String string2 = "jline.UnixTerminal".equals(string) ? "unix" : (string == null && System.getProperty("sbt.cygwin") != null ? "unix" : ("jline.WindowsTerminal".equals(string) ? "windows" : ("jline.AnsiWindowsTerminal".equals(string) ? "windows" : ("jline.UnsupportedTerminal".equals(string) ? "none" : string))));
        String newValue = string2;
        Object object = newValue != null ? System.setProperty(this.TerminalProperty, newValue) : BoxedUnit.UNIT;
    }

    public FileInputStream originalIn() {
        return this.originalIn;
    }

    public InputStream makeInputStream(boolean injectThreadSleep) {
        return injectThreadSleep ? new InputStreamWrapper(this.originalIn(), Duration$.MODULE$.apply("50 ms")) : this.originalIn();
    }

    public Terminal sbt$internal$util$JLine$$terminal() {
        return TerminalFactory.get();
    }

    private synchronized <T> T withTerminal(Function1<Terminal, T> f) {
        Object object;
        Terminal t;
        Terminal terminal = t = this.sbt$internal$util$JLine$$terminal();
        synchronized (terminal) {
            object = f.apply((Object)t);
        }
        return (T)object;
    }

    public <T> T usingTerminal(Function1<Terminal, T> f) {
        return this.withTerminal((Function1 & Serializable & scala.Serializable)t -> {
            void var2_2;
            t.restore();
            Object result = f.apply(t);
            t.restore();
            return var2_2;
        });
    }

    public ConsoleReader createReader() {
        return this.createReader((Option<File>)None$.MODULE$, this.makeInputStream(true));
    }

    public ConsoleReader createReader(Option<File> historyPath, InputStream in) {
        return (ConsoleReader)this.usingTerminal((Function1 & Serializable & scala.Serializable)x$1 -> {
            MemoryHistory memoryHistory;
            ConsoleReader cr = new ConsoleReader(in, (OutputStream)System.out);
            cr.setExpandEvents(false);
            cr.setBellEnabled(false);
            Option option = historyPath;
            if (None$.MODULE$.equals(option)) {
                memoryHistory = new MemoryHistory();
            } else if (option instanceof Some) {
                Some some = (Some)option;
                File file = (File)some.value();
                memoryHistory = new FileHistory(file);
            } else {
                throw new MatchError((Object)option);
            }
            MemoryHistory h = memoryHistory;
            h.setMaxSize(MODULE$.MaxHistorySize());
            cr.setHistory((History)h);
            return cr;
        });
    }

    public <T> T withJLine(Function0<T> action) {
        return this.withTerminal((Function1 & Serializable & scala.Serializable)t -> {
            Object object;
            t.init();
            try {
                object = action.apply();
            }
            finally {
                t.restore();
            }
            return object;
        });
    }

    public SimpleReader simple(Option<File> historyPath, boolean handleCONT, boolean injectThreadSleep) {
        return new SimpleReader(historyPath, handleCONT, injectThreadSleep);
    }

    public boolean simple$default$2() {
        return this.HandleCONT();
    }

    public boolean simple$default$3() {
        return false;
    }

    public int MaxHistorySize() {
        return this.MaxHistorySize;
    }

    public boolean HandleCONT() {
        return this.HandleCONT;
    }

    private JLine$() {
        MODULE$ = this;
        this.TerminalProperty = "jline.terminal";
        this.fixTerminalProperty();
        this.originalIn = new FileInputStream(FileDescriptor.in);
        this.MaxHistorySize = 500;
        this.HandleCONT = !Boolean.getBoolean("sbt.disable.cont") && Signals$.MODULE$.supported(Signals$.MODULE$.CONT());
    }
}

