/*
 * Decompiled with CFR 0.152.
 */
package edu.umass.cs.benchlab.har;

import edu.umass.cs.benchlab.har.HarContent;
import edu.umass.cs.benchlab.har.HarCookies;
import edu.umass.cs.benchlab.har.HarDatabaseConfig;
import edu.umass.cs.benchlab.har.HarEntry;
import edu.umass.cs.benchlab.har.HarHeaders;
import edu.umass.cs.benchlab.har.HarWarning;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;

public class HarResponse {
    public static String TABLE_NAME = "response";
    private Integer status;
    private String statusText;
    private String httpVersion;
    private HarCookies cookies;
    private HarHeaders headers;
    private HarContent content;
    private String redirectURL;
    private Long headersSize = new Long(-1L);
    private Long bodySize = new Long(-1L);
    private String comment;

    public HarResponse(int status, String statusText, String httpVersion, HarCookies cookies, HarHeaders headers, HarContent content, String redirectURL, long headersSize, long bodySize, String comment) {
        this.status = status;
        this.statusText = statusText;
        this.httpVersion = httpVersion;
        this.cookies = cookies;
        this.headers = headers;
        this.content = content;
        this.redirectURL = redirectURL;
        this.headersSize = headersSize;
        this.bodySize = bodySize;
        this.comment = comment;
    }

    public HarResponse(int status, String statusText, String httpVersion, HarCookies cookies, HarHeaders headers, HarContent content, String redirectURL) {
        this.status = status;
        this.statusText = statusText;
        this.httpVersion = httpVersion;
        this.cookies = cookies;
        this.headers = headers;
        this.content = content;
        this.redirectURL = redirectURL;
    }

    public HarResponse(JsonParser jp, List<HarWarning> warnings) throws JsonParseException, IOException {
        if (jp.nextToken() != JsonToken.START_OBJECT) {
            throw new JsonParseException("{ missing after \"response\" element", jp.getCurrentLocation());
        }
        while (jp.nextToken() != JsonToken.END_OBJECT) {
            String name = jp.getCurrentName();
            if ("status".equals(name)) {
                this.setStatus(jp.getValueAsInt());
                continue;
            }
            if ("statusText".equals(name)) {
                this.setStatusText(jp.getText());
                continue;
            }
            if ("httpVersion".equals(name)) {
                this.setHttpVersion(jp.getText());
                continue;
            }
            if ("cookies".equals(name)) {
                this.setCookies(new HarCookies(jp, warnings));
                continue;
            }
            if ("headers".equals(name)) {
                this.setHeaders(new HarHeaders(jp, warnings));
                continue;
            }
            if ("content".equals(name)) {
                this.setContent(new HarContent(jp, warnings));
                continue;
            }
            if ("redirectURL".equals(name)) {
                this.setRedirectURL(jp.getText());
                continue;
            }
            if ("headersSize".equals(name)) {
                this.setHeadersSize(jp.getValueAsLong());
                continue;
            }
            if ("bodySize".equals(name)) {
                this.setBodySize(jp.getValueAsLong());
                continue;
            }
            if ("comment".equals(name)) {
                this.setComment(jp.getText());
                continue;
            }
            throw new JsonParseException("Unrecognized field '" + name + "' in response element", jp.getCurrentLocation());
        }
        if (this.status == null) {
            if (warnings != null) {
                warnings.add(new HarWarning("Missing status field in response element", jp.getCurrentLocation()));
            } else {
                throw new JsonParseException("Missing status field in response element", jp.getCurrentLocation());
            }
        }
        if (this.statusText == null) {
            if (warnings != null) {
                warnings.add(new HarWarning("Missing statusText field in response element", jp.getCurrentLocation()));
            } else {
                throw new JsonParseException("Missing statusText field in response element", jp.getCurrentLocation());
            }
        }
        if (this.httpVersion == null) {
            if (warnings != null) {
                warnings.add(new HarWarning("Missing httpVersion field in response element", jp.getCurrentLocation()));
            } else {
                throw new JsonParseException("Missing httpVersion field in response element", jp.getCurrentLocation());
            }
        }
        if (this.cookies == null) {
            if (warnings != null) {
                warnings.add(new HarWarning("Missing cookies field in response element", jp.getCurrentLocation()));
            } else {
                throw new JsonParseException("Missing cookies field in response element", jp.getCurrentLocation());
            }
        }
        if (this.headers == null) {
            if (warnings != null) {
                warnings.add(new HarWarning("Missing headers field in response element", jp.getCurrentLocation()));
            } else {
                throw new JsonParseException("Missing headers field in response element", jp.getCurrentLocation());
            }
        }
        if (this.content == null) {
            if (warnings != null) {
                warnings.add(new HarWarning("Missing content field in response element", jp.getCurrentLocation()));
            } else {
                throw new JsonParseException("Missing content field in response element", jp.getCurrentLocation());
            }
        }
        if (this.redirectURL == null) {
            if (warnings != null) {
                warnings.add(new HarWarning("Missing redirectURL field in response element", jp.getCurrentLocation()));
            } else {
                throw new JsonParseException("Missing redirectURL field in response element", jp.getCurrentLocation());
            }
        }
        if (this.headersSize == null) {
            if (warnings != null) {
                warnings.add(new HarWarning("Missing headersSize field in response element", jp.getCurrentLocation()));
            } else {
                throw new JsonParseException("Missing headersSize field in response element", jp.getCurrentLocation());
            }
        }
        if (this.bodySize == null) {
            if (warnings != null) {
                warnings.add(new HarWarning("Missing bodySize field in response element", jp.getCurrentLocation()));
            } else {
                throw new JsonParseException("Missing bodySize field in response element", jp.getCurrentLocation());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HarResponse(HarDatabaseConfig config, long entryId) throws SQLException {
        Connection c = config.getConnection();
        String tableName = config.getTablePrefix() + TABLE_NAME;
        Statement ps = null;
        ResultSet rs = null;
        try {
            ps = c.prepareStatement("SELECT id,status,status_text,http_version,redirect_url,header_size,body_size,comment FROM " + tableName + " WHERE entry_id=?");
            ps.setLong(1, entryId);
            rs = ps.executeQuery();
            if (!rs.next()) {
                throw new SQLException("No HarResponse for entry id " + entryId + " found in database");
            }
            long responseId = rs.getLong(1);
            this.setStatus((int)rs.getLong(2));
            this.setStatusText(rs.getString(3));
            this.setHttpVersion(rs.getString(4));
            this.setRedirectURL(rs.getString(5));
            this.setHeadersSize(rs.getLong(6));
            this.setBodySize(rs.getLong(7));
            this.setComment(rs.getString(8));
            this.cookies = new HarCookies(config, responseId, false);
            this.headers = new HarHeaders(config, responseId, false);
            this.content = new HarContent(config, responseId);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception ignore) {}
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (Exception ignore) {}
            config.closeConnection(c);
        }
    }

    public void writeHar(JsonGenerator g) throws JsonGenerationException, IOException {
        g.writeObjectFieldStart("response");
        g.writeNumberField("status", this.status);
        g.writeStringField("statusText", this.statusText);
        g.writeStringField("httpVersion", this.httpVersion);
        this.cookies.writeHar(g);
        this.headers.writeHar(g);
        this.content.writeHar(g);
        g.writeStringField("redirectURL", this.redirectURL);
        g.writeNumberField("headersSize", this.headersSize);
        g.writeNumberField("bodySize", this.bodySize);
        if (this.comment != null) {
            g.writeStringField("comment", this.comment);
        }
        g.writeEndObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeJDBC(long entryId, HarDatabaseConfig config, long logId) throws SQLException {
        long responseId;
        Connection c = config.getConnection();
        String tableName = config.getTablePrefix() + TABLE_NAME;
        if (!config.isCreatedTable(tableName)) {
            try {
                Statement s = c.createStatement();
                s.executeUpdate("CREATE TABLE " + tableName + " (id " + config.getDbAutoGeneratedId() + ",status " + config.getLongDbType() + ",status_text " + config.getStringDbType() + ",http_version " + config.getStringDbType() + ",redirect_url " + config.getStringDbType() + ",header_size " + config.getLongDbType() + ",body_size " + config.getLongDbType() + ",comment " + config.getStringDbType() + ",entry_id " + config.getLongDbType() + ")");
                s.close();
                config.addCreatedTable(tableName);
            }
            catch (Exception ignore) {
                // empty catch block
            }
        }
        Statement ps = null;
        ResultSet rs = null;
        try {
            ps = c.prepareStatement("INSERT INTO " + tableName + " (status,status_text,http_version,redirect_url,header_size,body_size,comment,entry_id) VALUES (?,?,?,?,?,?,?,?)", 1);
            ps.setLong(1, this.status.intValue());
            ps.setString(2, this.statusText);
            ps.setString(3, this.httpVersion);
            ps.setString(4, this.redirectURL);
            ps.setLong(5, this.headersSize);
            ps.setLong(6, this.bodySize);
            if (this.comment == null) {
                ps.setNull(7, -1);
            } else {
                ps.setString(7, this.comment);
            }
            ps.setLong(8, entryId);
            ps.executeUpdate();
            rs = ps.getGeneratedKeys();
            if (!rs.next()) {
                throw new SQLException("The database did not generate a key for an HarResponse entry");
            }
            responseId = rs.getLong(1);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception ignore) {}
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (Exception ignore) {}
            config.closeConnection(c);
        }
        this.cookies.writeJDBC(responseId, config, false, logId);
        this.headers.writeJDBC(responseId, config, false, logId);
        this.content.writeJDBC(responseId, config, logId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteFromJDBC(HarDatabaseConfig config, long logId, boolean dropTables) throws SQLException {
        this.cookies.deleteFromJDBC(config, logId, false);
        this.headers.deleteFromJDBC(config, logId, false);
        this.content.deleteFromJDBC(config, logId);
        if (dropTables) {
            Connection c = config.getConnection();
            String entriesTableName = config.getTablePrefix() + HarEntry.TABLE_NAME;
            String responseTableName = config.getTablePrefix() + TABLE_NAME;
            Statement ps = null;
            try {
                ps = c.prepareStatement("DELETE FROM " + responseTableName + " WHERE entry_id IN (SELECT entry_id FROM " + entriesTableName + " WHERE log_id=?)");
                ps.setLong(1, logId);
                ps.executeUpdate();
                config.dropTableIfEmpty(c, responseTableName, config);
            }
            finally {
                try {
                    if (ps != null) {
                        ps.close();
                    }
                }
                catch (Exception ignore) {}
                config.closeConnection(c);
            }
        }
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public String getStatusText() {
        return this.statusText;
    }

    public void setStatusText(String statusText) {
        this.statusText = statusText;
    }

    public String getHttpVersion() {
        return this.httpVersion;
    }

    public void setHttpVersion(String httpVersion) {
        this.httpVersion = httpVersion;
    }

    public HarCookies getCookies() {
        return this.cookies;
    }

    public void setCookies(HarCookies cookies) {
        this.cookies = cookies;
    }

    public HarHeaders getHeaders() {
        return this.headers;
    }

    public void setHeaders(HarHeaders headers) {
        this.headers = headers;
    }

    public HarContent getContent() {
        return this.content;
    }

    public void setContent(HarContent content) {
        this.content = content;
    }

    public String getRedirectURL() {
        return this.redirectURL;
    }

    public void setRedirectURL(String redirectURL) {
        this.redirectURL = redirectURL;
    }

    public long getHeadersSize() {
        return this.headersSize;
    }

    public void setHeadersSize(long headersSize) {
        this.headersSize = headersSize;
    }

    public long getBodySize() {
        return this.bodySize;
    }

    public void setBodySize(long bodySize) {
        this.bodySize = bodySize;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String toString() {
        return "\"response\": {  \"status\": \"" + this.status + "\", \"statusText\": \"" + this.statusText + "\",  \"httpVersion\": \"" + this.httpVersion + "\", " + this.cookies + ", " + this.headers + ", " + this.content + ", \"redirectURL\": \"" + this.redirectURL + "\", \"headersSize\": " + this.headersSize + ", \"bodySize\": " + this.bodySize + ", \"comment\": \"" + this.comment + "\"}\n";
    }
}

