/*
 * Decompiled with CFR 0.152.
 */
package com.zeroc.IceGrid;

import com.zeroc.Ice.Current;
import com.zeroc.Ice.InputStream;
import com.zeroc.Ice.Object;
import com.zeroc.Ice.OperationNotExistException;
import com.zeroc.Ice.OutputStream;
import com.zeroc.Ice.UserException;
import com.zeroc.IceGrid.AdapterDynamicInfo;
import com.zeroc.IceGrid.NodeDynamicInfo;
import com.zeroc.IceGrid.NodeDynamicInfoSeqHelper;
import com.zeroc.IceGrid.ServerDynamicInfo;
import com.zeroc.IceInternal.Incoming;
import java.util.Arrays;
import java.util.concurrent.CompletionStage;

public interface NodeObserver
extends Object {
    public static final String[] _iceIds;
    public static final String[] _iceOps;

    public void nodeInit(NodeDynamicInfo[] var1, Current var2);

    public void nodeUp(NodeDynamicInfo var1, Current var2);

    public void nodeDown(String var1, Current var2);

    public void updateServer(String var1, ServerDynamicInfo var2, Current var3);

    public void updateAdapter(String var1, AdapterDynamicInfo var2, Current var3);

    @Override
    default public String[] ice_ids(Current current) {
        return _iceIds;
    }

    @Override
    default public String ice_id(Current current) {
        return NodeObserver.ice_staticId();
    }

    public static String ice_staticId() {
        return "::IceGrid::NodeObserver";
    }

    public static CompletionStage<OutputStream> _iceD_nodeInit(NodeObserver obj, Incoming inS, Current current) {
        Object._iceCheckMode(null, current.mode);
        InputStream istr = inS.startReadParams();
        NodeDynamicInfo[] iceP_nodes = NodeDynamicInfoSeqHelper.read(istr);
        inS.endReadParams();
        obj.nodeInit(iceP_nodes, current);
        return inS.setResult(inS.writeEmptyParams());
    }

    public static CompletionStage<OutputStream> _iceD_nodeUp(NodeObserver obj, Incoming inS, Current current) {
        Object._iceCheckMode(null, current.mode);
        InputStream istr = inS.startReadParams();
        NodeDynamicInfo iceP_node = NodeDynamicInfo.ice_read(istr);
        inS.endReadParams();
        obj.nodeUp(iceP_node, current);
        return inS.setResult(inS.writeEmptyParams());
    }

    public static CompletionStage<OutputStream> _iceD_nodeDown(NodeObserver obj, Incoming inS, Current current) {
        Object._iceCheckMode(null, current.mode);
        InputStream istr = inS.startReadParams();
        String iceP_name = istr.readString();
        inS.endReadParams();
        obj.nodeDown(iceP_name, current);
        return inS.setResult(inS.writeEmptyParams());
    }

    public static CompletionStage<OutputStream> _iceD_updateServer(NodeObserver obj, Incoming inS, Current current) {
        Object._iceCheckMode(null, current.mode);
        InputStream istr = inS.startReadParams();
        String iceP_node = istr.readString();
        ServerDynamicInfo iceP_updatedInfo = ServerDynamicInfo.ice_read(istr);
        inS.endReadParams();
        obj.updateServer(iceP_node, iceP_updatedInfo, current);
        return inS.setResult(inS.writeEmptyParams());
    }

    public static CompletionStage<OutputStream> _iceD_updateAdapter(NodeObserver obj, Incoming inS, Current current) {
        Object._iceCheckMode(null, current.mode);
        InputStream istr = inS.startReadParams();
        String iceP_node = istr.readString();
        AdapterDynamicInfo iceP_updatedInfo = AdapterDynamicInfo.ice_read(istr);
        inS.endReadParams();
        obj.updateAdapter(iceP_node, iceP_updatedInfo, current);
        return inS.setResult(inS.writeEmptyParams());
    }

    @Override
    default public CompletionStage<OutputStream> _iceDispatch(Incoming in, Current current) throws UserException {
        int pos = Arrays.binarySearch(_iceOps, current.operation);
        if (pos < 0) {
            throw new OperationNotExistException(current.id, current.facet, current.operation);
        }
        switch (pos) {
            case 0: {
                return Object._iceD_ice_id(this, in, current);
            }
            case 1: {
                return Object._iceD_ice_ids(this, in, current);
            }
            case 2: {
                return Object._iceD_ice_isA(this, in, current);
            }
            case 3: {
                return Object._iceD_ice_ping(this, in, current);
            }
            case 4: {
                return NodeObserver._iceD_nodeDown(this, in, current);
            }
            case 5: {
                return NodeObserver._iceD_nodeInit(this, in, current);
            }
            case 6: {
                return NodeObserver._iceD_nodeUp(this, in, current);
            }
            case 7: {
                return NodeObserver._iceD_updateAdapter(this, in, current);
            }
            case 8: {
                return NodeObserver._iceD_updateServer(this, in, current);
            }
        }
        if (!1.$assertionsDisabled) {
            throw new AssertionError();
        }
        throw new OperationNotExistException(current.id, current.facet, current.operation);
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
        _iceIds = new String[]{"::Ice::Object", "::IceGrid::NodeObserver"};
        _iceOps = new String[]{"ice_id", "ice_ids", "ice_isA", "ice_ping", "nodeDown", "nodeInit", "nodeUp", "updateAdapter", "updateServer"};
    }
}

