/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.glsof.common.preferences;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import net.sourceforge.glsof.common.about.AbstractButtonsDialog;
import net.sourceforge.glsof.common.i18n.Messages;
import net.sourceforge.glsof.common.model.Filter;
import net.sourceforge.glsof.common.model.Location;
import net.sourceforge.glsof.common.model.OtherPreferences;
import net.sourceforge.glsof.common.model.Preferences;
import net.sourceforge.glsof.common.preferences.AbstractCommandDialog;
import net.sourceforge.glsof.common.preferences.ButtonEditor;
import net.sourceforge.glsof.common.preferences.ButtonRenderer;
import net.sourceforge.glsof.common.preferences.LsofParameterType;
import net.sourceforge.glsof.common.rmi.RmiUtils;
import net.sourceforge.glsof.common.utils.GBCBuilder;
import net.sourceforge.glsof.common.utils.MessageDialog;

public class PreferencesDialog
extends AbstractButtonsDialog {
    private static final int TYPE = 0;
    private static final int VALUE = 1;
    private static final int ACTION = 2;
    private static final int EDIT = 3;
    private static final int REMOVE = 4;
    private static final int OBJ_REF = 5;
    private Preferences _prefs;
    protected JTable _table;
    private JCheckBox _remote;
    private JComponent[] _address;
    private JComponent[] _port;
    private JButton _test;
    private ButtonGroup _idLogin;
    private ButtonGroup _sizeOffset;
    private JComponent[] _timeout;
    private JComponent[] _links;
    private JCheckBox _avoid;
    private JCheckBox _ipFormat;
    private JCheckBox _nfs;
    private JCheckBox _ports;
    private JCheckBox _sockets;
    private JCheckBox _and;

    public PreferencesDialog(Preferences prefs, String name) {
        super(new Dimension(640, 400), Messages.NLS("Preference") + " " + name);
        if (prefs.getLocation() == null) {
            prefs.setLocation(new Location());
        }
        this._prefs = prefs;
    }

    @Override
    protected void createDialogArea(JPanel parent) {
        JPanel main = (JPanel)parent.getParent();
        JPanel panel = new JPanel(new BorderLayout());
        main.add((Component)panel, "Center");
        JPanel left = new JPanel(new BorderLayout());
        left.add((Component)this.createGeneralOptions(), "North");
        panel.add((Component)left, "West");
        JPanel right = new JPanel(new BorderLayout());
        right.setBorder(new EmptyBorder(5, 5, 5, 5));
        right.add((Component)this.createFilterTable(), "North");
        right.add((Component)this.createFilterButtons(), "Center");
        panel.add((Component)right, "Center");
    }

    private JScrollPane createFilterTable() {
        Vector<Vector<Object>> model = this.populateTableModel();
        Vector<String> columnNames = new Vector<String>(Arrays.asList("Type", "Value", "Action", "", "", ""));
        this._table = new JTable(model, columnNames){

            @Override
            public Component prepareRenderer(TableCellRenderer renderer, int row, int col) {
                String value;
                Component comp = super.prepareRenderer(renderer, row, col);
                if (col == 1 && (value = (String)this.getValueAt(row, col)).length() > 0) {
                    ((JComponent)comp).setToolTipText(value);
                }
                return comp;
            }
        };
        this._table.getTableHeader().setReorderingAllowed(false);
        TableColumn editColumn = this._table.getColumnModel().getColumn(3);
        TableColumn removeColumn = this._table.getColumnModel().getColumn(4);
        editColumn.setCellRenderer(new ButtonRenderer());
        removeColumn.setCellRenderer(new ButtonRenderer());
        this._table.removeColumn(this._table.getColumnModel().getColumn(5));
        this._table.setAutoResizeMode(4);
        removeColumn.setCellEditor(new ButtonEditor(this._table, new JCheckBox()){

            @Override
            protected void fireEditingStopped() {
                super.fireEditingStopped();
                ((DefaultTableModel)this._table.getModel()).removeRow(this._table.getSelectedRow());
            }
        });
        editColumn.setCellEditor(new ButtonEditor(this._table, new JCheckBox()){

            @Override
            protected void fireEditingStopped() {
                super.fireEditingStopped();
                try {
                    Filter currentFilter = (Filter)this._table.getModel().getValueAt(this._table.getSelectedRow(), 5);
                    LsofParameterType parameterType = LsofParameterType.getParameterType(currentFilter.getType());
                    AbstractCommandDialog dialog = parameterType.createDialog();
                    dialog.create();
                    dialog.copyValuesInTheMask(currentFilter);
                    dialog.setVisible(true);
                    if (dialog.getButtonClickedId() == 1 && dialog.inputIsCorrect()) {
                        Object[] data = parameterType.toTableRow(dialog.getModelData());
                        DefaultTableModel model = (DefaultTableModel)this._table.getModel();
                        int row = this._table.getSelectedRow();
                        for (int i = 0; i < data.length; ++i) {
                            model.setValueAt(data[i], row, i);
                        }
                        PreferencesDialog.this.setSameValueForFDsAction(data);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        return new JScrollPane(this._table, 20, 30);
    }

    private Vector<Vector<Object>> populateTableModel() {
        Vector<Vector<Object>> model = new Vector<Vector<Object>>();
        List<Filter> filters = this._prefs.getFilters();
        for (int i = 0; i < filters.size(); ++i) {
            LsofParameterType parameterType = LsofParameterType.getParameterType(filters.get(i).getType());
            model.add(new Vector<Object>(Arrays.asList(parameterType.toTableRow(filters.get(i)))));
        }
        return model;
    }

    private JPanel createFilterButtons() {
        JPanel main = new JPanel();
        main.setLayout(new GridLayout(2, 4));
        GridBagConstraints gbc = new GBCBuilder().gridx(0).gridy(0).fill(2).build();
        for (final LsofParameterType parameterType : LsofParameterType.values()) {
            JButton button = parameterType.createButton();
            button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        AbstractCommandDialog dialog = parameterType.createDialog();
                        dialog.create();
                        dialog.setVisible(true);
                        if (dialog.getButtonClickedId() == 1 && dialog.inputIsCorrect()) {
                            Object[] data = parameterType.toTableRow(dialog.getModelData());
                            ((DefaultTableModel)PreferencesDialog.this._table.getModel()).addRow(data);
                            PreferencesDialog.this.setSameValueForFDsAction(data);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
            main.add((Component)button, gbc);
            ++gbc.gridy;
        }
        return main;
    }

    private void enableLocationComponents(boolean enabled) {
        this._address[1].setEnabled(enabled);
        this._port[1].setEnabled(enabled);
        this._test.setEnabled(enabled);
    }

    private void setSameValueForFDsAction(Object[] data) {
        Filter filter = (Filter)data[5];
        if (filter.getType().equals(LsofParameterType.FD.getId())) {
            this.changeFDsAction(filter.getValues().get(1));
        }
    }

    private void changeFDsAction(String action) {
        DefaultTableModel model = (DefaultTableModel)this._table.getModel();
        for (int i = 0; i < model.getRowCount(); ++i) {
            if (!model.getValueAt(i, 0).equals(LsofParameterType.FD.getLabel())) continue;
            model.setValueAt(LsofParameterType.FD.getInclusionLabel(action), i, 2);
            Filter filter = (Filter)model.getValueAt(i, 5);
            filter.getValues().set(1, action);
        }
    }

    private JPanel createLocationArea() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createTitledBorder(Messages.NLS("Location")));
        Location location = this._prefs.getLocation();
        this._remote = this.createCheckButton("Remote", location.isRemote(), panel, 0);
        this._address = new JComponent[]{new JLabel(Messages.NLS("Address")), new JTextField(location.getAddress(), 30)};
        this.packTwoElements(panel, this._address[0], this._address[1], 1, new Insets(0, 15, 0, 0), new Insets(5, 5, 5, 5));
        this._port = new JComponent[]{new JLabel(Messages.NLS("Port")), new JSpinner(new SpinnerNumberModel(location.getPort(), 1, 65535, 1))};
        this.packTwoElements(panel, this._port[0], this._port[1], 2, new Insets(0, 15, 0, 0), new Insets(5, 5, 5, 5));
        this._test = new JButton(Messages.NLS("Test"));
        this.enableLocationComponents(location.isRemote());
        this._remote.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                PreferencesDialog.this.enableLocationComponents(((JCheckBox)event.getSource()).isSelected());
            }
        });
        this._test.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Location location = new Location();
                location.setAddress(((JTextField)PreferencesDialog.this._address[1]).getText());
                location.setPort((Integer)((JSpinner)PreferencesDialog.this._port[1]).getValue());
                try {
                    RmiUtils.initRmiService(location);
                    MessageDialog.info(PreferencesDialog.this, location.getRmiAddress() + "\n\n" + Messages.NLS("Remote_connect_ok"));
                }
                catch (Exception ex) {
                    MessageDialog.warning(PreferencesDialog.this, location.getRmiAddress() + "\n\n" + Messages.NLS("Remote_connect_ko"));
                }
            }
        });
        panel.add((Component)this._test, new GBCBuilder().gridx(0).gridy(3).anchor(18).weighty(0.0).insets(new Insets(5, 20, 5, 5)).build());
        return panel;
    }

    private JPanel createGeneralOptions() {
        JPanel main = new JPanel(new BorderLayout());
        JPanel panel = new JPanel(new GridBagLayout());
        main.add((Component)panel, "North");
        panel.add((Component)this.createLocationArea(), new GBCBuilder().gridx(0).gridy(0).anchor(18).weighty(0.0).insets(new Insets(5, 5, 5, 5)).build());
        OtherPreferences page = this._prefs.getOtherPreferences();
        this._and = this.createCheckButton("AND_all_settings", page.isAnd(), panel, 1);
        this._avoid = this.createCheckButton("Avoid", page.isAvoid(), panel, 2);
        this._ipFormat = this.createCheckButton("Show_addresses_in_IP-format", page.isIpFormat(), panel, 3);
        this._nfs = this.createCheckButton("NFS_files", page.isNfs(), panel, 4);
        this._ports = this.createCheckButton("Show_port-numbers", page.isPortNumbers(), panel, 5);
        this._sockets = this.createCheckButton("UNIX_domain_socket_files", page.isDomainSocket(), panel, 6);
        this._idLogin = this.createRadioButtons(new String[]{"ID_Number", "Login_Name"}, page.isIdNumber());
        Enumeration<AbstractButton> buttons = this._idLogin.getElements();
        this.packTwoElements(panel, buttons.nextElement(), buttons.nextElement(), 7, new Insets(5, 5, 5, 5), new Insets(0, 0, 0, 0));
        this._sizeOffset = this.createRadioButtons(new String[]{"File_Size", "File_Offset"}, page.isSize());
        buttons = this._sizeOffset.getElements();
        this.packTwoElements(panel, buttons.nextElement(), buttons.nextElement(), 8, new Insets(5, 5, 5, 5), new Insets(0, 0, 0, 0));
        this._links = this.createCheckButtonAndSpinner("Max_number_of_links_for_a_file", page.getLinksFileValue(), 0, page.isLinksFile());
        this.packTwoElements(panel, this._links[0], this._links[1], 9, new Insets(5, 5, 5, 5), new Insets(0, 0, 0, 0));
        this._timeout = this.createCheckButtonAndSpinner("Timeout_s", page.getTimeoutValue(), 2, page.isTimeout());
        this.packTwoElements(panel, this._timeout[0], this._timeout[1], 10, new Insets(5, 5, 5, 5), new Insets(0, 0, 0, 0));
        return main;
    }

    private void packTwoElements(JPanel panel, Component c1, Component c2, int gridy, Insets insets, Insets inner) {
        JPanel sub = new JPanel(new GridBagLayout());
        sub.add(c1, new GBCBuilder().gridx(0).gridy(0).anchor(18).insets(inner).weighty(0.0).build());
        sub.add(c2, new GBCBuilder().gridx(1).gridy(0).anchor(18).insets(inner).weighty(0.0).build());
        panel.add((Component)sub, new GBCBuilder().gridx(0).gridy(gridy).anchor(18).weighty(0.0).insets(insets).gridwidth(2).build());
    }

    private JCheckBox createCheckButton(String text, boolean state, JPanel panel, int y) {
        JCheckBox button = this.createCheckButton(text, state);
        panel.add((Component)button, new GBCBuilder().gridx(0).gridy(y).anchor(18).insets(new Insets(5, 5, 5, 5)).build());
        return button;
    }

    private JCheckBox createCheckButton(String text, boolean state) {
        JCheckBox button = new JCheckBox(Messages.NLS(text), state);
        button.setToolTipText(Messages.NLS(text + "_tip"));
        return button;
    }

    private ButtonGroup createRadioButtons(String[] texts, boolean state) {
        ButtonGroup group = new ButtonGroup();
        JRadioButton button1 = new JRadioButton(Messages.NLS(texts[0]));
        JRadioButton button2 = new JRadioButton(Messages.NLS(texts[1]));
        button1.setToolTipText(Messages.NLS(texts[0] + "_tip"));
        button2.setToolTipText(Messages.NLS(texts[1] + "_tip"));
        group.add(button1);
        group.add(button2);
        group.setSelected(state ? button1.getModel() : button2.getModel(), true);
        return group;
    }

    private JComponent[] createCheckButtonAndSpinner(String text, int value, int min, boolean state) {
        final JComponent[] controls = new JComponent[]{this.createCheckButton(text, state), new JSpinner(new SpinnerNumberModel(value, min, 10000000, 1))};
        controls[1].setEnabled(state);
        ((JCheckBox)controls[0]).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                controls[1].setEnabled(((JCheckBox)event.getSource()).isSelected());
            }
        });
        return controls;
    }

    @Override
    protected void buttonPressed(int i) {
        if (i == 1) {
            List<Filter> filters = this._prefs.getFilters();
            filters.clear();
            DefaultTableModel model = (DefaultTableModel)this._table.getModel();
            for (int j = 0; j < model.getRowCount(); ++j) {
                filters.add((Filter)model.getValueAt(j, 5));
            }
            OtherPreferences page = this._prefs.getOtherPreferences();
            page.setIdNumber(this._idLogin.getElements().nextElement().isSelected());
            page.setSize(this._sizeOffset.getElements().nextElement().isSelected());
            page.setTimeout(((JCheckBox)this._timeout[0]).isSelected());
            page.setTimeoutValue((Integer)((JSpinner)this._timeout[1]).getValue());
            page.setLinksFile(((JCheckBox)this._links[0]).isSelected());
            page.setLinksFileValue((Integer)((JSpinner)this._links[1]).getValue());
            page.setAvoid(this._avoid.isSelected());
            page.setIpFormat(this._ipFormat.isSelected());
            page.setNfs(this._nfs.isSelected());
            page.setPortNumbers(this._ports.isSelected());
            page.setDomainSocket(this._sockets.isSelected());
            page.setAnd(this._and.isSelected());
            Location location = this._prefs.getLocation();
            location.setRemote(this._remote.isSelected());
            location.setAddress(((JTextField)this._address[1]).getText());
            location.setPort((Integer)((JSpinner)this._port[1]).getValue());
        }
        this.dispose();
    }
}

