/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.datafeed;

import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.license.License;
import org.elasticsearch.protocol.xpack.XPackInfoRequest;
import org.elasticsearch.protocol.xpack.XPackInfoResponse;
import org.elasticsearch.protocol.xpack.license.LicenseStatus;
import org.elasticsearch.transport.ActionNotFoundTransportException;
import org.elasticsearch.xpack.core.action.XPackInfoAction;

public class MlRemoteLicenseChecker {
    private final Client client;

    public MlRemoteLicenseChecker(Client client) {
        this.client = client;
    }

    public void checkRemoteClusterLicenses(List<String> clusterNames, final ActionListener<LicenseViolation> listener) {
        final Iterator<String> itr = clusterNames.iterator();
        if (!itr.hasNext()) {
            listener.onResponse((Object)new LicenseViolation(null));
            return;
        }
        final AtomicReference<String> clusterName = new AtomicReference<String>(itr.next());
        ActionListener<XPackInfoResponse> infoListener = new ActionListener<XPackInfoResponse>(){

            public void onResponse(XPackInfoResponse xPackInfoResponse) {
                if (!MlRemoteLicenseChecker.licenseSupportsML(xPackInfoResponse.getLicenseInfo())) {
                    listener.onResponse((Object)new LicenseViolation(new RemoteClusterLicenseInfo((String)clusterName.get(), xPackInfoResponse.getLicenseInfo())));
                    return;
                }
                if (itr.hasNext()) {
                    clusterName.set((String)itr.next());
                    MlRemoteLicenseChecker.this.remoteClusterLicense((String)clusterName.get(), (ActionListener<XPackInfoResponse>)this);
                } else {
                    listener.onResponse((Object)new LicenseViolation(null));
                }
            }

            public void onFailure(Exception e) {
                String message = "Could not determine the X-Pack licence type for cluster [" + (String)clusterName.get() + "]";
                if (e instanceof ActionNotFoundTransportException) {
                    message = message + ". Is X-Pack installed on the target cluster?";
                }
                listener.onFailure((Exception)new ElasticsearchException(message, (Throwable)e, new Object[0]));
            }
        };
        this.remoteClusterLicense(clusterName.get(), infoListener);
    }

    private void remoteClusterLicense(String clusterName, ActionListener<XPackInfoResponse> listener) {
        Client remoteClusterClient = this.client.getRemoteClusterClient(clusterName);
        ThreadContext threadContext = remoteClusterClient.threadPool().getThreadContext();
        try (ThreadContext.StoredContext ignore = threadContext.stashContext();){
            threadContext.markAsSystemContext();
            XPackInfoRequest request = new XPackInfoRequest();
            request.setCategories(EnumSet.of(XPackInfoRequest.Category.LICENSE));
            remoteClusterClient.execute((Action)XPackInfoAction.INSTANCE, (ActionRequest)request, listener);
        }
    }

    static boolean licenseSupportsML(XPackInfoResponse.LicenseInfo licenseInfo) {
        License.OperationMode mode = License.OperationMode.resolve((String)licenseInfo.getMode());
        return licenseInfo.getStatus() == LicenseStatus.ACTIVE && (mode == License.OperationMode.PLATINUM || mode == License.OperationMode.TRIAL);
    }

    public static boolean isRemoteIndex(String index) {
        return index.indexOf(58) != -1;
    }

    public static boolean containsRemoteIndex(List<String> indices) {
        return indices.stream().anyMatch(MlRemoteLicenseChecker::isRemoteIndex);
    }

    public static List<String> remoteIndices(List<String> indices) {
        return indices.stream().filter(MlRemoteLicenseChecker::isRemoteIndex).collect(Collectors.toList());
    }

    public static List<String> remoteClusterNames(List<String> indices) {
        return indices.stream().filter(MlRemoteLicenseChecker::isRemoteIndex).map(index -> index.substring(0, index.indexOf(58))).distinct().collect(Collectors.toList());
    }

    public static String buildErrorMessage(RemoteClusterLicenseInfo clusterLicenseInfo) {
        StringBuilder error = new StringBuilder();
        if (clusterLicenseInfo.licenseInfo.getStatus() != LicenseStatus.ACTIVE) {
            error.append("The license on cluster [").append(clusterLicenseInfo.clusterName).append("] is not active. ");
        } else {
            License.OperationMode mode = License.OperationMode.resolve((String)clusterLicenseInfo.licenseInfo.getMode());
            if (mode != License.OperationMode.PLATINUM && mode != License.OperationMode.TRIAL) {
                error.append("The license mode [").append(mode).append("] on cluster [").append(clusterLicenseInfo.clusterName).append("] does not enable Machine Learning. ");
            }
        }
        error.append(Strings.toString((ToXContent)clusterLicenseInfo.licenseInfo));
        return error.toString();
    }

    public class LicenseViolation {
        private final RemoteClusterLicenseInfo licenseInfo;

        private LicenseViolation(RemoteClusterLicenseInfo licenseInfo) {
            this.licenseInfo = licenseInfo;
        }

        public boolean isViolated() {
            return this.licenseInfo != null;
        }

        public RemoteClusterLicenseInfo get() {
            return this.licenseInfo;
        }
    }

    public static class RemoteClusterLicenseInfo {
        private final String clusterName;
        private final XPackInfoResponse.LicenseInfo licenseInfo;

        RemoteClusterLicenseInfo(String clusterName, XPackInfoResponse.LicenseInfo licenseInfo) {
            this.clusterName = clusterName;
            this.licenseInfo = licenseInfo;
        }

        public String getClusterName() {
            return this.clusterName;
        }

        public XPackInfoResponse.LicenseInfo getLicenseInfo() {
            return this.licenseInfo;
        }
    }
}

