/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.manage.schema;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.jcip.annotations.ThreadSafe;
import org.gradle.internal.Cast;
import org.gradle.internal.reflect.PropertyAccessorType;
import org.gradle.model.internal.manage.schema.ModelSchema;
import org.gradle.model.internal.method.WeaklyTypeReferencingMethod;
import org.gradle.model.internal.type.ModelType;

@ThreadSafe
public class ModelProperty<T> {
    private final String name;
    private final ModelType<T> type;
    private final Set<ModelType<?>> declaredBy;
    private final ImmutableMap<PropertyAccessorType, WeaklyTypeReferencingMethod<?, ?>> accessors;
    private ModelSchema<T> schema;

    public ModelProperty(ModelType<T> type, String name, Set<ModelType<?>> declaredBy, Map<PropertyAccessorType, WeaklyTypeReferencingMethod<?, ?>> accessors) {
        this.name = name;
        this.type = type;
        this.declaredBy = ImmutableSet.copyOf(declaredBy);
        this.accessors = Maps.immutableEnumMap(accessors);
    }

    public String getName() {
        return this.name;
    }

    public ModelType<T> getType() {
        return this.type;
    }

    public ModelSchema<T> getSchema() {
        return this.schema;
    }

    public void setSchema(ModelSchema<T> schema) {
        this.schema = schema;
    }

    public boolean isWritable() {
        return PropertyAccessorType.hasSetter((Collection)this.accessors.keySet());
    }

    public Set<ModelType<?>> getDeclaredBy() {
        return this.declaredBy;
    }

    @Nullable
    public WeaklyTypeReferencingMethod<?, ?> getAccessor(PropertyAccessorType accessorType) {
        return (WeaklyTypeReferencingMethod)this.accessors.get((Object)accessorType);
    }

    public Collection<WeaklyTypeReferencingMethod<?, ?>> getAccessors() {
        return this.accessors.values();
    }

    public boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
        return this.isAnnotationPresent(annotationType, this.getAccessor(PropertyAccessorType.GET_GETTER)) || this.isAnnotationPresent(annotationType, this.getAccessor(PropertyAccessorType.IS_GETTER));
    }

    private boolean isAnnotationPresent(Class<? extends Annotation> annotationType, WeaklyTypeReferencingMethod<?, ?> getter) {
        return getter != null && getter.getMethod().isAnnotationPresent(annotationType);
    }

    public <I> T getPropertyValue(I instance) {
        return (T)((WeaklyTypeReferencingMethod)Cast.uncheckedCast(this.getGetter())).invoke(instance, new Object[0]);
    }

    public WeaklyTypeReferencingMethod<?, ?> getGetter() {
        WeaklyTypeReferencingMethod<?, ?> getter = this.getAccessor(PropertyAccessorType.GET_GETTER);
        if (getter == null) {
            getter = this.getAccessor(PropertyAccessorType.IS_GETTER);
        }
        if (getter == null) {
            throw new IllegalStateException("No getter for property" + this);
        }
        return getter;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ModelProperty that = (ModelProperty)o;
        return Objects.equal((Object)this.name, (Object)that.name) && Objects.equal(this.type, that.type) && this.isWritable() == that.isWritable();
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.type.hashCode();
        result = 31 * result + Boolean.valueOf(this.isWritable()).hashCode();
        return result;
    }

    public String toString() {
        return this.getName() + "(" + this.getType().getDisplayName() + ")";
    }
}

