/*
 * Decompiled with CFR 0.152.
 */
package com.sparshui.server;

import com.sparshui.common.Location;
import com.sparshui.server.ClientConnection;
import com.sparshui.server.InputDeviceConnection;
import com.sparshui.server.TouchPoint;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Map;
import javajs.util.Lst;
import org.jmol.api.JmolGestureServerInterface;
import org.jmol.util.Logger;

public class GestureServer
implements Runnable,
JmolGestureServerInterface {
    GestureServer clientServer;
    GestureServer deviceServer;
    GestureServer main;
    Thread clientThread;
    Thread deviceThread;
    ServerSocket _clientSocket;
    ServerSocket _deviceSocket;
    ServerSocket _mySocket;
    private Lst<ClientConnection> _clients = new Lst();
    private int port;
    InputDeviceConnection ic = null;
    private int myState;

    public GestureServer() {
        Logger.info(this + " constructed");
    }

    public void finalize() {
        if (Logger.debugging) {
            Logger.debug(this + " finalized");
        }
    }

    public GestureServer(int port, GestureServer main) {
        this.port = port;
        this.main = main;
    }

    @Override
    public void startGestureServer() {
        this.clientServer = new GestureServer(5946, this);
        this.clientThread = new Thread(this.clientServer);
        this.clientThread.setName("Jmol SparshUI Client GestureServer on port 5946");
        this.clientThread.start();
        this.deviceServer = new GestureServer(5947, this);
        this.deviceThread = new Thread(this.deviceServer);
        this.deviceThread.setName("Jmol SparshUI Device GestureServer on port 5947");
        this.deviceThread.start();
    }

    @Override
    public void dispose() {
        try {
            this._clientSocket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this._deviceSocket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.clientThread.interrupt();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.deviceThread.interrupt();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this._clientSocket = null;
        this.clientThread = null;
        this._deviceSocket = null;
        this.deviceThread = null;
        this.clientServer = null;
        this.deviceServer = null;
    }

    @Override
    public void run() {
        try {
            this.openSocket();
            this.acceptConnections();
        }
        catch (Exception e) {
            Logger.info("[GestureServer] connection unavailable");
        }
    }

    private void openSocket() {
        try {
            this._mySocket = this.port == 5946 ? (this.main._clientSocket = new ServerSocket(this.port)) : (this.main._deviceSocket = new ServerSocket(this.port));
            Logger.info("[GestureServer] Socket Open: " + this.port);
            this.main.myState = 1;
        }
        catch (IOException e) {
            Logger.error("[GestureServer] Failed to open a server socket.");
            e.printStackTrace();
            this.main.myState = 0;
        }
    }

    private void acceptConnections() {
        while (!this._mySocket.isClosed()) {
            try {
                if (this.port == 5947) {
                    Logger.info("[GestureServer] Accepting device connections");
                    this.acceptConnection(this._mySocket.accept());
                    return;
                }
                Logger.info("[GestureServer] Accepting client connections");
                this.acceptConnection(this._mySocket.accept());
            }
            catch (IOException e) {
                Logger.error("[GestureServer] Failed to establish connection on port " + this.port);
                e.printStackTrace();
            }
        }
        Logger.info("[GestureServer] Socket Closed on port " + this.port);
    }

    private void acceptConnection(Socket socket) throws IOException {
        byte[] add = socket.getInetAddress().getAddress();
        if (add[0] != 127 || add[1] != 0 || add[2] != 0 || add[3] != 1) {
            return;
        }
        int type = socket.getInputStream().read();
        if (type == 0) {
            Logger.info("[GestureServer] client connection established on port " + this.port);
            this.acceptClientConnection(socket);
        } else if (type == 1) {
            Logger.info("[GestureServer] device connection established on port " + this.port);
            this.acceptInputDeviceConnection(socket);
        }
    }

    private void acceptClientConnection(Socket socket) throws IOException {
        Logger.info("[GestureServer] Client connection accepted");
        ClientConnection cc = new ClientConnection(socket);
        this.main._clients.addLast(cc);
        if (this.main.ic == null) {
            cc.processError(-2);
        } else {
            this.main.myState |= 2;
        }
    }

    private void acceptInputDeviceConnection(Socket socket) throws IOException {
        Logger.info("[GestureServer] Input device connection accepted");
        this.main.ic = new InputDeviceConnection(this, socket);
        this.main.myState |= 4;
    }

    void notifyInputLost() {
        Logger.error("[GestureServer] sending clients message that input device was lost.");
        this.main.ic = null;
        this.main.myState &= 0xFFFFFFFB;
        this.processBirth(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean processTouchPoint(Map<Integer, TouchPoint> inputDeviceTouchPoints, int id, Location location, long time, int state) {
        Integer iid;
        if (Logger.debugging) {
            Logger.debug("[GestureServer] processTouchPoint id=" + id + " state=" + state + " " + location + " " + time);
        }
        if (inputDeviceTouchPoints.containsKey(iid = Integer.valueOf(id))) {
            TouchPoint touchPoint = inputDeviceTouchPoints.get(iid);
            if (!touchPoint.isClaimed()) {
                return false;
            }
            if (Logger.debugging) {
                Logger.debug("[GestureServer] OK");
            }
            TouchPoint touchPoint2 = touchPoint;
            synchronized (touchPoint2) {
                touchPoint.update(location, time, state);
            }
            return true;
        }
        TouchPoint touchPoint = new TouchPoint(id, location, time);
        inputDeviceTouchPoints.put(iid, touchPoint);
        return this.processBirth(touchPoint);
    }

    private boolean processBirth(TouchPoint touchPoint) {
        int i;
        Lst<ClientConnection> clients_to_remove = null;
        boolean isClaimed = false;
        for (i = 0; i < this.main._clients.size(); ++i) {
            ClientConnection client = (ClientConnection)this.main._clients.get(i);
            try {
                if (touchPoint == null) {
                    client.processError(-2);
                } else {
                    isClaimed = client.processBirth(touchPoint);
                }
                if (!isClaimed) continue;
                break;
            }
            catch (IOException e) {
                if (clients_to_remove == null) {
                    clients_to_remove = new Lst<ClientConnection>();
                }
                clients_to_remove.addLast(client);
            }
        }
        if (clients_to_remove != null) {
            for (i = 0; i < clients_to_remove.size(); ++i) {
                this.main._clients.removeObj(clients_to_remove.get(i));
                Logger.info("[GestureServer] Client Disconnected");
            }
        }
        return isClaimed;
    }

    @Override
    public int getState() {
        return this.myState;
    }
}

