/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyKey;
import com.intellij.util.pico.DefaultPicoContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.picocontainer.PicoContainer;

public class ServiceManager {
    private static final Logger LOG = Logger.getInstance(ServiceManager.class);

    private ServiceManager() {
    }

    public static <T> T getService(@NotNull Class<T> serviceClass) {
        if (serviceClass == null) {
            ServiceManager.$$$reportNull$$$0(0);
        }
        Application application = ApplicationManager.getApplication();
        return ServiceManager.doGetService(application, serviceClass, true);
    }

    public static <T> T getService(@NotNull Project project, @NotNull Class<T> serviceClass) {
        if (project == null) {
            ServiceManager.$$$reportNull$$$0(1);
        }
        if (serviceClass == null) {
            ServiceManager.$$$reportNull$$$0(2);
        }
        return ServiceManager.doGetService(project, serviceClass, true);
    }

    @Nullable
    private static <T> T doGetService(ComponentManager componentManager, @NotNull Class<T> serviceClass, boolean isCreate) {
        if (serviceClass == null) {
            ServiceManager.$$$reportNull$$$0(5);
        }
        String componentKey = serviceClass.getName();
        PicoContainer picoContainer = componentManager.getPicoContainer();
        if (!isCreate && picoContainer instanceof DefaultPicoContainer) {
            return ((DefaultPicoContainer)picoContainer).getComponentInstanceIfInstantiated(componentKey);
        }
        Object instance = picoContainer.getComponentInstance(componentKey);
        if (instance == null) {
            ProgressManager.checkCanceled();
            instance = componentManager.getComponent(serviceClass);
            if (instance != null) {
                Application app = ApplicationManager.getApplication();
                String message = componentKey + " requested as a service, but it is a component - convert it to a service or change call to " + (componentManager == app ? "ApplicationManager.getApplication().getComponent()" : "project.getComponent()");
                if (app.isUnitTestMode()) {
                    LOG.error(message);
                } else {
                    LOG.warn(message);
                }
            }
        }
        return (T)instance;
    }

    @NotNull
    public static <T> NotNullLazyKey<T, Project> createLazyKey(@NotNull Class<T> serviceClass) {
        if (serviceClass == null) {
            ServiceManager.$$$reportNull$$$0(6);
        }
        NotNullLazyKey<Object, Project> notNullLazyKey = NotNullLazyKey.create("Service: " + serviceClass.getName(), project -> {
            if (serviceClass == null) {
                ServiceManager.$$$reportNull$$$0(8);
            }
            return ServiceManager.getService(project, serviceClass);
        });
        if (notNullLazyKey == null) {
            ServiceManager.$$$reportNull$$$0(7);
        }
        return notNullLazyKey;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serviceClass";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/components/ServiceManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/components/ServiceManager";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createLazyKey";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getService";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getServiceIfCreated";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "doGetService";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createLazyKey";
                break;
            }
            case 7: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createLazyKey$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

