/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.model;

import com.eteks.sweethome3d.model.BackgroundImage;
import com.eteks.sweethome3d.model.HomeObject;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;

public class Level
extends HomeObject {
    private static final long serialVersionUID = 1L;
    private String name;
    private float elevation;
    private float floorThickness;
    private float height;
    private BackgroundImage backgroundImage;
    private boolean visible;
    private boolean viewable;
    private int elevationIndex;
    private transient PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    public Level(String string, float f, float f2, float f3) {
        this.name = string;
        this.elevation = f;
        this.floorThickness = f2;
        this.height = f3;
        this.visible = true;
        this.viewable = true;
        this.elevationIndex = -1;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.propertyChangeSupport = new PropertyChangeSupport(this);
        this.visible = true;
        this.viewable = true;
        this.elevationIndex = -1;
        objectInputStream.defaultReadObject();
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        if (!(string == this.name || string != null && string.equals(this.name))) {
            String string2 = this.name;
            this.name = string;
            this.propertyChangeSupport.firePropertyChange(Property.NAME.name(), string2, string);
        }
    }

    public float getElevation() {
        return this.elevation;
    }

    public void setElevation(float f) {
        if (f != this.elevation) {
            float f2 = this.elevation;
            this.elevation = f;
            this.propertyChangeSupport.firePropertyChange(Property.ELEVATION.name(), Float.valueOf(f2), Float.valueOf(f));
        }
    }

    public float getFloorThickness() {
        return this.floorThickness;
    }

    public void setFloorThickness(float f) {
        if (f != this.floorThickness) {
            float f2 = this.floorThickness;
            this.floorThickness = f;
            this.propertyChangeSupport.firePropertyChange(Property.FLOOR_THICKNESS.name(), Float.valueOf(f2), Float.valueOf(f));
        }
    }

    public float getHeight() {
        return this.height;
    }

    public void setHeight(float f) {
        if (f != this.height) {
            float f2 = this.height;
            this.height = f;
            this.propertyChangeSupport.firePropertyChange(Property.HEIGHT.name(), Float.valueOf(f2), Float.valueOf(f));
        }
    }

    public BackgroundImage getBackgroundImage() {
        return this.backgroundImage;
    }

    public void setBackgroundImage(BackgroundImage backgroundImage) {
        if (backgroundImage != this.backgroundImage) {
            BackgroundImage backgroundImage2 = this.backgroundImage;
            this.backgroundImage = backgroundImage;
            this.propertyChangeSupport.firePropertyChange(Property.BACKGROUND_IMAGE.name(), backgroundImage2, backgroundImage);
        }
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean bl) {
        if (bl != this.visible) {
            this.visible = bl;
            this.propertyChangeSupport.firePropertyChange(Property.VISIBLE.name(), !bl, bl);
        }
    }

    public boolean isViewable() {
        return this.viewable;
    }

    public void setViewable(boolean bl) {
        if (bl != this.viewable) {
            this.viewable = bl;
            this.propertyChangeSupport.firePropertyChange(Property.VIEWABLE.name(), !bl, bl);
        }
    }

    public boolean isViewableAndVisible() {
        return this.viewable && this.visible;
    }

    public int getElevationIndex() {
        return this.elevationIndex;
    }

    public void setElevationIndex(int n) {
        if (n != this.elevationIndex) {
            int n2 = this.elevationIndex;
            this.elevationIndex = n;
            this.propertyChangeSupport.firePropertyChange(Property.ELEVATION_INDEX.name(), n2, n);
        }
    }

    public Level clone() {
        Level level = (Level)super.clone();
        level.propertyChangeSupport = new PropertyChangeSupport(level);
        return level;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Property {
        NAME,
        ELEVATION,
        HEIGHT,
        FLOOR_THICKNESS,
        BACKGROUND_IMAGE,
        VISIBLE,
        VIEWABLE,
        ELEVATION_INDEX;

    }
}

