/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.history;

import java.util.List;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.extension.history.ExtensionHistory;
import org.parosproxy.paros.model.HistoryReference;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.model.SiteMap;
import org.parosproxy.paros.model.SiteNode;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.view.messagecontainer.http.HttpMessageContainer;
import org.zaproxy.zap.view.popup.PopupMenuItemHttpMessageContainer;
import org.zaproxy.zap.view.popup.PopupMenuItemSiteNodeContainer;

public class PopupMenuPurgeSites
extends PopupMenuItemSiteNodeContainer {
    private static final long serialVersionUID = 4827464631678110752L;

    public PopupMenuPurgeSites() {
        super(Constant.messages.getString("sites.purge.popup"), true);
    }

    @Override
    public boolean isEnableForInvoker(PopupMenuItemHttpMessageContainer.Invoker invoker, HttpMessageContainer httpMessageContainer) {
        return invoker == PopupMenuItemHttpMessageContainer.Invoker.SITES_PANEL;
    }

    @Override
    public boolean isButtonEnabledForSiteNode(SiteNode sn) {
        return !sn.isRoot() || sn.getChildCount() != 0;
    }

    @Override
    public void performHistoryReferenceActions(List<HistoryReference> hrefs) {
        int result;
        if (hrefs.size() > 0 && (result = View.getSingleton().showConfirmDialog(Constant.messages.getString("sites.purge.warning"))) != 0) {
            return;
        }
        super.performHistoryReferenceActions(hrefs);
    }

    @Override
    public void performAction(SiteNode sn) {
        ExtensionHistory extHistory = Control.getSingleton().getExtensionLoader().getExtension(ExtensionHistory.class);
        if (extHistory != null) {
            extHistory.purge(Model.getSingleton().getSession().getSiteTree(), sn);
        }
    }

    @Deprecated
    public static void purge(SiteMap map, SiteNode node) {
        ExtensionHistory extHistory = Control.getSingleton().getExtensionLoader().getExtension(ExtensionHistory.class);
        if (extHistory != null) {
            extHistory.purge(map, node);
        }
    }

    @Override
    public boolean isSafe() {
        return true;
    }
}

