/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import java.util.Arrays;
import java.util.Collection;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.control.ControlBuilder;
import javafx.scene.control.SplitPane;
import javafx.util.Builder;

public class SplitPaneBuilder<B extends SplitPaneBuilder<B>>
extends ControlBuilder<B>
implements Builder<SplitPane> {
    private int __set;
    private double[] dividerPositions;
    private Collection<? extends Node> items;
    private Orientation orientation;

    protected SplitPaneBuilder() {
    }

    public static SplitPaneBuilder<?> create() {
        return new SplitPaneBuilder();
    }

    public void applyTo(SplitPane splitPane) {
        super.applyTo(splitPane);
        int n = this.__set;
        if ((n & 1) != 0) {
            splitPane.setDividerPositions(this.dividerPositions);
        }
        if ((n & 2) != 0) {
            splitPane.getItems().addAll(this.items);
        }
        if ((n & 4) != 0) {
            splitPane.setOrientation(this.orientation);
        }
    }

    public B dividerPositions(double[] dArray) {
        this.dividerPositions = dArray;
        this.__set |= 1;
        return (B)this;
    }

    public B items(Collection<? extends Node> collection) {
        this.items = collection;
        this.__set |= 2;
        return (B)this;
    }

    public B items(Node ... nodeArray) {
        return this.items(Arrays.asList(nodeArray));
    }

    public B orientation(Orientation orientation) {
        this.orientation = orientation;
        this.__set |= 4;
        return (B)this;
    }

    @Override
    public SplitPane build() {
        SplitPane splitPane = new SplitPane();
        this.applyTo(splitPane);
        return splitPane;
    }
}

