/*
 * Decompiled with CFR 0.152.
 */
package com.zeroc.IceGridGUI.LiveDeployment;

import com.zeroc.Ice.Identity;
import com.zeroc.Ice.LocalException;
import com.zeroc.Ice.ObjectPrx;
import com.zeroc.IceGrid.AdapterDynamicInfo;
import com.zeroc.IceGrid.AdapterInfo;
import com.zeroc.IceGrid.AdminPrx;
import com.zeroc.IceGrid.AdminSessionPrx;
import com.zeroc.IceGrid.ApplicationDescriptor;
import com.zeroc.IceGrid.ApplicationInfo;
import com.zeroc.IceGrid.ApplicationUpdateInfo;
import com.zeroc.IceGrid.DeploymentException;
import com.zeroc.IceGrid.FileIteratorPrx;
import com.zeroc.IceGrid.FileNotAvailableException;
import com.zeroc.IceGrid.NodeDescriptor;
import com.zeroc.IceGrid.NodeDynamicInfo;
import com.zeroc.IceGrid.NodeUpdateDescriptor;
import com.zeroc.IceGrid.ObjectExistsException;
import com.zeroc.IceGrid.ObjectInfo;
import com.zeroc.IceGrid.PropertySetDescriptor;
import com.zeroc.IceGrid.RegistryInfo;
import com.zeroc.IceGrid.RegistryNotExistException;
import com.zeroc.IceGrid.RegistryUnreachableException;
import com.zeroc.IceGrid.ReplicaGroupDescriptor;
import com.zeroc.IceGrid.ServerDynamicInfo;
import com.zeroc.IceGridGUI.Coordinator;
import com.zeroc.IceGridGUI.LiveActions;
import com.zeroc.IceGridGUI.LiveDeployment.ApplicationDetailsDialog;
import com.zeroc.IceGridGUI.LiveDeployment.Communicator;
import com.zeroc.IceGridGUI.LiveDeployment.Editor;
import com.zeroc.IceGridGUI.LiveDeployment.Node;
import com.zeroc.IceGridGUI.LiveDeployment.ObjectDialog;
import com.zeroc.IceGridGUI.LiveDeployment.RegistryEditor;
import com.zeroc.IceGridGUI.LiveDeployment.Server;
import com.zeroc.IceGridGUI.LiveDeployment.ShowIceLogDialog;
import com.zeroc.IceGridGUI.LiveDeployment.ShowLogFileDialog;
import com.zeroc.IceGridGUI.LiveDeployment.Slave;
import com.zeroc.IceGridGUI.LiveDeployment.TreeNode;
import com.zeroc.IceGridGUI.TreeNodeBase;
import com.zeroc.IceGridGUI.Utils;
import java.awt.Component;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.prefs.Preferences;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;

public class Root
extends Communicator {
    private final Coordinator _coordinator;
    private String _instanceName = "";
    private String _replicaName;
    private final List<Node> _nodes = new LinkedList<Node>();
    private final List<Slave> _slaves = new LinkedList<Slave>();
    private final Map<String, ApplicationInfo> _infoMap = new TreeMap<String, ApplicationInfo>();
    private SortedMap<String, AdapterInfo> _adapters = new TreeMap<String, AdapterInfo>();
    private SortedMap<String, ObjectInfo> _objects = new TreeMap<String, ObjectInfo>();
    private final JTree _tree;
    private final FilteredTreeModel _treeModel;
    private RegistryInfo _info;
    private String _label;
    private ObjectDialog _addObjectDialog;
    private ObjectDialog _showObjectDialog;
    private final int _messageSizeMax;
    private final Map<String, ShowIceLogDialog> _showIceLogDialogMap = new HashMap<String, ShowIceLogDialog>();
    private final Map<String, ShowLogFileDialog> _showLogFileDialogMap = new HashMap<String, ShowLogFileDialog>();
    int _logMaxLines;
    int _logMaxSize;
    int _logInitialLines;
    int _logMaxReadSize;
    int _logPeriod;
    private ApplicationDetailsDialog _applicationDetailsDialog;
    private static RegistryEditor _editor;
    private static JPopupMenu _popup;
    private static DefaultTreeCellRenderer _cellRenderer;
    private String _applicationNameFilter = null;

    private boolean matchFilter(TreeNode n) {
        if (this._applicationNameFilter == null) {
            return true;
        }
        if (n instanceof Server) {
            Server server = (Server)n;
            if (!this._applicationNameFilter.equals(server.getApplication().name)) {
                return false;
            }
        } else if (n instanceof Node) {
            return ((Node)n).hasServersFromApplication(this._applicationNameFilter);
        }
        return true;
    }

    private boolean filterEnabled() {
        return this._applicationNameFilter != null;
    }

    public void setApplicationNameFilter(String name) {
        this._applicationNameFilter = name;
        this._label = this._instanceName + " (" + this._replicaName + ")";
        if (this._applicationNameFilter != null) {
            this._label = this._label + " - " + this._applicationNameFilter;
        }
        this._treeModel.resetFilters();
    }

    public String getApplicationNameFilter() {
        return this._applicationNameFilter;
    }

    public Root(Coordinator coordinator) {
        super(null, "Root", 3);
        this._coordinator = coordinator;
        this._childrenArray[0] = this._metrics;
        this._childrenArray[1] = this._slaves;
        this._childrenArray[2] = this._nodes;
        this._messageSizeMax = Root.computeMessageSizeMax(this._coordinator.getProperties().getPropertyAsInt("Ice.MessageSizeMax"));
        this._treeModel = new FilteredTreeModel(this);
        this._tree = new JTree();
        this._tree.setModel(this._treeModel);
        this._addObjectDialog = new ObjectDialog(this, false);
        this._showObjectDialog = new ObjectDialog(this, true);
        this._tree.addTreeWillExpandListener(new TreeWillExpandListener(){

            @Override
            public void treeWillExpand(TreeExpansionEvent event) {
                TreeNode node = (TreeNode)event.getPath().getLastPathComponent();
                if (node instanceof Communicator) {
                    ((Communicator)node).fetchMetricsViewNames();
                }
            }

            @Override
            public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
                if (event.getPath().getLastPathComponent() == Root.this) {
                    throw new ExpandVetoException(event);
                }
            }
        });
        this.loadLogPrefs();
    }

    @Override
    public boolean[] getAvailableActions() {
        boolean[] actions = new boolean[25];
        actions[19] = this._coordinator.connectedToMaster();
        actions[17] = true;
        actions[12] = true;
        actions[13] = true;
        actions[14] = true;
        return actions;
    }

    @Override
    public void shutdownRegistry() {
        String prefix = "Shutting down registry '" + this._replicaName + "'...";
        String errorTitle = "Failed to shutdown " + this._replicaName;
        this._coordinator.getStatusBar().setText(prefix);
        try {
            AdminPrx admin = this._coordinator.getAdmin();
            admin.shutdownRegistryAsync(this._replicaName).whenComplete((result, ex) -> this.amiComplete(prefix, errorTitle, (Throwable)ex));
        }
        catch (LocalException ex2) {
            this.failure(prefix, errorTitle, ex2.toString());
        }
    }

    public ApplicationDescriptor getApplicationDescriptor(String name) {
        ApplicationInfo app = this._infoMap.get(name);
        if (app == null) {
            return null;
        }
        return app.descriptor;
    }

    public Object[] getApplicationNames() {
        return this._infoMap.keySet().toArray();
    }

    public Object[] getPatchableApplicationNames() {
        ArrayList<String> result = new ArrayList<String>();
        for (Map.Entry<String, ApplicationInfo> p : this._infoMap.entrySet()) {
            ApplicationInfo app = p.getValue();
            if (app.descriptor.distrib.icepatch.length() <= 0) continue;
            result.add(p.getKey());
        }
        return result.toArray();
    }

    public SortedMap<String, String> getApplicationMap() {
        TreeMap<String, String> r = new TreeMap<String, String>();
        for (Map.Entry<String, ApplicationInfo> p : this._infoMap.entrySet()) {
            ApplicationInfo app = p.getValue();
            r.put(p.getKey(), DateFormat.getDateTimeInstance().format(new Date(app.updateTime)));
        }
        return r;
    }

    @Override
    public Editor getEditor() {
        if (_editor == null) {
            _editor = new RegistryEditor();
        }
        _editor.show(this);
        return _editor;
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        if (_cellRenderer == null) {
            _cellRenderer = new DefaultTreeCellRenderer();
            ImageIcon icon = Utils.getIcon("/icons/16x16/registry.png");
            _cellRenderer.setOpenIcon(icon);
            _cellRenderer.setClosedIcon(icon);
        }
        return _cellRenderer.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
    }

    public void applicationInit(String instanceName, String replicaName, List<ApplicationInfo> applications) {
        this._instanceName = instanceName;
        this._replicaName = replicaName;
        this._label = instanceName + " (" + this._replicaName + ")";
        this._tree.setRootVisible(true);
        for (ApplicationInfo p : applications) {
            this.applicationAdded(p);
        }
        this._treeModel.resetFilters();
    }

    public void clear() {
        this._adapters.clear();
        this._objects.clear();
        this._replicaName = null;
        this._applicationNameFilter = null;
        this._infoMap.clear();
        this._nodes.clear();
        this._slaves.clear();
        this._metrics.clear();
        this._metricsRetrieved = false;
        this._treeModel.nodeStructureChanged(this);
        this._tree.setRootVisible(false);
        _editor = null;
    }

    public void patch(String applicationName) {
        int shutdown = JOptionPane.showConfirmDialog(this._coordinator.getMainFrame(), "You are about to install or refresh your application distribution.\n Do you want shut down all servers affected by this update?", "Patch Confirmation", 1);
        if (shutdown == 2) {
            return;
        }
        String prefix = "Patching application '" + applicationName + "'...";
        String errorTitle = "Failed to patch '" + applicationName;
        this._coordinator.getStatusBar().setText(prefix);
        try {
            AdminPrx admin = this._coordinator.getAdmin();
            admin.patchApplicationAsync(applicationName, shutdown == 0).whenComplete((result, ex) -> this.amiComplete(prefix, errorTitle, (Throwable)ex));
        }
        catch (LocalException ex2) {
            this.failure(prefix, errorTitle, ex2.toString());
        }
    }

    public void showApplicationDetails(String appName) {
        ApplicationInfo app = this._infoMap.get(appName);
        if (app != null) {
            if (this._applicationDetailsDialog == null) {
                this._applicationDetailsDialog = new ApplicationDetailsDialog(this);
            }
            this._applicationDetailsDialog.showDialog(app);
        }
    }

    public void applicationAdded(ApplicationInfo info) {
        this._infoMap.put(info.descriptor.name, info);
        for (Map.Entry<String, NodeDescriptor> p : info.descriptor.nodes.entrySet()) {
            String nodeName = p.getKey();
            NodeDescriptor nodeDesc = p.getValue();
            Node node = this.findNode(nodeName);
            if (node == null) {
                this.insertNode(new Node(this, info.descriptor, nodeName, nodeDesc));
                continue;
            }
            node.add(info.descriptor, nodeDesc);
        }
    }

    public void applicationRemoved(String name) {
        this._infoMap.remove(name);
        LinkedList<Node> toRemove = new LinkedList<Node>();
        int[] toRemoveIndices = new int[this._nodes.size()];
        int i = 0;
        for (Node node : this._nodes) {
            if (!node.remove(name)) continue;
            toRemove.add(node);
            toRemoveIndices[i++] = this.getIndex(node);
        }
        if (toRemove.size() > 0) {
            this._nodes.removeAll(toRemove);
            this._treeModel.nodesWereRemoved(this, toRemoveIndices, toRemove.toArray());
        }
    }

    public void applicationUpdated(ApplicationUpdateInfo update) {
        ApplicationInfo app = this._infoMap.get(update.descriptor.name);
        app.updateTime = update.updateTime;
        app.updateUser = update.updateUser;
        app.revision = update.revision;
        ApplicationDescriptor appDesc = app.descriptor;
        if (update.descriptor.description != null) {
            appDesc.description = update.descriptor.description.value;
        }
        if (update.descriptor.distrib != null) {
            appDesc.distrib = update.descriptor.distrib.value;
        }
        appDesc.variables.keySet().removeAll(Arrays.asList(update.descriptor.removeVariables));
        appDesc.variables.putAll(update.descriptor.variables);
        boolean variablesChanged = update.descriptor.removeVariables.length > 0 || !update.descriptor.variables.isEmpty();
        appDesc.propertySets.keySet().removeAll(Arrays.asList(update.descriptor.removePropertySets));
        appDesc.propertySets.putAll(update.descriptor.propertySets);
        block0: for (String id : update.descriptor.removeReplicaGroups) {
            for (int i = 0; i < appDesc.replicaGroups.size(); ++i) {
                ReplicaGroupDescriptor rgd = appDesc.replicaGroups.get(i);
                if (!rgd.id.equals(id)) continue;
                appDesc.replicaGroups.remove(i);
                continue block0;
            }
        }
        for (ReplicaGroupDescriptor newRgd : update.descriptor.replicaGroups) {
            int replaced = 0;
            for (int i = 0; i < appDesc.replicaGroups.size() && replaced == 0; ++i) {
                ReplicaGroupDescriptor oldRgd = appDesc.replicaGroups.get(i);
                if (!newRgd.id.equals(oldRgd.id)) continue;
                appDesc.replicaGroups.set(i, newRgd);
                replaced = 1;
            }
            if (replaced != 0) continue;
            appDesc.replicaGroups.add(newRgd);
        }
        appDesc.serviceTemplates.keySet().removeAll(Arrays.asList(update.descriptor.removeServiceTemplates));
        appDesc.serviceTemplates.putAll(update.descriptor.serviceTemplates);
        appDesc.serverTemplates.keySet().removeAll(Arrays.asList(update.descriptor.removeServerTemplates));
        appDesc.serverTemplates.putAll(update.descriptor.serverTemplates);
        appDesc.nodes.keySet().removeAll(Arrays.asList(update.descriptor.removeNodes));
        for (String name : update.descriptor.removeNodes) {
            Node node = this.findNode(name);
            if (!node.remove(update.descriptor.name)) continue;
            int index = this.getIndex(node);
            this._nodes.remove(node);
            this._treeModel.nodesWereRemoved(this, new int[]{index}, new Object[]{node});
        }
        HashSet<Node> freshNodes = new HashSet<Node>();
        for (NodeUpdateDescriptor desc : update.descriptor.nodes) {
            String nodeName = desc.name;
            Node node = this.findNode(nodeName);
            if (node == null) {
                node = new Node(this, appDesc, desc);
                this.insertNode(node);
            } else {
                node.update(appDesc, desc, variablesChanged, update.descriptor.serviceTemplates.keySet(), update.descriptor.serverTemplates.keySet());
            }
            freshNodes.add(node);
        }
        if (variablesChanged || !update.descriptor.serviceTemplates.isEmpty() || !update.descriptor.serverTemplates.isEmpty()) {
            for (Node p : this._nodes) {
                if (freshNodes.contains(p)) continue;
                p.update(appDesc, null, variablesChanged, update.descriptor.serviceTemplates.keySet(), update.descriptor.serverTemplates.keySet());
            }
        }
    }

    public void adapterInit(AdapterInfo[] adapters) {
        for (AdapterInfo info : adapters) {
            this._adapters.put(info.id, info);
        }
    }

    public void adapterAdded(AdapterInfo info) {
        this._adapters.put(info.id, info);
    }

    public void adapterUpdated(AdapterInfo info) {
        this._adapters.put(info.id, info);
    }

    public void adapterRemoved(String id) {
        this._adapters.remove(id);
    }

    public void objectInit(ObjectInfo[] objects) {
        for (ObjectInfo info : objects) {
            this._objects.put(info.proxy.ice_getCommunicator().identityToString(info.proxy.ice_getIdentity()), info);
        }
    }

    public void objectAdded(ObjectInfo info) {
        this._objects.put(info.proxy.ice_getCommunicator().identityToString(info.proxy.ice_getIdentity()), info);
    }

    public void objectUpdated(ObjectInfo info) {
        this._objects.put(info.proxy.ice_getCommunicator().identityToString(info.proxy.ice_getIdentity()), info);
    }

    public void objectRemoved(Identity id) {
        this._objects.remove(this._coordinator.getCommunicator().identityToString(id));
    }

    public void registryUp(RegistryInfo info) {
        if (info.name.equals(this._replicaName)) {
            this._info = info;
            this.fetchMetricsViewNames();
        } else {
            Slave newSlave = new Slave((TreeNode)this, info, this._replicaName);
            this.insertSortedChild(newSlave, this._slaves, this._treeModel);
        }
    }

    public void registryDown(String name) {
        TreeNodeBase registry = this.find(name, this._slaves);
        if (registry != null) {
            int index = this.getIndex(registry);
            this._slaves.remove(registry);
            this._treeModel.nodesWereRemoved(this, new int[]{index}, new Object[]{registry});
        }
    }

    public void nodeUp(NodeDynamicInfo updatedInfo) {
        Node node = this.findNode(updatedInfo.info.name);
        if (node != null) {
            node.up(updatedInfo, true);
        } else {
            this.insertNode(new Node(this, updatedInfo));
        }
    }

    public void nodeDown(String nodeName) {
        Node node = this.findNode(nodeName);
        if (node != null && node.down()) {
            int index = this.getIndex(node);
            this._nodes.remove(node);
            this._treeModel.nodesWereRemoved(this, new int[]{index}, new Object[]{node});
        }
    }

    public void updateServer(String nodeName, ServerDynamicInfo updatedInfo) {
        Node node = this.findNode(nodeName);
        if (node != null) {
            node.updateServer(updatedInfo);
        }
    }

    public void updateAdapter(String nodeName, AdapterDynamicInfo updatedInfo) {
        Node node = this.findNode(nodeName);
        if (node != null) {
            node.updateAdapter(updatedInfo);
        }
    }

    @Override
    public JPopupMenu getPopupMenu() {
        LiveActions la = this._coordinator.getLiveActionsForPopup();
        if (_popup == null) {
            _popup = new JPopupMenu();
            _popup.add(la.get(19));
            _popup.addSeparator();
            _popup.add(la.get(12));
            _popup.add(la.get(13));
            _popup.add(la.get(14));
            _popup.addSeparator();
            _popup.add(la.get(17));
        }
        la.setTarget(this);
        return _popup;
    }

    public void setSelectedNode(TreeNode node) {
        this._tree.setSelectionPath(node.getPath());
    }

    public JTree getTree() {
        return this._tree;
    }

    public DefaultTreeModel getTreeModel() {
        return this._treeModel;
    }

    @Override
    public Coordinator getCoordinator() {
        return this._coordinator;
    }

    @Override
    public String toString() {
        return this._label;
    }

    public boolean hasNode(TreeNode node) {
        while (node != this) {
            TreeNode parent = (TreeNode)node.getParent();
            if (parent.getIndex(node) == -1) {
                return false;
            }
            node = parent;
        }
        return true;
    }

    @Override
    public void addObject() {
        this._addObjectDialog.showDialog();
    }

    public void showObject(String proxy, String type) {
        this._showObjectDialog.showDialog(proxy, type);
    }

    @Override
    Root getRoot() {
        return this;
    }

    SortedMap<String, ObjectInfo> getObjects() {
        return this._objects;
    }

    SortedMap<String, AdapterInfo> getAdapters() {
        return this._adapters;
    }

    RegistryInfo getRegistryInfo() {
        return this._info;
    }

    void addObject(String strProxy, String type, JDialog dialog) {
        ObjectPrx proxy = null;
        try {
            proxy = this._coordinator.getCommunicator().stringToProxy(strProxy);
        }
        catch (LocalException e) {
            JOptionPane.showMessageDialog(this._coordinator.getMainFrame(), "Cannot parse proxy '" + strProxy + "'", "addObject failed", 0);
        }
        if (proxy == null) {
            JOptionPane.showMessageDialog(this._coordinator.getMainFrame(), "You must provide a non-null proxy", "addObject failed", 0);
        }
        String strIdentity = this._coordinator.getCommunicator().identityToString(proxy.ice_getIdentity());
        String prefix = "Adding well-known object '" + strIdentity + "'...";
        AdminPrx admin = this._coordinator.getAdmin();
        this._coordinator.getStatusBar().setText(prefix);
        try {
            CompletableFuture<Void> r = type == null ? admin.addObjectAsync(proxy) : admin.addObjectWithTypeAsync(proxy, type);
            r.whenComplete((result, ex) -> {
                if (ex == null) {
                    this.amiSuccess(prefix);
                    SwingUtilities.invokeLater(() -> dialog.setVisible(false));
                } else if (ex instanceof ObjectExistsException) {
                    this.amiFailure(prefix, "addObject failed", "An object with this identity is already registered as a well-known object");
                } else if (ex instanceof DeploymentException) {
                    this.amiFailure(prefix, "addObject failed", "Deployment exception: " + ((DeploymentException)ex).reason);
                } else {
                    this.amiFailure(prefix, "addObject failed", ex.toString());
                }
            });
        }
        catch (LocalException ex2) {
            this.failure(prefix, "addObject failed", ex2.toString());
        }
    }

    void removeObject(String strProxy) {
        ObjectPrx proxy = this._coordinator.getCommunicator().stringToProxy(strProxy);
        Identity identity = proxy.ice_getIdentity();
        String strIdentity = this._coordinator.getCommunicator().identityToString(identity);
        String prefix = "Removing well-known object '" + strIdentity + "'...";
        String errorTitle = "Failed to remove object '" + strIdentity + "'";
        this._coordinator.getStatusBar().setText(prefix);
        try {
            AdminPrx admin = this._coordinator.getAdmin();
            admin.removeObjectAsync(identity).whenComplete((result, ex) -> this.amiComplete(prefix, errorTitle, (Throwable)ex));
        }
        catch (LocalException ex2) {
            this.failure(prefix, errorTitle, ex2.toString());
        }
    }

    void removeAdapter(String adapterId) {
        String prefix = "Removing adapter '" + adapterId + "'...";
        String errorTitle = "Failed to remove adapter '" + adapterId + "'";
        this._coordinator.getStatusBar().setText(prefix);
        try {
            AdminPrx admin = this._coordinator.getAdmin();
            admin.removeAdapterAsync(adapterId).whenComplete((result, ex) -> this.amiComplete(prefix, errorTitle, (Throwable)ex));
        }
        catch (LocalException ex2) {
            this.failure(prefix, errorTitle, ex2.toString());
        }
    }

    @Override
    protected CompletableFuture<ObjectPrx> getAdminAsync() {
        return this._coordinator.getAdmin().getRegistryAdminAsync(this._replicaName);
    }

    @Override
    protected String getDisplayName() {
        return "Registry";
    }

    @Override
    protected String getDefaultFileName() {
        return "registry-" + this._instanceName + "-" + this._replicaName;
    }

    @Override
    public void retrieveOutput(final boolean stdout) {
        this.getRoot().openShowLogFileDialog(new ShowLogFileDialog.FileIteratorFactory(){

            @Override
            public FileIteratorPrx open(int count) throws FileNotAvailableException, RegistryNotExistException, RegistryUnreachableException {
                AdminSessionPrx session = Root.this._coordinator.getSession();
                FileIteratorPrx result = stdout ? session.openRegistryStdOut(Root.this._replicaName, count) : session.openRegistryStdErr(Root.this._replicaName, count);
                return result;
            }

            @Override
            public String getTitle() {
                return "Registry " + Root.this._label + " " + (stdout ? "stdout" : "stderr");
            }

            @Override
            public String getDefaultFilename() {
                return Root.this._replicaName + (stdout ? ".out" : ".err");
            }
        });
    }

    PropertySetDescriptor findNamedPropertySet(String name, String applicationName) {
        ApplicationInfo app = this._infoMap.get(applicationName);
        return app.descriptor.propertySets.get(name);
    }

    void addShowIceLogDialog(String title, ShowIceLogDialog dialog) {
        this._showIceLogDialogMap.put(title, dialog);
    }

    void removeShowIceLogDialog(String title) {
        this._showIceLogDialogMap.remove(title);
    }

    void openShowLogFileDialog(ShowLogFileDialog.FileIteratorFactory factory) {
        ShowLogFileDialog d = this._showLogFileDialogMap.get(factory.getTitle());
        if (d == null) {
            d = new ShowLogFileDialog(this, factory, this._logMaxLines, this._logMaxSize, this._logInitialLines, this._logMaxReadSize, this._logPeriod);
            this._showLogFileDialogMap.put(factory.getTitle(), d);
        } else {
            d.toFront();
        }
    }

    void removeShowLogFileDialog(String title) {
        this._showLogFileDialogMap.remove(title);
    }

    public void closeAllShowLogDialogs() {
        for (ShowIceLogDialog showIceLogDialog : this._showIceLogDialogMap.values()) {
            showIceLogDialog.close(false);
        }
        this._showIceLogDialogMap.clear();
        for (ShowLogFileDialog showLogFileDialog : this._showLogFileDialogMap.values()) {
            showLogFileDialog.close(false);
        }
        this._showLogFileDialogMap.clear();
    }

    public int getMessageSizeMax() {
        return this._messageSizeMax;
    }

    public void setLogPrefs(int maxLines, int maxSize, int initialLines, int maxReadSize, int period) {
        this._logMaxLines = maxLines;
        this._logMaxSize = maxSize;
        this._logInitialLines = initialLines;
        this._logMaxReadSize = maxReadSize;
        this._logPeriod = period;
        this.storeLogPrefs();
    }

    public void setLogPrefs(int maxLines, int initialLines) {
        this._logMaxLines = maxLines;
        this._logInitialLines = initialLines;
        this.storeLogPrefs();
    }

    public int getLogMaxLines() {
        return this._logMaxLines;
    }

    public int getLogInitialLines() {
        return this._logInitialLines;
    }

    private void loadLogPrefs() {
        Preferences logPrefs = Coordinator.getPreferences().node("Log");
        this._logMaxLines = logPrefs.getInt("maxLines", 1000);
        this._logMaxSize = logPrefs.getInt("maxSize", 1000000);
        this._logInitialLines = logPrefs.getInt("initialLines", 1000);
        this._logMaxReadSize = logPrefs.getInt("maxReadSize", 1000000);
        this._logPeriod = logPrefs.getInt("period", 300);
        if (this._logMaxReadSize + 512 > this._messageSizeMax) {
            this._logMaxReadSize = this._messageSizeMax - 512;
        }
    }

    private void storeLogPrefs() {
        Preferences logPrefs = Coordinator.getPreferences().node("Log");
        logPrefs.putInt("maxLines", this._logMaxLines);
        logPrefs.putInt("maxSize", this._logMaxSize);
        logPrefs.putInt("initialLines", this._logInitialLines);
        logPrefs.putInt("maxReadSize", this._logMaxReadSize);
        logPrefs.putInt("period", this._logPeriod);
    }

    private Node findNode(String nodeName) {
        return (Node)this.find(nodeName, this._nodes);
    }

    private void insertNode(Node node) {
        this.insertSortedChild(node, this._nodes, this._treeModel);
    }

    public static int computeMessageSizeMax(int num) {
        if (num <= 0) {
            num = 1024;
        }
        if (num > 0x1FFFFF) {
            return Integer.MAX_VALUE;
        }
        return num * 1024;
    }

    class FilteredTreeModel
    extends DefaultTreeModel {
        public FilteredTreeModel(TreeNode root) {
            super(root, true);
        }

        public void resetFilters() {
            Object[] path = new Object[]{this.root};
            int[] childIndices = new int[this.root.getChildCount()];
            Object[] children = new Object[this.root.getChildCount()];
            for (int i = 0; i < this.root.getChildCount(); ++i) {
                childIndices[i] = i;
                children[i] = this.root.getChildAt(i);
            }
            this.fireTreeStructureChanged(this, path, childIndices, children);
        }

        @Override
        public int getChildCount(Object parent) {
            if (!Root.this.filterEnabled()) {
                return super.getChildCount(parent);
            }
            int p = super.getChildCount(parent);
            int q = 0;
            for (int j = 0; j < p; ++j) {
                TreeNode node = (TreeNode)super.getChild(parent, j);
                if (!Root.this.matchFilter(node)) continue;
                ++q;
            }
            return q;
        }

        @Override
        public Object getChild(Object parent, int index) {
            if (!Root.this.filterEnabled()) {
                return super.getChild(parent, index);
            }
            TreeNode child = null;
            int p = 0;
            int q = super.getChildCount(parent);
            for (int j = 0; j < q; ++j) {
                TreeNode node = (TreeNode)super.getChild(parent, j);
                if (!Root.this.matchFilter(node)) continue;
                if (p == index) {
                    child = node;
                    break;
                }
                if (++p > index) break;
            }
            return child;
        }
    }
}

