%%%----------------------------------------------------------------------
%%%
%%% ejabberd, Copyright (C) 2002-2018   ProcessOne
%%%
%%% This program is free software; you can redistribute it and/or
%%% modify it under the terms of the GNU General Public License as
%%% published by the Free Software Foundation; either version 2 of the
%%% License, or (at your option) any later version.
%%%
%%% This program is distributed in the hope that it will be useful,
%%% but WITHOUT ANY WARRANTY; without even the implied warranty of
%%% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
%%% General Public License for more details.
%%%
%%% You should have received a copy of the GNU General Public License along
%%% with this program; if not, write to the Free Software Foundation, Inc.,
%%% 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
%%%
%%%----------------------------------------------------------------------

-record(privacy, {us = {<<"">>, <<"">>} :: {binary(), binary()},
                  default = none        :: none | binary(),
                  lists = []            :: [{binary(), [listitem()]}]}).

-type privacy() :: #privacy{}.

-record(listitem, {type = none :: listitem_type(),
                   value = none :: listitem_value(),
                   action = allow :: listitem_action(),
                   order = 0 :: integer(),
                   match_all = false :: boolean(),
                   match_iq = false :: boolean(),
                   match_message = false :: boolean(),
                   match_presence_in = false :: boolean(),
                   match_presence_out = false :: boolean()}).

-type listitem() :: #listitem{}.
-type listitem_type() :: none | jid | group | subscription.
-type listitem_value() :: none | both | from | to | jid:ljid() | binary().
-type listitem_action() :: allow | deny.
