/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import java.io.IOException;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.persistent.PersistentTasksCustomMetaData;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ml.MlTasks;
import org.elasticsearch.xpack.core.ml.action.KillProcessAction;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.ml.action.TransportJobTaskAction;
import org.elasticsearch.xpack.ml.action.TransportOpenJobAction;
import org.elasticsearch.xpack.ml.job.process.autodetect.AutodetectProcessManager;
import org.elasticsearch.xpack.ml.notifications.Auditor;

public class TransportKillProcessAction
extends TransportJobTaskAction<KillProcessAction.Request, KillProcessAction.Response> {
    private final Auditor auditor;

    @Inject
    public TransportKillProcessAction(Settings settings, TransportService transportService, ThreadPool threadPool, ClusterService clusterService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, AutodetectProcessManager processManager, Auditor auditor) {
        super(settings, "cluster:internal/xpack/ml/job/kill/process", threadPool, clusterService, transportService, actionFilters, indexNameExpressionResolver, KillProcessAction.Request::new, KillProcessAction.Response::new, "ml_utility", processManager);
        this.auditor = auditor;
    }

    protected void taskOperation(KillProcessAction.Request request, TransportOpenJobAction.JobTask jobTask, ActionListener<KillProcessAction.Response> listener) {
        this.logger.info("[{}] Killing job", (Object)jobTask.getJobId());
        this.auditor.info(jobTask.getJobId(), "Killing job");
        try {
            this.processManager.killProcess(jobTask, true, null);
            listener.onResponse((Object)new KillProcessAction.Response(true));
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    @Override
    protected void doExecute(Task task, KillProcessAction.Request request, ActionListener<KillProcessAction.Response> listener) {
        DiscoveryNodes nodes = this.clusterService.state().nodes();
        PersistentTasksCustomMetaData tasks = (PersistentTasksCustomMetaData)this.clusterService.state().getMetaData().custom("persistent_tasks");
        PersistentTasksCustomMetaData.PersistentTask jobTask = MlTasks.getJobTask((String)request.getJobId(), (PersistentTasksCustomMetaData)tasks);
        if (jobTask == null || jobTask.getExecutorNode() == null) {
            this.logger.debug("[{}] Cannot kill the process because job is not open", (Object)request.getJobId());
            listener.onResponse((Object)new KillProcessAction.Response(false));
            return;
        }
        DiscoveryNode executorNode = nodes.get(jobTask.getExecutorNode());
        if (executorNode == null) {
            listener.onFailure((Exception)ExceptionsHelper.conflictStatusException((String)"Cannot kill process for job {} asexecutor node {} cannot be found", (Object[])new Object[]{request.getJobId(), jobTask.getExecutorNode()}));
            return;
        }
        Version nodeVersion = executorNode.getVersion();
        if (nodeVersion.before(Version.V_5_5_0)) {
            listener.onFailure((Exception)new ElasticsearchException("Cannot kill the process on node with version " + nodeVersion, new Object[0]));
            return;
        }
        super.doExecute(task, request, listener);
    }

    protected KillProcessAction.Response readTaskResponse(StreamInput in) throws IOException {
        return new KillProcessAction.Response(in);
    }
}

