/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job.process.normalizer;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.ml.job.results.BucketInfluencer;
import org.elasticsearch.xpack.ml.job.process.normalizer.AbstractLeafNormalizable;
import org.elasticsearch.xpack.ml.job.process.normalizer.Level;

class BucketInfluencerNormalizable
extends AbstractLeafNormalizable {
    private final BucketInfluencer bucketInfluencer;

    BucketInfluencerNormalizable(BucketInfluencer influencer, String indexName) {
        super(indexName);
        this.bucketInfluencer = Objects.requireNonNull(influencer);
    }

    @Override
    public String getId() {
        return this.bucketInfluencer.getId();
    }

    @Override
    public Level getLevel() {
        return "bucket_time".equals(this.bucketInfluencer.getInfluencerFieldName()) ? Level.ROOT : Level.BUCKET_INFLUENCER;
    }

    @Override
    public String getPartitionFieldName() {
        return null;
    }

    @Override
    public String getPartitionFieldValue() {
        return null;
    }

    @Override
    public String getPersonFieldName() {
        return this.bucketInfluencer.getInfluencerFieldName();
    }

    @Override
    public String getFunctionName() {
        return null;
    }

    @Override
    public String getValueFieldName() {
        return null;
    }

    @Override
    public double getProbability() {
        return this.bucketInfluencer.getProbability();
    }

    @Override
    public double getNormalizedScore() {
        return this.bucketInfluencer.getAnomalyScore();
    }

    @Override
    public void setNormalizedScore(double normalizedScore) {
        this.bucketInfluencer.setAnomalyScore(normalizedScore);
    }

    @Override
    public void setParentScore(double parentScore) {
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return this.bucketInfluencer.toXContent(builder, params);
    }
}

