/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.planner;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.elasticsearch.xpack.sql.SqlIllegalArgumentException;
import org.elasticsearch.xpack.sql.expression.Attribute;
import org.elasticsearch.xpack.sql.expression.BinaryExpression;
import org.elasticsearch.xpack.sql.expression.Expression;
import org.elasticsearch.xpack.sql.expression.ExpressionId;
import org.elasticsearch.xpack.sql.expression.Expressions;
import org.elasticsearch.xpack.sql.expression.FieldAttribute;
import org.elasticsearch.xpack.sql.expression.Foldables;
import org.elasticsearch.xpack.sql.expression.Literal;
import org.elasticsearch.xpack.sql.expression.NamedExpression;
import org.elasticsearch.xpack.sql.expression.UnaryExpression;
import org.elasticsearch.xpack.sql.expression.function.Function;
import org.elasticsearch.xpack.sql.expression.function.Functions;
import org.elasticsearch.xpack.sql.expression.function.aggregate.AggregateFunction;
import org.elasticsearch.xpack.sql.expression.function.aggregate.AggregateFunctionAttribute;
import org.elasticsearch.xpack.sql.expression.function.aggregate.Avg;
import org.elasticsearch.xpack.sql.expression.function.aggregate.CompoundNumericAggregate;
import org.elasticsearch.xpack.sql.expression.function.aggregate.Count;
import org.elasticsearch.xpack.sql.expression.function.aggregate.ExtendedStats;
import org.elasticsearch.xpack.sql.expression.function.aggregate.MatrixStats;
import org.elasticsearch.xpack.sql.expression.function.aggregate.Max;
import org.elasticsearch.xpack.sql.expression.function.aggregate.Min;
import org.elasticsearch.xpack.sql.expression.function.aggregate.PercentileRanks;
import org.elasticsearch.xpack.sql.expression.function.aggregate.Percentiles;
import org.elasticsearch.xpack.sql.expression.function.aggregate.Stats;
import org.elasticsearch.xpack.sql.expression.function.aggregate.Sum;
import org.elasticsearch.xpack.sql.expression.function.scalar.ScalarFunction;
import org.elasticsearch.xpack.sql.expression.function.scalar.ScalarFunctionAttribute;
import org.elasticsearch.xpack.sql.expression.function.scalar.datetime.DateTimeFunction;
import org.elasticsearch.xpack.sql.expression.function.scalar.datetime.DateTimeHistogramFunction;
import org.elasticsearch.xpack.sql.expression.function.scalar.script.Params;
import org.elasticsearch.xpack.sql.expression.function.scalar.script.ParamsBuilder;
import org.elasticsearch.xpack.sql.expression.function.scalar.script.ScriptTemplate;
import org.elasticsearch.xpack.sql.expression.predicate.And;
import org.elasticsearch.xpack.sql.expression.predicate.BinaryComparison;
import org.elasticsearch.xpack.sql.expression.predicate.Equals;
import org.elasticsearch.xpack.sql.expression.predicate.GreaterThan;
import org.elasticsearch.xpack.sql.expression.predicate.GreaterThanOrEqual;
import org.elasticsearch.xpack.sql.expression.predicate.IsNotNull;
import org.elasticsearch.xpack.sql.expression.predicate.LessThan;
import org.elasticsearch.xpack.sql.expression.predicate.LessThanOrEqual;
import org.elasticsearch.xpack.sql.expression.predicate.Not;
import org.elasticsearch.xpack.sql.expression.predicate.Or;
import org.elasticsearch.xpack.sql.expression.predicate.Range;
import org.elasticsearch.xpack.sql.expression.predicate.fulltext.MatchQueryPredicate;
import org.elasticsearch.xpack.sql.expression.predicate.fulltext.MultiMatchQueryPredicate;
import org.elasticsearch.xpack.sql.expression.predicate.fulltext.StringQueryPredicate;
import org.elasticsearch.xpack.sql.expression.regex.Like;
import org.elasticsearch.xpack.sql.expression.regex.LikePattern;
import org.elasticsearch.xpack.sql.expression.regex.RLike;
import org.elasticsearch.xpack.sql.querydsl.agg.AggFilter;
import org.elasticsearch.xpack.sql.querydsl.agg.AndAggFilter;
import org.elasticsearch.xpack.sql.querydsl.agg.AvgAgg;
import org.elasticsearch.xpack.sql.querydsl.agg.CardinalityAgg;
import org.elasticsearch.xpack.sql.querydsl.agg.ExtendedStatsAgg;
import org.elasticsearch.xpack.sql.querydsl.agg.GroupByColumnKey;
import org.elasticsearch.xpack.sql.querydsl.agg.GroupByDateKey;
import org.elasticsearch.xpack.sql.querydsl.agg.GroupByKey;
import org.elasticsearch.xpack.sql.querydsl.agg.GroupByScriptKey;
import org.elasticsearch.xpack.sql.querydsl.agg.LeafAgg;
import org.elasticsearch.xpack.sql.querydsl.agg.MatrixStatsAgg;
import org.elasticsearch.xpack.sql.querydsl.agg.MaxAgg;
import org.elasticsearch.xpack.sql.querydsl.agg.MinAgg;
import org.elasticsearch.xpack.sql.querydsl.agg.OrAggFilter;
import org.elasticsearch.xpack.sql.querydsl.agg.PercentileRanksAgg;
import org.elasticsearch.xpack.sql.querydsl.agg.PercentilesAgg;
import org.elasticsearch.xpack.sql.querydsl.agg.StatsAgg;
import org.elasticsearch.xpack.sql.querydsl.agg.SumAgg;
import org.elasticsearch.xpack.sql.querydsl.query.BoolQuery;
import org.elasticsearch.xpack.sql.querydsl.query.ExistsQuery;
import org.elasticsearch.xpack.sql.querydsl.query.LeafQuery;
import org.elasticsearch.xpack.sql.querydsl.query.MatchQuery;
import org.elasticsearch.xpack.sql.querydsl.query.MultiMatchQuery;
import org.elasticsearch.xpack.sql.querydsl.query.NestedQuery;
import org.elasticsearch.xpack.sql.querydsl.query.NotQuery;
import org.elasticsearch.xpack.sql.querydsl.query.Query;
import org.elasticsearch.xpack.sql.querydsl.query.QueryStringQuery;
import org.elasticsearch.xpack.sql.querydsl.query.RangeQuery;
import org.elasticsearch.xpack.sql.querydsl.query.RegexQuery;
import org.elasticsearch.xpack.sql.querydsl.query.ScriptQuery;
import org.elasticsearch.xpack.sql.querydsl.query.TermQuery;
import org.elasticsearch.xpack.sql.querydsl.query.WildcardQuery;
import org.elasticsearch.xpack.sql.tree.Location;
import org.elasticsearch.xpack.sql.type.DataType;
import org.elasticsearch.xpack.sql.util.Check;
import org.elasticsearch.xpack.sql.util.ReflectionUtils;

abstract class QueryTranslator {
    static final List<ExpressionTranslator<?>> QUERY_TRANSLATORS = Arrays.asList(new BinaryComparisons(), new Ranges(), new BinaryLogic(), new Nots(), new Nulls(), new Likes(), new StringQueries(), new Matches(), new MultiMatches());
    static final List<AggTranslator<?>> AGG_TRANSLATORS = Arrays.asList(new Maxes(), new Mins(), new Avgs(), new Sums(), new StatsAggs(), new ExtendedStatsAggs(), new MatrixStatsAggs(), new PercentilesAggs(), new PercentileRanksAggs(), new DistinctCounts(), new DateTimes());

    QueryTranslator() {
    }

    static QueryTranslation toQuery(Expression e, boolean onAggs) {
        QueryTranslation translation = null;
        for (ExpressionTranslator<?> translator : QUERY_TRANSLATORS) {
            translation = translator.translate(e, onAggs);
            if (translation == null) continue;
            return translation;
        }
        throw new SqlIllegalArgumentException("Don't know how to translate {} {}", e.nodeName(), e);
    }

    static LeafAgg toAgg(String id, Function f) {
        for (AggTranslator<?> translator : AGG_TRANSLATORS) {
            LeafAgg agg = translator.apply(id, f);
            if (agg == null) continue;
            return agg;
        }
        throw new SqlIllegalArgumentException("Don't know how to translate {} {}", f.nodeName(), f);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static GroupingContext groupBy(List<? extends Expression> groupings) {
        if (groupings.isEmpty()) {
            return null;
        }
        LinkedHashMap<ExpressionId, GroupByKey> aggMap = new LinkedHashMap<ExpressionId, GroupByKey>();
        for (Expression expression : groupings) {
            void var6_6;
            FieldAttribute fieldAttribute;
            if (!(expression instanceof NamedExpression)) throw new SqlIllegalArgumentException("Don't know how to group on {}", expression.nodeString());
            NamedExpression ne = (NamedExpression)expression;
            if (expression instanceof FieldAttribute && (fieldAttribute = (FieldAttribute)expression).isInexact()) {
                ne = fieldAttribute.exactAttribute();
            }
            String aggId = ne.id().toString();
            Object var6_9 = null;
            if (expression instanceof Function) {
                if (expression instanceof DateTimeHistogramFunction) {
                    DateTimeHistogramFunction dthf = (DateTimeHistogramFunction)expression;
                    GroupByDateKey groupByDateKey = new GroupByDateKey(aggId, QueryTranslator.nameOf(expression), dthf.interval(), dthf.timeZone());
                } else {
                    if (!(expression instanceof ScalarFunction)) throw new SqlIllegalArgumentException("Cannot GROUP BY function {}", expression);
                    ScalarFunction sf = (ScalarFunction)expression;
                    GroupByScriptKey groupByScriptKey = new GroupByScriptKey(aggId, QueryTranslator.nameOf(expression), sf.asScript());
                }
            } else {
                GroupByColumnKey groupByColumnKey = new GroupByColumnKey(aggId, ne.name());
            }
            aggMap.put(ne.id(), (GroupByKey)var6_6);
        }
        return new GroupingContext(aggMap);
    }

    static QueryTranslation and(Location loc, QueryTranslation left, QueryTranslation right) {
        Check.isTrue(left != null || right != null, "Both expressions are null");
        if (left == null) {
            return right;
        }
        if (right == null) {
            return left;
        }
        Query newQ = null;
        if (left.query != null || right.query != null) {
            newQ = QueryTranslator.and(loc, left.query, right.query);
        }
        AggFilter aggFilter = null;
        aggFilter = left.aggFilter == null ? right.aggFilter : (right.aggFilter == null ? left.aggFilter : new AndAggFilter(left.aggFilter, right.aggFilter));
        return new QueryTranslation(newQ, aggFilter);
    }

    static Query and(Location loc, Query left, Query right) {
        Check.isTrue(left != null || right != null, "Both expressions are null");
        if (left == null) {
            return right;
        }
        if (right == null) {
            return left;
        }
        return new BoolQuery(loc, true, left, right);
    }

    static QueryTranslation or(Location loc, QueryTranslation left, QueryTranslation right) {
        Check.isTrue(left != null || right != null, "Both expressions are null");
        if (left == null) {
            return right;
        }
        if (right == null) {
            return left;
        }
        Query newQ = null;
        if (left.query != null || right.query != null) {
            newQ = QueryTranslator.or(loc, left.query, right.query);
        }
        AggFilter aggFilter = null;
        aggFilter = left.aggFilter == null ? right.aggFilter : (right.aggFilter == null ? left.aggFilter : new OrAggFilter(left.aggFilter, right.aggFilter));
        return new QueryTranslation(newQ, aggFilter);
    }

    static Query or(Location loc, Query left, Query right) {
        Check.isTrue(left != null || right != null, "Both expressions are null");
        if (left == null) {
            return right;
        }
        if (right == null) {
            return left;
        }
        return new BoolQuery(loc, false, left, right);
    }

    static Query not(Query query) {
        Check.isTrue(query != null, "Expressions is null");
        return new NotQuery(query.location(), query);
    }

    static String nameOf(Expression e) {
        if (e instanceof DateTimeFunction) {
            return QueryTranslator.nameOf(((DateTimeFunction)e).field());
        }
        if (e instanceof NamedExpression) {
            return ((NamedExpression)e).name();
        }
        if (e instanceof Literal) {
            return String.valueOf(e.fold());
        }
        throw new SqlIllegalArgumentException("Cannot determine name for {}", e);
    }

    static String idOf(Expression e) {
        if (e instanceof NamedExpression) {
            return ((NamedExpression)e).id().toString();
        }
        throw new SqlIllegalArgumentException("Cannot determine id for {}", e);
    }

    static String dateFormat(Expression e) {
        if (e instanceof DateTimeFunction) {
            return ((DateTimeFunction)e).dateTimeFormat();
        }
        return null;
    }

    static String field(AggregateFunction af) {
        Expression arg = af.field();
        if (arg instanceof FieldAttribute) {
            return ((FieldAttribute)arg).name();
        }
        if (arg instanceof Literal) {
            return String.valueOf(((Literal)arg).value());
        }
        throw new SqlIllegalArgumentException("Does not know how to convert argument {} for function {}", arg.nodeString(), af.nodeString());
    }

    static abstract class ExpressionTranslator<E extends Expression> {
        private final Class<E> typeToken = ReflectionUtils.detectSuperTypeForRuleLike(this.getClass());

        ExpressionTranslator() {
        }

        public QueryTranslation translate(Expression exp, boolean onAggs) {
            return this.typeToken.isInstance(exp) ? this.asQuery(exp, onAggs) : null;
        }

        protected abstract QueryTranslation asQuery(E var1, boolean var2);

        protected static Query wrapIfNested(Query query, Expression exp) {
            FieldAttribute fa;
            if (exp instanceof FieldAttribute && (fa = (FieldAttribute)exp).isNested()) {
                return new NestedQuery(fa.location(), fa.nestedParent().name(), query);
            }
            return query;
        }
    }

    static abstract class CompoundAggTranslator<C extends CompoundNumericAggregate>
    extends AggTranslator<C> {
        CompoundAggTranslator() {
        }

        @Override
        protected final LeafAgg asAgg(String id, C function) {
            return this.toAgg(id, function);
        }

        protected abstract LeafAgg toAgg(String var1, C var2);
    }

    static abstract class SingleValueAggTranslator<F extends Function>
    extends AggTranslator<F> {
        SingleValueAggTranslator() {
        }

        @Override
        protected final LeafAgg asAgg(String id, F function) {
            return this.toAgg(id, function);
        }

        protected abstract LeafAgg toAgg(String var1, F var2);
    }

    static abstract class AggTranslator<F extends Function> {
        private final Class<?> typeToken = ReflectionUtils.detectSuperTypeForRuleLike(this.getClass());

        AggTranslator() {
        }

        public final LeafAgg apply(String id, Function f) {
            return this.typeToken.isInstance(f) ? this.asAgg(id, f) : null;
        }

        protected abstract LeafAgg asAgg(String var1, F var2);
    }

    static class DateTimes
    extends SingleValueAggTranslator<Min> {
        DateTimes() {
        }

        @Override
        protected LeafAgg toAgg(String id, Min m) {
            return new MinAgg(id, QueryTranslator.field(m));
        }
    }

    static class PercentileRanksAggs
    extends CompoundAggTranslator<PercentileRanks> {
        PercentileRanksAggs() {
        }

        @Override
        protected LeafAgg toAgg(String id, PercentileRanks p) {
            return new PercentileRanksAgg(id, QueryTranslator.field(p), Foldables.doubleValuesOf(p.values()));
        }
    }

    static class PercentilesAggs
    extends CompoundAggTranslator<Percentiles> {
        PercentilesAggs() {
        }

        @Override
        protected LeafAgg toAgg(String id, Percentiles p) {
            return new PercentilesAgg(id, QueryTranslator.field(p), Foldables.doubleValuesOf(p.percents()));
        }
    }

    static class MatrixStatsAggs
    extends CompoundAggTranslator<MatrixStats> {
        MatrixStatsAggs() {
        }

        @Override
        protected LeafAgg toAgg(String id, MatrixStats m) {
            return new MatrixStatsAgg(id, Collections.singletonList(QueryTranslator.field(m)));
        }
    }

    static class ExtendedStatsAggs
    extends CompoundAggTranslator<ExtendedStats> {
        ExtendedStatsAggs() {
        }

        @Override
        protected LeafAgg toAgg(String id, ExtendedStats e) {
            return new ExtendedStatsAgg(id, QueryTranslator.field(e));
        }
    }

    static class StatsAggs
    extends CompoundAggTranslator<Stats> {
        StatsAggs() {
        }

        @Override
        protected LeafAgg toAgg(String id, Stats s) {
            return new StatsAgg(id, QueryTranslator.field(s));
        }
    }

    static class Mins
    extends SingleValueAggTranslator<Min> {
        Mins() {
        }

        @Override
        protected LeafAgg toAgg(String id, Min m) {
            return new MinAgg(id, QueryTranslator.field(m));
        }
    }

    static class Maxes
    extends SingleValueAggTranslator<Max> {
        Maxes() {
        }

        @Override
        protected LeafAgg toAgg(String id, Max m) {
            return new MaxAgg(id, QueryTranslator.field(m));
        }
    }

    static class Avgs
    extends SingleValueAggTranslator<Avg> {
        Avgs() {
        }

        @Override
        protected LeafAgg toAgg(String id, Avg a) {
            return new AvgAgg(id, QueryTranslator.field(a));
        }
    }

    static class Sums
    extends SingleValueAggTranslator<Sum> {
        Sums() {
        }

        @Override
        protected LeafAgg toAgg(String id, Sum s) {
            return new SumAgg(id, QueryTranslator.field(s));
        }
    }

    static class DistinctCounts
    extends SingleValueAggTranslator<Count> {
        DistinctCounts() {
        }

        @Override
        protected LeafAgg toAgg(String id, Count c) {
            if (!c.distinct()) {
                return null;
            }
            return new CardinalityAgg(id, QueryTranslator.field(c));
        }
    }

    static class Ranges
    extends ExpressionTranslator<Range> {
        Ranges() {
        }

        @Override
        protected QueryTranslation asQuery(Range r, boolean onAggs) {
            Object lower = Foldables.valueOf(r.lower());
            Object upper = Foldables.valueOf(r.upper());
            Expression e = r.value();
            if (e instanceof NamedExpression) {
                NamedExpression ne = (NamedExpression)e;
                Query query = null;
                AggFilter aggFilter = null;
                Attribute at = ne.toAttribute();
                if (at instanceof ScalarFunctionAttribute) {
                    ScalarFunctionAttribute sfa = (ScalarFunctionAttribute)at;
                    ScriptTemplate scriptTemplate = sfa.script();
                    String template = ScriptTemplate.formatTemplate(String.format(Locale.ROOT, "({} %s %s) && (%s %s {})", r.includeLower() ? "<=" : "<", scriptTemplate.template(), scriptTemplate.template(), r.includeUpper() ? "<=" : "<"));
                    Params params = ParamsBuilder.paramsBuilder().variable(lower).script(scriptTemplate.params()).script(scriptTemplate.params()).variable(upper).build();
                    ScriptTemplate script = new ScriptTemplate(template, params, DataType.BOOLEAN);
                    if (onAggs) {
                        aggFilter = new AggFilter(at.id().toString(), script);
                    } else {
                        query = new ScriptQuery(at.location(), script);
                    }
                } else if (onAggs) {
                    String template = null;
                    Params params = null;
                    if (at instanceof AggregateFunctionAttribute) {
                        AggregateFunctionAttribute fa = (AggregateFunctionAttribute)at;
                        template = ScriptTemplate.formatTemplate(String.format(Locale.ROOT, "{} %s {} && {} %s {}", r.includeLower() ? "<=" : "<", r.includeUpper() ? "<=" : "<"));
                        params = ParamsBuilder.paramsBuilder().variable(lower).agg(fa).agg(fa).variable(upper).build();
                    }
                    aggFilter = new AggFilter(((NamedExpression)r.value()).id().toString(), new ScriptTemplate(template, params, DataType.BOOLEAN));
                } else if (at instanceof FieldAttribute) {
                    RangeQuery rangeQuery = new RangeQuery(r.location(), QueryTranslator.nameOf(r.value()), Foldables.valueOf(r.lower()), r.includeLower(), Foldables.valueOf(r.upper()), r.includeUpper(), QueryTranslator.dateFormat(r.value()));
                    query = Ranges.wrapIfNested(rangeQuery, r.value());
                }
                return new QueryTranslation(query, aggFilter);
            }
            throw new SqlIllegalArgumentException("No idea how to translate " + e);
        }
    }

    static class BinaryComparisons
    extends ExpressionTranslator<BinaryComparison> {
        BinaryComparisons() {
        }

        @Override
        protected QueryTranslation asQuery(BinaryComparison bc, boolean onAggs) {
            Check.isTrue(bc.right().foldable(), "Line {}:{}: Comparisons against variables are not (currently) supported; offender [{}] in [{}]", bc.right().location().getLineNumber(), bc.right().location().getColumnNumber(), Expressions.name(bc.right()), bc.symbol());
            if (bc.left() instanceof NamedExpression) {
                NamedExpression ne = (NamedExpression)bc.left();
                Query query = null;
                AggFilter aggFilter = null;
                Attribute at = ne.toAttribute();
                if (at instanceof ScalarFunctionAttribute) {
                    ScalarFunctionAttribute sfa = (ScalarFunctionAttribute)at;
                    ScriptTemplate scriptTemplate = sfa.script();
                    String template = ScriptTemplate.formatTemplate(String.format(Locale.ROOT, "%s %s {}", scriptTemplate.template(), bc.symbol()));
                    Params params = ParamsBuilder.paramsBuilder().script(scriptTemplate.params()).variable(Foldables.valueOf(bc.right())).build();
                    ScriptTemplate script = new ScriptTemplate(template, params, DataType.BOOLEAN);
                    if (onAggs) {
                        aggFilter = new AggFilter(at.id().toString(), script);
                    } else {
                        query = new ScriptQuery(at.location(), script);
                    }
                } else if (onAggs) {
                    String template = null;
                    Params params = null;
                    if (at instanceof AggregateFunctionAttribute) {
                        AggregateFunctionAttribute fa = (AggregateFunctionAttribute)at;
                        template = ScriptTemplate.formatTemplate(String.format(Locale.ROOT, "{} %s {}", bc.symbol()));
                        params = ParamsBuilder.paramsBuilder().agg(fa).variable(Foldables.valueOf(bc.right())).build();
                    }
                    aggFilter = new AggFilter(at.id().toString(), new ScriptTemplate(template, params, DataType.BOOLEAN));
                } else if (at instanceof FieldAttribute) {
                    query = BinaryComparisons.wrapIfNested(BinaryComparisons.translateQuery(bc), ne);
                }
                return new QueryTranslation(query, aggFilter);
            }
            throw new UnsupportedOperationException("No idea how to translate " + bc.left());
        }

        private static Query translateQuery(BinaryComparison bc) {
            Location loc = bc.location();
            String name = QueryTranslator.nameOf(bc.left());
            Object value = Foldables.valueOf(bc.right());
            String format = QueryTranslator.dateFormat(bc.left());
            if (bc instanceof GreaterThan) {
                return new RangeQuery(loc, name, value, false, null, false, format);
            }
            if (bc instanceof GreaterThanOrEqual) {
                return new RangeQuery(loc, name, value, true, null, false, format);
            }
            if (bc instanceof LessThan) {
                return new RangeQuery(loc, name, null, false, value, false, format);
            }
            if (bc instanceof LessThanOrEqual) {
                return new RangeQuery(loc, name, null, false, value, true, format);
            }
            if (bc instanceof Equals) {
                FieldAttribute fa;
                if (bc.left() instanceof FieldAttribute && (fa = (FieldAttribute)bc.left()).isInexact()) {
                    name = fa.exactAttribute().name();
                }
                return new TermQuery(loc, name, value);
            }
            throw new SqlIllegalArgumentException("Don't know how to translate binary comparison [{}] in [{}]", bc.right().nodeString(), bc);
        }
    }

    static class Nulls
    extends ExpressionTranslator<UnaryExpression> {
        Nulls() {
        }

        @Override
        protected QueryTranslation asQuery(UnaryExpression ue, boolean onAggs) {
            if (ue instanceof IsNotNull) {
                return new QueryTranslation(new ExistsQuery(ue.location(), QueryTranslator.nameOf(ue.child())));
            }
            return null;
        }
    }

    static class Nots
    extends ExpressionTranslator<Not> {
        Nots() {
        }

        @Override
        protected QueryTranslation asQuery(Not not, boolean onAggs) {
            QueryTranslation translation = QueryTranslator.toQuery(not.child(), onAggs);
            return new QueryTranslation(QueryTranslator.not(translation.query), translation.aggFilter);
        }
    }

    static class BinaryLogic
    extends ExpressionTranslator<BinaryExpression> {
        BinaryLogic() {
        }

        @Override
        protected QueryTranslation asQuery(BinaryExpression e, boolean onAggs) {
            if (e instanceof And) {
                return QueryTranslator.and(e.location(), QueryTranslator.toQuery(e.left(), onAggs), QueryTranslator.toQuery(e.right(), onAggs));
            }
            if (e instanceof Or) {
                return QueryTranslator.or(e.location(), QueryTranslator.toQuery(e.left(), onAggs), QueryTranslator.toQuery(e.right(), onAggs));
            }
            return null;
        }
    }

    static class MultiMatches
    extends ExpressionTranslator<MultiMatchQueryPredicate> {
        MultiMatches() {
        }

        @Override
        protected QueryTranslation asQuery(MultiMatchQueryPredicate q, boolean onAggs) {
            return new QueryTranslation(new MultiMatchQuery(q.location(), q.query(), q.fields(), q));
        }
    }

    static class Matches
    extends ExpressionTranslator<MatchQueryPredicate> {
        Matches() {
        }

        @Override
        protected QueryTranslation asQuery(MatchQueryPredicate q, boolean onAggs) {
            return new QueryTranslation(Matches.wrapIfNested(new MatchQuery(q.location(), QueryTranslator.nameOf(q.field()), q.query(), q), q.field()));
        }
    }

    static class StringQueries
    extends ExpressionTranslator<StringQueryPredicate> {
        StringQueries() {
        }

        @Override
        protected QueryTranslation asQuery(StringQueryPredicate q, boolean onAggs) {
            return new QueryTranslation(new QueryStringQuery(q.location(), q.query(), q.fields(), q));
        }
    }

    static class Likes
    extends ExpressionTranslator<BinaryExpression> {
        Likes() {
        }

        @Override
        protected QueryTranslation asQuery(BinaryExpression e, boolean onAggs) {
            LeafQuery q = null;
            boolean inexact = true;
            String target = null;
            if (!(e.left() instanceof FieldAttribute)) {
                throw new SqlIllegalArgumentException("Scalar function ({}) not allowed (yet) as arguments for LIKE", Expressions.name(e.left()));
            }
            FieldAttribute fa = (FieldAttribute)e.left();
            inexact = fa.isInexact();
            target = QueryTranslator.nameOf(inexact ? fa : fa.exactAttribute());
            if (e instanceof Like) {
                LikePattern p = ((Like)e).right();
                q = inexact ? new QueryStringQuery(e.location(), p.asLuceneWildcard(), target) : new WildcardQuery(e.location(), QueryTranslator.nameOf(e.left()), p.asLuceneWildcard());
            }
            if (e instanceof RLike) {
                String pattern = Foldables.stringValueOf(e.right());
                q = inexact ? new QueryStringQuery(e.location(), "/" + pattern + "/", target) : new RegexQuery(e.location(), QueryTranslator.nameOf(e.left()), pattern);
            }
            return q != null ? new QueryTranslation(Likes.wrapIfNested(q, e.left())) : null;
        }
    }

    static class GroupingContext {
        final Map<ExpressionId, GroupByKey> groupMap;
        final GroupByKey tail;

        GroupingContext(Map<ExpressionId, GroupByKey> groupMap) {
            this.groupMap = groupMap;
            GroupByKey lastAgg = null;
            for (Map.Entry<ExpressionId, GroupByKey> entry : groupMap.entrySet()) {
                lastAgg = entry.getValue();
            }
            this.tail = lastAgg;
        }

        GroupByKey groupFor(Expression exp) {
            if (Functions.isAggregate(exp)) {
                AggregateFunction f = (AggregateFunction)exp;
                if (!this.groupMap.isEmpty()) {
                    GroupByKey matchingGroup = null;
                    if (f.field() instanceof NamedExpression) {
                        matchingGroup = this.groupMap.get(((NamedExpression)f.field()).id());
                    }
                    return matchingGroup != null ? matchingGroup : this.tail;
                }
                return null;
            }
            if (exp instanceof NamedExpression) {
                return this.groupMap.get(((NamedExpression)exp).id());
            }
            throw new SqlIllegalArgumentException("Don't know how to find group for expression {}", exp);
        }

        public String toString() {
            return this.groupMap.toString();
        }
    }

    static class QueryTranslation {
        final Query query;
        final AggFilter aggFilter;

        QueryTranslation(Query query) {
            this(query, null);
        }

        QueryTranslation(AggFilter aggFilter) {
            this(null, aggFilter);
        }

        QueryTranslation(Query query, AggFilter aggFilter) {
            this.query = query;
            this.aggFilter = aggFilter;
        }
    }
}

