/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.action;

import java.io.IOException;
import java.util.Objects;
import java.util.function.LongSupplier;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.Version;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestBuilder;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.MasterNodeRequest;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.joda.DateMathParser;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.mapper.DateFieldMapper;
import org.elasticsearch.xpack.core.XPackPlugin;
import org.elasticsearch.xpack.core.ml.datafeed.DatafeedConfig;
import org.elasticsearch.xpack.core.ml.job.messages.Messages;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;

public class StartDatafeedAction
extends Action<Request, Response, RequestBuilder> {
    public static final ParseField START_TIME = new ParseField("start", new String[0]);
    public static final ParseField END_TIME = new ParseField("end", new String[0]);
    public static final ParseField TIMEOUT = new ParseField("timeout", new String[0]);
    public static final StartDatafeedAction INSTANCE = new StartDatafeedAction();
    public static final String NAME = "cluster:admin/xpack/ml/datafeed/start";
    public static final String TASK_NAME = "xpack/ml/datafeed";

    private StartDatafeedAction() {
        super(NAME);
    }

    public RequestBuilder newRequestBuilder(ElasticsearchClient client) {
        return new RequestBuilder(client, this);
    }

    public Response newResponse() {
        return new Response();
    }

    public static interface DatafeedTaskMatcher {
    }

    static class RequestBuilder
    extends ActionRequestBuilder<Request, Response, RequestBuilder> {
        RequestBuilder(ElasticsearchClient client, StartDatafeedAction action) {
            super(client, (Action)action, (ActionRequest)new Request());
        }
    }

    public static class Response
    extends AcknowledgedResponse {
        public Response() {
        }

        public Response(boolean acknowledged) {
            super(acknowledged);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            AcknowledgedResponse that = (AcknowledgedResponse)o;
            return this.isAcknowledged() == that.isAcknowledged();
        }

        public int hashCode() {
            return Objects.hash(this.isAcknowledged());
        }
    }

    public static class DatafeedParams
    implements XPackPlugin.XPackPersistentTaskParams {
        public static ObjectParser<DatafeedParams, Void> PARSER = new ObjectParser("xpack/ml/datafeed", DatafeedParams::new);
        private String datafeedId;
        private long startTime;
        private Long endTime;
        private TimeValue timeout = TimeValue.timeValueSeconds((long)20L);

        static long parseDateOrThrow(String date, ParseField paramName, LongSupplier now) {
            DateMathParser dateMathParser = new DateMathParser(DateFieldMapper.DEFAULT_DATE_TIME_FORMATTER);
            try {
                return dateMathParser.parse(date, now);
            }
            catch (Exception e) {
                String msg = Messages.getMessage("Query param [{0}] with value [{1}] cannot be parsed as a date or converted to a number (epoch).", paramName.getPreferredName(), date);
                throw new ElasticsearchParseException(msg, (Throwable)e, new Object[0]);
            }
        }

        public static DatafeedParams fromXContent(XContentParser parser) {
            return DatafeedParams.parseRequest(null, parser);
        }

        public static DatafeedParams parseRequest(String datafeedId, XContentParser parser) {
            DatafeedParams params = (DatafeedParams)PARSER.apply(parser, null);
            if (datafeedId != null) {
                params.datafeedId = datafeedId;
            }
            return params;
        }

        public DatafeedParams(String datafeedId, long startTime) {
            this.datafeedId = ExceptionsHelper.requireNonNull(datafeedId, DatafeedConfig.ID.getPreferredName());
            this.startTime = startTime;
        }

        public DatafeedParams(String datafeedId, String startTime) {
            this(datafeedId, DatafeedParams.parseDateOrThrow(startTime, START_TIME, System::currentTimeMillis));
        }

        public DatafeedParams(StreamInput in) throws IOException {
            this.datafeedId = in.readString();
            this.startTime = in.readVLong();
            this.endTime = in.readOptionalLong();
            this.timeout = TimeValue.timeValueMillis((long)in.readVLong());
        }

        DatafeedParams() {
        }

        public String getDatafeedId() {
            return this.datafeedId;
        }

        public long getStartTime() {
            return this.startTime;
        }

        public Long getEndTime() {
            return this.endTime;
        }

        public void setEndTime(String endTime) {
            this.setEndTime(DatafeedParams.parseDateOrThrow(endTime, END_TIME, System::currentTimeMillis));
        }

        public void setEndTime(Long endTime) {
            this.endTime = endTime;
        }

        public TimeValue getTimeout() {
            return this.timeout;
        }

        public void setTimeout(TimeValue timeout) {
            this.timeout = timeout;
        }

        public String getWriteableName() {
            return StartDatafeedAction.TASK_NAME;
        }

        public Version getMinimalSupportedVersion() {
            return Version.CURRENT.minimumCompatibilityVersion();
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.datafeedId);
            out.writeVLong(this.startTime);
            out.writeOptionalLong(this.endTime);
            out.writeVLong(this.timeout.millis());
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(DatafeedConfig.ID.getPreferredName(), this.datafeedId);
            builder.field(START_TIME.getPreferredName(), String.valueOf(this.startTime));
            if (this.endTime != null) {
                builder.field(END_TIME.getPreferredName(), String.valueOf(this.endTime));
            }
            builder.field(TIMEOUT.getPreferredName(), this.timeout.getStringRep());
            builder.endObject();
            return builder;
        }

        public int hashCode() {
            return Objects.hash(this.datafeedId, this.startTime, this.endTime, this.timeout);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            DatafeedParams other = (DatafeedParams)obj;
            return Objects.equals(this.datafeedId, other.datafeedId) && Objects.equals(this.startTime, other.startTime) && Objects.equals(this.endTime, other.endTime) && Objects.equals(this.timeout, other.timeout);
        }

        static {
            PARSER.declareString((params, datafeedId) -> {
                params.datafeedId = datafeedId;
            }, DatafeedConfig.ID);
            PARSER.declareString((params, startTime) -> {
                params.startTime = DatafeedParams.parseDateOrThrow(startTime, START_TIME, System::currentTimeMillis);
            }, START_TIME);
            PARSER.declareString(DatafeedParams::setEndTime, END_TIME);
            PARSER.declareString((params, val) -> params.setTimeout(TimeValue.parseTimeValue((String)val, (String)TIMEOUT.getPreferredName())), TIMEOUT);
        }
    }

    public static class Request
    extends MasterNodeRequest<Request>
    implements ToXContentObject {
        private DatafeedParams params;

        public static Request fromXContent(XContentParser parser) {
            return Request.parseRequest(null, parser);
        }

        public static Request parseRequest(String datafeedId, XContentParser parser) {
            DatafeedParams params = (DatafeedParams)DatafeedParams.PARSER.apply(parser, null);
            if (datafeedId != null) {
                params.datafeedId = datafeedId;
            }
            return new Request(params);
        }

        public Request(String datafeedId, long startTime) {
            this.params = new DatafeedParams(datafeedId, startTime);
        }

        public Request(String datafeedId, String startTime) {
            this.params = new DatafeedParams(datafeedId, startTime);
        }

        public Request(DatafeedParams params) {
            this.params = params;
        }

        public Request(StreamInput in) throws IOException {
            this.readFrom(in);
        }

        public Request() {
        }

        public DatafeedParams getParams() {
            return this.params;
        }

        public ActionRequestValidationException validate() {
            ActionRequestValidationException e = null;
            if (this.params.endTime != null && this.params.endTime <= this.params.startTime) {
                e = ValidateActions.addValidationError((String)(START_TIME.getPreferredName() + " [" + this.params.startTime + "] must be earlier than " + END_TIME.getPreferredName() + " [" + this.params.endTime + "]"), e);
            }
            return e;
        }

        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.params = new DatafeedParams(in);
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.params.writeTo(out);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            this.params.toXContent(builder, params);
            return builder;
        }

        public int hashCode() {
            return Objects.hash(this.params);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            Request other = (Request)((Object)obj);
            return Objects.equals(this.params, other.params);
        }
    }
}

