/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless;

import java.lang.invoke.MethodType;
import java.lang.reflect.Modifier;
import org.elasticsearch.painless.WriterConstants;
import org.elasticsearch.painless.lookup.PainlessClass;
import org.elasticsearch.painless.lookup.PainlessLookup;
import org.elasticsearch.painless.lookup.PainlessLookupUtility;
import org.elasticsearch.painless.lookup.PainlessMethod;
import org.objectweb.asm.Type;

public class FunctionRef {
    public final String interfaceMethodName;
    public final MethodType factoryMethodType;
    public final MethodType interfaceMethodType;
    public final String delegateClassName;
    public final int delegateInvokeType;
    public final String delegateMethodName;
    public final MethodType delegateMethodType;
    public final PainlessMethod interfaceMethod;
    public final PainlessMethod delegateMethod;
    public final String factoryDescriptor;
    public final Type interfaceType;
    public final Type delegateType;
    public final boolean isDelegateInterface;

    public FunctionRef(PainlessLookup painlessLookup, Class<?> expected, String type, String call, int numCaptures) {
        this(expected, painlessLookup.getPainlessStructFromJavaClass(expected).functionalMethod, FunctionRef.lookup(painlessLookup, expected, type, call, numCaptures > 0), numCaptures);
    }

    public FunctionRef(Class<?> expected, PainlessMethod interfaceMethod, PainlessMethod delegateMethod, int numCaptures) {
        MethodType delegateMethodType = delegateMethod.getMethodType();
        this.interfaceMethodName = interfaceMethod.name;
        this.factoryMethodType = MethodType.methodType(expected, delegateMethodType.dropParameterTypes(numCaptures, delegateMethodType.parameterCount()));
        this.interfaceMethodType = interfaceMethod.getMethodType().dropParameterTypes(0, 1);
        if (delegateMethod.target == null) {
            this.delegateClassName = WriterConstants.CLASS_NAME;
            this.isDelegateInterface = false;
        } else if (delegateMethod.augmentation != null) {
            this.delegateClassName = delegateMethod.augmentation.getName();
            this.isDelegateInterface = delegateMethod.augmentation.isInterface();
        } else {
            this.delegateClassName = delegateMethod.target.getName();
            this.isDelegateInterface = delegateMethod.target.isInterface();
        }
        this.delegateInvokeType = "<init>".equals(delegateMethod.name) ? 8 : (Modifier.isStatic(delegateMethod.modifiers) ? 6 : (delegateMethod.target.isInterface() ? 9 : 5));
        this.delegateMethodName = delegateMethod.name;
        this.delegateMethodType = delegateMethodType.dropParameterTypes(0, numCaptures);
        this.interfaceMethod = interfaceMethod;
        this.delegateMethod = delegateMethod;
        this.factoryDescriptor = this.factoryMethodType.toMethodDescriptorString();
        this.interfaceType = Type.getMethodType((String)this.interfaceMethodType.toMethodDescriptorString());
        this.delegateType = Type.getMethodType((String)this.delegateMethodType.toMethodDescriptorString());
    }

    public FunctionRef(Class<?> expected, PainlessMethod interfaceMethod, String delegateMethodName, MethodType delegateMethodType, int numCaptures) {
        this.interfaceMethodName = interfaceMethod.name;
        this.factoryMethodType = MethodType.methodType(expected, delegateMethodType.dropParameterTypes(numCaptures, delegateMethodType.parameterCount()));
        this.interfaceMethodType = interfaceMethod.getMethodType().dropParameterTypes(0, 1);
        this.delegateClassName = WriterConstants.CLASS_NAME;
        this.delegateInvokeType = 6;
        this.delegateMethodName = delegateMethodName;
        this.delegateMethodType = delegateMethodType.dropParameterTypes(0, numCaptures);
        this.isDelegateInterface = false;
        this.interfaceMethod = null;
        this.delegateMethod = null;
        this.factoryDescriptor = null;
        this.interfaceType = null;
        this.delegateType = null;
    }

    private static PainlessMethod lookup(PainlessLookup painlessLookup, Class<?> expected, String type, String call, boolean receiverCaptured) {
        PainlessMethod impl;
        PainlessMethod method = painlessLookup.getPainlessStructFromJavaClass(expected).functionalMethod;
        if (method == null) {
            throw new IllegalArgumentException("Cannot convert function reference [" + type + "::" + call + "] to [" + PainlessLookupUtility.typeToCanonicalTypeName(expected) + "], not a functional interface");
        }
        PainlessClass struct = painlessLookup.getPainlessStructFromJavaClass(painlessLookup.getJavaClassFromPainlessType(type));
        if ("new".equals(call)) {
            impl = struct.constructors.get(PainlessLookupUtility.buildPainlessMethodKey("<init>", method.arguments.size()));
        } else {
            PainlessMethod staticImpl = struct.staticMethods.get(PainlessLookupUtility.buildPainlessMethodKey(call, method.arguments.size()));
            if (staticImpl == null) {
                int arity = receiverCaptured ? method.arguments.size() : method.arguments.size() - 1;
                impl = struct.methods.get(PainlessLookupUtility.buildPainlessMethodKey(call, arity));
            } else {
                impl = staticImpl;
            }
        }
        if (impl == null) {
            throw new IllegalArgumentException("Unknown reference [" + type + "::" + call + "] matching [" + expected + "]");
        }
        return impl;
    }
}

