/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc.esnative.tool;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.util.Collections;
import java.util.List;
import javax.net.ssl.HttpsURLConnection;
import org.elasticsearch.common.CheckedFunction;
import org.elasticsearch.common.CheckedSupplier;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.SuppressForbidden;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.common.lease.Releasables;
import org.elasticsearch.common.network.InetAddresses;
import org.elasticsearch.common.network.NetworkService;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.PortsRange;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.env.Environment;
import org.elasticsearch.http.HttpTransportSettings;
import org.elasticsearch.xpack.core.XPackSettings;
import org.elasticsearch.xpack.core.common.socket.SocketAccess;
import org.elasticsearch.xpack.core.security.authc.support.UsernamePasswordToken;
import org.elasticsearch.xpack.core.ssl.SSLConfiguration;
import org.elasticsearch.xpack.core.ssl.SSLService;
import org.elasticsearch.xpack.security.authc.esnative.tool.HttpResponse;

public class CommandLineHttpClient {
    private static final int READ_TIMEOUT = 35000;
    private final Settings settings;
    private final Environment env;

    public CommandLineHttpClient(Settings settings, Environment env) {
        this.settings = settings;
        this.env = env;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressForbidden(reason="We call connect in doPrivileged and provide SocketPermission")
    public HttpResponse execute(String method, URL url, String user, SecureString password, CheckedSupplier<String, Exception> requestBodySupplier, CheckedFunction<InputStream, HttpResponse.HttpResponseBuilder, Exception> responseHandler) throws Exception {
        HttpURLConnection conn;
        if ("https".equalsIgnoreCase(url.getProtocol())) {
            SSLService sslService = new SSLService(this.settings, this.env);
            HttpsURLConnection httpsConn = (HttpsURLConnection)url.openConnection();
            AccessController.doPrivileged(() -> {
                SSLConfiguration sslConfiguration = sslService.getHttpTransportSSLConfiguration();
                httpsConn.setSSLSocketFactory(sslService.sslSocketFactory(sslConfiguration));
                boolean isHostnameVerificationEnabled = sslConfiguration.verificationMode().isHostnameVerificationEnabled();
                if (!isHostnameVerificationEnabled) {
                    httpsConn.setHostnameVerifier((hostname, session) -> true);
                }
                return null;
            });
            conn = httpsConn;
        } else {
            conn = (HttpURLConnection)url.openConnection();
        }
        conn.setRequestMethod(method);
        conn.setReadTimeout(35000);
        String token = UsernamePasswordToken.basicAuthHeaderValue((String)user, (SecureString)password);
        conn.setRequestProperty("Authorization", token);
        conn.setRequestProperty("Content-Type", XContentType.JSON.mediaType());
        String bodyString = (String)requestBodySupplier.get();
        conn.setDoOutput(bodyString != null);
        SocketAccess.doPrivileged(conn::connect);
        if (bodyString != null) {
            try (OutputStream out = conn.getOutputStream();){
                out.write(bodyString.getBytes(StandardCharsets.UTF_8));
            }
            catch (Exception e) {
                Releasable[] releasableArray = new Releasable[1];
                releasableArray[0] = conn::disconnect;
                Releasables.closeWhileHandlingException((Releasable[])releasableArray);
                throw e;
            }
        }
        int responseCode = conn.getResponseCode();
        HttpResponse.HttpResponseBuilder responseBuilder = null;
        try (InputStream inputStream = conn.getInputStream();){
            responseBuilder = (HttpResponse.HttpResponseBuilder)responseHandler.apply((Object)inputStream);
        }
        catch (IOException e) {
            try (InputStream errorStream = conn.getErrorStream();){
                responseBuilder = (HttpResponse.HttpResponseBuilder)responseHandler.apply((Object)errorStream);
            }
            catch (Throwable throwable) {
                Releasable[] releasableArray = new Releasable[1];
                releasableArray[0] = conn::disconnect;
                Releasables.closeWhileHandlingException((Releasable[])releasableArray);
                throw throwable;
            }
            Releasable[] releasableArray = new Releasable[1];
            releasableArray[0] = conn::disconnect;
            Releasables.closeWhileHandlingException((Releasable[])releasableArray);
        }
        Releasable[] releasableArray = new Releasable[1];
        releasableArray[0] = conn::disconnect;
        Releasables.closeWhileHandlingException((Releasable[])releasableArray);
        responseBuilder.withHttpStatus(responseCode);
        return responseBuilder.build();
    }

    String getDefaultURL() {
        String scheme = (Boolean)XPackSettings.HTTP_SSL_ENABLED.get(this.settings) != false ? "https" : "http";
        List httpPublishHost = (List)HttpTransportSettings.SETTING_HTTP_PUBLISH_HOST.get(this.settings);
        if (httpPublishHost.isEmpty()) {
            httpPublishHost = (List)NetworkService.GLOBAL_NETWORK_PUBLISHHOST_SETTING.get(this.settings);
        }
        NetworkService networkService = new NetworkService(Collections.emptyList());
        try {
            InetAddress publishAddress = networkService.resolvePublishHostAddresses(httpPublishHost.toArray(Strings.EMPTY_ARRAY));
            int port = (Integer)HttpTransportSettings.SETTING_HTTP_PUBLISH_PORT.get(this.settings);
            if (port <= 0) {
                int[] ports = ((PortsRange)HttpTransportSettings.SETTING_HTTP_PORT.get(this.settings)).ports();
                if (ports.length > 0) {
                    port = ports[0];
                }
                if (port <= 0) {
                    throw new IllegalStateException("unable to determine http port from settings, please use the -u option to provide the url");
                }
            }
            return scheme + "://" + InetAddresses.toUriString((InetAddress)publishAddress) + ":" + port;
        }
        catch (IOException e) {
            throw new UncheckedIOException("failed to resolve default URL", e);
        }
    }
}

