/*
 * Decompiled with CFR 0.152.
 */
package org.fibs.geotag.webserver;

import com.topografix.gpx._1._0.BoundsType;
import com.topografix.gpx._1._0.Gpx;
import com.topografix.gpx._1._0.ObjectFactory;
import fi.iki.elonen.NanoHTTPD;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import org.fibs.geotag.track.TrackStore;
import org.fibs.geotag.util.BoundsTypeUtil;
import org.fibs.geotag.webserver.ContextHandler;
import org.fibs.geotag.webserver.WebServer;

public class TracksHandler
implements ContextHandler {
    @Override
    public NanoHTTPD.Response serve(WebServer server, String uri, String method, Properties header, Properties parms) {
        Double south = null;
        Double west = null;
        Double north = null;
        Double east = null;
        Integer width = null;
        Integer height = null;
        Enumeration<Object> parameters = parms.keys();
        while (parameters.hasMoreElements()) {
            String parameter = (String)parameters.nextElement();
            String value = parms.getProperty(parameter);
            if (parameter.equals("south")) {
                south = new Double(Double.parseDouble(value));
                continue;
            }
            if (parameter.equals("west")) {
                west = new Double(Double.parseDouble(value));
                continue;
            }
            if (parameter.equals("north")) {
                north = new Double(Double.parseDouble(value));
                continue;
            }
            if (parameter.equals("east")) {
                east = new Double(Double.parseDouble(value));
                continue;
            }
            if (parameter.equals("width")) {
                width = Integer.parseInt(value);
                continue;
            }
            if (!parameter.equals("height")) continue;
            height = Integer.parseInt(value);
        }
        ObjectFactory gpxObjectFactory = new ObjectFactory();
        if (south != null && west != null && north != null && east != null && width != null && height != null) {
            BoundsType mapBounds = gpxObjectFactory.createBoundsType();
            mapBounds.setMinlat(new BigDecimal(south));
            mapBounds.setMaxlat(new BigDecimal(north));
            mapBounds.setMinlon(new BigDecimal(west));
            mapBounds.setMaxlon(new BigDecimal(east));
            ArrayList<Gpx.Trk.Trkseg> segments = new ArrayList<Gpx.Trk.Trkseg>();
            for (Gpx.Trk.Trkseg segment : TrackStore.getTrackStore().getIntersectingTrackSegments(mapBounds)) {
                segments.add(segment);
            }
            List<Gpx.Trk.Trkseg> filteredSegments = this.filterSegments(mapBounds, segments, width, height);
            return server.xmlResponse(this.tracksToXml(filteredSegments));
        }
        WebServer webServer = server;
        webServer.getClass();
        return (NanoHTTPD)webServer.new NanoHTTPD.Response("404 Not Found", "text/plain", WebServer.FILE_NOT_FOUND);
    }

    private boolean isOnMap(Gpx.Trk.Trkseg.Trkpt trackPoint, BoundsType mapBounds) {
        BigDecimal latitude = trackPoint.getLat();
        BigDecimal longitude = trackPoint.getLon();
        if (latitude.compareTo(mapBounds.getMinlat()) < 0) {
            return false;
        }
        if (latitude.compareTo(mapBounds.getMaxlat()) > 0) {
            return false;
        }
        if (longitude.compareTo(mapBounds.getMinlon()) < 0) {
            return false;
        }
        return longitude.compareTo(mapBounds.getMaxlon()) <= 0;
    }

    private List<Gpx.Trk.Trkseg> filterSegments(BoundsType mapBounds, List<Gpx.Trk.Trkseg> segments, int mapWidth, int mapHeight) {
        int numberUnfiltered = 0;
        int numberFiltered = 0;
        ArrayList<Gpx.Trk.Trkseg> filteredList = new ArrayList<Gpx.Trk.Trkseg>();
        ObjectFactory gpxObjectFactory = new ObjectFactory();
        for (Gpx.Trk.Trkseg segment : segments) {
            Gpx.Trk.Trkseg filteredSegment = gpxObjectFactory.createGpxTrkTrkseg();
            Gpx.Trk.Trkseg.Trkpt lastPointOffMap = null;
            Gpx.Trk.Trkseg.Trkpt lastPointOnMap = null;
            Gpx.Trk.Trkseg.Trkpt lastPointAdded = null;
            for (Gpx.Trk.Trkseg.Trkpt trackPoint : segment.getTrkpt()) {
                ++numberUnfiltered;
                if (this.isOnMap(trackPoint, mapBounds)) {
                    lastPointOnMap = trackPoint;
                    if (lastPointOffMap != null) {
                        filteredSegment.getTrkpt().add(lastPointOffMap);
                        lastPointAdded = lastPointOffMap;
                        lastPointOffMap = null;
                    }
                    int tooClose = 10;
                    if (lastPointAdded != null && !(BoundsTypeUtil.pixelDistance(lastPointAdded, trackPoint, mapBounds, mapWidth, mapHeight) > 10.0)) continue;
                    filteredSegment.getTrkpt().add(trackPoint);
                    lastPointAdded = trackPoint;
                    continue;
                }
                lastPointOffMap = trackPoint;
                if (lastPointOnMap == null) continue;
                filteredSegment.getTrkpt().add(trackPoint);
                lastPointOnMap = null;
            }
            if (filteredSegment.getTrkpt().size() <= 0) continue;
            filteredList.add(filteredSegment);
            numberFiltered += filteredSegment.getTrkpt().size();
        }
        System.out.println("Filter: " + numberUnfiltered + "->" + numberFiltered);
        return filteredList;
    }

    private String tracksToXml(List<Gpx.Trk.Trkseg> segments) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<tracks>\n");
        int trackPoints = 0;
        for (Gpx.Trk.Trkseg trkseg : segments) {
            trackPoints += trkseg.getTrkpt().size();
            stringBuilder.append(" <track>\n");
            for (Gpx.Trk.Trkseg.Trkpt trackPoint : trkseg.getTrkpt()) {
                stringBuilder.append("  <point latitude=\"");
                stringBuilder.append(trackPoint.getLat().toString());
                stringBuilder.append("\" longitude=\"");
                stringBuilder.append(trackPoint.getLon().toString());
                stringBuilder.append("\"/>\n");
            }
            stringBuilder.append(" </track>\n");
        }
        stringBuilder.append("</tracks>");
        return stringBuilder.toString();
    }
}

