/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.publish.plugins;

import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.dsl.RepositoryHandler;
import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.api.internal.FeaturePreviews;
import org.gradle.api.internal.artifacts.ArtifactPublicationServices;
import org.gradle.api.internal.artifacts.ivyservice.projectmodule.ProjectPublication;
import org.gradle.api.internal.artifacts.ivyservice.projectmodule.ProjectPublicationRegistry;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.publish.Publication;
import org.gradle.api.publish.PublicationContainer;
import org.gradle.api.publish.PublishingExtension;
import org.gradle.api.publish.internal.DefaultPublicationContainer;
import org.gradle.api.publish.internal.DefaultPublishingExtension;
import org.gradle.api.publish.internal.DeferredConfigurablePublishingExtension;
import org.gradle.api.publish.internal.PublicationInternal;
import org.gradle.api.publish.plugins.PublishingPluginRules;
import org.gradle.internal.model.RuleBasedPluginListener;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.util.DeprecationLogger;

public class PublishingPlugin
implements Plugin<Project> {
    public static final String PUBLISH_TASK_GROUP = "publishing";
    public static final String PUBLISH_LIFECYCLE_TASK_NAME = "publish";
    private final Instantiator instantiator;
    private final ArtifactPublicationServices publicationServices;
    private final ProjectPublicationRegistry projectPublicationRegistry;
    private final FeaturePreviews featurePreviews;
    private final DocumentationRegistry documentationRegistry;

    @Inject
    public PublishingPlugin(ArtifactPublicationServices publicationServices, Instantiator instantiator, ProjectPublicationRegistry projectPublicationRegistry, FeaturePreviews featurePreviews, DocumentationRegistry documentationRegistry) {
        this.publicationServices = publicationServices;
        this.instantiator = instantiator;
        this.projectPublicationRegistry = projectPublicationRegistry;
        this.featurePreviews = featurePreviews;
        this.documentationRegistry = documentationRegistry;
    }

    public void apply(final Project project) {
        RepositoryHandler repositories = this.publicationServices.createRepositoryHandler();
        PublicationContainer publications = (PublicationContainer)this.instantiator.newInstance(DefaultPublicationContainer.class, new Object[]{this.instantiator});
        PublishingExtension extension = (PublishingExtension)project.getExtensions().create(PublishingExtension.class, PUBLISH_TASK_GROUP, this.determineExtensionClass(), new Object[]{repositories, publications});
        project.getTasks().register(PUBLISH_LIFECYCLE_TASK_NAME, (Action)new Action<Task>(){

            public void execute(Task task) {
                task.setDescription("Publishes all publications produced by this project.");
                task.setGroup(PublishingPlugin.PUBLISH_TASK_GROUP);
            }
        });
        extension.getPublications().all((Action)new Action<Publication>(){

            public void execute(Publication publication) {
                PublicationInternal internalPublication = (PublicationInternal)publication;
                PublishingPlugin.this.projectPublicationRegistry.registerPublication(project.getPath(), (ProjectPublication)internalPublication);
            }
        });
        this.bridgeToSoftwareModelIfNeeded((ProjectInternal)project);
    }

    private Class<? extends PublishingExtension> determineExtensionClass() {
        if (this.featurePreviews.isFeatureEnabled(FeaturePreviews.Feature.STABLE_PUBLISHING)) {
            return DefaultPublishingExtension.class;
        }
        DeprecationLogger.nagUserWithDeprecatedBuildInvocationFeature((String)"As part of making the publishing plugins stable, the 'deferred configurable' behavior of the 'publishing {}' block", (String)"In Gradle 5.0 the 'enableFeaturePreview('STABLE_PUBLISHING')' flag will be removed and the new behavior will become the default.", (String)("Please add 'enableFeaturePreview('STABLE_PUBLISHING')' to your settings file and do a test run by publishing to a local repository. If all artifacts are published as expected, there is nothing else to do. If the published artifacts change unexpectedly, please see the migration guide for more details: " + this.documentationRegistry.getDocumentationFor("publishing_maven", "publishing_maven:deferred_configuration") + "."));
        return DeferredConfigurablePublishingExtension.class;
    }

    private void bridgeToSoftwareModelIfNeeded(ProjectInternal project) {
        if (this.featurePreviews.isFeatureEnabled(FeaturePreviews.Feature.STABLE_PUBLISHING)) {
            project.addRuleBasedPluginListener(new RuleBasedPluginListener(){

                public void prepareForRuleBasedPlugins(Project project) {
                    project.getPluginManager().apply(PublishingPluginRules.class);
                }
            });
        } else {
            project.getPluginManager().apply(PublishingPluginRules.class);
        }
    }
}

