/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins;

import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.ActionConfiguration;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.type.ArtifactTypeDefinition;
import org.gradle.api.attributes.AttributeCompatibilityRule;
import org.gradle.api.attributes.AttributeDisambiguationRule;
import org.gradle.api.attributes.AttributeMatchingStrategy;
import org.gradle.api.attributes.CompatibilityCheckDetails;
import org.gradle.api.attributes.MultipleCandidatesDetails;
import org.gradle.api.attributes.Usage;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.internal.ConventionMapping;
import org.gradle.api.internal.IConventionAware;
import org.gradle.api.internal.plugins.DslObject;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.BasePlugin;
import org.gradle.api.plugins.JavaBasePluginRules;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.plugins.ReportingBasePlugin;
import org.gradle.api.plugins.internal.DefaultJavaPluginExtension;
import org.gradle.api.plugins.internal.SourceSetUtil;
import org.gradle.api.reporting.ReportingExtension;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.compile.AbstractCompile;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.api.tasks.javadoc.Javadoc;
import org.gradle.api.tasks.testing.Test;
import org.gradle.internal.Factory;
import org.gradle.internal.model.RuleBasedPluginListener;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.language.jvm.tasks.ProcessResources;
import org.gradle.util.DeprecationLogger;
import org.gradle.util.SingleMessageLogger;

public class JavaBasePlugin
implements Plugin<ProjectInternal> {
    public static final String CHECK_TASK_NAME = "check";
    public static final String VERIFICATION_GROUP = "verification";
    public static final String BUILD_TASK_NAME = "build";
    public static final String BUILD_DEPENDENTS_TASK_NAME = "buildDependents";
    public static final String BUILD_NEEDED_TASK_NAME = "buildNeeded";
    public static final String DOCUMENTATION_GROUP = "documentation";
    private final Instantiator instantiator;
    private final ObjectFactory objectFactory;

    @Inject
    public JavaBasePlugin(Instantiator instantiator, ObjectFactory objectFactory) {
        this.instantiator = instantiator;
        this.objectFactory = objectFactory;
    }

    public void apply(ProjectInternal project) {
        project.getPluginManager().apply(BasePlugin.class);
        project.getPluginManager().apply(ReportingBasePlugin.class);
        JavaPluginConvention javaConvention = this.addExtensions(project);
        this.configureSourceSetDefaults(javaConvention);
        this.configureCompileDefaults((Project)project, javaConvention);
        this.configureJavaDoc((Project)project, javaConvention);
        this.configureTest((Project)project, javaConvention);
        this.configureBuildNeeded((Project)project);
        this.configureBuildDependents((Project)project);
        this.configureSchema(project);
        this.bridgeToSoftwareModelIfNecessary(project);
    }

    private JavaPluginConvention addExtensions(final ProjectInternal project) {
        JavaPluginConvention javaConvention = (JavaPluginConvention)DeprecationLogger.whileDisabled((Factory)new Factory<JavaPluginConvention>(){

            public JavaPluginConvention create() {
                return new JavaPluginConvention(project, JavaBasePlugin.this.instantiator);
            }
        });
        project.getConvention().getPlugins().put("java", javaConvention);
        project.getExtensions().add(SourceSetContainer.class, "sourceSets", (Object)javaConvention.getSourceSets());
        project.getExtensions().create(JavaPluginExtension.class, "java", DefaultJavaPluginExtension.class, new Object[]{javaConvention});
        return javaConvention;
    }

    private void bridgeToSoftwareModelIfNecessary(ProjectInternal project) {
        project.addRuleBasedPluginListener(new RuleBasedPluginListener(){

            public void prepareForRuleBasedPlugins(Project project) {
                project.getPluginManager().apply(JavaBasePluginRules.class);
            }
        });
    }

    private void configureSchema(ProjectInternal project) {
        AttributeMatchingStrategy matchingStrategy = project.getDependencies().getAttributesSchema().attribute(Usage.USAGE_ATTRIBUTE);
        matchingStrategy.getCompatibilityRules().add(UsageCompatibilityRules.class);
        matchingStrategy.getDisambiguationRules().add(UsageDisambiguationRules.class, (Action)new Action<ActionConfiguration>(){

            public void execute(ActionConfiguration actionConfiguration) {
                actionConfiguration.params(new Object[]{JavaBasePlugin.this.objectFactory.named(Usage.class, "java-api")});
                actionConfiguration.params(new Object[]{JavaBasePlugin.this.objectFactory.named(Usage.class, "java-api-classes")});
                actionConfiguration.params(new Object[]{JavaBasePlugin.this.objectFactory.named(Usage.class, "java-runtime-jars")});
                actionConfiguration.params(new Object[]{JavaBasePlugin.this.objectFactory.named(Usage.class, "java-runtime-classes")});
                actionConfiguration.params(new Object[]{JavaBasePlugin.this.objectFactory.named(Usage.class, "java-runtime-resources")});
            }
        });
        ((ArtifactTypeDefinition)project.getDependencies().getArtifactTypes().create("jar")).getAttributes().attribute(Usage.USAGE_ATTRIBUTE, (Object)this.objectFactory.named(Usage.class, "java-runtime-jars"));
    }

    private void configureSourceSetDefaults(JavaPluginConvention pluginConvention) {
        ProjectInternal project = pluginConvention.getProject();
        pluginConvention.getSourceSets().all((Action)new Action<SourceSet>((Project)project){
            final /* synthetic */ Project val$project;
            {
                this.val$project = project;
            }

            public void execute(SourceSet sourceSet) {
                ConventionMapping outputConventionMapping = ((IConventionAware)sourceSet.getOutput()).getConventionMapping();
                ConfigurationContainer configurations = this.val$project.getConfigurations();
                JavaBasePlugin.this.defineConfigurationsForSourceSet(sourceSet, configurations);
                JavaBasePlugin.this.definePathsForSourceSet(sourceSet, outputConventionMapping, this.val$project);
                SourceSetUtil.configureOutputDirectoryForSourceSet(sourceSet, sourceSet.getJava(), this.val$project);
                JavaBasePlugin.this.createProcessResourcesTask(sourceSet, sourceSet.getResources(), this.val$project);
                JavaBasePlugin.this.createCompileJavaTask(sourceSet, sourceSet.getJava(), this.val$project);
                JavaBasePlugin.this.createClassesTask(sourceSet, this.val$project);
            }
        });
    }

    private void createCompileJavaTask(final SourceSet sourceSet, final SourceDirectorySet sourceDirectorySet, final Project target) {
        target.getTasks().register(sourceSet.getCompileJavaTaskName(), JavaCompile.class, (Action)new Action<JavaCompile>(){

            public void execute(JavaCompile compileTask) {
                compileTask.setDescription("Compiles " + sourceDirectorySet + ".");
                compileTask.setSource((FileTree)sourceDirectorySet);
                ConventionMapping conventionMapping = compileTask.getConventionMapping();
                conventionMapping.map("classpath", (Callable)new Callable<Object>(){

                    @Override
                    public Object call() {
                        return sourceSet.getCompileClasspath();
                    }
                });
                SourceSetUtil.configureAnnotationProcessorPath(sourceSet, compileTask.getOptions(), target);
                compileTask.setDestinationDir(target.provider((Callable)new Callable<File>(){

                    @Override
                    public File call() {
                        return sourceDirectorySet.getOutputDir();
                    }
                }));
            }
        });
    }

    private void createProcessResourcesTask(final SourceSet sourceSet, final SourceDirectorySet resourceSet, Project target) {
        target.getTasks().register(sourceSet.getProcessResourcesTaskName(), ProcessResources.class, (Action)new Action<ProcessResources>(){

            public void execute(ProcessResources resourcesTask) {
                resourcesTask.setDescription("Processes " + resourceSet + ".");
                new DslObject((Object)resourcesTask).getConventionMapping().map("destinationDir", (Callable)new Callable<File>(){

                    @Override
                    public File call() {
                        return sourceSet.getOutput().getResourcesDir();
                    }
                });
                resourcesTask.from(new Object[]{resourceSet});
            }
        });
    }

    private void createClassesTask(final SourceSet sourceSet, Project target) {
        TaskProvider classesTask = target.getTasks().register(sourceSet.getClassesTaskName(), (Action)new Action<Task>(){

            public void execute(Task classesTask) {
                classesTask.setGroup(JavaBasePlugin.BUILD_TASK_NAME);
                classesTask.setDescription("Assembles " + sourceSet.getOutput() + ".");
                classesTask.dependsOn(new Object[]{sourceSet.getOutput().getDirs()});
                classesTask.dependsOn(new Object[]{sourceSet.getCompileJavaTaskName()});
                classesTask.dependsOn(new Object[]{sourceSet.getProcessResourcesTaskName()});
            }
        });
        sourceSet.compiledBy(classesTask);
    }

    private void definePathsForSourceSet(final SourceSet sourceSet, ConventionMapping outputConventionMapping, final Project project) {
        outputConventionMapping.map("resourcesDir", (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                String classesDirName = "resources/" + sourceSet.getName();
                return new File(project.getBuildDir(), classesDirName);
            }
        });
        sourceSet.getJava().srcDir((Object)("src/" + sourceSet.getName() + "/java"));
        sourceSet.getResources().srcDir((Object)("src/" + sourceSet.getName() + "/resources"));
    }

    private void defineConfigurationsForSourceSet(SourceSet sourceSet, ConfigurationContainer configurations) {
        String compileConfigurationName = sourceSet.getCompileConfigurationName();
        String implementationConfigurationName = sourceSet.getImplementationConfigurationName();
        String runtimeConfigurationName = sourceSet.getRuntimeConfigurationName();
        String runtimeOnlyConfigurationName = sourceSet.getRuntimeOnlyConfigurationName();
        String compileOnlyConfigurationName = sourceSet.getCompileOnlyConfigurationName();
        String compileClasspathConfigurationName = sourceSet.getCompileClasspathConfigurationName();
        String annotationProcessorConfigurationName = sourceSet.getAnnotationProcessorConfigurationName();
        String runtimeClasspathConfigurationName = sourceSet.getRuntimeClasspathConfigurationName();
        String sourceSetName = sourceSet.toString();
        Configuration compileConfiguration = (Configuration)configurations.maybeCreate(compileConfigurationName);
        compileConfiguration.setVisible(false);
        compileConfiguration.setDescription("Dependencies for " + sourceSetName + " (deprecated, use '" + implementationConfigurationName + "' instead).");
        Configuration implementationConfiguration = (Configuration)configurations.maybeCreate(implementationConfigurationName);
        implementationConfiguration.setVisible(false);
        implementationConfiguration.setDescription("Implementation only dependencies for " + sourceSetName + ".");
        implementationConfiguration.setCanBeConsumed(false);
        implementationConfiguration.setCanBeResolved(false);
        implementationConfiguration.extendsFrom(new Configuration[]{compileConfiguration});
        Configuration runtimeConfiguration = (Configuration)configurations.maybeCreate(runtimeConfigurationName);
        runtimeConfiguration.setVisible(false);
        runtimeConfiguration.extendsFrom(new Configuration[]{compileConfiguration});
        runtimeConfiguration.setDescription("Runtime dependencies for " + sourceSetName + " (deprecated, use '" + runtimeOnlyConfigurationName + "' instead).");
        Configuration compileOnlyConfiguration = (Configuration)configurations.maybeCreate(compileOnlyConfigurationName);
        compileOnlyConfiguration.setVisible(false);
        compileOnlyConfiguration.setDescription("Compile only dependencies for " + sourceSetName + ".");
        Configuration compileClasspathConfiguration = (Configuration)configurations.maybeCreate(compileClasspathConfigurationName);
        compileClasspathConfiguration.setVisible(false);
        compileClasspathConfiguration.extendsFrom(new Configuration[]{compileOnlyConfiguration, implementationConfiguration});
        compileClasspathConfiguration.setDescription("Compile classpath for " + sourceSetName + ".");
        compileClasspathConfiguration.setCanBeConsumed(false);
        compileClasspathConfiguration.getAttributes().attribute(Usage.USAGE_ATTRIBUTE, (Object)this.objectFactory.named(Usage.class, "java-api"));
        Configuration annotationProcessorConfiguration = (Configuration)configurations.maybeCreate(annotationProcessorConfigurationName);
        annotationProcessorConfiguration.setVisible(false);
        annotationProcessorConfiguration.setDescription("Annotation processors and their dependencies for " + sourceSetName + ".");
        annotationProcessorConfiguration.setCanBeConsumed(false);
        annotationProcessorConfiguration.setCanBeResolved(true);
        Configuration runtimeOnlyConfiguration = (Configuration)configurations.maybeCreate(runtimeOnlyConfigurationName);
        runtimeOnlyConfiguration.setVisible(false);
        runtimeOnlyConfiguration.setCanBeConsumed(false);
        runtimeOnlyConfiguration.setCanBeResolved(false);
        runtimeOnlyConfiguration.setDescription("Runtime only dependencies for " + sourceSetName + ".");
        Configuration runtimeClasspathConfiguration = (Configuration)configurations.maybeCreate(runtimeClasspathConfigurationName);
        runtimeClasspathConfiguration.setVisible(false);
        runtimeClasspathConfiguration.setCanBeConsumed(false);
        runtimeClasspathConfiguration.setCanBeResolved(true);
        runtimeClasspathConfiguration.setDescription("Runtime classpath of " + sourceSetName + ".");
        runtimeClasspathConfiguration.extendsFrom(new Configuration[]{runtimeOnlyConfiguration, runtimeConfiguration, implementationConfiguration});
        runtimeClasspathConfiguration.getAttributes().attribute(Usage.USAGE_ATTRIBUTE, (Object)this.objectFactory.named(Usage.class, "java-runtime"));
        sourceSet.setCompileClasspath((FileCollection)compileClasspathConfiguration);
        sourceSet.setRuntimeClasspath(sourceSet.getOutput().plus((FileCollection)runtimeClasspathConfiguration));
        sourceSet.setAnnotationProcessorPath((FileCollection)annotationProcessorConfiguration);
    }

    @Deprecated
    public void configureForSourceSet(final SourceSet sourceSet, final AbstractCompile compile) {
        SingleMessageLogger.nagUserOfDiscontinuedMethod((String)"configureForSourceSet(SourceSet, AbstractCompile)");
        compile.setDescription("Compiles the " + sourceSet.getJava() + ".");
        ConventionMapping conventionMapping = compile.getConventionMapping();
        compile.setSource((FileTree)sourceSet.getJava());
        conventionMapping.map("classpath", (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return sourceSet.getCompileClasspath().plus((FileCollection)compile.getProject().files(new Object[]{sourceSet.getJava().getOutputDir()}));
            }
        });
        conventionMapping.map("destinationDir", (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return sourceSet.getOutput().getClassesDir();
            }
        });
    }

    private void configureCompileDefaults(Project project, final JavaPluginConvention javaConvention) {
        project.getTasks().withType(AbstractCompile.class).configureEach((Action)new Action<AbstractCompile>(){

            public void execute(AbstractCompile compile) {
                ConventionMapping conventionMapping = compile.getConventionMapping();
                conventionMapping.map("sourceCompatibility", (Callable)new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        return javaConvention.getSourceCompatibility().toString();
                    }
                });
                conventionMapping.map("targetCompatibility", (Callable)new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        return javaConvention.getTargetCompatibility().toString();
                    }
                });
            }
        });
    }

    private void configureJavaDoc(final Project project, final JavaPluginConvention convention) {
        project.getTasks().withType(Javadoc.class).configureEach((Action)new Action<Javadoc>(){

            public void execute(Javadoc javadoc) {
                javadoc.getConventionMapping().map("destinationDir", (Callable)new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        return new File(convention.getDocsDir(), "javadoc");
                    }
                });
                javadoc.getConventionMapping().map("title", (Callable)new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        return ((ReportingExtension)project.getExtensions().getByType(ReportingExtension.class)).getApiDocTitle();
                    }
                });
            }
        });
    }

    private void configureBuildNeeded(Project project) {
        project.getTasks().register(BUILD_NEEDED_TASK_NAME, (Action)new Action<Task>(){

            public void execute(Task buildTask) {
                buildTask.setDescription("Assembles and tests this project and all projects it depends on.");
                buildTask.setGroup(JavaBasePlugin.BUILD_TASK_NAME);
                buildTask.dependsOn(new Object[]{JavaBasePlugin.BUILD_TASK_NAME});
            }
        });
    }

    private void configureBuildDependents(Project project) {
        project.getTasks().register(BUILD_DEPENDENTS_TASK_NAME, (Action)new Action<Task>(){

            public void execute(Task buildTask) {
                buildTask.setDescription("Assembles and tests this project and all projects that depend on it.");
                buildTask.setGroup(JavaBasePlugin.BUILD_TASK_NAME);
                buildTask.dependsOn(new Object[]{JavaBasePlugin.BUILD_TASK_NAME});
                buildTask.doFirst((Action)new Action<Task>(){

                    public void execute(Task task) {
                        if (!task.getProject().getGradle().getIncludedBuilds().isEmpty()) {
                            task.getProject().getLogger().warn("[composite-build] Warning: `" + task.getPath() + "` task does not build included builds.");
                        }
                    }
                });
            }
        });
    }

    private void configureTest(final Project project, final JavaPluginConvention convention) {
        project.getTasks().withType(Test.class).configureEach((Action)new Action<Test>(){

            public void execute(Test test) {
                JavaBasePlugin.this.configureTestDefaults(test, project, convention);
            }
        });
    }

    private void configureTestDefaults(final Test test, Project project, final JavaPluginConvention convention) {
        DslObject htmlReport = new DslObject((Object)test.getReports().getHtml());
        DslObject xmlReport = new DslObject((Object)test.getReports().getJunitXml());
        xmlReport.getConventionMapping().map("destination", (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return new File(convention.getTestResultsDir(), test.getName());
            }
        });
        htmlReport.getConventionMapping().map("destination", (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return new File(convention.getTestReportDir(), test.getName());
            }
        });
        test.getConventionMapping().map("binResultsDir", (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return new File(convention.getTestResultsDir(), test.getName() + "/binary");
            }
        });
        test.workingDir((Object)project.getProjectDir());
    }

    static class UsageCompatibilityRules
    implements AttributeCompatibilityRule<Usage> {
        UsageCompatibilityRules() {
        }

        public void execute(CompatibilityCheckDetails<Usage> details) {
            if (((Usage)details.getConsumerValue()).getName().equals("java-api")) {
                if (((Usage)details.getProducerValue()).getName().equals("java-api-classes")) {
                    details.compatible();
                } else if (((Usage)details.getProducerValue()).getName().equals("java-runtime-jars")) {
                    details.compatible();
                }
            } else if (((Usage)details.getConsumerValue()).getName().equals("java-api-classes")) {
                if (((Usage)details.getProducerValue()).getName().equals("java-api")) {
                    details.compatible();
                } else if (((Usage)details.getProducerValue()).getName().equals("java-runtime-jars")) {
                    details.compatible();
                }
            } else if (((Usage)details.getConsumerValue()).getName().equals("java-runtime") && ((Usage)details.getProducerValue()).getName().equals("java-runtime-jars")) {
                details.compatible();
            } else if (((Usage)details.getConsumerValue()).getName().equals("java-runtime-classes") && ((Usage)details.getProducerValue()).getName().equals("java-runtime-jars")) {
                details.compatible();
            } else if (((Usage)details.getConsumerValue()).getName().equals("java-runtime-resources") && ((Usage)details.getProducerValue()).getName().equals("java-runtime-jars")) {
                details.compatible();
            }
        }
    }

    static class UsageDisambiguationRules
    implements AttributeDisambiguationRule<Usage> {
        final Usage javaApi;
        final Usage javaApiClasses;
        final Usage javaRuntimeJars;
        final Usage javaRuntimeClasses;
        final Usage javaRuntimeResources;
        final ImmutableSet<Usage> javaApiAndJavaApiClasses;
        final ImmutableSet<Usage> javaApiAndJavaRuntimeJars;
        final ImmutableSet<Usage> javaRuntimeJarsAndJavaRuntimeClassesAndJavaRuntimeResources;

        @Inject
        UsageDisambiguationRules(Usage javaApi, Usage javaApiClasses, Usage javaRuntimeJars, Usage javaRuntimeClasses, Usage javaRuntimeResources) {
            this.javaApi = javaApi;
            this.javaApiClasses = javaApiClasses;
            this.javaRuntimeJars = javaRuntimeJars;
            this.javaRuntimeClasses = javaRuntimeClasses;
            this.javaRuntimeResources = javaRuntimeResources;
            this.javaApiAndJavaApiClasses = ImmutableSet.of((Object)javaApi, (Object)javaApiClasses);
            this.javaApiAndJavaRuntimeJars = ImmutableSet.of((Object)javaApi, (Object)javaRuntimeJars);
            this.javaRuntimeJarsAndJavaRuntimeClassesAndJavaRuntimeResources = ImmutableSet.of((Object)javaRuntimeJars, (Object)javaRuntimeClasses, (Object)javaRuntimeResources);
        }

        public void execute(MultipleCandidatesDetails<Usage> details) {
            Usage requested;
            if (details.getCandidateValues().equals(this.javaApiAndJavaApiClasses)) {
                details.closestMatch((Object)this.javaApiClasses);
            } else if (details.getConsumerValue() == null) {
                if (details.getCandidateValues().equals(this.javaApiAndJavaRuntimeJars)) {
                    details.closestMatch((Object)this.javaRuntimeJars);
                } else if (details.getCandidateValues().equals(this.javaRuntimeJarsAndJavaRuntimeClassesAndJavaRuntimeResources)) {
                    details.closestMatch((Object)this.javaRuntimeJars);
                }
            } else if (details.getConsumerValue() != null && ((requested = (Usage)details.getConsumerValue()).getName().equals("java-api") || requested.getName().equals("java-api-classes")) && details.getCandidateValues().equals(this.javaApiAndJavaRuntimeJars)) {
                details.closestMatch((Object)this.javaApi);
            }
        }
    }
}

