/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.psi.Bottom;
import org.jetbrains.kotlin.com.intellij.psi.PsiArrayType;
import org.jetbrains.kotlin.com.intellij.psi.PsiCapturedWildcardType;
import org.jetbrains.kotlin.com.intellij.psi.PsiClassType;
import org.jetbrains.kotlin.com.intellij.psi.PsiDiamondType;
import org.jetbrains.kotlin.com.intellij.psi.PsiDisjunctionType;
import org.jetbrains.kotlin.com.intellij.psi.PsiEllipsisType;
import org.jetbrains.kotlin.com.intellij.psi.PsiIntersectionType;
import org.jetbrains.kotlin.com.intellij.psi.PsiManager;
import org.jetbrains.kotlin.com.intellij.psi.PsiPrimitiveType;
import org.jetbrains.kotlin.com.intellij.psi.PsiType;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeVariable;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeVisitorEx;
import org.jetbrains.kotlin.com.intellij.psi.PsiWildcardType;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;

public abstract class PsiTypeMapper
extends PsiTypeVisitorEx<PsiType> {
    protected static final Logger LOG = Logger.getInstance("#com.intellij.psi.PsiTypeMapper");

    @Nullable
    public <T extends PsiType> T mapType(@NotNull T type2) {
        if (type2 == null) {
            PsiTypeMapper.$$$reportNull$$$0(0);
        }
        return (T)type2.accept(this);
    }

    @Override
    public PsiType visitArrayType(PsiArrayType type2) {
        PsiType componentType = type2.getComponentType();
        PsiType mappedComponent = this.mapType(componentType);
        if (mappedComponent == null) {
            return null;
        }
        if (mappedComponent == componentType) {
            return type2;
        }
        return new PsiArrayType(mappedComponent, type2.getAnnotationProvider());
    }

    @Override
    public PsiType visitEllipsisType(PsiEllipsisType type2) {
        PsiType componentType = type2.getComponentType();
        PsiType mappedComponent = this.mapType(componentType);
        if (mappedComponent == null) {
            return null;
        }
        if (mappedComponent == componentType) {
            return type2;
        }
        return new PsiEllipsisType(mappedComponent, type2.getAnnotationProvider());
    }

    @Override
    public PsiType visitTypeVariable(PsiTypeVariable var) {
        return var;
    }

    @Override
    public PsiType visitBottom(Bottom bottom) {
        return bottom;
    }

    @Override
    public PsiType visitCapturedWildcardType(PsiCapturedWildcardType type2) {
        return type2;
    }

    @Override
    public abstract PsiType visitClassType(PsiClassType var1);

    @Override
    public PsiType visitPrimitiveType(PsiPrimitiveType primitiveType) {
        return primitiveType;
    }

    @Override
    public PsiType visitType(PsiType type2) {
        LOG.error(type2);
        return null;
    }

    @Override
    public PsiType visitWildcardType(PsiWildcardType wildcardType) {
        PsiType bound = wildcardType.getBound();
        PsiManager manager = wildcardType.getManager();
        if (bound == null) {
            return PsiWildcardType.createUnbounded(manager);
        }
        if ((bound = this.mapType(bound)) == null) {
            return null;
        }
        return wildcardType.isExtends() ? PsiWildcardType.createExtends(manager, bound) : PsiWildcardType.createSuper(manager, bound);
    }

    @Override
    @Nullable
    public PsiType visitIntersectionType(PsiIntersectionType intersectionType) {
        List<PsiType> substituted = ContainerUtil.newSmartList();
        for (PsiType component : intersectionType.getConjuncts()) {
            PsiType mapped = this.mapType(component);
            if (mapped == null) {
                return null;
            }
            substituted.add(mapped);
        }
        return PsiIntersectionType.createIntersection(false, substituted.toArray(PsiType.EMPTY_ARRAY));
    }

    @Override
    public PsiType visitDisjunctionType(PsiDisjunctionType disjunctionType) {
        List<PsiType> substituted = ContainerUtil.newSmartList();
        for (PsiType component : disjunctionType.getDisjunctions()) {
            PsiType mapped = this.mapType(component);
            if (mapped == null) {
                return null;
            }
            substituted.add(mapped);
        }
        return disjunctionType.newDisjunctionType(substituted);
    }

    @Override
    public PsiType visitDiamondType(PsiDiamondType diamondType) {
        return diamondType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/com/intellij/psi/PsiTypeMapper", "mapType"));
    }
}

