/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.ide.visualstudio.internal;

import java.io.File;
import java.util.List;
import java.util.Set;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.util.VersionNumber;

public interface VisualStudioTargetBinary {
    @Input
    public String getProjectPath();

    @Input
    public String getComponentName();

    @Input
    public String getVisualStudioProjectName();

    @Input
    public String getVisualStudioConfigurationName();

    public VersionNumber getVisualStudioVersion();

    public VersionNumber getSdkVersion();

    @Input
    public ProjectType getProjectType();

    @Input
    public List<String> getVariantDimensions();

    @Internal
    public FileCollection getSourceFiles();

    @Internal
    public FileCollection getResourceFiles();

    @Internal
    public FileCollection getHeaderFiles();

    @Input
    public boolean isExecutable();

    @Input
    public String getBuildTaskPath();

    @Input
    public String getCleanTaskPath();

    @Input
    public boolean isDebuggable();

    @Internal
    public File getOutputFile();

    @Input
    public List<String> getCompilerDefines();

    @Internal
    public Set<File> getIncludePaths();

    public static enum ProjectType {
        EXE("Exe"),
        LIB("Lib"),
        DLL("Dll"),
        NONE("");

        private final String suffix;

        private ProjectType(String suffix) {
            this.suffix = suffix;
        }

        public String getSuffix() {
            return this.suffix;
        }
    }
}

