/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.cpp.plugins;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.Action;
import org.gradle.api.Incubating;
import org.gradle.api.Named;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.attributes.Usage;
import org.gradle.api.component.SoftwareComponent;
import org.gradle.api.internal.artifacts.dsl.LazyPublishArtifact;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.ImmutableAttributesFactory;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.tasks.TaskContainerInternal;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.AppliedPlugin;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.bundling.Zip;
import org.gradle.language.cpp.CppBinary;
import org.gradle.language.cpp.CppLibrary;
import org.gradle.language.cpp.CppPlatform;
import org.gradle.language.cpp.internal.DefaultCppLibrary;
import org.gradle.language.cpp.internal.DefaultCppSharedLibrary;
import org.gradle.language.cpp.internal.DefaultCppStaticLibrary;
import org.gradle.language.cpp.internal.DefaultUsageContext;
import org.gradle.language.cpp.internal.MainLibraryVariant;
import org.gradle.language.cpp.internal.NativeVariantIdentity;
import org.gradle.language.cpp.plugins.CppBasePlugin;
import org.gradle.language.internal.DefaultBinaryCollection;
import org.gradle.language.internal.NativeComponentFactory;
import org.gradle.language.nativeplatform.internal.toolchains.ToolChainSelector;
import org.gradle.nativeplatform.Linkage;
import org.gradle.nativeplatform.OperatingSystemFamily;
import org.gradle.nativeplatform.platform.internal.DefaultNativePlatform;

@Incubating
public class CppLibraryPlugin
implements Plugin<ProjectInternal> {
    private final NativeComponentFactory componentFactory;
    private final ToolChainSelector toolChainSelector;
    private final ImmutableAttributesFactory attributesFactory;

    @Inject
    public CppLibraryPlugin(NativeComponentFactory componentFactory, ToolChainSelector toolChainSelector, ImmutableAttributesFactory attributesFactory) {
        this.componentFactory = componentFactory;
        this.toolChainSelector = toolChainSelector;
        this.attributesFactory = attributesFactory;
    }

    public void apply(ProjectInternal project) {
        project.getPluginManager().apply(CppBasePlugin.class);
        TaskContainerInternal tasks = project.getTasks();
        final ObjectFactory objectFactory = project.getObjects();
        final ProviderFactory providers = project.getProviders();
        final DefaultCppLibrary library = this.componentFactory.newInstance(CppLibrary.class, DefaultCppLibrary.class, "main");
        project.getExtensions().add(CppLibrary.class, "library", (Object)library);
        project.getComponents().add((Object)library);
        library.getBaseName().set((Object)project.getName());
        project.afterEvaluate((Action)new Action<Project>((TaskContainer)tasks){
            final /* synthetic */ TaskContainer val$tasks;
            {
                this.val$tasks = taskContainer;
            }

            public void execute(final Project project) {
                library.getOperatingSystems().lockNow();
                Set operatingSystemFamilies = (Set)library.getOperatingSystems().get();
                if (operatingSystemFamilies.isEmpty()) {
                    throw new IllegalArgumentException("An operating system needs to be specified for the library.");
                }
                library.getLinkage().lockNow();
                Set linkages = (Set)library.getLinkage().get();
                if (linkages.isEmpty()) {
                    throw new IllegalArgumentException("A linkage needs to be specified for the library.");
                }
                Usage runtimeUsage = (Usage)objectFactory.named(Usage.class, "native-runtime");
                Usage linkUsage = (Usage)objectFactory.named(Usage.class, "native-link");
                for (BuildType buildType : BuildType.DEFAULT_BUILD_TYPES) {
                    for (OperatingSystemFamily operatingSystem : operatingSystemFamilies) {
                        for (Linkage linkage : linkages) {
                            String operatingSystemSuffix = CppLibraryPlugin.this.createDimensionSuffix((Named)operatingSystem, operatingSystemFamilies);
                            String linkageSuffix = CppLibraryPlugin.this.createDimensionSuffix((Named)linkage, linkages);
                            String variantName = buildType.getName() + linkageSuffix + operatingSystemSuffix;
                            Provider group = project.provider((Callable)new Callable<String>(){

                                @Override
                                public String call() throws Exception {
                                    return project.getGroup().toString();
                                }
                            });
                            Provider version = project.provider((Callable)new Callable<String>(){

                                @Override
                                public String call() throws Exception {
                                    return project.getVersion().toString();
                                }
                            });
                            AttributeContainerInternal runtimeAttributes = CppLibraryPlugin.this.attributesFactory.mutable();
                            runtimeAttributes.attribute(Usage.USAGE_ATTRIBUTE, (Object)runtimeUsage);
                            runtimeAttributes.attribute(CppBinary.DEBUGGABLE_ATTRIBUTE, (Object)buildType.isDebuggable());
                            runtimeAttributes.attribute(CppBinary.OPTIMIZED_ATTRIBUTE, (Object)buildType.isOptimized());
                            runtimeAttributes.attribute(CppBinary.LINKAGE_ATTRIBUTE, (Object)linkage);
                            runtimeAttributes.attribute(OperatingSystemFamily.OPERATING_SYSTEM_ATTRIBUTE, (Object)operatingSystem);
                            AttributeContainerInternal linkAttributes = CppLibraryPlugin.this.attributesFactory.mutable();
                            linkAttributes.attribute(Usage.USAGE_ATTRIBUTE, (Object)linkUsage);
                            linkAttributes.attribute(CppBinary.DEBUGGABLE_ATTRIBUTE, (Object)buildType.isDebuggable());
                            linkAttributes.attribute(CppBinary.OPTIMIZED_ATTRIBUTE, (Object)buildType.isOptimized());
                            linkAttributes.attribute(CppBinary.LINKAGE_ATTRIBUTE, (Object)linkage);
                            linkAttributes.attribute(OperatingSystemFamily.OPERATING_SYSTEM_ATTRIBUTE, (Object)operatingSystem);
                            NativeVariantIdentity variantIdentity = new NativeVariantIdentity(variantName, (Provider<String>)library.getBaseName(), (Provider<String>)group, (Provider<String>)version, buildType.isDebuggable(), buildType.isOptimized(), operatingSystem, new DefaultUsageContext(variantName + "Link", linkUsage, (AttributeContainer)linkAttributes), new DefaultUsageContext(variantName + "Runtime", runtimeUsage, (AttributeContainer)runtimeAttributes));
                            if (DefaultNativePlatform.getCurrentOperatingSystem().toFamilyName().equals(operatingSystem.getName())) {
                                ToolChainSelector.Result<CppPlatform> result = CppLibraryPlugin.this.toolChainSelector.select(CppPlatform.class);
                                if (linkage == Linkage.SHARED) {
                                    DefaultCppSharedLibrary sharedLibrary = library.addSharedLibrary(variantIdentity, result.getTargetPlatform(), result.getToolChain(), result.getPlatformToolProvider());
                                    library.getMainPublication().addVariant(sharedLibrary);
                                    if (buildType != BuildType.DEBUG) continue;
                                    library.getDevelopmentBinary().set((Object)sharedLibrary);
                                    continue;
                                }
                                DefaultCppStaticLibrary staticLibrary = library.addStaticLibrary(variantIdentity, result.getTargetPlatform(), result.getToolChain(), result.getPlatformToolProvider());
                                library.getMainPublication().addVariant(staticLibrary);
                                if (linkages.contains(Linkage.SHARED) || buildType != BuildType.DEBUG) continue;
                                library.getDevelopmentBinary().set((Object)staticLibrary);
                                continue;
                            }
                            library.getMainPublication().addVariant((SoftwareComponent)variantIdentity);
                        }
                    }
                }
                final MainLibraryVariant mainVariant = library.getMainPublication();
                Configuration apiElements = library.getApiElements();
                Provider publicHeaders = providers.provider((Callable)new Callable<File>(){

                    @Override
                    public File call() throws Exception {
                        Set files = library.getPublicHeaderDirs().getFiles();
                        if (files.size() != 1) {
                            throw new UnsupportedOperationException(String.format("The C++ library plugin currently requires exactly one public header directory, however there are %d directories configured: %s", files.size(), files));
                        }
                        return (File)files.iterator().next();
                    }
                });
                apiElements.getOutgoing().artifact((Object)publicHeaders);
                project.getPluginManager().withPlugin("maven-publish", (Action)new Action<AppliedPlugin>(){

                    public void execute(AppliedPlugin appliedPlugin) {
                        TaskProvider headersZip = val$tasks.register("cppHeaders", Zip.class, (Action)new Action<Zip>(){

                            public void execute(Zip headersZip) {
                                headersZip.from(new Object[]{library.getPublicHeaderFiles()});
                                headersZip.setDestinationDir(new File(project.getBuildDir(), "headers"));
                                headersZip.setClassifier("cpp-api-headers");
                                headersZip.setArchiveName("cpp-api-headers.zip");
                            }
                        });
                        mainVariant.addArtifact((PublishArtifact)new LazyPublishArtifact((Provider)headersZip));
                    }
                });
                ((DefaultBinaryCollection)library.getBinaries()).realizeNow();
            }
        });
    }

    private String createDimensionSuffix(Named dimensionValue, Collection<? extends Named> multivalueProperty) {
        if (this.isDimensionVisible(multivalueProperty)) {
            return StringUtils.capitalize((String)dimensionValue.getName().toLowerCase());
        }
        return "";
    }

    private boolean isDimensionVisible(Collection<? extends Named> multivalueProperty) {
        return multivalueProperty.size() > 1;
    }

    private static final class BuildType
    implements Named {
        private static final BuildType DEBUG = new BuildType("debug", true, false);
        private static final BuildType RELEASE = new BuildType("release", true, true);
        public static final Collection<BuildType> DEFAULT_BUILD_TYPES = Arrays.asList(DEBUG, RELEASE);
        private final boolean debuggable;
        private final boolean optimized;
        private final String name;

        private BuildType(String name, boolean debuggable, boolean optimized) {
            this.debuggable = debuggable;
            this.optimized = optimized;
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public boolean isDebuggable() {
            return this.debuggable;
        }

        public boolean isOptimized() {
            return this.optimized;
        }
    }
}

