/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource.transport.gcp.gcs;

import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.http.HttpBackOffIOExceptionHandler;
import com.google.api.client.http.HttpBackOffUnsuccessfulResponseHandler;
import com.google.api.client.http.HttpExecuteInterceptor;
import com.google.api.client.http.HttpIOExceptionHandler;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.HttpUnsuccessfulResponseHandler;
import com.google.api.client.util.BackOff;
import com.google.api.client.util.ExponentialBackOff;
import com.google.api.client.util.Sleeper;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.gradle.api.logging.Logging;

final class RetryHttpInitializerWrapper
implements HttpRequestInitializer {
    private static final org.gradle.api.logging.Logger LOG = Logging.getLogger(RetryHttpInitializerWrapper.class);
    private static final long DEFAULT_READ_TIMEOUT_MILLIS = TimeUnit.MINUTES.toMillis(2L);
    private final Supplier<Credential> credentialSupplier;
    private final Sleeper sleeper;

    RetryHttpInitializerWrapper(Supplier<Credential> credentialSupplier) {
        this(credentialSupplier, Sleeper.DEFAULT);
    }

    RetryHttpInitializerWrapper(Supplier<Credential> credentialSupplier, Sleeper sleeper) {
        this.credentialSupplier = (Supplier)Preconditions.checkNotNull(credentialSupplier);
        this.sleeper = sleeper;
    }

    public void initialize(HttpRequest request) {
        boolean loggingEnabled = false;
        request.setLoggingEnabled(false);
        request.setCurlLoggingEnabled(false);
        RetryHttpInitializerWrapper.disableHttpTransportLogging();
        request.setReadTimeout((int)DEFAULT_READ_TIMEOUT_MILLIS);
        HttpBackOffUnsuccessfulResponseHandler backoffHandler = new HttpBackOffUnsuccessfulResponseHandler((BackOff)new ExponentialBackOff()).setSleeper(this.sleeper);
        final Credential credential = (Credential)this.credentialSupplier.get();
        request.setInterceptor((HttpExecuteInterceptor)credential);
        request.setUnsuccessfulResponseHandler(new HttpUnsuccessfulResponseHandler((HttpUnsuccessfulResponseHandler)backoffHandler){
            final /* synthetic */ HttpUnsuccessfulResponseHandler val$backoffHandler;
            {
                this.val$backoffHandler = httpUnsuccessfulResponseHandler;
            }

            public boolean handleResponse(HttpRequest request, HttpResponse response, boolean supportsRetry) throws IOException {
                request.setLoggingEnabled(false);
                request.setCurlLoggingEnabled(false);
                if (credential.handleResponse(request, response, supportsRetry)) {
                    return true;
                }
                if (this.val$backoffHandler.handleResponse(request, response, supportsRetry)) {
                    LOG.info("Retrying " + request.getUrl().toString());
                    return true;
                }
                return false;
            }
        });
        request.setIOExceptionHandler((HttpIOExceptionHandler)new HttpBackOffIOExceptionHandler((BackOff)new ExponentialBackOff()).setSleeper(this.sleeper));
    }

    private static void disableHttpTransportLogging() {
        Logger.getLogger(HttpTransport.class.getName()).setLevel(Level.OFF);
    }
}

