/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.server;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.concurrent.ExecutorFactory;
import org.gradle.internal.concurrent.ManagedExecutor;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.internal.remote.internal.Connection;
import org.gradle.internal.remote.internal.RemoteConnection;
import org.gradle.launcher.daemon.context.DaemonContext;
import org.gradle.launcher.daemon.protocol.Command;
import org.gradle.launcher.daemon.protocol.Failure;
import org.gradle.launcher.daemon.protocol.Message;
import org.gradle.launcher.daemon.server.BadlyFormedRequestException;
import org.gradle.launcher.daemon.server.DefaultDaemonConnection;
import org.gradle.launcher.daemon.server.IncomingConnectionHandler;
import org.gradle.launcher.daemon.server.api.DaemonConnection;
import org.gradle.launcher.daemon.server.api.DaemonStateControl;
import org.gradle.launcher.daemon.server.exec.DaemonCommandExecuter;

public class DefaultIncomingConnectionHandler
implements IncomingConnectionHandler,
Stoppable {
    private static final Logger LOGGER = Logging.getLogger(DefaultIncomingConnectionHandler.class);
    private final ManagedExecutor workers;
    private final byte[] token;
    private final DaemonContext daemonContext;
    private final DaemonCommandExecuter commandExecuter;
    private final DaemonStateControl daemonStateControl;
    private final ExecutorFactory executorFactory;
    private final Lock lock = new ReentrantLock();
    private final Condition condition = this.lock.newCondition();
    private final Set<Connection<?>> inProgress = new HashSet();

    public DefaultIncomingConnectionHandler(DaemonCommandExecuter commandExecuter, DaemonContext daemonContext, DaemonStateControl daemonStateControl, ExecutorFactory executorFactory, byte[] token) {
        this.commandExecuter = commandExecuter;
        this.daemonContext = daemonContext;
        this.daemonStateControl = daemonStateControl;
        this.executorFactory = executorFactory;
        this.workers = executorFactory.create("Daemon");
        this.token = token;
    }

    @Override
    public void handle(RemoteConnection<Message> connection) {
        this.onStartHandling((Connection<?>)connection);
        this.workers.execute(new ConnectionWorker(connection));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onStartHandling(Connection<?> connection) {
        this.lock.lock();
        try {
            this.inProgress.add(connection);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onFinishHandling(Connection<?> connection) {
        this.lock.lock();
        try {
            this.inProgress.remove(connection);
            this.condition.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void stop() {
        this.lock.lock();
        try {
            while (!this.inProgress.isEmpty()) {
                try {
                    this.condition.await();
                }
                catch (InterruptedException e) {
                    throw UncheckedException.throwAsUncheckedException(e);
                    return;
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private class ConnectionWorker
    implements Runnable {
        private final RemoteConnection<Message> connection;

        public ConnectionWorker(RemoteConnection<Message> connection) {
            this.connection = connection;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.receiveAndHandleCommand();
            }
            finally {
                DefaultIncomingConnectionHandler.this.onFinishHandling(this.connection);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void receiveAndHandleCommand() {
            try {
                DefaultDaemonConnection daemonConnection = new DefaultDaemonConnection(this.connection, DefaultIncomingConnectionHandler.this.executorFactory);
                try {
                    Command command = this.receiveCommand(daemonConnection);
                    if (command != null) {
                        this.handleCommand(command, daemonConnection);
                    }
                }
                finally {
                    daemonConnection.stop();
                }
            }
            finally {
                this.connection.stop();
            }
        }

        private Command receiveCommand(DaemonConnection daemonConnection) {
            try {
                Command command = (Command)daemonConnection.receive(120L, TimeUnit.SECONDS);
                LOGGER.info("Received command: {}.", (Object)command);
                return command;
            }
            catch (Throwable e) {
                LOGGER.warn(String.format("Unable to receive command from client %s. Discarding connection.", this.connection), e);
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleCommand(Command command, DaemonConnection daemonConnection) {
            LOGGER.debug("{}{} with connection: {}.", new Object[]{"Starting executing command: ", command, this.connection});
            try {
                if (!Arrays.equals(command.getToken(), DefaultIncomingConnectionHandler.this.token)) {
                    throw new BadlyFormedRequestException(String.format("Unexpected authentication token in command %s received from %s", command, this.connection));
                }
                DefaultIncomingConnectionHandler.this.commandExecuter.executeCommand(daemonConnection, command, DefaultIncomingConnectionHandler.this.daemonContext, DefaultIncomingConnectionHandler.this.daemonStateControl);
            }
            catch (Throwable e) {
                LOGGER.warn(String.format("Unable to execute command %s from %s. Dispatching the failure to the daemon client", command, this.connection), e);
                daemonConnection.completed(new Failure(e));
            }
            finally {
                LOGGER.debug("{}{}", (Object)"Finishing executing command: ", (Object)command);
            }
            Object finished = daemonConnection.receive(60L, TimeUnit.SECONDS);
            LOGGER.debug("Received finished message: {}", finished);
        }
    }
}

